/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction.core;

import com.google.common.base.Preconditions;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.transaction.core.ResourceIdGenerator;
import org.apache.shardingsphere.transaction.exception.ResourceNameLengthExceededException;

public final class ResourceDataSource {
    private static final int MAX_RESOURCE_NAME_LENGTH = 45;
    private final String originalName;
    private final String uniqueResourceName;
    private final DataSource dataSource;

    public ResourceDataSource(String originalName, DataSource dataSource) {
        String[] databaseAndDataSourceName = originalName.split("\\.");
        Preconditions.checkState((2 == databaseAndDataSourceName.length ? 1 : 0) != 0, (String)"Database and data source name must be provided together by `%s`.", (Object)originalName);
        this.originalName = originalName;
        this.dataSource = dataSource;
        this.uniqueResourceName = ResourceIdGenerator.getInstance().nextId() + databaseAndDataSourceName[1];
        ShardingSpherePreconditions.checkState((this.uniqueResourceName.getBytes().length <= 45 ? 1 : 0) != 0, () -> new ResourceNameLengthExceededException(this.uniqueResourceName));
    }

    @Generated
    public String getOriginalName() {
        return this.originalName;
    }

    @Generated
    public String getUniqueResourceName() {
        return this.uniqueResourceName;
    }

    @Generated
    public DataSource getDataSource() {
        return this.dataSource;
    }
}

