/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.merge.dal.show;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.merge.result.impl.memory.MemoryMergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.memory.MemoryQueryResultRow;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.util.IndexMetaDataUtils;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.ShardingTable;

public final class ShowIndexMergedResult
extends MemoryMergedResult<ShardingRule> {
    public ShowIndexMergedResult(ShardingRule shardingRule, SQLStatementContext sqlStatementContext, ShardingSphereSchema schema, List<QueryResult> queryResults) throws SQLException {
        super((ShardingSphereRule)shardingRule, schema, sqlStatementContext, queryResults);
    }

    protected List<MemoryQueryResultRow> init(ShardingRule shardingRule, ShardingSphereSchema schema, SQLStatementContext sqlStatementContext, List<QueryResult> queryResults) throws SQLException {
        LinkedList<MemoryQueryResultRow> result = new LinkedList<MemoryQueryResultRow>();
        for (QueryResult each : queryResults) {
            while (each.next()) {
                MemoryQueryResultRow memoryResultSetRow = new MemoryQueryResultRow(each);
                String actualTableName = memoryResultSetRow.getCell(1).toString();
                String actualIndexName = memoryResultSetRow.getCell(3).toString();
                Optional<ShardingTable> shardingTable = shardingRule.findShardingTableByActualTable(actualTableName);
                shardingTable.ifPresent(optional -> memoryResultSetRow.setCell(1, (Object)optional.getLogicTable()));
                memoryResultSetRow.setCell(3, (Object)IndexMetaDataUtils.getLogicIndexName((String)actualIndexName, (String)actualTableName));
                result.add(memoryResultSetRow);
            }
        }
        return result;
    }
}

