/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.engine.segment.dml.expression.type;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.cedarsoftware.util.CaseInsensitiveSet;
import com.google.common.base.Strings;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.groovy.util.Maps;
import org.apache.shardingsphere.infra.binder.engine.segment.SegmentType;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.type.FunctionTableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.type.SimpleTableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.ColumnNotFoundException;
import org.apache.shardingsphere.infra.exception.kernel.syntax.AmbiguousColumnException;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.bound.ColumnSegmentBoundInfo;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.bound.TableSegmentBoundInfo;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class ColumnSegmentBinder {
    private static final Collection<String> EXCLUDE_BIND_COLUMNS = new CaseInsensitiveSet(Arrays.asList("ROWNUM", "ROW_NUMBER", "ROWNUM_", "ROWID", "SYSDATE", "SYSTIMESTAMP", "CURRENT_TIMESTAMP", "LOCALTIMESTAMP", "UID", "USER", "NEXTVAL", "LEVEL"));
    private static final Map<SegmentType, String> SEGMENT_TYPE_MESSAGES = Maps.of((Object)((Object)SegmentType.PROJECTION), (Object)"field list", (Object)((Object)SegmentType.JOIN_ON), (Object)"on clause", (Object)((Object)SegmentType.JOIN_USING), (Object)"from clause", (Object)((Object)SegmentType.PREDICATE), (Object)"where clause", (Object)((Object)SegmentType.ORDER_BY), (Object)"order clause", (Object)((Object)SegmentType.GROUP_BY), (Object)"group statement", (Object)((Object)SegmentType.INSERT_COLUMNS), (Object)"field list");
    private static final String UNKNOWN_SEGMENT_TYPE_MESSAGE = "unknown clause";

    public static ColumnSegment bind(ColumnSegment segment, SegmentType parentSegmentType, SQLStatementBinderContext binderContext, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> tableBinderContexts, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> outerTableBinderContexts) {
        if (EXCLUDE_BIND_COLUMNS.contains(segment.getIdentifier().getValue())) {
            return segment;
        }
        ColumnSegment result = ColumnSegmentBinder.copy(segment);
        Collection<TableSegmentBinderContext> tableSegmentBinderContexts = ColumnSegmentBinder.getTableSegmentBinderContexts(segment, parentSegmentType, binderContext, tableBinderContexts, outerTableBinderContexts);
        Optional<ColumnSegment> inputColumnSegment = ColumnSegmentBinder.findInputColumnSegment(segment, parentSegmentType, tableSegmentBinderContexts, outerTableBinderContexts, binderContext);
        inputColumnSegment.ifPresent(optional -> result.setVariable(optional.isVariable()));
        segment.getOwner().ifPresent(optional -> result.setOwner(ColumnSegmentBinder.bindOwnerTableContext(optional, inputColumnSegment.orElse(null))));
        result.setColumnBoundInfo(ColumnSegmentBinder.createColumnSegmentBoundInfo(segment, inputColumnSegment.orElse(null)));
        return result;
    }

    private static ColumnSegment copy(ColumnSegment segment) {
        ColumnSegment result = new ColumnSegment(segment.getStartIndex(), segment.getStopIndex(), segment.getIdentifier());
        segment.getLeftParentheses().ifPresent(arg_0 -> ((ColumnSegment)result).setLeftParentheses(arg_0));
        segment.getRightParentheses().ifPresent(arg_0 -> ((ColumnSegment)result).setRightParentheses(arg_0));
        return result;
    }

    private static OwnerSegment bindOwnerTableContext(OwnerSegment owner, ColumnSegment inputColumnSegment) {
        IdentifierValue originalSchema;
        IdentifierValue originalDatabase = null == inputColumnSegment ? null : inputColumnSegment.getColumnBoundInfo().getOriginalDatabase();
        IdentifierValue identifierValue = originalSchema = null == inputColumnSegment ? null : inputColumnSegment.getColumnBoundInfo().getOriginalSchema();
        if (originalDatabase != null && originalSchema != null) {
            owner.setTableBoundInfo(new TableSegmentBoundInfo(originalDatabase, originalSchema));
        }
        return owner;
    }

    private static Collection<TableSegmentBinderContext> getTableSegmentBinderContexts(ColumnSegment segment, SegmentType parentSegmentType, SQLStatementBinderContext binderContext, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> tableBinderContexts, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> outerTableBinderContexts) {
        if (segment.getOwner().isPresent()) {
            String owner = ((OwnerSegment)segment.getOwner().get()).getIdentifier().getValue();
            return ColumnSegmentBinder.getTableBinderContextByOwner(owner, tableBinderContexts, outerTableBinderContexts, binderContext.getExternalTableBinderContexts());
        }
        if (!binderContext.getJoinTableProjectionSegments().isEmpty() && ColumnSegmentBinder.isNeedUseJoinTableProjectionBind(segment, parentSegmentType, binderContext)) {
            return Collections.singleton(new SimpleTableSegmentBinderContext(binderContext.getJoinTableProjectionSegments()));
        }
        return tableBinderContexts.values();
    }

    private static Collection<TableSegmentBinderContext> getTableBinderContextByOwner(String owner, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> tableBinderContexts, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> outerTableBinderContexts, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> externalTableBinderContexts) {
        CaseInsensitiveMap.CaseInsensitiveString caseInsensitiveOwner = new CaseInsensitiveMap.CaseInsensitiveString(owner);
        if (tableBinderContexts.containsKey((Object)caseInsensitiveOwner)) {
            return tableBinderContexts.get((Object)caseInsensitiveOwner);
        }
        if (outerTableBinderContexts.containsKey((Object)caseInsensitiveOwner)) {
            return outerTableBinderContexts.get((Object)caseInsensitiveOwner);
        }
        if (externalTableBinderContexts.containsKey((Object)caseInsensitiveOwner)) {
            return externalTableBinderContexts.get((Object)caseInsensitiveOwner);
        }
        return Collections.emptyList();
    }

    private static boolean isNeedUseJoinTableProjectionBind(ColumnSegment segment, SegmentType parentSegmentType, SQLStatementBinderContext binderContext) {
        return SegmentType.PROJECTION == parentSegmentType || SegmentType.PREDICATE == parentSegmentType && binderContext.getUsingColumnNames().contains(segment.getIdentifier().getValue());
    }

    private static Optional<ColumnSegment> findInputColumnSegment(ColumnSegment segment, SegmentType parentSegmentType, Collection<TableSegmentBinderContext> tableBinderContexts, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> outerTableBinderContexts, SQLStatementBinderContext binderContext) {
        Optional<ProjectionSegment> projectionSegment;
        ColumnSegment result = null;
        boolean isFindInputColumn = false;
        for (TableSegmentBinderContext each : tableBinderContexts) {
            Optional<ProjectionSegment> projectionSegment2 = each.findProjectionSegmentByColumnLabel(segment.getIdentifier().getValue());
            if (!projectionSegment2.isPresent()) continue;
            if (projectionSegment2.get() instanceof ColumnProjectionSegment) {
                ShardingSpherePreconditions.checkState((null == result ? 1 : 0) != 0, () -> new AmbiguousColumnException(segment.getExpression(), SEGMENT_TYPE_MESSAGES.getOrDefault((Object)parentSegmentType, UNKNOWN_SEGMENT_TYPE_MESSAGE)));
            }
            result = ColumnSegmentBinder.getColumnSegment(projectionSegment2.get());
            isFindInputColumn = true;
        }
        if (!isFindInputColumn) {
            projectionSegment = ColumnSegmentBinder.findInputColumnSegmentFromOuterTable(segment, outerTableBinderContexts);
            isFindInputColumn = projectionSegment.isPresent();
            if (projectionSegment.isPresent() && projectionSegment.get() instanceof ColumnProjectionSegment) {
                result = ((ColumnProjectionSegment)projectionSegment.get()).getColumn();
            }
        }
        if (!isFindInputColumn) {
            projectionSegment = ColumnSegmentBinder.findInputColumnSegmentFromExternalTables(segment, binderContext.getExternalTableBinderContexts());
            isFindInputColumn = projectionSegment.isPresent();
            if (projectionSegment.isPresent() && projectionSegment.get() instanceof ColumnProjectionSegment) {
                result = ((ColumnProjectionSegment)projectionSegment.get()).getColumn();
            }
        }
        if (!isFindInputColumn) {
            result = ColumnSegmentBinder.findInputColumnSegmentByVariables(segment, binderContext.getSqlStatement().getVariableNames()).orElse(null);
            boolean bl = isFindInputColumn = null != result;
        }
        if (!isFindInputColumn) {
            result = ColumnSegmentBinder.findInputColumnSegmentByPivotColumns(segment, binderContext.getPivotColumnNames()).orElse(null);
            isFindInputColumn = null != result;
        }
        ShardingSpherePreconditions.checkState((isFindInputColumn || ColumnSegmentBinder.containsFunctionTable(tableBinderContexts, outerTableBinderContexts.values()) ? 1 : 0) != 0, () -> new ColumnNotFoundException(segment.getExpression(), SEGMENT_TYPE_MESSAGES.getOrDefault((Object)parentSegmentType, UNKNOWN_SEGMENT_TYPE_MESSAGE)));
        return Optional.ofNullable(result);
    }

    private static ColumnSegment getColumnSegment(ProjectionSegment projectionSegment) {
        if (projectionSegment instanceof ColumnProjectionSegment) {
            return ((ColumnProjectionSegment)projectionSegment).getColumn();
        }
        return null;
    }

    private static Optional<ColumnSegment> findInputColumnSegmentByPivotColumns(ColumnSegment segment, Collection<String> pivotColumnNames) {
        if (pivotColumnNames.isEmpty()) {
            return Optional.empty();
        }
        if (pivotColumnNames.contains(segment.getIdentifier().getValue())) {
            return Optional.of(new ColumnSegment(0, 0, segment.getIdentifier()));
        }
        return Optional.empty();
    }

    private static Optional<ProjectionSegment> findInputColumnSegmentFromOuterTable(ColumnSegment segment, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> outerTableBinderContexts) {
        ListIterator listIterator = new ArrayList(outerTableBinderContexts.values()).listIterator(outerTableBinderContexts.size());
        while (listIterator.hasPrevious()) {
            TableSegmentBinderContext each = (TableSegmentBinderContext)listIterator.previous();
            Optional<ProjectionSegment> result = each.findProjectionSegmentByColumnLabel(segment.getIdentifier().getValue());
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    private static Optional<ProjectionSegment> findInputColumnSegmentFromExternalTables(ColumnSegment segment, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> externalTableBinderContexts) {
        for (TableSegmentBinderContext each : externalTableBinderContexts.values()) {
            Optional<ProjectionSegment> result = each.findProjectionSegmentByColumnLabel(segment.getIdentifier().getValue());
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    private static Optional<ColumnSegment> findInputColumnSegmentByVariables(ColumnSegment segment, Collection<String> variableNames) {
        if (variableNames.isEmpty()) {
            return Optional.empty();
        }
        if (variableNames.contains(segment.getIdentifier().getValue())) {
            ColumnSegment result = new ColumnSegment(0, 0, segment.getIdentifier());
            result.setVariable(true);
            return Optional.of(result);
        }
        return Optional.empty();
    }

    private static boolean containsFunctionTable(Collection<TableSegmentBinderContext> tableBinderContexts, Collection<TableSegmentBinderContext> outerBinderContexts) {
        for (TableSegmentBinderContext each : tableBinderContexts) {
            if (!(each instanceof FunctionTableSegmentBinderContext)) continue;
            return true;
        }
        for (TableSegmentBinderContext each : outerBinderContexts) {
            if (!(each instanceof FunctionTableSegmentBinderContext)) continue;
            return true;
        }
        return false;
    }

    private static ColumnSegmentBoundInfo createColumnSegmentBoundInfo(ColumnSegment segment, ColumnSegment inputColumnSegment) {
        IdentifierValue originalDatabase = null == inputColumnSegment ? null : inputColumnSegment.getColumnBoundInfo().getOriginalDatabase();
        IdentifierValue originalSchema = null == inputColumnSegment ? null : inputColumnSegment.getColumnBoundInfo().getOriginalSchema();
        IdentifierValue segmentOriginalTable = segment.getColumnBoundInfo().getOriginalTable();
        IdentifierValue originalTable = Strings.isNullOrEmpty((String)segmentOriginalTable.getValue()) ? Optional.ofNullable(inputColumnSegment).map(optional -> optional.getColumnBoundInfo().getOriginalTable()).orElse(segmentOriginalTable) : segmentOriginalTable;
        IdentifierValue segmentOriginalColumn = segment.getColumnBoundInfo().getOriginalColumn();
        IdentifierValue originalColumn = Optional.ofNullable(inputColumnSegment).map(optional -> optional.getColumnBoundInfo().getOriginalColumn()).orElse(segmentOriginalColumn);
        return new ColumnSegmentBoundInfo(new TableSegmentBoundInfo(originalDatabase, originalSchema), originalTable, originalColumn);
    }

    public static ColumnSegment bindUsingColumn(ColumnSegment segment, SegmentType parentSegmentType, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> tableBinderContexts) {
        ColumnSegment result = ColumnSegmentBinder.copy(segment);
        List<ColumnSegment> usingInputColumnSegments = ColumnSegmentBinder.findUsingInputColumnSegments(segment.getIdentifier().getValue(), tableBinderContexts.values());
        ShardingSpherePreconditions.checkState((usingInputColumnSegments.size() >= 2 ? 1 : 0) != 0, () -> new ColumnNotFoundException(segment.getExpression(), SEGMENT_TYPE_MESSAGES.getOrDefault((Object)parentSegmentType, UNKNOWN_SEGMENT_TYPE_MESSAGE)));
        result.setColumnBoundInfo(ColumnSegmentBinder.createColumnSegmentBoundInfo(segment, usingInputColumnSegments.get(0)));
        result.setOtherUsingColumnBoundInfo(ColumnSegmentBinder.createColumnSegmentBoundInfo(segment, usingInputColumnSegments.get(1)));
        return result;
    }

    private static List<ColumnSegment> findUsingInputColumnSegments(String columnName, Collection<TableSegmentBinderContext> tableBinderContexts) {
        return tableBinderContexts.stream().map(each -> each.findProjectionSegmentByColumnLabel(columnName)).filter(optional -> optional.isPresent() && optional.get() instanceof ColumnProjectionSegment).map(each -> ((ColumnProjectionSegment)each.get()).getColumn()).collect(Collectors.toList());
    }

    @Generated
    private ColumnSegmentBinder() {
    }
}

