/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.postgresql.handler.admin.executor.variable.charset;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.apache.shardingsphere.infra.exception.dialect.exception.data.InvalidParameterValueException;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.variable.charset.CharsetVariableProvider;
import org.apache.shardingsphere.proxy.backend.postgresql.handler.admin.executor.variable.charset.PostgreSQLCharacterSets;

public final class PostgreSQLSetCharsetExecutor
implements CharsetVariableProvider {
    public boolean isCharsetVariable(String variableName) {
        return "client_encoding".equalsIgnoreCase(variableName);
    }

    public Charset parseCharset(String variableValue) {
        String formattedValue = this.formatValue(variableValue);
        try {
            String result = formattedValue.toLowerCase(Locale.ROOT);
            return "default".equals(result) ? StandardCharsets.UTF_8 : PostgreSQLCharacterSets.findCharacterSet(result);
        }
        catch (IllegalArgumentException ignored) {
            throw new InvalidParameterValueException("client_encoding", formattedValue.toLowerCase(Locale.ROOT));
        }
    }

    private String formatValue(String variableValue) {
        return variableValue.trim();
    }

    public String getDatabaseType() {
        return "PostgreSQL";
    }
}

