/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.global;

import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shardingsphere.infra.instance.ComputeNodeData;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.instance.metadata.InstanceMetaData;
import org.apache.shardingsphere.infra.instance.metadata.InstanceMetaDataFactory;
import org.apache.shardingsphere.infra.instance.metadata.InstanceType;
import org.apache.shardingsphere.infra.instance.yaml.YamlComputeNodeData;
import org.apache.shardingsphere.infra.instance.yaml.YamlComputeNodeDataSwapper;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.DataChangedEventHandler;
import org.apache.shardingsphere.mode.node.path.metadata.ComputeNodePath;

public final class ComputeNodeOnlineHandler
implements DataChangedEventHandler {
    @Override
    public String getSubscribedKey() {
        return ComputeNodePath.getOnlineRootPath();
    }

    @Override
    public Collection<DataChangedEvent.Type> getSubscribedTypes() {
        return Arrays.asList(DataChangedEvent.Type.ADDED, DataChangedEvent.Type.DELETED);
    }

    @Override
    public void handle(ContextManager contextManager, DataChangedEvent event) {
        Matcher matcher = this.getInstanceOnlinePathMatcher(event.getKey());
        if (!matcher.find()) {
            return;
        }
        ComputeNodeData computeNodeData = new YamlComputeNodeDataSwapper().swapToObject((YamlComputeNodeData)YamlEngine.unmarshal((String)event.getValue(), YamlComputeNodeData.class));
        InstanceMetaData instanceMetaData = InstanceMetaDataFactory.create((String)matcher.group(2), (InstanceType)InstanceType.valueOf((String)matcher.group(1).toUpperCase()), (ComputeNodeData)computeNodeData);
        if (DataChangedEvent.Type.ADDED == event.getType()) {
            contextManager.getComputeNodeInstanceContext().getClusterInstanceRegistry().add(contextManager.getPersistServiceFacade().getComputeNodePersistService().loadInstance(instanceMetaData));
        } else if (DataChangedEvent.Type.DELETED == event.getType()) {
            contextManager.getComputeNodeInstanceContext().getClusterInstanceRegistry().delete(new ComputeNodeInstance(instanceMetaData));
        }
    }

    private Matcher getInstanceOnlinePathMatcher(String onlineInstancePath) {
        return Pattern.compile(ComputeNodePath.getOnlineRootPath() + "/([\\S]+)/([\\S]+)$", 2).matcher(onlineInstancePath);
    }
}

