/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.io.PrintWriter;
import java.net.URI;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.base.StoreUtilities;
import org.apache.sis.storage.internal.Resources;
import org.apache.sis.util.Classes;
import org.apache.sis.util.logging.Logging;

final class URLDataSource
implements DataSource {
    private static final Set<String> DRIVERS = new HashSet<String>();
    private final String url;

    public URLDataSource(URI url) {
        this.url = url.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Connection log(Connection connection) throws SQLException {
        if (StoreUtilities.LOGGER.isLoggable(Level.CONFIG)) {
            boolean log;
            DatabaseMetaData metadata = connection.getMetaData();
            String name = metadata.getDriverName();
            Set<String> set = DRIVERS;
            synchronized (set) {
                log = DRIVERS.add(name);
            }
            if (log) {
                LogRecord record = Resources.forLocale(null).createLogRecord(Level.CONFIG, (short)82, name, metadata.getDriverMajorVersion(), metadata.getDriverMinorVersion());
                Logging.completeAndLog((Logger)StoreUtilities.LOGGER, StorageConnector.class, (String)"getStorageAs", (LogRecord)record);
            }
        }
        return connection;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return URLDataSource.log(DriverManager.getConnection(this.url));
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return URLDataSource.log(DriverManager.getConnection(this.url, username, password));
    }

    @Override
    public PrintWriter getLogWriter() {
        return DriverManager.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) {
        DriverManager.setLogWriter(out);
    }

    @Override
    public int getLoginTimeout() {
        return DriverManager.getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int seconds) {
        DriverManager.setLoginTimeout(seconds);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException();
    }

    public boolean equals(Object other) {
        return other instanceof URLDataSource && this.url.equals(((URLDataSource)other).url);
    }

    public int hashCode() {
        return this.url.hashCode() ^ 0x13FF13DB;
    }

    public String toString() {
        return Classes.getShortClassName((Object)this) + "[\"" + this.url + "\"]";
    }

    @Override
    public Logger getParentLogger() {
        return StoreUtilities.LOGGER;
    }
}

