/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.bind.cat;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.sis.util.internal.shared.CodeLists;
import org.apache.sis.util.iso.Types;
import org.apache.sis.xml.bind.Context;
import org.apache.sis.xml.bind.FilterByVersion;
import org.apache.sis.xml.bind.cat.CodeListUID;
import org.opengis.util.CodeList;

public abstract class CodeListAdapter<ValueType extends CodeListAdapter<ValueType, BoundType>, BoundType extends CodeList<BoundType>>
extends XmlAdapter<ValueType, BoundType> {
    protected CodeListUID identifier;

    protected CodeListAdapter() {
    }

    protected CodeListAdapter(CodeListUID value) {
        this.identifier = value;
    }

    protected abstract ValueType wrap(CodeListUID var1);

    protected abstract Class<BoundType> getCodeListClass();

    protected final boolean accept2014() {
        return FilterByVersion.CURRENT_METADATA.accept();
    }

    public final BoundType unmarshal(ValueType adapter) {
        if (adapter != null) {
            try {
                return (BoundType)CodeLists.getOrCreate(this.getCodeListClass(), (String)((CodeListAdapter)((Object)adapter)).identifier.toString());
            }
            catch (RuntimeException e) {
                Context.warningOccured(Context.current(), CodeListAdapter.class, "unmarshal", e, true);
            }
        }
        return null;
    }

    public final ValueType marshal(BoundType code) {
        CodeListUID p;
        if (code == null) {
            return null;
        }
        if (this.isEnum()) {
            p = new CodeListUID();
            p.value = Types.getCodeName(code);
        } else {
            p = new CodeListUID(Context.current(), (CodeList<?>)code);
        }
        return this.wrap(p);
    }

    protected boolean isEnum() {
        return false;
    }

    public abstract CodeListUID getElement();
}

