/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config.impl;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.config.impl.ConfigHttpClientManager;
import com.alibaba.nacos.client.config.impl.ServerListChangeEvent;
import com.alibaba.nacos.client.env.NacosClientProperties;
import com.alibaba.nacos.client.utils.ContextPathUtil;
import com.alibaba.nacos.client.utils.EnvUtil;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.client.utils.ParamUtil;
import com.alibaba.nacos.client.utils.TemplateUtils;
import com.alibaba.nacos.common.executor.NameThreadFactory;
import com.alibaba.nacos.common.http.HttpRestResult;
import com.alibaba.nacos.common.http.client.NacosRestTemplate;
import com.alibaba.nacos.common.http.param.Header;
import com.alibaba.nacos.common.http.param.Query;
import com.alibaba.nacos.common.lifecycle.Closeable;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.utils.InternetAddressUtil;
import com.alibaba.nacos.common.utils.IoUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.common.utils.ThreadUtils;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class ServerListManager
implements Closeable {
    private static final Logger LOGGER = LogUtils.logger(ServerListManager.class);
    private final NacosRestTemplate nacosRestTemplate = ConfigHttpClientManager.getInstance().getNacosRestTemplate();
    private final ScheduledExecutorService executorService = new ScheduledThreadPoolExecutor(1, new NameThreadFactory("com.alibaba.nacos.client.ServerListManager"));
    private final String name;
    private String namespace = "";
    private String tenant = "";
    public static final String DEFAULT_NAME = "default";
    public static final String CUSTOM_NAME = "custom";
    public static final String FIXED_NAME = "fixed";
    private final int initServerListRetryTimes = 5;
    final boolean isFixed;
    boolean isStarted;
    private String endpoint;
    private int endpointPort = 8080;
    private String endpointContextPath;
    private String contentPath = ParamUtil.getDefaultContextPath();
    private String serverListName = ParamUtil.getDefaultNodesPath();
    volatile List<String> serverUrls = new ArrayList<String>();
    private volatile String currentServerAddr;
    private Iterator<String> iterator;
    public String addressServerUrl;
    private String serverAddrsStr;

    public ServerListManager() {
        this.isFixed = false;
        this.isStarted = false;
        this.name = DEFAULT_NAME;
    }

    public ServerListManager(List<String> fixed) {
        this(fixed, null);
    }

    public ServerListManager(List<String> fixed, String namespace) {
        this.isFixed = true;
        this.isStarted = true;
        ArrayList<String> serverAddrs = new ArrayList<String>();
        for (String serverAddr : fixed) {
            String[] serverAddrArr = InternetAddressUtil.splitIPPortStr(serverAddr);
            if (serverAddrArr.length == 1) {
                serverAddrs.add(serverAddrArr[0] + ":" + ParamUtil.getDefaultServerPort());
                continue;
            }
            serverAddrs.add(serverAddr);
        }
        this.serverUrls = new ArrayList<String>(serverAddrs);
        if (StringUtils.isNotBlank(namespace)) {
            this.namespace = namespace;
            this.tenant = namespace;
        }
        this.name = this.initServerName(null);
    }

    public ServerListManager(String host, int port) {
        this.isFixed = false;
        this.isStarted = false;
        this.endpoint = host;
        this.endpointPort = port;
        this.name = this.initServerName(null);
        this.initAddressServerUrl(null);
    }

    public ServerListManager(String endpoint) throws NacosException {
        this(endpoint, null);
    }

    public ServerListManager(String endpoint, String namespace) throws NacosException {
        this.isFixed = false;
        this.isStarted = false;
        if (StringUtils.isBlank(endpoint)) {
            throw new NacosException(-400, "endpoint is blank");
        }
        Properties properties = new Properties();
        properties.setProperty("endpoint", endpoint);
        NacosClientProperties clientProperties = NacosClientProperties.PROTOTYPE.derive(properties);
        this.initParam(clientProperties);
        if (StringUtils.isNotBlank(namespace)) {
            this.namespace = namespace;
            this.tenant = namespace;
        }
        this.name = this.initServerName(null);
        this.initAddressServerUrl(clientProperties);
    }

    public ServerListManager(NacosClientProperties properties) throws NacosException {
        this.isStarted = false;
        this.initParam(properties);
        if (StringUtils.isNotEmpty(this.serverAddrsStr)) {
            this.isFixed = true;
            ArrayList<String> serverAddrs = new ArrayList<String>();
            StringTokenizer serverAddrsTokens = new StringTokenizer(this.serverAddrsStr, ",;");
            while (serverAddrsTokens.hasMoreTokens()) {
                String serverAddr = serverAddrsTokens.nextToken().trim();
                if (serverAddr.startsWith("http://") || serverAddr.startsWith("https://")) {
                    serverAddrs.add(serverAddr);
                    continue;
                }
                String[] serverAddrArr = InternetAddressUtil.splitIPPortStr(serverAddr);
                if (serverAddrArr.length == 1) {
                    serverAddrs.add("http://" + serverAddrArr[0] + ":" + ParamUtil.getDefaultServerPort());
                    continue;
                }
                serverAddrs.add("http://" + serverAddr);
            }
            this.serverUrls = serverAddrs;
            this.name = this.initServerName(properties);
        } else {
            if (StringUtils.isBlank(this.endpoint)) {
                throw new NacosException(-400, "endpoint is blank");
            }
            this.isFixed = false;
            this.name = this.initServerName(properties);
            this.initAddressServerUrl(properties);
        }
    }

    private void initNameSpace(NacosClientProperties properties) {
        String namespace = properties.getProperty("namespace");
        if (StringUtils.isNotBlank(namespace)) {
            this.namespace = namespace;
            this.tenant = namespace;
        }
    }

    private void initServerAddr(NacosClientProperties properties) {
        this.serverAddrsStr = properties.getProperty("serverAddr");
    }

    private String initServerName(NacosClientProperties properties) {
        String serverName;
        if (properties != null && properties.containsKey("serverName")) {
            serverName = properties.getProperty("serverName");
        } else if (this.isFixed) {
            serverName = "fixed-" + (StringUtils.isNotBlank(this.namespace) ? StringUtils.trim(this.namespace) + "-" : "") + this.getFixedNameSuffix(this.serverUrls.toArray(new String[0]));
        } else {
            String contextPathTmp = StringUtils.isNotBlank(this.endpointContextPath) ? this.endpointContextPath : this.contentPath;
            serverName = "custom-" + String.join((CharSequence)"_", this.endpoint, String.valueOf(this.endpointPort), contextPathTmp, this.serverListName) + (StringUtils.isNotBlank(this.namespace) ? "_" + StringUtils.trim(this.namespace) : "");
        }
        serverName = serverName.replaceAll("\\/", "_");
        serverName = serverName.replaceAll("\\:", "_");
        return serverName;
    }

    private void initAddressServerUrl(NacosClientProperties properties) {
        if (this.isFixed) {
            return;
        }
        String contextPathTem = StringUtils.isNotBlank(this.endpointContextPath) ? ContextPathUtil.normalizeContextPath(this.endpointContextPath) : ContextPathUtil.normalizeContextPath(this.contentPath);
        StringBuilder addressServerUrlTem = new StringBuilder(String.format("http://%s:%d%s/%s", this.endpoint, this.endpointPort, contextPathTem, this.serverListName));
        boolean hasQueryString = false;
        if (StringUtils.isNotBlank(this.namespace)) {
            addressServerUrlTem.append("?namespace=").append(this.namespace);
            hasQueryString = true;
        }
        if (properties != null && properties.containsKey("endpointQueryParams")) {
            addressServerUrlTem.append(hasQueryString ? "&" : "?" + properties.getProperty("endpointQueryParams"));
        }
        this.addressServerUrl = addressServerUrlTem.toString();
        LOGGER.info("serverName = {},  address server url = {}", (Object)this.name, (Object)this.addressServerUrl);
    }

    private void initParam(NacosClientProperties properties) {
        this.initServerAddr(properties);
        this.initNameSpace(properties);
        this.initEndpoint(properties);
        this.initEndpointPort(properties);
        this.initEndpointContextPath(properties);
        this.initContextPath(properties);
        this.initServerListName(properties);
    }

    private void initEndpointContextPath(NacosClientProperties properties) {
        String endpointContextPathTmp = TemplateUtils.stringEmptyAndThenExecute(properties.getProperty("ALIBABA_ALIWARE_ENDPOINT_CONTEXT_PATH"), () -> properties.getProperty("endpointContextPath"));
        if (StringUtils.isNotBlank(endpointContextPathTmp)) {
            this.endpointContextPath = endpointContextPathTmp;
        }
    }

    private void initEndpointPort(NacosClientProperties properties) {
        String endpointPortTmp = TemplateUtils.stringEmptyAndThenExecute(properties.getProperty("ALIBABA_ALIWARE_ENDPOINT_PORT"), () -> properties.getProperty("endpointPort"));
        if (StringUtils.isNotBlank(endpointPortTmp)) {
            this.endpointPort = Integer.parseInt(endpointPortTmp);
        }
    }

    private void initServerListName(NacosClientProperties properties) {
        String serverListNameTmp = properties.getProperty("clusterName");
        if (!StringUtils.isBlank(serverListNameTmp)) {
            this.serverListName = serverListNameTmp;
        }
    }

    private void initContextPath(NacosClientProperties properties) {
        String contentPathTmp = properties.getProperty("contextPath");
        if (!StringUtils.isBlank(contentPathTmp)) {
            this.contentPath = contentPathTmp;
        }
    }

    private void initEndpoint(NacosClientProperties properties) {
        String endpointTmp = properties.getProperty("endpoint");
        String isUseEndpointRuleParsing = properties.getProperty("isUseEndpointParsingRule", properties.getProperty("nacos.use.endpoint.parsing.rule", String.valueOf(true)));
        if (Boolean.parseBoolean(isUseEndpointRuleParsing)) {
            String endpointUrl = ParamUtil.parsingEndpointRule(endpointTmp);
            if (StringUtils.isNotBlank(endpointUrl)) {
                this.serverAddrsStr = "";
            }
            this.endpoint = endpointUrl;
        }
        this.endpoint = StringUtils.isNotBlank(endpointTmp) ? endpointTmp : "";
    }

    public synchronized void start() throws NacosException {
        if (this.isStarted || this.isFixed) {
            return;
        }
        GetServerListTask getServersTask = new GetServerListTask(this.addressServerUrl);
        for (int i = 0; i < 5 && this.serverUrls.isEmpty(); ++i) {
            getServersTask.run();
            if (!this.serverUrls.isEmpty()) break;
            try {
                this.wait((long)(i + 1) * 100L);
                continue;
            }
            catch (Exception e) {
                LOGGER.warn("get serverlist fail,url: {}", (Object)this.addressServerUrl);
            }
        }
        if (this.serverUrls.isEmpty()) {
            LOGGER.error("[init-serverlist] fail to get NACOS-server serverlist! env: {}, url: {}", (Object)this.name, (Object)this.addressServerUrl);
            throw new NacosException(500, "fail to get NACOS-server serverlist! env:" + this.name + ", not connnect url:" + this.addressServerUrl);
        }
        this.executorService.scheduleWithFixedDelay(getServersTask, 0L, 30L, TimeUnit.SECONDS);
        this.isStarted = true;
    }

    public List<String> getServerUrls() {
        return this.serverUrls;
    }

    Iterator<String> iterator() {
        if (this.serverUrls.isEmpty()) {
            LOGGER.error("[{}] [iterator-serverlist] No server address defined!", (Object)this.name);
        }
        return new ServerAddressIterator(this.serverUrls);
    }

    @Override
    public void shutdown() throws NacosException {
        String className = this.getClass().getName();
        LOGGER.info("{} do shutdown begin", (Object)className);
        ThreadUtils.shutdownThreadPool(this.executorService, LOGGER);
        LOGGER.info("{} do shutdown stop", (Object)className);
    }

    private void updateIfChanged(List<String> newList) {
        if (null == newList || newList.isEmpty()) {
            LOGGER.warn("[update-serverlist] current serverlist from address server is empty!!!");
            return;
        }
        ArrayList<String> newServerAddrList = new ArrayList<String>();
        for (String server : newList) {
            if (server.startsWith("http://") || server.startsWith("https://")) {
                newServerAddrList.add(server);
                continue;
            }
            newServerAddrList.add("http://" + server);
        }
        if (newServerAddrList.equals(this.serverUrls)) {
            return;
        }
        this.serverUrls = new ArrayList<String>(newServerAddrList);
        this.iterator = this.iterator();
        this.currentServerAddr = this.iterator.next();
        NotifyCenter.publishEvent(new ServerListChangeEvent());
        LOGGER.info("[{}] [update-serverList] serverList updated to {}", (Object)this.name, this.serverUrls);
    }

    private List<String> getApacheServerList(String url, String name) {
        try {
            HttpRestResult httpResult = this.nacosRestTemplate.get(url, Header.EMPTY, Query.EMPTY, (Type)((Object)String.class));
            if (httpResult.ok()) {
                if (DEFAULT_NAME.equals(name)) {
                    EnvUtil.setSelfEnv(httpResult.getHeader().getOriginalResponseHeader());
                }
                List<String> lines = IoUtils.readLines(new StringReader((String)httpResult.getData()));
                ArrayList<String> result = new ArrayList<String>(lines.size());
                for (String serverAddr : lines) {
                    if (!StringUtils.isNotBlank(serverAddr)) continue;
                    String[] ipPort = InternetAddressUtil.splitIPPortStr(serverAddr.trim());
                    String ip = ipPort[0].trim();
                    if (ipPort.length == 1) {
                        result.add(ip + ":" + ParamUtil.getDefaultServerPort());
                        continue;
                    }
                    result.add(serverAddr);
                }
                return result;
            }
            LOGGER.error("[check-serverlist] error. addressServerUrl: {}, code: {}", (Object)this.addressServerUrl, (Object)httpResult.getCode());
            return null;
        }
        catch (Exception e) {
            LOGGER.error("[check-serverlist] exception. url: " + url, (Throwable)e);
            return null;
        }
    }

    String getUrlString() {
        return this.serverUrls.toString();
    }

    String getFixedNameSuffix(String ... serverIps) {
        StringBuilder sb = new StringBuilder();
        String split = "";
        for (String serverIp : serverIps) {
            sb.append(split);
            serverIp = serverIp.replaceAll("http(s)?://", "");
            sb.append(serverIp.replaceAll(":", "_"));
            split = "-";
        }
        return sb.toString();
    }

    public String toString() {
        return "ServerManager-" + this.name + "-" + this.getUrlString();
    }

    public boolean contain(String ip) {
        return this.serverUrls.contains(ip);
    }

    public void refreshCurrentServerAddr() {
        this.iterator = this.iterator();
        this.currentServerAddr = this.iterator.next();
    }

    public String getNextServerAddr() {
        if (this.iterator == null || !this.iterator.hasNext()) {
            this.refreshCurrentServerAddr();
            return this.currentServerAddr;
        }
        try {
            return this.iterator.next();
        }
        catch (Exception exception) {
            this.refreshCurrentServerAddr();
            return this.currentServerAddr;
        }
    }

    public String getCurrentServerAddr() {
        if (StringUtils.isBlank(this.currentServerAddr)) {
            this.iterator = this.iterator();
            this.currentServerAddr = this.iterator.next();
        }
        return this.currentServerAddr;
    }

    public void updateCurrentServerAddr(String currentServerAddr) {
        this.currentServerAddr = currentServerAddr;
    }

    public Iterator<String> getIterator() {
        return this.iterator;
    }

    public String getContentPath() {
        return this.contentPath;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getTenant() {
        return this.tenant;
    }

    private static class ServerAddressIterator
    implements Iterator<String> {
        final List<RandomizedServerAddress> sorted = new ArrayList<RandomizedServerAddress>();
        final Iterator<RandomizedServerAddress> iter;

        public ServerAddressIterator(List<String> source) {
            for (String address : source) {
                this.sorted.add(new RandomizedServerAddress(address));
            }
            Collections.sort(this.sorted);
            this.iter = this.sorted.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public String next() {
            return this.iter.next().serverIp;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        static class RandomizedServerAddress
        implements Comparable<RandomizedServerAddress> {
            static Random random = new Random();
            String serverIp;
            int priority = 0;
            int seed;

            public RandomizedServerAddress(String ip) {
                try {
                    this.serverIp = ip;
                    this.seed = random.nextInt(Integer.MAX_VALUE);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public int compareTo(RandomizedServerAddress other) {
                if (this.priority != other.priority) {
                    return other.priority - this.priority;
                }
                return other.seed - this.seed;
            }
        }
    }

    class GetServerListTask
    implements Runnable {
        final String url;

        GetServerListTask(String url) {
            this.url = url;
        }

        @Override
        public void run() {
            try {
                ServerListManager.this.updateIfChanged(ServerListManager.this.getApacheServerList(this.url, ServerListManager.this.name));
            }
            catch (Exception e) {
                LOGGER.error("[" + ServerListManager.this.name + "][update-serverlist] failed to update serverlist from address server!", (Throwable)e);
            }
        }
    }
}

