/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.form.impl.jaas;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.security.auth.spi.LoginModule;
import org.apache.felix.jaas.LoginModuleFactory;
import org.apache.sling.auth.form.impl.FormAuthenticationHandler;
import org.apache.sling.auth.form.impl.FormAuthenticationHandlerConfig;
import org.apache.sling.auth.form.impl.jaas.FormLoginModule;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaasHelper {
    private static final Logger log = LoggerFactory.getLogger(JaasHelper.class);
    private final FormAuthenticationHandler authHandler;
    private final ServiceRegistration<?> factoryRegistration;

    public JaasHelper(FormAuthenticationHandler authHandler, BundleContext ctx, FormAuthenticationHandlerConfig config) {
        this.authHandler = authHandler;
        this.factoryRegistration = JaasHelper.hasSSOLoginModule(ctx) ? this.registerLoginModuleFactory(ctx, config) : null;
    }

    public boolean enabled() {
        return this.factoryRegistration != null;
    }

    public void close() {
        if (this.factoryRegistration != null) {
            this.factoryRegistration.unregister();
        }
    }

    private ServiceRegistration<?> registerLoginModuleFactory(BundleContext ctx, FormAuthenticationHandlerConfig config) {
        ServiceRegistration reg = null;
        try {
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            String desc = "LoginModule Support for FormAuthenticationHandler";
            ((Dictionary)props).put("service.description", "LoginModule Support for FormAuthenticationHandler");
            ((Dictionary)props).put("service.vendor", ctx.getBundle().getHeaders().get("Bundle-Vendor"));
            ((Dictionary)props).put("jaas.ranking", config.jaas_ranking());
            ((Dictionary)props).put("jaas.controlFlag", config.jaas_controlFlag());
            ((Dictionary)props).put("jaas.realmName", config.jaas_realmName());
            reg = ctx.registerService(LoginModuleFactory.class.getName(), (Object)new LoginModuleFactory(){

                public LoginModule createLoginModule() {
                    return new FormLoginModule(JaasHelper.this.authHandler);
                }

                public String toString() {
                    return "LoginModule Support for FormAuthenticationHandler (" + FormLoginModule.class.getName() + ")";
                }
            }, props);
            log.info("Registered FormLoginModuleFactory");
        }
        catch (Throwable e) {
            log.error("unable to create an register the SSO login module factory", e);
        }
        return reg;
    }

    private static boolean hasSSOLoginModule(BundleContext ctx) {
        try {
            ctx.getBundle().loadClass("org.apache.sling.auth.form.impl.jaas.FormLoginModule");
            log.debug("FormLoginModule available.");
            return true;
        }
        catch (Throwable e) {
            log.debug("no FormLoginModule available.", e);
            return false;
        }
    }
}

