/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.queue.impl.resource;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.distribution.DistributionRequestType;
import org.apache.sling.distribution.queue.DistributionQueueEntry;
import org.apache.sling.distribution.queue.DistributionQueueItem;
import org.apache.sling.distribution.queue.DistributionQueueItemState;
import org.apache.sling.distribution.queue.DistributionQueueItemStatus;
import org.apache.sling.distribution.queue.impl.resource.ResourceIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceQueueUtils {
    private static final String ID_START = "distrq-";
    private static final String RESOURCE_ROOT = "sling:Folder";
    public static final String RESOURCE_FOLDER = "sling:OrderedFolder";
    private static final String RESOURCE_ITEM = "nt:unstructured";
    private static final String DISTRIBUTION_PACKAGE_PREFIX = "distribution.";
    private static final String DISTRIBUTION_PACKAGE_ID = "distribution.item.id";
    private static final String DISTRIBUTION_PACKAGE_SIZE = "distribution.package.size";
    private static final String ENTERED_DATE = "entered.date";
    private static final String PROCESSING_ATTEMPTS = "processing.attempts";
    private static final AtomicLong itemCounter = new AtomicLong(0L);
    private static final Logger log = LoggerFactory.getLogger(ResourceQueueUtils.class);

    private static Map<String, Object> serializeItem(DistributionQueueItem queueItem) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (String key : queueItem.keySet()) {
            Object value = queueItem.get(key);
            if ("request.type".equals(key) && value instanceof DistributionRequestType) {
                value = ((DistributionRequestType)value).name();
            }
            if (value == null) continue;
            properties.put(DISTRIBUTION_PACKAGE_PREFIX + key, value);
        }
        properties.put(DISTRIBUTION_PACKAGE_ID, queueItem.getPackageId());
        properties.put(DISTRIBUTION_PACKAGE_SIZE, queueItem.getSize());
        return properties;
    }

    private static DistributionQueueItem deserializeItem(ValueMap valueMap) {
        String packageId = (String)valueMap.get(DISTRIBUTION_PACKAGE_ID, String.class);
        Long sizeProperty = (Long)valueMap.get(DISTRIBUTION_PACKAGE_SIZE, Long.class);
        long size = sizeProperty == null ? -1L : sizeProperty;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (String key : valueMap.keySet()) {
            if (!key.startsWith(DISTRIBUTION_PACKAGE_PREFIX)) continue;
            String infoKey = key.substring(DISTRIBUTION_PACKAGE_PREFIX.length());
            Object value = valueMap.get((Object)key);
            if ("request.type".equals(infoKey) && value instanceof String) {
                value = DistributionRequestType.valueOf((String)((String)value));
            }
            properties.put(infoKey, value);
        }
        DistributionQueueItem queueItem = new DistributionQueueItem(packageId, size, properties);
        return queueItem;
    }

    static DistributionQueueEntry readEntry(Resource queueRoot, Resource resource) {
        if (resource == null) {
            return null;
        }
        if (!resource.getPath().startsWith(queueRoot.getPath() + "/")) {
            return null;
        }
        if (!resource.isResourceType(RESOURCE_ITEM)) {
            return null;
        }
        String queueName = queueRoot.getName();
        ValueMap valueMap = resource.getValueMap();
        DistributionQueueItem queueItem = ResourceQueueUtils.deserializeItem(valueMap);
        Calendar entered = (Calendar)valueMap.get(ENTERED_DATE, (Object)Calendar.getInstance());
        int attempts = (Integer)valueMap.get(PROCESSING_ATTEMPTS, (Object)0);
        DistributionQueueItemStatus queueItemStatus = new DistributionQueueItemStatus(entered, DistributionQueueItemState.QUEUED, attempts, queueName);
        String entryId = ResourceQueueUtils.getIdFromPath(queueRoot.getPath(), resource.getPath());
        return new DistributionQueueEntry(entryId, queueItem, queueItemStatus);
    }

    static List<DistributionQueueEntry> getEntries(Resource queueRoot, int skip, int limit) {
        ResourceIterator it = new ResourceIterator(queueRoot, RESOURCE_FOLDER, false, true);
        ArrayList<DistributionQueueEntry> entries = new ArrayList<DistributionQueueEntry>();
        int i = 0;
        while (it.hasNext()) {
            Resource resource = (Resource)it.next();
            if (i++ < skip) continue;
            DistributionQueueEntry entry = ResourceQueueUtils.readEntry(queueRoot, resource);
            entries.add(entry);
            if (limit == -1 || entries.size() < limit) continue;
            break;
        }
        return entries;
    }

    static DistributionQueueEntry getHead(Resource root) {
        Iterator<DistributionQueueEntry> it = ResourceQueueUtils.getEntries(root, 0, 1).iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    public static Resource getRootResource(ResourceResolver resourceResolver, String rootPath) throws PersistenceException {
        Resource resource = ResourceUtil.getOrCreateResource((ResourceResolver)resourceResolver, (String)rootPath, (String)RESOURCE_FOLDER, (String)RESOURCE_ROOT, (boolean)true);
        return resource;
    }

    public static Resource getResourceById(Resource root, String entryId) {
        String entryPath = ResourceQueueUtils.getPathFromId(root.getPath(), entryId);
        return root.getResourceResolver().getResource(entryPath);
    }

    public static Resource createResource(Resource root, DistributionQueueItem queueItem) throws PersistenceException {
        Resource minuteResource = ResourceQueueUtils.getOrCreateMinuteResource(root);
        String entryPath = ResourceQueueUtils.getUniqueEntryPath(minuteResource);
        ResourceResolver resourceResolver = root.getResourceResolver();
        Map<String, Object> properties = ResourceQueueUtils.serializeItem(queueItem);
        properties.put("sling:resourceType", RESOURCE_ITEM);
        properties.put(ENTERED_DATE, Calendar.getInstance());
        Resource resourceItem = ResourceUtil.getOrCreateResource((ResourceResolver)resourceResolver, (String)entryPath, properties, (String)RESOURCE_FOLDER, (boolean)true);
        resourceResolver.commit();
        return resourceItem;
    }

    private static Resource getOrCreateMinuteResource(Resource root) throws PersistenceException {
        int retries = 2;
        for (int i = 0; i < 2; ++i) {
            try {
                return ResourceQueueUtils.tryGetOrCreateMinutes(root);
            }
            catch (PersistenceException e) {
                log.warn("creating minute resource failed. retrying {} more times.", (Object)(2 - i));
                root.getResourceResolver().revert();
                root.getResourceResolver().refresh();
                continue;
            }
        }
        return ResourceQueueUtils.tryGetOrCreateMinutes(root);
    }

    private static Resource tryGetOrCreateMinutes(Resource root) throws PersistenceException {
        Calendar now;
        String firstMinutePath;
        ResourceResolver resourceResolver = root.getResourceResolver();
        Resource firstMinuteResource = resourceResolver.getResource(root, firstMinutePath = ResourceQueueUtils.getTimePath(now = Calendar.getInstance()));
        if (firstMinuteResource != null) {
            return firstMinuteResource;
        }
        for (int i = 0; i < 3; ++i) {
            String newMinutePath = ResourceQueueUtils.getTimePath(now);
            Resource resource = ResourceQueueUtils.createResource(root, newMinutePath);
            log.debug("minute resource created {}", (Object)resource.getPath());
            now.add(12, 1);
        }
        resourceResolver.commit();
        firstMinuteResource = resourceResolver.getResource(root, firstMinutePath);
        return firstMinuteResource;
    }

    private static Resource createResource(Resource root, String relPath) throws PersistenceException {
        ResourceResolver resourceResolver = root.getResourceResolver();
        String path = root.getPath() + "/" + relPath;
        String parentPath = ResourceUtil.getParent((String)path);
        String name = ResourceUtil.getName((String)path);
        Resource parent = ResourceUtil.getOrCreateResource((ResourceResolver)resourceResolver, (String)parentPath, (String)RESOURCE_FOLDER, (String)RESOURCE_FOLDER, (boolean)false);
        Map<String, String> props = Collections.singletonMap("sling:resourceType", RESOURCE_FOLDER);
        return resourceResolver.create(parent, name, props);
    }

    public static void deleteResource(Resource resource) throws PersistenceException {
        block2: {
            ResourceResolver resolver = resource.getResourceResolver();
            String path = resource.getPath();
            try {
                resolver.delete(resource);
                resolver.commit();
            }
            catch (PersistenceException var10) {
                resolver.revert();
                resolver.refresh();
                resource = resolver.getResource(path);
                if (resource == null) break block2;
                resolver.delete(resource);
                resolver.commit();
            }
        }
    }

    public static int getResourceCount(Resource root) {
        return ResourceQueueUtils.getEntries(root, 0, -1).size();
    }

    private static String getUniqueEntryPath(Resource parent) {
        StringBuilder sb = new StringBuilder();
        sb.append(parent.getPath());
        sb.append('/');
        sb.append(UUID.randomUUID().toString().replace("-", ""));
        sb.append('_');
        sb.append(itemCounter.getAndIncrement());
        return sb.toString();
    }

    public static String getTimePath(Calendar now) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd/HH/mm");
        return sdf.format(now.getTime());
    }

    public static boolean isSafeToDelete(String nowPath, String path) {
        if (nowPath.length() < path.length()) {
            return false;
        }
        return (nowPath = nowPath.substring(0, path.length())).compareTo(path) > 0;
    }

    private static String getPathFromId(String roothPath, String entryId) {
        String entryPath = ResourceQueueUtils.unescapeId(entryId);
        return roothPath + "/" + entryPath;
    }

    private static String getIdFromPath(String rootPath, String path) {
        if (path.startsWith(rootPath)) {
            String entryPath = path.substring(rootPath.length() + 1);
            String entryId = ResourceQueueUtils.escapeId(entryPath);
            return entryId;
        }
        throw new IllegalArgumentException("entry path does not start with " + rootPath);
    }

    private static String escapeId(String jobId) {
        if (jobId == null) {
            return null;
        }
        return ID_START + jobId.replace("/", "--");
    }

    public static String unescapeId(String itemId) {
        if (itemId == null) {
            return null;
        }
        if (!itemId.startsWith(ID_START)) {
            return null;
        }
        return itemId.replace(ID_START, "").replace("--", "/");
    }

    public static void incrementProcessingAttemptForQueueItem(Resource queueItemResource) {
        ValueMap vm = (ValueMap)queueItemResource.adaptTo(ModifiableValueMap.class);
        int attempts = (Integer)vm.get(PROCESSING_ATTEMPTS, (Object)0);
        vm.put((Object)PROCESSING_ATTEMPTS, (Object)(attempts + 1));
    }
}

