/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.dynamicinclude;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.dynamicinclude.Configuration;
import org.apache.sling.dynamicinclude.ConfigurationWhiteboard;
import org.apache.sling.dynamicinclude.api.IncludeGenerator;
import org.apache.sling.dynamicinclude.generator.IncludeGeneratorWhiteboard;
import org.apache.sling.dynamicinclude.impl.UrlBuilder;
import org.apache.sling.dynamicinclude.util.RequestHelperUtil;
import org.apache.sling.servlets.annotations.SlingServletFilter;
import org.apache.sling.servlets.annotations.SlingServletFilterScope;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServletFilter(scope={SlingServletFilterScope.INCLUDE})
@Component(property={"service.ranking:Integer=-500"})
public class IncludeTagFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(IncludeTagFilter.class);
    private static final String COMMENT = "<!-- SDI include (path: %s, resourceType: %s) -->\n";
    @Reference
    private ConfigurationWhiteboard configurationWhiteboard;
    @Reference
    private IncludeGeneratorWhiteboard generatorWhiteboard;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)request;
        String resourceType = slingRequest.getResource().getResourceType();
        Configuration config = this.configurationWhiteboard.getConfiguration(slingRequest, resourceType);
        if (config == null) {
            chain.doFilter(request, response);
            return;
        }
        IncludeGenerator generator = this.generatorWhiteboard.getGenerator(config.getIncludeTypeName());
        if (generator == null) {
            LOG.error("Invalid generator: " + config.getIncludeTypeName());
            chain.doFilter(request, response);
            return;
        }
        PrintWriter writer = response.getWriter();
        String url = this.getUrl(config, slingRequest);
        if (url == null) {
            chain.doFilter(request, response);
            return;
        }
        if (config.getAddComment()) {
            writer.append(String.format(COMMENT, StringEscapeUtils.escapeHtml4((String)url), resourceType));
        }
        if (this.shouldWriteIncludes(config, slingRequest)) {
            String include = generator.getInclude(slingRequest, url);
            LOG.debug(include);
            writer.append(include);
        } else {
            chain.doFilter(request, response);
        }
    }

    private boolean shouldWriteIncludes(Configuration config, SlingHttpServletRequest request) {
        if (!config.isDisableIgnoreUrlParams() && RequestHelperUtil.requestHasNonIgnoredParameters(config.getIgnoreUrlParams(), request)) {
            return false;
        }
        String requiredHeader = config.getRequiredHeader();
        return StringUtils.isBlank((CharSequence)requiredHeader) || this.containsHeader(requiredHeader, request);
    }

    private boolean containsHeader(String requiredHeader, SlingHttpServletRequest request) {
        String expectedValue;
        String name;
        if (StringUtils.contains((CharSequence)requiredHeader, (int)61)) {
            String[] split = StringUtils.split((String)requiredHeader, (char)'=');
            name = split[0];
            expectedValue = split[1];
        } else {
            name = requiredHeader;
            expectedValue = null;
        }
        String actualValue = request.getHeader(name);
        if (actualValue == null) {
            return false;
        }
        if (expectedValue == null) {
            return true;
        }
        return actualValue.equalsIgnoreCase(expectedValue);
    }

    private String getUrl(Configuration config, SlingHttpServletRequest request) {
        String url = this.buildUrl(config, request);
        if (config.isRewritePath()) {
            url = IncludeTagFilter.removeQuestionMark(url);
            url = request.getResourceResolver().map((HttpServletRequest)request, url);
        } else {
            url = IncludeTagFilter.encodeJcrContentPart(url);
            try {
                url = new URI(null, null, url, null).toASCIIString();
            }
            catch (URISyntaxException e) {
                LOG.error("Include url is in the wrong format", (Throwable)e);
                return null;
            }
        }
        return url;
    }

    private String buildUrl(Configuration config, SlingHttpServletRequest request) {
        Resource resource = request.getResource();
        boolean synthetic = ResourceUtil.isSyntheticResource((Resource)request.getResource());
        return UrlBuilder.buildUrl(config.getIncludeSelector(), resource.getResourceType(), synthetic, config, request.getRequestPathInfo());
    }

    private static String sanitize(String path) {
        return StringUtils.defaultString((String)path);
    }

    private static String encodeJcrContentPart(String url) {
        return url.replace("jcr:content", "_jcr_content");
    }

    private static String removeQuestionMark(String url) {
        return url.replaceAll("[?]", "");
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

