/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingPolicy;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingPolicyBuilder;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingPolicyFluentImpl;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingRules;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingRulesFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class HPAScalingRulesFluentImpl<A extends HPAScalingRulesFluent<A>>
extends BaseFluent<A>
implements HPAScalingRulesFluent<A> {
    private List<HPAScalingPolicyBuilder> policies = new ArrayList<HPAScalingPolicyBuilder>();
    private String selectPolicy;
    private Integer stabilizationWindowSeconds;

    public HPAScalingRulesFluentImpl() {
    }

    public HPAScalingRulesFluentImpl(HPAScalingRules instance) {
        this.withPolicies(instance.getPolicies());
        this.withSelectPolicy(instance.getSelectPolicy());
        this.withStabilizationWindowSeconds(instance.getStabilizationWindowSeconds());
    }

    @Override
    public A addToPolicies(int index, HPAScalingPolicy item) {
        if (this.policies == null) {
            this.policies = new ArrayList<HPAScalingPolicyBuilder>();
        }
        HPAScalingPolicyBuilder builder = new HPAScalingPolicyBuilder(item);
        this._visitables.get("policies").add(index >= 0 ? index : this._visitables.get("policies").size(), builder);
        this.policies.add(index >= 0 ? index : this.policies.size(), builder);
        return (A)this;
    }

    @Override
    public A setToPolicies(int index, HPAScalingPolicy item) {
        if (this.policies == null) {
            this.policies = new ArrayList<HPAScalingPolicyBuilder>();
        }
        HPAScalingPolicyBuilder builder = new HPAScalingPolicyBuilder(item);
        if (index < 0 || index >= this._visitables.get("policies").size()) {
            this._visitables.get("policies").add(builder);
        } else {
            this._visitables.get("policies").set(index, builder);
        }
        if (index < 0 || index >= this.policies.size()) {
            this.policies.add(builder);
        } else {
            this.policies.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPolicies(HPAScalingPolicy ... items) {
        if (this.policies == null) {
            this.policies = new ArrayList<HPAScalingPolicyBuilder>();
        }
        for (HPAScalingPolicy item : items) {
            HPAScalingPolicyBuilder builder = new HPAScalingPolicyBuilder(item);
            this._visitables.get("policies").add(builder);
            this.policies.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPolicies(Collection<HPAScalingPolicy> items) {
        if (this.policies == null) {
            this.policies = new ArrayList<HPAScalingPolicyBuilder>();
        }
        for (HPAScalingPolicy item : items) {
            HPAScalingPolicyBuilder builder = new HPAScalingPolicyBuilder(item);
            this._visitables.get("policies").add(builder);
            this.policies.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPolicies(HPAScalingPolicy ... items) {
        for (HPAScalingPolicy item : items) {
            HPAScalingPolicyBuilder builder = new HPAScalingPolicyBuilder(item);
            this._visitables.get("policies").remove(builder);
            if (this.policies == null) continue;
            this.policies.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPolicies(Collection<HPAScalingPolicy> items) {
        for (HPAScalingPolicy item : items) {
            HPAScalingPolicyBuilder builder = new HPAScalingPolicyBuilder(item);
            this._visitables.get("policies").remove(builder);
            if (this.policies == null) continue;
            this.policies.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromPolicies(Predicate<HPAScalingPolicyBuilder> predicate) {
        if (this.policies == null) {
            return (A)this;
        }
        Iterator<HPAScalingPolicyBuilder> each = this.policies.iterator();
        Object visitables = this._visitables.get("policies");
        while (each.hasNext()) {
            HPAScalingPolicyBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<HPAScalingPolicy> getPolicies() {
        return HPAScalingRulesFluentImpl.build(this.policies);
    }

    @Override
    public List<HPAScalingPolicy> buildPolicies() {
        return HPAScalingRulesFluentImpl.build(this.policies);
    }

    @Override
    public HPAScalingPolicy buildPolicy(int index) {
        return this.policies.get(index).build();
    }

    @Override
    public HPAScalingPolicy buildFirstPolicy() {
        return this.policies.get(0).build();
    }

    @Override
    public HPAScalingPolicy buildLastPolicy() {
        return this.policies.get(this.policies.size() - 1).build();
    }

    @Override
    public HPAScalingPolicy buildMatchingPolicy(Predicate<HPAScalingPolicyBuilder> predicate) {
        for (HPAScalingPolicyBuilder item : this.policies) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPolicy(Predicate<HPAScalingPolicyBuilder> predicate) {
        for (HPAScalingPolicyBuilder item : this.policies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPolicies(List<HPAScalingPolicy> policies) {
        if (this.policies != null) {
            this._visitables.get("policies").removeAll(this.policies);
        }
        if (policies != null) {
            this.policies = new ArrayList<HPAScalingPolicyBuilder>();
            for (HPAScalingPolicy item : policies) {
                this.addToPolicies(item);
            }
        } else {
            this.policies = null;
        }
        return (A)this;
    }

    @Override
    public A withPolicies(HPAScalingPolicy ... policies) {
        if (this.policies != null) {
            this.policies.clear();
        }
        if (policies != null) {
            for (HPAScalingPolicy item : policies) {
                this.addToPolicies(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPolicies() {
        return this.policies != null && !this.policies.isEmpty();
    }

    @Override
    public A addNewPolicy(Integer periodSeconds, String type, Integer value) {
        return this.addToPolicies(new HPAScalingPolicy(periodSeconds, type, value));
    }

    @Override
    public HPAScalingRulesFluent.PoliciesNested<A> addNewPolicy() {
        return new PoliciesNestedImpl();
    }

    @Override
    public HPAScalingRulesFluent.PoliciesNested<A> addNewPolicyLike(HPAScalingPolicy item) {
        return new PoliciesNestedImpl(-1, item);
    }

    @Override
    public HPAScalingRulesFluent.PoliciesNested<A> setNewPolicyLike(int index, HPAScalingPolicy item) {
        return new PoliciesNestedImpl(index, item);
    }

    @Override
    public HPAScalingRulesFluent.PoliciesNested<A> editPolicy(int index) {
        if (this.policies.size() <= index) {
            throw new RuntimeException("Can't edit policies. Index exceeds size.");
        }
        return this.setNewPolicyLike(index, this.buildPolicy(index));
    }

    @Override
    public HPAScalingRulesFluent.PoliciesNested<A> editFirstPolicy() {
        if (this.policies.size() == 0) {
            throw new RuntimeException("Can't edit first policies. The list is empty.");
        }
        return this.setNewPolicyLike(0, this.buildPolicy(0));
    }

    @Override
    public HPAScalingRulesFluent.PoliciesNested<A> editLastPolicy() {
        int index = this.policies.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last policies. The list is empty.");
        }
        return this.setNewPolicyLike(index, this.buildPolicy(index));
    }

    @Override
    public HPAScalingRulesFluent.PoliciesNested<A> editMatchingPolicy(Predicate<HPAScalingPolicyBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.policies.size(); ++i) {
            if (!predicate.test(this.policies.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching policies. No match found.");
        }
        return this.setNewPolicyLike(index, this.buildPolicy(index));
    }

    @Override
    public String getSelectPolicy() {
        return this.selectPolicy;
    }

    @Override
    public A withSelectPolicy(String selectPolicy) {
        this.selectPolicy = selectPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasSelectPolicy() {
        return this.selectPolicy != null;
    }

    @Override
    @Deprecated
    public A withNewSelectPolicy(String arg0) {
        return this.withSelectPolicy(new String(arg0));
    }

    @Override
    public Integer getStabilizationWindowSeconds() {
        return this.stabilizationWindowSeconds;
    }

    @Override
    public A withStabilizationWindowSeconds(Integer stabilizationWindowSeconds) {
        this.stabilizationWindowSeconds = stabilizationWindowSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasStabilizationWindowSeconds() {
        return this.stabilizationWindowSeconds != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HPAScalingRulesFluentImpl that = (HPAScalingRulesFluentImpl)o;
        if (this.policies != null ? !this.policies.equals(that.policies) : that.policies != null) {
            return false;
        }
        if (this.selectPolicy != null ? !this.selectPolicy.equals(that.selectPolicy) : that.selectPolicy != null) {
            return false;
        }
        return !(this.stabilizationWindowSeconds != null ? !this.stabilizationWindowSeconds.equals(that.stabilizationWindowSeconds) : that.stabilizationWindowSeconds != null);
    }

    public int hashCode() {
        return Objects.hash(this.policies, this.selectPolicy, this.stabilizationWindowSeconds, super.hashCode());
    }

    public class PoliciesNestedImpl<N>
    extends HPAScalingPolicyFluentImpl<HPAScalingRulesFluent.PoliciesNested<N>>
    implements HPAScalingRulesFluent.PoliciesNested<N>,
    Nested<N> {
        private final HPAScalingPolicyBuilder builder;
        private final int index;

        PoliciesNestedImpl(int index, HPAScalingPolicy item) {
            this.index = index;
            this.builder = new HPAScalingPolicyBuilder(this, item);
        }

        PoliciesNestedImpl() {
            this.index = -1;
            this.builder = new HPAScalingPolicyBuilder(this);
        }

        @Override
        public N and() {
            return (N)HPAScalingRulesFluentImpl.this.setToPolicies(this.index, this.builder.build());
        }

        @Override
        public N endPolicy() {
            return this.and();
        }
    }
}

