/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.lineage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.apache.sysds.runtime.controlprogram.BasicProgramBlock;
import org.apache.sysds.runtime.controlprogram.ForProgramBlock;
import org.apache.sysds.runtime.controlprogram.FunctionProgramBlock;
import org.apache.sysds.runtime.controlprogram.IfProgramBlock;
import org.apache.sysds.runtime.controlprogram.ProgramBlock;
import org.apache.sysds.runtime.controlprogram.WhileProgramBlock;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.lineage.Lineage;
import org.apache.sysds.runtime.lineage.LineageCache;
import org.apache.sysds.runtime.lineage.LineageCacheConfig;
import org.apache.sysds.runtime.lineage.LineageDedupBlock;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.lineage.LineageItemUtils;
import org.apache.sysds.runtime.lineage.LineageMap;
import org.apache.sysds.utils.Explain;

public class LineageDedupUtils {
    public static final String DEDUP_DELIM = "_";
    private static Lineage _tmpLineage = null;
    private static Lineage _mainLineage = null;
    private static ArrayList<Long> _numDistinctPaths = new ArrayList();
    private static long _maxNumPaths = 0L;
    private static int _numPaths = 0;

    public static boolean isValidDedupBlock(ProgramBlock pb, boolean inLoop) {
        boolean ret;
        block8: {
            block10: {
                block9: {
                    block7: {
                        ret = true;
                        if (!(pb instanceof FunctionProgramBlock)) break block7;
                        FunctionProgramBlock fsb = (FunctionProgramBlock)pb;
                        for (ProgramBlock cpb : fsb.getChildBlocks()) {
                            ret &= LineageDedupUtils.isValidDedupBlock(cpb, inLoop);
                        }
                        break block8;
                    }
                    if (!(pb instanceof WhileProgramBlock)) break block9;
                    if (inLoop) {
                        return false;
                    }
                    WhileProgramBlock wpb = (WhileProgramBlock)pb;
                    for (ProgramBlock cpb : wpb.getChildBlocks()) {
                        ret &= LineageDedupUtils.isValidDedupBlock(cpb, true);
                    }
                    break block8;
                }
                if (!(pb instanceof IfProgramBlock)) break block10;
                IfProgramBlock ipb = (IfProgramBlock)pb;
                for (ProgramBlock cpb : ipb.getChildBlocksIfBody()) {
                    ret &= LineageDedupUtils.isValidDedupBlock(cpb, inLoop);
                }
                for (ProgramBlock cpb : ipb.getChildBlocksElseBody()) {
                    ret &= LineageDedupUtils.isValidDedupBlock(cpb, inLoop);
                }
                break block8;
            }
            if (!(pb instanceof ForProgramBlock)) break block8;
            if (inLoop) {
                return false;
            }
            ForProgramBlock fpb = (ForProgramBlock)pb;
            for (ProgramBlock cpb : fpb.getChildBlocks()) {
                ret &= LineageDedupUtils.isValidDedupBlock(cpb, true);
            }
        }
        return ret;
    }

    public static LineageDedupBlock computeDedupBlock(ProgramBlock fpb, ExecutionContext ec) {
        LineageDedupBlock ldb = new LineageDedupBlock();
        ec.getLineage().setInitDedupBlock(ldb);
        ldb.traceProgramBlocks(fpb.getChildBlocks(), ec);
        ec.getLineage().setInitDedupBlock(null);
        return ldb;
    }

    public static LineageDedupBlock initializeDedupBlock(ProgramBlock fpb, ExecutionContext ec) {
        LineageDedupBlock ldb = new LineageDedupBlock();
        ec.getLineage().setInitDedupBlock(ldb);
        LineageDedupUtils.initLocalLineage(ec);
        _mainLineage = ec.getLineage();
        ldb.setNumPathsInPBs(fpb.getChildBlocks(), ec);
        ec.getLineage().setInitDedupBlock(null);
        return ldb;
    }

    public static void setNewDedupPatch(LineageDedupBlock ldb, ProgramBlock fpb, ExecutionContext ec) {
        if (ldb.isAllPathsTaken() && LineageCacheConfig.ReuseCacheType.isNone()) {
            return;
        }
        LineageDedupUtils.initLocalLineage(ec);
        ArrayList<String> inputnames = fpb.getStatementBlock().getInputstoSB();
        LineageItem[] liinputs = LineageItemUtils.getLineageItemInputstoSB(inputnames, ec);
        String ph = "IN#";
        int i = 0;
        for (String input : inputnames) {
            if (ec.getVariable(input) == null) continue;
            LineageItem phInput = new LineageItem(ph + String.valueOf(i), new LineageItem[]{liinputs[i]});
            _tmpLineage.set(input, phInput);
            ++i;
        }
        _tmpLineage.setDedupBlock(ldb);
        ec.setLineage(_tmpLineage);
    }

    public static void replaceLineage(ExecutionContext ec) {
        ec.setLineage(_mainLineage);
    }

    public static Map<String, Integer> setDedupMap(LineageDedupBlock ldb, long takenPath) {
        if (ldb.getMap(takenPath) == null) {
            LineageMap patchMap = _tmpLineage.getLineageMap();
            LineageDedupUtils.cleanDedupMap(patchMap);
            ldb.setMap(takenPath, patchMap);
        }
        if (!LineageCacheConfig.ReuseCacheType.isNone()) {
            HashMap<String, Integer> dedupPatchHashList = new HashMap<String, Integer>();
            LineageMap patchMap = _tmpLineage.getLineageMap();
            for (Map.Entry<String, LineageItem> litem : patchMap.getTraces().entrySet()) {
                if (litem.getValue().isPlaceholder()) continue;
                dedupPatchHashList.put(litem.getKey(), litem.getValue().hashCode());
            }
            return dedupPatchHashList;
        }
        return null;
    }

    private static void initLocalLineage(ExecutionContext ec) {
        _mainLineage = ec.getLineage();
        _tmpLineage = _tmpLineage == null ? new Lineage() : _tmpLineage;
        _tmpLineage.clearLineageMap();
        _tmpLineage.clearDedupBlock();
    }

    public static String mergeExplainDedupBlocks(ExecutionContext ec) {
        Map<ProgramBlock, LineageDedupBlock> dedupBlocks = ec.getLineage().getDedupBlocks();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<ProgramBlock, LineageDedupBlock> dblock : dedupBlocks.entrySet()) {
            if (dblock.getValue() == null) continue;
            String forKey = dblock.getKey().getStatementBlock().getName();
            LineageDedupBlock dedup = dblock.getValue();
            for (Map.Entry<Long, LineageMap> patch : dedup.getPathMaps().entrySet()) {
                for (Map.Entry<String, LineageItem> root : patch.getValue().getTraces().entrySet()) {
                    sb.append("patch");
                    sb.append(DEDUP_DELIM);
                    sb.append(root.getKey());
                    sb.append(DEDUP_DELIM);
                    sb.append(forKey);
                    sb.append(DEDUP_DELIM);
                    sb.append(patch.getKey());
                    sb.append("\n");
                    sb.append(Explain.explain(root.getValue()));
                    sb.append("\n");
                }
            }
        }
        return sb.toString();
    }

    private static void cleanDedupMap(LineageMap lmap) {
        HashSet<String> emptyRoots = new HashSet<String>();
        for (Map.Entry<String, LineageItem> litem : lmap.getTraces().entrySet()) {
            LineageItem root = litem.getValue();
            if (root.isPlaceholder()) {
                emptyRoots.add(litem.getKey());
                continue;
            }
            root.resetVisitStatusNR();
            LineageDedupUtils.cutAtPlaceholder(root);
            if (LineageCacheConfig.ReuseCacheType.isNone()) continue;
            LineageCache.removeEntry(root);
        }
        lmap.getTraces().keySet().removeAll(emptyRoots);
    }

    private static void cutAtPlaceholder(LineageItem root) {
        Stack<LineageItem> q = new Stack<LineageItem>();
        q.push(root);
        while (!q.empty()) {
            LineageItem tmp = (LineageItem)q.pop();
            if (tmp.isVisited()) continue;
            if (tmp.isPlaceholder()) {
                tmp.resetInputs();
                tmp.setVisited();
                continue;
            }
            if (tmp.getInputs() != null) {
                for (int i = 0; i < tmp.getInputs().length; ++i) {
                    LineageItem li = tmp.getInputs()[i];
                    q.push(li);
                }
            }
            tmp.setVisited();
        }
    }

    public static long computeNumPaths(ProgramBlock fpb, ExecutionContext ec) {
        if (fpb == null || fpb.getChildBlocks() == null) {
            return 0L;
        }
        _numDistinctPaths.clear();
        long n = LineageDedupUtils.numPathsInPBs(fpb.getChildBlocks(), ec);
        if (n > _maxNumPaths) {
            _maxNumPaths = n;
            System.out.println("\nmax no of paths : " + _maxNumPaths + "\n");
        }
        return n;
    }

    public static long numPathsInPBs(ArrayList<ProgramBlock> pbs, ExecutionContext ec) {
        if (_numDistinctPaths.size() == 0) {
            _numDistinctPaths.add(0L);
        }
        for (ProgramBlock pb : pbs) {
            LineageDedupUtils.numPathsInPB(pb, ec, _numDistinctPaths);
        }
        return _numDistinctPaths.size();
    }

    private static void numPathsInPB(ProgramBlock pb, ExecutionContext ec, ArrayList<Long> paths) {
        if (!(pb instanceof IfProgramBlock)) {
            if (pb instanceof BasicProgramBlock) {
                return;
            }
            return;
        }
        LineageDedupUtils.numPathsInIfPB((IfProgramBlock)pb, ec, paths);
    }

    private static void numPathsInIfPB(IfProgramBlock ipb, ExecutionContext ec, ArrayList<Long> paths) {
        ipb.setLineageDedupPathPos(_numPaths++);
        ArrayList<Long> rep = new ArrayList<Long>();
        int pathKey = 1 << _numPaths - 1;
        Iterator<Object> iterator = paths.iterator();
        while (iterator.hasNext()) {
            long p = iterator.next();
            long pathIndex = p | (long)pathKey;
            rep.add(pathIndex);
        }
        _numDistinctPaths.addAll(rep);
        for (ProgramBlock pb : ipb.getChildBlocksIfBody()) {
            LineageDedupUtils.numPathsInPB(pb, ec, rep);
        }
        for (ProgramBlock pb : ipb.getChildBlocksElseBody()) {
            LineageDedupUtils.numPathsInPB(pb, ec, paths);
        }
    }
}

