/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client.cdi;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.util.NoSuchElementException;
import org.apache.cxf.Bus;
import org.apache.cxf.microprofile.client.cdi.Instance;

public final class CDIUtils {
    private CDIUtils() {
    }

    static BeanManager getCurrentBeanManager(Bus bus) {
        BeanManager bm = (BeanManager)bus.getExtension(BeanManager.class);
        if (bm == null) {
            bm = CDIUtils.getCurrentBeanManager();
            bus.setExtension((Object)bm, BeanManager.class);
        }
        return bm;
    }

    static BeanManager getCurrentBeanManager() {
        return CDI.current().getBeanManager();
    }

    static <T> Instance<T> getInstanceFromCDI(Class<T> clazz) {
        return CDIUtils.getInstanceFromCDI(clazz, null);
    }

    static <T> Instance<T> getInstanceFromCDI(Class<T> clazz, Bus bus) {
        Instance<T> instance;
        try {
            instance = CDIUtils.findBean(clazz, bus);
        }
        catch (ExceptionInInitializerError | IllegalStateException | NoClassDefFoundError ex) {
            instance = null;
        }
        catch (NoSuchElementException ex) {
            instance = null;
        }
        return instance;
    }

    private static <T> Instance<T> findBean(Class<T> clazz, Bus bus) {
        BeanManager beanManager = bus == null ? CDIUtils.getCurrentBeanManager() : CDIUtils.getCurrentBeanManager(bus);
        Bean bean = (Bean)beanManager.getBeans(clazz, new Annotation[0]).iterator().next();
        CreationalContext ctx = beanManager.createCreationalContext((Contextual)bean);
        Instance<Object> instance = new Instance<Object>(beanManager.getReference(bean, clazz, ctx), beanManager.isNormalScope(bean.getScope()) ? () -> {} : () -> ((CreationalContext)ctx).release());
        return instance;
    }
}

