/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.timer;

import jakarta.ejb.ScheduleExpression;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.openejb.core.timer.EJBCronTrigger;
import org.apache.openejb.quartz.JobDetail;
import org.apache.openejb.quartz.ScheduleBuilder;
import org.apache.openejb.quartz.TriggerKey;
import org.apache.openejb.quartz.impl.jdbcjobstore.CronTriggerPersistenceDelegate;
import org.apache.openejb.quartz.impl.jdbcjobstore.TriggerPersistenceDelegate;
import org.apache.openejb.quartz.impl.jdbcjobstore.Util;
import org.apache.openejb.quartz.spi.MutableTrigger;
import org.apache.openejb.quartz.spi.OperableTrigger;

public class EJBCronTriggerPersistenceDelegate
extends CronTriggerPersistenceDelegate {
    public String getHandledTriggerTypeDiscriminator() {
        return "EJB_CRON";
    }

    public boolean canHandleTriggerType(OperableTrigger trigger) {
        return trigger instanceof EJBCronTrigger;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TriggerPersistenceDelegate.TriggerPropertyBundle loadExtendedTriggerProperties(Connection conn, TriggerKey triggerKey) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        ps = conn.prepareStatement(Util.rtp((String)"SELECT * FROM {0}CRON_TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?", (String)this.tablePrefix, (String)this.schedNameLiteral));
        ps.setString(1, triggerKey.getName());
        ps.setString(2, triggerKey.getGroup());
        rs = ps.executeQuery();
        if (!rs.next()) throw new IllegalStateException("No record found for selection of Trigger with key: '" + triggerKey + "' and statement: " + Util.rtp((String)"SELECT * FROM {0}CRON_TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?", (String)this.tablePrefix, (String)this.schedNameLiteral));
        String cronExpr = rs.getString("CRON_EXPRESSION");
        String timeZoneId = rs.getString("TIME_ZONE_ID");
        String[] parts = cronExpr.split(";");
        EJBCronTrigger cb = new EJBCronTrigger(new ScheduleExpression().year(parts[0]).month(parts[1]).dayOfMonth(parts[2]).dayOfWeek(parts[3]).hour(parts[4]).minute(parts[5]).second(parts[6]).timezone(timeZoneId));
        TriggerPersistenceDelegate.TriggerPropertyBundle triggerPropertyBundle = new TriggerPersistenceDelegate.TriggerPropertyBundle((ScheduleBuilder)new EJBCronTriggerSceduleBuilder(cb), null, null);
        Util.closeResultSet((ResultSet)rs);
        Util.closeStatement((Statement)ps);
        return triggerPropertyBundle;
        {
            catch (EJBCronTrigger.ParseException e) {
                try {
                    throw new IllegalStateException("Can't build the Trigger with key: '" + triggerKey + "' and statement: " + Util.rtp((String)"SELECT * FROM {0}CRON_TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?", (String)this.tablePrefix, (String)this.schedNameLiteral));
                }
                catch (Throwable throwable) {
                    Util.closeResultSet(rs);
                    Util.closeStatement(ps);
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertExtendedTriggerProperties(Connection conn, OperableTrigger trigger, String state, JobDetail jobDetail) throws SQLException, IOException {
        int n;
        EJBCronTrigger cronTrigger = (EJBCronTrigger)trigger;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(Util.rtp((String)"INSERT INTO {0}CRON_TRIGGERS (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, CRON_EXPRESSION, TIME_ZONE_ID)  VALUES({1}, ?, ?, ?, ?)", (String)this.tablePrefix, (String)this.schedNameLiteral));
            ps.setString(1, trigger.getKey().getName());
            ps.setString(2, trigger.getKey().getGroup());
            ps.setString(3, cronTrigger.getRawValue());
            ps.setString(4, cronTrigger.getTimeZone().getID());
            n = ps.executeUpdate();
        }
        catch (Throwable throwable) {
            Util.closeStatement(ps);
            throw throwable;
        }
        Util.closeStatement((Statement)ps);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateExtendedTriggerProperties(Connection conn, OperableTrigger trigger, String state, JobDetail jobDetail) throws SQLException, IOException {
        int n;
        EJBCronTrigger cronTrigger = (EJBCronTrigger)trigger;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(Util.rtp((String)"UPDATE {0}CRON_TRIGGERS SET CRON_EXPRESSION = ?, TIME_ZONE_ID = ? WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?", (String)this.tablePrefix, (String)this.schedNameLiteral));
            ps.setString(1, cronTrigger.getRawValue());
            ps.setString(2, cronTrigger.getTimeZone().getID());
            ps.setString(3, trigger.getKey().getName());
            ps.setString(4, trigger.getKey().getGroup());
            n = ps.executeUpdate();
        }
        catch (Throwable throwable) {
            Util.closeStatement(ps);
            throw throwable;
        }
        Util.closeStatement((Statement)ps);
        return n;
    }

    private static class EJBCronTriggerSceduleBuilder
    extends ScheduleBuilder<EJBCronTrigger> {
        private final EJBCronTrigger trigger;

        public EJBCronTriggerSceduleBuilder(EJBCronTrigger trig) {
            this.trigger = trig;
        }

        protected MutableTrigger build() {
            return this.trigger;
        }
    }
}

