/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.torque.om;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fulcrum.security.torque.om.BaseTorqueDynamicPermissionPeer;
import org.apache.fulcrum.security.torque.om.TorqueDynamicPermission;
import org.apache.torque.Column;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.om.mapper.MappingStrategy;
import org.apache.torque.om.mapper.RecordMapper;
import org.apache.torque.util.UniqueColumnList;

public class BaseTorqueDynamicPermissionRecordMapper
implements RecordMapper<TorqueDynamicPermission> {
    private static final long serialVersionUID = 1735909173174L;
    private static Log log = LogFactory.getLog(BaseTorqueDynamicPermissionRecordMapper.class);
    private static final String PERMISSION_ID_EXPRESSION = BaseTorqueDynamicPermissionPeer.PERMISSION_ID.getSqlExpression();
    private static final String PERMISSION_NAME_EXPRESSION = BaseTorqueDynamicPermissionPeer.PERMISSION_NAME.getSqlExpression();
    private boolean useMappingStrategy = true;
    private MappingStrategy<TorqueDynamicPermission> strategy;

    public void initStrategy() {
        this.strategy = new MappingStrategy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TorqueDynamicPermission processRow(ResultSet resultSet, int offset, Criteria criteria) throws TorqueException {
        TorqueDynamicPermission torqueDynamicPermission = new TorqueDynamicPermission();
        try {
            torqueDynamicPermission.setLoading(true);
            if (criteria == null) {
                torqueDynamicPermission.setEntityId(this.getEntityId(resultSet, offset + 1));
                torqueDynamicPermission.setEntityName(this.getEntityName(resultSet, offset + 2));
            } else {
                if (this.useMappingStrategy) {
                    this.initStrategy();
                }
                int totalOffset = offset + 1;
                UniqueColumnList selectColumns = criteria.getSelectColumns();
                List columnsWithoutOffset = selectColumns.subList(offset, selectColumns.size());
                HashSet<String> columnsMapped = new HashSet<String>();
                for (Column column : columnsWithoutOffset) {
                    int nextOffset = totalOffset;
                    if (!columnsMapped.contains(PERMISSION_ID_EXPRESSION) && PERMISSION_ID_EXPRESSION.equals(column.getSqlExpression())) {
                        if (this.useMappingStrategy) {
                            this.strategy.addColumn(nextOffset, (res, inst) -> inst.setEntityId(this.getEntityId((ResultSet)res, nextOffset)));
                        } else {
                            torqueDynamicPermission.setEntityId(this.getEntityId(resultSet, totalOffset));
                        }
                        columnsMapped.add(PERMISSION_ID_EXPRESSION);
                    } else if (!columnsMapped.contains(PERMISSION_NAME_EXPRESSION) && PERMISSION_NAME_EXPRESSION.equals(column.getSqlExpression())) {
                        if (this.useMappingStrategy) {
                            this.strategy.addColumn(nextOffset, (res, inst) -> inst.setEntityName(this.getEntityName((ResultSet)res, nextOffset)));
                        } else {
                            torqueDynamicPermission.setEntityName(this.getEntityName(resultSet, totalOffset));
                        }
                        columnsMapped.add(PERMISSION_NAME_EXPRESSION);
                    }
                    ++totalOffset;
                }
                if (columnsMapped.isEmpty()) {
                    log.debug((Object)"no columns to map found in criteria, returning null");
                    Iterator iterator = null;
                    return iterator;
                }
                if (this.useMappingStrategy) {
                    this.strategy.finish(2, true);
                    this.strategy.execute(resultSet, (Object)torqueDynamicPermission);
                }
            }
            torqueDynamicPermission.setNew(false);
            torqueDynamicPermission.setModified(false);
        }
        finally {
            torqueDynamicPermission.setLoading(false);
        }
        return torqueDynamicPermission;
    }

    protected Integer getEntityId(ResultSet resultSet, int columnIndex) throws TorqueException {
        try {
            Integer value = resultSet.getInt(columnIndex);
            if (resultSet.wasNull()) {
                value = null;
            }
            return value;
        }
        catch (SQLException e) {
            throw new TorqueException((Throwable)e);
        }
    }

    protected String getEntityName(ResultSet resultSet, int columnIndex) throws TorqueException {
        try {
            return resultSet.getString(columnIndex);
        }
        catch (SQLException e) {
            throw new TorqueException((Throwable)e);
        }
    }
}

