/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.uniffle.com.google.common.annotations.VisibleForTesting;
import org.apache.uniffle.proto.RssProtos;

public class ShuffleServerInfo
implements Serializable {
    private String id;
    private String host;
    private int grpcPort;
    private int nettyPort = -1;

    @VisibleForTesting
    public ShuffleServerInfo(String host, int port) {
        this.id = host + "-" + port;
        this.host = host;
        this.grpcPort = port;
    }

    @VisibleForTesting
    public ShuffleServerInfo(String host, int grpcPort, int nettyPort) {
        this.id = host + "-" + grpcPort + "-" + nettyPort;
        this.host = host;
        this.grpcPort = grpcPort;
        this.nettyPort = nettyPort;
    }

    public ShuffleServerInfo(String id, String host, int port) {
        this.id = id;
        this.host = host;
        this.grpcPort = port;
    }

    public ShuffleServerInfo(String id, String host, int grpcPort, int nettyPort) {
        this.id = id;
        this.host = host;
        this.grpcPort = grpcPort;
        this.nettyPort = nettyPort;
    }

    public String getId() {
        return this.id;
    }

    public String getHost() {
        return this.host;
    }

    public int getGrpcPort() {
        return this.grpcPort;
    }

    public int getNettyPort() {
        return this.nettyPort;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ShuffleServerInfo) {
            return this.id.equals(((ShuffleServerInfo)obj).getId()) && this.host.equals(((ShuffleServerInfo)obj).getHost()) && this.grpcPort == ((ShuffleServerInfo)obj).getGrpcPort() && this.nettyPort == ((ShuffleServerInfo)obj).getNettyPort();
        }
        return false;
    }

    public String toString() {
        if (this.nettyPort > 0) {
            return "ShuffleServerInfo{host[" + this.host + "], grpc port[" + this.grpcPort + "], netty port[" + this.nettyPort + "]}";
        }
        return "ShuffleServerInfo{host[" + this.host + "], grpc port[" + this.grpcPort + "]}";
    }

    private static ShuffleServerInfo convertToShuffleServerId(RssProtos.ShuffleServerId shuffleServerId) {
        ShuffleServerInfo shuffleServerInfo = new ShuffleServerInfo(shuffleServerId.getId(), shuffleServerId.getIp(), shuffleServerId.getPort(), 0);
        return shuffleServerInfo;
    }

    public static RssProtos.ShuffleServerId convertToShuffleServerId(ShuffleServerInfo shuffleServerInfo) {
        RssProtos.ShuffleServerId shuffleServerId = RssProtos.ShuffleServerId.newBuilder().setId(shuffleServerInfo.getId()).setIp(shuffleServerInfo.getHost()).setPort(shuffleServerInfo.grpcPort).setNettyPort(shuffleServerInfo.nettyPort).build();
        return shuffleServerId;
    }

    public static List<ShuffleServerInfo> fromProto(List<RssProtos.ShuffleServerId> servers) {
        return servers.stream().map(server -> ShuffleServerInfo.convertToShuffleServerId(server)).collect(Collectors.toList());
    }

    public static List<RssProtos.ShuffleServerId> toProto(List<ShuffleServerInfo> shuffleServerInfos) {
        return shuffleServerInfos.stream().map(server -> ShuffleServerInfo.convertToShuffleServerId(server)).collect(Collectors.toList());
    }
}

