/* 
   Unix SMB/CIFS implementation.
   test suite for atsvc ndr operations

   Copyright (C) Jelmer Vernooij 2007
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "includes.h"
#include "torture/ndr/ndr.h"
#include "librpc/gen_ndr/ndr_lsa.h"

static const uint8_t lsarlookupnames_in_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x2a, 0xab, 0xb8, 0x84, 0x36, 0xc6, 0xed, 0x4f,
  0x83, 0x16, 0x04, 0xe8, 0x63, 0x15, 0xeb, 0x84, 0x64, 0x00, 0x00, 0x00,
  0x64, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x02, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x03, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x05, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x06, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x07, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x08, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x09, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x0c, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x0d, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x0f, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x10, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x11, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x12, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x13, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x14, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x15, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x16, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x17, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x18, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x19, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x1a, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x1b, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x1c, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x1e, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x1f, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x20, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x21, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x22, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x23, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x24, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x25, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x26, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x27, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x28, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x29, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x2a, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x2b, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x2c, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x2d, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x2e, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x2f, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x30, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x31, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x32, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x33, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x34, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x35, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x36, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x37, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x38, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x39, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x3a, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x3b, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x3c, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x3d, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x3f, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x40, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x41, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x42, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x43, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x44, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x45, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x46, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x47, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x48, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x49, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x4a, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x4b, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x4c, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x4d, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x4e, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x4f, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x50, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x51, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x52, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x53, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x54, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x55, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x56, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x57, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x58, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x59, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x5a, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x5b, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x5c, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x5d, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x5e, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x5f, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x60, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x61, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x62, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x63, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x64, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

static bool lsarlookupnames_in_check(struct torture_context *tctx, 
									 struct lsa_LookupNames *r)
{
	int i;
	/* FIXME: Handle */
	torture_assert_int_equal(tctx, r->in.num_names, 100, "num names");
	for (i = 0; i < 100; i++) {
		torture_assert_str_equal(tctx, r->in.names[i].string, "Users", "names");
	}
	torture_assert(tctx, r->in.sids != NULL, "sids");
	torture_assert_int_equal(tctx, r->in.sids->count, 0, "sids count");
	torture_assert(tctx, r->in.sids->sids == NULL, "sids domains");
	torture_assert_int_equal(tctx, r->in.level, 1, "level");
	torture_assert(tctx, r->in.count != NULL, "count ptr");
	torture_assert_int_equal(tctx, *r->in.count, 0, "count");
	return true;
}

static const uint8_t lsarlookupnames_out_data[] = {
  0x00, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04, 0x00, 0x02, 0x00,
  0x20, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x10, 0x00,
  0x08, 0x00, 0x02, 0x00, 0x0c, 0x00, 0x02, 0x00, 0x08, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x42, 0x00, 0x55, 0x00,
  0x49, 0x00, 0x4c, 0x00, 0x54, 0x00, 0x49, 0x00, 0x4e, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00, 0x10, 0x00, 0x02, 0x00,
  0x64, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x6f, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x70, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x72, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x69, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x61, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x55, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x5f, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x35, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x57, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x45, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x20, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x43, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x68, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x61, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x73, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x76, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x65, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xb4, 0xfc, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xd8, 0x9f, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x42, 0x48, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x05, 0xbf, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xf4, 0x98, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xc4, 0x18, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x94, 0xb3, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x0c, 0x7f, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x9b, 0x92, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xf7, 0x59, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x75, 0xa3, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x37, 0xeb, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x98, 0xbe, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x5a, 0x7e, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x7c, 0xae, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xcb, 0x87, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x1c, 0x77, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x45, 0xa9, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x6f, 0xbf, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x86, 0x6d, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xbc, 0x61, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x18, 0xa7, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x5f, 0xa8, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x44, 0x3c, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x4e, 0x0d, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xcf, 0xb0, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xd1, 0x87, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x48, 0xc1, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xa8, 0xb3, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x52, 0xf4, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x62, 0x3e, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xb6, 0x7f, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xee, 0x43, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xc1, 0x85, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x8a, 0x80, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xe1, 0x1e, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x5b, 0xdf, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x98, 0xe0, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x85, 0x8b, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xc9, 0xb4, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x60, 0xba, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x9b, 0x95, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x0f, 0x10, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xc9, 0xed, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x72, 0xa6, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xbe, 0x11, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x37, 0xcd, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xc3, 0x40, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x51, 0x12, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xd3, 0x25, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x4f, 0x72, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x33, 0xd7, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xfb, 0x70, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xdc, 0xd2, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x1f, 0xeb, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xd0, 0x98, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x87, 0x14, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xc6, 0xb5, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x94, 0x74, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x5a, 0x50, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x5d, 0x43, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x34, 0x6a, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x6d, 0x30, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x02, 0x01, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xf7, 0x37, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xf1, 0x90, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x91, 0xf6, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x8e, 0x0d, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x54, 0x87, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xb2, 0x14, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xf8, 0x8d, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x25, 0x23, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x2c, 0x2f, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static bool lsarlookupnames_out_check(struct torture_context *tctx, 
									 struct lsa_LookupNames *r)
{
	torture_assert(tctx, r->out.domains != NULL, "domains ptr");
	torture_assert_int_equal(tctx, r->out.domains->count, 1, "domains count");
	torture_assert_int_equal(tctx, r->out.domains->max_size, 32, "domains size");
	torture_assert(tctx, r->out.domains->domains != NULL, "domains domains");
	torture_assert_str_equal(tctx, r->out.domains->domains[0].name.string, "BUILTIN", "domain name");
	/* FIXME: SID */
	torture_assert(tctx, r->out.count != NULL, "count ptr");
	torture_assert_int_equal(tctx, *r->out.count, 100, "count");

	torture_assert_int_equal(tctx, r->out.sids->count, 100, "sids count");
	torture_assert_int_equal(tctx, r->out.sids->sids[0].sid_type, 4, "sid type");
	torture_assert_int_equal(tctx, r->out.sids->sids[0].rid, 0x221, "sid rid");
	torture_assert_int_equal(tctx, r->out.sids->sids[0].sid_index, 0, "sid index");
	return true;
}

static const uint8_t lsarlookupsids_in_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x2a, 0xab, 0xb8, 0x84, 0x36, 0xc6, 0xed, 0x4f,
  0x83, 0x16, 0x04, 0xe8, 0x63, 0x15, 0xeb, 0x84, 0x64, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x03, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
  0x09, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00,
  0x0c, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00,
  0x0f, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00,
  0x12, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00,
  0x15, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00,
  0x18, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x00,
  0x1b, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00,
  0x1e, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x23, 0x00, 0x00, 0x00,
  0x24, 0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x26, 0x00, 0x00, 0x00,
  0x27, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x00, 0x29, 0x00, 0x00, 0x00,
  0x2a, 0x00, 0x00, 0x00, 0x2b, 0x00, 0x00, 0x00, 0x2c, 0x00, 0x00, 0x00,
  0x2d, 0x00, 0x00, 0x00, 0x2e, 0x00, 0x00, 0x00, 0x2f, 0x00, 0x00, 0x00,
  0x30, 0x00, 0x00, 0x00, 0x31, 0x00, 0x00, 0x00, 0x32, 0x00, 0x00, 0x00,
  0x33, 0x00, 0x00, 0x00, 0x34, 0x00, 0x00, 0x00, 0x35, 0x00, 0x00, 0x00,
  0x36, 0x00, 0x00, 0x00, 0x37, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00,
  0x39, 0x00, 0x00, 0x00, 0x3a, 0x00, 0x00, 0x00, 0x3b, 0x00, 0x00, 0x00,
  0x3c, 0x00, 0x00, 0x00, 0x3d, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00,
  0x3f, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x41, 0x00, 0x00, 0x00,
  0x42, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00,
  0x45, 0x00, 0x00, 0x00, 0x46, 0x00, 0x00, 0x00, 0x47, 0x00, 0x00, 0x00,
  0x48, 0x00, 0x00, 0x00, 0x49, 0x00, 0x00, 0x00, 0x4a, 0x00, 0x00, 0x00,
  0x4b, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x00, 0x4d, 0x00, 0x00, 0x00,
  0x4e, 0x00, 0x00, 0x00, 0x4f, 0x00, 0x00, 0x00, 0x50, 0x00, 0x00, 0x00,
  0x51, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x53, 0x00, 0x00, 0x00,
  0x54, 0x00, 0x00, 0x00, 0x55, 0x00, 0x00, 0x00, 0x56, 0x00, 0x00, 0x00,
  0x57, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x59, 0x00, 0x00, 0x00,
  0x5a, 0x00, 0x00, 0x00, 0x5b, 0x00, 0x00, 0x00, 0x5c, 0x00, 0x00, 0x00,
  0x5d, 0x00, 0x00, 0x00, 0x5e, 0x00, 0x00, 0x00, 0x5f, 0x00, 0x00, 0x00,
  0x60, 0x00, 0x00, 0x00, 0x61, 0x00, 0x00, 0x00, 0x62, 0x00, 0x00, 0x00,
  0x63, 0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00, 0x65, 0x00, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static bool lsarlookupsids_in_check(struct torture_context *tctx, 
									 struct lsa_LookupSids *r)
{
	/* FIXME: Handle */
	torture_assert_int_equal(tctx, r->in.sids->num_sids, 100, "num sids");
	torture_assert(tctx, r->in.sids->sids != NULL, "sids sids");
	torture_assert_int_equal(tctx, r->in.names->count, 0, "names count");
	torture_assert(tctx, r->in.names->names == NULL, "names names");
	torture_assert_int_equal(tctx, r->in.level, 1, "level");
	torture_assert(tctx, r->in.count != NULL, "count ptr");
	torture_assert_int_equal(tctx, *r->in.count, 0, "count");

	return true;
}

static const uint8_t lsarlookupsids_out_data[] = {
  0x00, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04, 0x00, 0x02, 0x00,
  0x20, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x10, 0x00,
  0x08, 0x00, 0x02, 0x00, 0x0c, 0x00, 0x02, 0x00, 0x08, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x42, 0x00, 0x55, 0x00,
  0x49, 0x00, 0x4c, 0x00, 0x54, 0x00, 0x49, 0x00, 0x4e, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00, 0x10, 0x00, 0x02, 0x00,
  0x64, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x14, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x18, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x1c, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x20, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x24, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x28, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x2c, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x30, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x34, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x38, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x3c, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x40, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x44, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x48, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x4c, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x50, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x54, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x58, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x5c, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x60, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x64, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x68, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x6c, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x70, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x74, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x78, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x7c, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x80, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x84, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x88, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x8c, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x90, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x94, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x98, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x9c, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0xa0, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0xa4, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0xa8, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0xac, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0xb0, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xde, 0x36,
  0x0a, 0x00, 0x0a, 0x00, 0xb4, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0xb8, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0xbc, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0xc0, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0xc4, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0xc8, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0xcc, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0xd0, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0xd4, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0xd8, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0xdc, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0xe0, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0xe4, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0xe8, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0xec, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0xf0, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0xf4, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0xf8, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0xfc, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x00, 0x01, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x04, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x08, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x0c, 0x01, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x10, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x14, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x18, 0x01, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x1c, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x20, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x24, 0x01, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x28, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x2c, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x30, 0x01, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x34, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x38, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x3c, 0x01, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x40, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x44, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x48, 0x01, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x4c, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x50, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x54, 0x01, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x58, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x5c, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x60, 0x01, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x64, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x68, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x6c, 0x01, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x70, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x74, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x78, 0x01, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x7c, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x80, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x84, 0x01, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x88, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x8c, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x90, 0x01, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x94, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x98, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x9c, 0x01, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0xa0, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

static bool lsarlookupsids_out_check(struct torture_context *tctx, 
									 struct lsa_LookupSids *r)
{
	torture_assert(tctx, r->out.domains != NULL, "domains");
	torture_assert_int_equal(tctx, r->out.domains->count, 1, "domains count");
	torture_assert_int_equal(tctx, r->out.domains->max_size, 32, "domains size");
	torture_assert(tctx, r->out.domains->domains != NULL, "domains domains");
	torture_assert_str_equal(tctx, r->out.domains->domains[0].name.string, "BUILTIN", "name");
	torture_assert_ntstatus_ok(tctx, r->out.result, "return code");
	return true;
}

static const uint8_t lsaropenpolicy2_in_data[] = {
  0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x02
};

static bool lsaropenpolicy2_in_check(struct torture_context *tctx, 
									 struct lsa_OpenPolicy2 *r)
{
	torture_assert_str_equal(tctx, r->in.system_name, "\\", "system name");
	torture_assert(tctx, r->in.attr != NULL, "attr ptr");
	torture_assert_int_equal(tctx, r->in.attr->len, 0, "attr len");
	torture_assert(tctx, r->in.attr->root_dir == NULL, "attr root");
	torture_assert(tctx, r->in.attr->object_name == NULL, "attr object name");
	torture_assert_int_equal(tctx, r->in.attr->attributes, 0, "attr attributes");
	torture_assert_int_equal(tctx, r->in.access_mask, 0x02000000, "access mask");
	return true;
}

static const uint8_t lsaropenpolicy2_out_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x2a, 0xab, 0xb8, 0x84, 0x36, 0xc6, 0xed, 0x4f,
  0x83, 0x16, 0x04, 0xe8, 0x63, 0x15, 0xeb, 0x84, 0x00, 0x00, 0x00, 0x00
};

static bool lsaropenpolicy2_out_check(struct torture_context *tctx, 
									 struct lsa_OpenPolicy2 *r)
{
	/* FIXME: handle */
	torture_assert_ntstatus_ok(tctx, r->out.result, "return code");
	return true;
}

static const uint8_t lsaropenpolicy_in_data[] = {
  0x01, 0x00, 0x00, 0x00, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x02
};

static bool lsaropenpolicy_in_check(struct torture_context *tctx, 
									 struct lsa_OpenPolicy *r)
{
	torture_assert(tctx, r->in.system_name != NULL, "system name");
	torture_assert(tctx, r->in.attr != NULL, "attr ptr");
	torture_assert_int_equal(tctx, r->in.attr->len, 0, "attr len");
	torture_assert(tctx, r->in.attr->root_dir == NULL, "attr root");
	torture_assert(tctx, r->in.attr->object_name == NULL, "attr object name");
	torture_assert_int_equal(tctx, r->in.attr->attributes, 0, "attr attributes");
	torture_assert_int_equal(tctx, r->in.access_mask, 0x02000000, "access mask");

	return true;
}

static const uint8_t lsaropenpolicy_out_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x2a, 0xbd, 0xf1, 0xb1, 0xe8, 0xd7, 0xf8, 0x43,
  0xae, 0xb4, 0x5f, 0x9b, 0xbe, 0x06, 0xf2, 0xce, 0x00, 0x00, 0x00, 0x00
};

static bool lsaropenpolicy_out_check(struct torture_context *tctx, 
									 struct lsa_OpenPolicy *r)
{
	/* FIXME: Handle */
	torture_assert_ntstatus_ok(tctx, r->out.result, "return code");
	return true;
}

static const uint8_t lsarcreateaccount_in_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x2a, 0xab, 0xb8, 0x84, 0x36, 0xc6, 0xed, 0x4f,
  0x83, 0x16, 0x04, 0xe8, 0x63, 0x15, 0xeb, 0x84, 0x03, 0x00, 0x00, 0x00,
  0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xb4, 0x71, 0xbc, 0x00,
  0xe1, 0x10, 0x00, 0x00, 0x26, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02
};

static bool lsarcreateaccount_in_check(struct torture_context *tctx, 
									 struct lsa_CreateAccount *r)
{
	/* FIXME: Handle */	
	/* FIXME: Sid */
	torture_assert_int_equal(tctx, r->in.access_mask, 0x2000000, "access mask");
	return true;
}

static const uint8_t lsarcreateaccount_out_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x3d, 0x28, 0x64, 0xd8, 0x9a, 0xad, 0x2f, 0x48,
  0xa5, 0x37, 0x26, 0xb4, 0x17, 0x71, 0x3a, 0xe8, 0x00, 0x00, 0x00, 0x00
};

static bool lsarcreateaccount_out_check(struct torture_context *tctx, 
									 struct lsa_CreateAccount *r)
{
	/* FIXME */	
	torture_assert_ntstatus_ok(tctx, r->out.result, "return code");
	return true;
}

static const uint8_t lsardelete_in_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x3d, 0x28, 0x64, 0xd8, 0x9a, 0xad, 0x2f, 0x48,
  0xa5, 0x37, 0x26, 0xb4, 0x17, 0x71, 0x3a, 0xe8
};

static bool lsardelete_in_check(struct torture_context *tctx, 
									 struct lsa_Delete *r)
{
	/* FIXME: Handle */
	return true;
}

static const uint8_t lsardelete_out_data[] = {
  0x00, 0x00, 0x00, 0x00
};

static bool lsardelete_out_check(struct torture_context *tctx, 
									 struct lsa_Delete *r)
{
	torture_assert_ntstatus_ok(tctx, r->out.result, "return code");
	return true;
}

static const uint8_t lsarcreatesecret_in_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x2a, 0xab, 0xb8, 0x84, 0x36, 0xc6, 0xed, 0x4f,
  0x83, 0x16, 0x04, 0xe8, 0x63, 0x15, 0xeb, 0x84, 0x2e, 0x00, 0x2e, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x17, 0x00, 0x00, 0x00, 0x74, 0x00, 0x6f, 0x00, 0x72, 0x00, 0x74, 0x00,
  0x75, 0x00, 0x72, 0x00, 0x65, 0x00, 0x73, 0x00, 0x65, 0x00, 0x63, 0x00,
  0x72, 0x00, 0x65, 0x00, 0x74, 0x00, 0x2d, 0x00, 0x38, 0x00, 0x35, 0x00,
  0x32, 0x00, 0x38, 0x00, 0x38, 0x00, 0x35, 0x00, 0x33, 0x00, 0x35, 0x00,
  0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02
};

static bool lsarcreatesecret_in_check(struct torture_context *tctx,
									struct lsa_CreateSecret *r)
{
	/* FIXME: Handle */
	torture_assert_str_equal(tctx, r->in.name.string, "torturesecret-852885356", "name");
	torture_assert_int_equal(tctx, r->in.access_mask, 0x2000000, "access mask");
	return true;
}

static const uint8_t lsarcreatesecret_out_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x08, 0x2d, 0x02, 0x15, 0x3d, 0xfb, 0x27, 0x4c,
  0xaa, 0x22, 0x13, 0x79, 0x20, 0x14, 0x7f, 0xad, 0x00, 0x00, 0x00, 0x00
};

static bool lsarcreatesecret_out_check(struct torture_context *tctx,
									struct lsa_CreateSecret *r)
{
	/* FIXME: Handle */
	torture_assert_ntstatus_ok(tctx, r->out.result, "return code");
	return true;
}

static const uint8_t lsaropensecret_in_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x2a, 0xab, 0xb8, 0x84, 0x36, 0xc6, 0xed, 0x4f,
  0x83, 0x16, 0x04, 0xe8, 0x63, 0x15, 0xeb, 0x84, 0x2e, 0x00, 0x2e, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x17, 0x00, 0x00, 0x00, 0x74, 0x00, 0x6f, 0x00, 0x72, 0x00, 0x74, 0x00,
  0x75, 0x00, 0x72, 0x00, 0x65, 0x00, 0x73, 0x00, 0x65, 0x00, 0x63, 0x00,
  0x72, 0x00, 0x65, 0x00, 0x74, 0x00, 0x2d, 0x00, 0x38, 0x00, 0x35, 0x00,
  0x32, 0x00, 0x38, 0x00, 0x38, 0x00, 0x35, 0x00, 0x33, 0x00, 0x35, 0x00,
  0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02
};

static bool lsaropensecret_in_check(struct torture_context *tctx,
									struct lsa_OpenSecret *r)
{
	/* FIXME: Handle */
	torture_assert_str_equal(tctx, r->in.name.string, "torturesecret-852885356", "name");
	torture_assert_int_equal(tctx, r->in.access_mask, 0x2000000, "access mask");
	return true;
}

static const uint8_t lsaropensecret_out_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x9f, 0x6d, 0x07, 0x35, 0x08, 0x43, 0xd9, 0x4b,
  0xbb, 0xcf, 0xeb, 0x4a, 0x91, 0xd2, 0x24, 0xe7, 0x00, 0x00, 0x00, 0x00
};

static bool lsaropensecret_out_check(struct torture_context *tctx,
									struct lsa_OpenSecret *r)
{
	/* FIXME: Handle */
	torture_assert_ntstatus_ok(tctx, r->out.result, "return code");
	return true;
}

static const uint8_t lsarsetsecret_in_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x08, 0x2d, 0x02, 0x15, 0x3d, 0xfb, 0x27, 0x4c,
  0xaa, 0x22, 0x13, 0x79, 0x20, 0x14, 0x7f, 0xad, 0x01, 0x00, 0x00, 0x00,
  0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00,
  0xda, 0xb8, 0x19, 0xb6, 0xaf, 0x8c, 0x0f, 0xf5, 0x28, 0x81, 0xca, 0xce,
  0xcc, 0x8b, 0x70, 0xc4, 0x8a, 0xe5, 0xad, 0x51, 0x1a, 0x0e, 0xb5, 0xaa,
  0x3b, 0xdc, 0xbf, 0x38, 0x30, 0xb4, 0x18, 0x6d, 0x00, 0x00, 0x00, 0x00
};

static bool lsarsetsecret_in_check(struct torture_context *tctx,
									struct lsa_SetSecret *r)
{
	/* FIXME: Handle */
	torture_assert(tctx, r->in.new_val != NULL, "new val ptr");
	torture_assert(tctx, r->in.old_val == NULL, "old val ptr");
	torture_assert_int_equal(tctx, r->in.new_val->length, 32, "new val len");
	torture_assert_int_equal(tctx, r->in.new_val->size, 32, "new val size");
	return true;
}


static const uint8_t lsarsetsecret_out_data[] = {
  0x00, 0x00, 0x00, 0x00
};

static bool lsarsetsecret_out_check(struct torture_context *tctx,
									struct lsa_SetSecret *r)
{
	torture_assert_ntstatus_ok(tctx, r->out.result, "return code");
	return true;
}

static const uint8_t lsarquerysecret_in_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x08, 0x2d, 0x02, 0x15, 0x3d, 0xfb, 0x27, 0x4c,
  0xaa, 0x22, 0x13, 0x79, 0x20, 0x14, 0x7f, 0xad, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static bool lsarquerysecret_in_check(struct torture_context *tctx,
									struct lsa_QuerySecret *r)
{
	/* FIXME: Handle */
	torture_assert(tctx, r->in.new_val != NULL, "new val ptr");
	torture_assert(tctx, r->in.new_val->buf == NULL, "new val ptr ptr");
	torture_assert(tctx, r->in.new_mtime != NULL, "new mtime ptr");
	/* FIXME: *new_mtime */
	torture_assert(tctx, r->in.old_val == NULL, "old val ptr");
	torture_assert(tctx, r->in.old_mtime == NULL, "old mtime ptr");
	return true;
}


static const uint8_t lsarquerysecret_out_data[] = {
  0x00, 0x00, 0x02, 0x00, 0x04, 0x00, 0x02, 0x00, 0x20, 0x00, 0x00, 0x00,
  0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x02, 0x00, 0x20, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0xda, 0xb8, 0x19, 0xb6,
  0xaf, 0x8c, 0x0f, 0xf5, 0x28, 0x81, 0xca, 0xce, 0xcc, 0x8b, 0x70, 0xc4,
  0x8a, 0xe5, 0xad, 0x51, 0x1a, 0x0e, 0xb5, 0xaa, 0x3b, 0xdc, 0xbf, 0x38,
  0x30, 0xb4, 0x18, 0x6d, 0x0c, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x90, 0x3e, 0x63, 0x7e, 0xee, 0xf1, 0xc4, 0x01, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static bool lsarquerysecret_out_check(struct torture_context *tctx,
									struct lsa_QuerySecret *r)
{
	/* FIXME: Handle */
	torture_assert(tctx, r->out.new_val != NULL, "new val ptr");
	torture_assert(tctx, r->out.new_mtime != NULL, "new mtime ptr");
	/* FIXME: *new_mtime */
	torture_assert(tctx, r->out.old_val == NULL, "old val ptr");
	torture_assert(tctx, r->out.old_mtime == NULL, "old mtime ptr");
	return true;
}

static const uint8_t lsarcreatetrusteddomain_in_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x2a, 0xab, 0xb8, 0x84, 0x36, 0xc6, 0xed, 0x4f,
  0x83, 0x16, 0x04, 0xe8, 0x63, 0x15, 0xeb, 0x84, 0x1a, 0x00, 0x1a, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x74, 0x00, 0x6f, 0x00,
  0x72, 0x00, 0x74, 0x00, 0x75, 0x00, 0x72, 0x00, 0x65, 0x00, 0x64, 0x00,
  0x6f, 0x00, 0x6d, 0x00, 0x61, 0x00, 0x69, 0x00, 0x6e, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x15, 0x00, 0x00, 0x00, 0x76, 0x7c, 0x01, 0x00, 0x93, 0xcb, 0x05, 0x00,
  0x39, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02
};

static bool lsarcreatetrusteddomain_in_check(struct torture_context *tctx, 
										   struct lsa_CreateTrustedDomain *r)
{
	/* FIXME: Handle */
	torture_assert_str_equal(tctx, r->in.info->name.string, "torturedomain", "name");
	torture_assert(tctx, r->in.info->sid != NULL, "sid");
	torture_assert_int_equal(tctx, r->in.access_mask, 0x2000000, "access mask");
	return true;
}

static const uint8_t lsarcreatetrusteddomain_out_data[] = {
  0x00, 0x00, 0x00, 0x00, 0xb5, 0x23, 0x36, 0x5f, 0x33, 0x92, 0x41, 0x4c,
  0x9a, 0x73, 0x7d, 0x6a, 0x23, 0x14, 0x62, 0x56, 0x00, 0x00, 0x00, 0x00
};

static bool lsarcreatetrusteddomain_out_check(struct torture_context *tctx, 
										   struct lsa_CreateTrustedDomain *r)
{
	/* FIXME: Handle */
	torture_assert_ntstatus_ok(tctx, r->out.result, "return code");
	return true;
}

static const uint8_t lsarenumerateaccounts_in_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x2a, 0xab, 0xb8, 0x84, 0x36, 0xc6, 0xed, 0x4f,
  0x83, 0x16, 0x04, 0xe8, 0x63, 0x15, 0xeb, 0x84, 0x00, 0x00, 0x00, 0x00,
  0x64, 0x00, 0x00, 0x00
};

static bool lsarenumerateaccounts_in_check(struct torture_context *tctx, 
										   struct lsa_EnumAccounts *r)
{
	/* FIXME: handle */
	torture_assert(tctx, r->in.resume_handle != NULL, "resume handle ptr");
	torture_assert_int_equal(tctx, *r->in.resume_handle, 0, "resume handle");
	torture_assert_int_equal(tctx, r->in.num_entries, 100, "num entries");
	return true;
}

static const uint8_t lsarenumerateaccounts_out_data[] = {
  0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
  0x07, 0x00, 0x00, 0x00, 0x04, 0x00, 0x02, 0x00, 0x08, 0x00, 0x02, 0x00,
  0x0c, 0x00, 0x02, 0x00, 0x10, 0x00, 0x02, 0x00, 0x14, 0x00, 0x02, 0x00,
  0x18, 0x00, 0x02, 0x00, 0x1c, 0x00, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x24, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x20, 0x02, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x15, 0x00, 0x00, 0x00, 0x14, 0xcd, 0xfb, 0x2b, 0x07, 0x32, 0xfb, 0xb2,
  0xcc, 0x04, 0x9c, 0x4c, 0xe9, 0x03, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x14, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x13, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x0b, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

static bool lsarenumerateaccounts_out_check(struct torture_context *tctx, 
										   struct lsa_EnumAccounts *r)
{
	torture_assert(tctx, r->out.resume_handle != NULL, "resume handle ptr");
	torture_assert_int_equal(tctx, *r->out.resume_handle, 7, "resume handle");
	torture_assert_int_equal(tctx, r->out.sids->num_sids, 7, "num sids");
	torture_assert(tctx, r->out.sids->sids != NULL, "sids sids");
	torture_assert(tctx, r->out.sids->sids[0].sid != NULL, "sids sids");
	torture_assert_ntstatus_ok(tctx, r->out.result, "return code");
	return true;
}

static const uint8_t lsarlookupsids2_in_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x2a, 0xab, 0xb8, 0x84, 0x36, 0xc6, 0xed, 0x4f,
  0x83, 0x16, 0x04, 0xe8, 0x63, 0x15, 0xeb, 0x84, 0x07, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x03, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x24, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x20, 0x02, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x01, 0x05, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x15, 0x00, 0x00, 0x00, 0x14, 0xcd, 0xfb, 0x2b,
  0x07, 0x32, 0xfb, 0xb2, 0xcc, 0x04, 0x9c, 0x4c, 0xe9, 0x03, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x14, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x13, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0b, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

static bool lsarlookupsids2_in_check(struct torture_context *tctx, 
									 struct lsa_LookupSids2 *r)
{
	/* FIXME: Handle */
	torture_assert_int_equal(tctx, r->in.sids->num_sids, 7, "num sids");
	torture_assert(tctx, r->in.sids->sids != NULL, "sids sids");
	torture_assert(tctx, r->in.sids->sids[0].sid != NULL, "sids sids");
	torture_assert(tctx, r->in.names != NULL, "names ptr");
	torture_assert_int_equal(tctx, r->in.names->count, 0, "names count");
	torture_assert(tctx, r->in.names->names == NULL, "names");
	torture_assert_int_equal(tctx, r->in.level, 1, "level");
	torture_assert(tctx, r->in.count != NULL, "count ptr");
	torture_assert_int_equal(tctx, *r->in.count, 7, "count");
	torture_assert_int_equal(tctx, r->in.unknown1, 0, "unknown 1");
	torture_assert_int_equal(tctx, r->in.unknown2, 0, "unknown 2");

	return true;
}

static const uint8_t lsarlookupsids2_out_data[] = {
  0x00, 0x00, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x02, 0x00,
  0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x18, 0x00, 0x1a, 0x00,
  0x08, 0x00, 0x02, 0x00, 0x0c, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00,
  0x10, 0x00, 0x02, 0x00, 0x14, 0x00, 0x02, 0x00, 0x0e, 0x00, 0x10, 0x00,
  0x18, 0x00, 0x02, 0x00, 0x1c, 0x00, 0x02, 0x00, 0x12, 0x00, 0x14, 0x00,
  0x20, 0x00, 0x02, 0x00, 0x24, 0x00, 0x02, 0x00, 0x0d, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x4e, 0x00, 0x54, 0x00,
  0x20, 0x00, 0x41, 0x00, 0x55, 0x00, 0x54, 0x00, 0x48, 0x00, 0x4f, 0x00,
  0x52, 0x00, 0x49, 0x00, 0x54, 0x00, 0x59, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x42, 0x00, 0x55, 0x00,
  0x49, 0x00, 0x4c, 0x00, 0x54, 0x00, 0x49, 0x00, 0x4e, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x09, 0x00, 0x00, 0x00, 0x57, 0x00, 0x49, 0x00, 0x4e, 0x00, 0x32, 0x00,
  0x4b, 0x00, 0x33, 0x00, 0x44, 0x00, 0x4f, 0x00, 0x4d, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x15, 0x00, 0x00, 0x00, 0x14, 0xcd, 0xfb, 0x2b, 0x07, 0x32, 0xfb, 0xb2,
  0xcc, 0x04, 0x9c, 0x4c, 0x07, 0x00, 0x00, 0x00, 0x28, 0x00, 0x02, 0x00,
  0x07, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x22, 0x00, 0x22, 0x00,
  0x2c, 0x00, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x30, 0x00, 0x02, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x20, 0x00, 0x20, 0x00, 0x34, 0x00, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x20, 0x00,
  0x38, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x1a, 0x00, 0x1c, 0x00, 0x3c, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x12, 0x00,
  0x26, 0x00, 0x28, 0x00, 0x40, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x10, 0x00, 0x12, 0x00,
  0x44, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00,
  0x41, 0x00, 0x63, 0x00, 0x63, 0x00, 0x6f, 0x00, 0x75, 0x00, 0x6e, 0x00,
  0x74, 0x00, 0x20, 0x00, 0x4f, 0x00, 0x70, 0x00, 0x65, 0x00, 0x72, 0x00,
  0x61, 0x00, 0x74, 0x00, 0x6f, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00,
  0x41, 0x00, 0x64, 0x00, 0x6d, 0x00, 0x69, 0x00, 0x6e, 0x00, 0x69, 0x00,
  0x73, 0x00, 0x74, 0x00, 0x72, 0x00, 0x61, 0x00, 0x74, 0x00, 0x6f, 0x00,
  0x72, 0x00, 0x73, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x00, 0x00, 0x00, 0x53, 0x00, 0x55, 0x00, 0x50, 0x00, 0x50, 0x00,
  0x4f, 0x00, 0x52, 0x00, 0x54, 0x00, 0x5f, 0x00, 0x33, 0x00, 0x38, 0x00,
  0x38, 0x00, 0x39, 0x00, 0x34, 0x00, 0x35, 0x00, 0x61, 0x00, 0x30, 0x00,
  0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00,
  0x4e, 0x00, 0x45, 0x00, 0x54, 0x00, 0x57, 0x00, 0x4f, 0x00, 0x52, 0x00,
  0x4b, 0x00, 0x20, 0x00, 0x53, 0x00, 0x45, 0x00, 0x52, 0x00, 0x56, 0x00,
  0x49, 0x00, 0x43, 0x00, 0x45, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x4f, 0x00,
  0x43, 0x00, 0x41, 0x00, 0x4c, 0x00, 0x20, 0x00, 0x53, 0x00, 0x45, 0x00,
  0x52, 0x00, 0x56, 0x00, 0x49, 0x00, 0x43, 0x00, 0x45, 0x00, 0x00, 0x00,
  0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00,
  0x41, 0x00, 0x75, 0x00, 0x74, 0x00, 0x68, 0x00, 0x65, 0x00, 0x6e, 0x00,
  0x74, 0x00, 0x69, 0x00, 0x63, 0x00, 0x61, 0x00, 0x74, 0x00, 0x65, 0x00,
  0x64, 0x00, 0x20, 0x00, 0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00,
  0x73, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x08, 0x00, 0x00, 0x00, 0x45, 0x00, 0x76, 0x00, 0x65, 0x00, 0x72, 0x00,
  0x79, 0x00, 0x6f, 0x00, 0x6e, 0x00, 0x65, 0x00, 0x07, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

static bool lsarlookupsids2_out_check(struct torture_context *tctx, 
									 struct lsa_LookupSids2 *r)
{
	/* FIXME: Handle */
	torture_assert(tctx, r->out.names != NULL, "names ptr");
	torture_assert(tctx, r->out.domains != NULL, "domains ptr");
	torture_assert_int_equal(tctx, r->out.domains->count, 4, "domains count");
	torture_assert_int_equal(tctx, r->out.domains->max_size, 32, "domains size");
	torture_assert_str_equal(tctx, r->out.domains->domains[0].name.string, "NT AUTHORITY", "trust info name");
	torture_assert_int_equal(tctx, r->out.names->count, 7, "names count");
	torture_assert_str_equal(tctx, r->out.names->names[0].name.string, "Account Operators", "name str 1");
	torture_assert_str_equal(tctx, r->out.names->names[1].name.string, "Administrators", "name str 2");
	torture_assert_str_equal(tctx, r->out.names->names[2].name.string, "SUPPORT_388945a0", "name str 3");
	torture_assert(tctx, r->out.count != NULL, "count ptr");
	torture_assert_int_equal(tctx, *r->out.count, 7, "count");
	torture_assert_ntstatus_ok(tctx, r->out.result, "return code");

	return true;
}

static const uint8_t lsarlookupnames2_in_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x2a, 0xab, 0xb8, 0x84, 0x36, 0xc6, 0xed, 0x4f,
  0x83, 0x16, 0x04, 0xe8, 0x63, 0x15, 0xeb, 0x84, 0x07, 0x00, 0x00, 0x00,
  0x07, 0x00, 0x00, 0x00, 0x22, 0x00, 0x22, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x1c, 0x00, 0x1c, 0x00, 0x02, 0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x00,
  0x03, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x1e, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x1a, 0x00, 0x1a, 0x00, 0x05, 0x00, 0x00, 0x00, 0x26, 0x00, 0x26, 0x00,
  0x06, 0x00, 0x00, 0x00, 0x10, 0x00, 0x10, 0x00, 0x07, 0x00, 0x00, 0x00,
  0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00,
  0x41, 0x00, 0x63, 0x00, 0x63, 0x00, 0x6f, 0x00, 0x75, 0x00, 0x6e, 0x00,
  0x74, 0x00, 0x20, 0x00, 0x4f, 0x00, 0x70, 0x00, 0x65, 0x00, 0x72, 0x00,
  0x61, 0x00, 0x74, 0x00, 0x6f, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00,
  0x41, 0x00, 0x64, 0x00, 0x6d, 0x00, 0x69, 0x00, 0x6e, 0x00, 0x69, 0x00,
  0x73, 0x00, 0x74, 0x00, 0x72, 0x00, 0x61, 0x00, 0x74, 0x00, 0x6f, 0x00,
  0x72, 0x00, 0x73, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x00, 0x00, 0x00, 0x53, 0x00, 0x55, 0x00, 0x50, 0x00, 0x50, 0x00,
  0x4f, 0x00, 0x52, 0x00, 0x54, 0x00, 0x5f, 0x00, 0x33, 0x00, 0x38, 0x00,
  0x38, 0x00, 0x39, 0x00, 0x34, 0x00, 0x35, 0x00, 0x61, 0x00, 0x30, 0x00,
  0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00,
  0x4e, 0x00, 0x45, 0x00, 0x54, 0x00, 0x57, 0x00, 0x4f, 0x00, 0x52, 0x00,
  0x4b, 0x00, 0x20, 0x00, 0x53, 0x00, 0x45, 0x00, 0x52, 0x00, 0x56, 0x00,
  0x49, 0x00, 0x43, 0x00, 0x45, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x4f, 0x00,
  0x43, 0x00, 0x41, 0x00, 0x4c, 0x00, 0x20, 0x00, 0x53, 0x00, 0x45, 0x00,
  0x52, 0x00, 0x56, 0x00, 0x49, 0x00, 0x43, 0x00, 0x45, 0x00, 0x00, 0x00,
  0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00,
  0x41, 0x00, 0x75, 0x00, 0x74, 0x00, 0x68, 0x00, 0x65, 0x00, 0x6e, 0x00,
  0x74, 0x00, 0x69, 0x00, 0x63, 0x00, 0x61, 0x00, 0x74, 0x00, 0x65, 0x00,
  0x64, 0x00, 0x20, 0x00, 0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00,
  0x73, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x08, 0x00, 0x00, 0x00, 0x45, 0x00, 0x76, 0x00, 0x65, 0x00, 0x72, 0x00,
  0x79, 0x00, 0x6f, 0x00, 0x6e, 0x00, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static bool lsarlookupnames2_in_check(struct torture_context *tctx,
									  struct lsa_LookupNames2 *r)
{
	/* FIXME: Handle */
	torture_assert_int_equal(tctx, r->in.num_names, 7, "num names");
	torture_assert_str_equal(tctx, r->in.names[0].string, "Account Operators", 
							 "names[0]");
	torture_assert_str_equal(tctx, r->in.names[1].string, "Administrators", 
							 "names[1]");
	torture_assert_int_equal(tctx, r->in.level, 1, "level");
	torture_assert_int_equal(tctx, r->in.unknown1, 0, "unknown 1");
	torture_assert_int_equal(tctx, r->in.unknown2, 0, "unknown 2");
	torture_assert_int_equal(tctx, *r->in.count, 0, "count");
	torture_assert_int_equal(tctx, r->in.sids->count, 0, "sids count");
	torture_assert(tctx, r->in.sids->sids == NULL, "sids sids");
	return true;
}

static const uint8_t lsarlookupnames2_out_data[] = {
  0x00, 0x00, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x02, 0x00,
  0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x18, 0x00, 0x1a, 0x00,
  0x08, 0x00, 0x02, 0x00, 0x0c, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00,
  0x10, 0x00, 0x02, 0x00, 0x14, 0x00, 0x02, 0x00, 0x0e, 0x00, 0x10, 0x00,
  0x18, 0x00, 0x02, 0x00, 0x1c, 0x00, 0x02, 0x00, 0x12, 0x00, 0x14, 0x00,
  0x20, 0x00, 0x02, 0x00, 0x24, 0x00, 0x02, 0x00, 0x0d, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x4e, 0x00, 0x54, 0x00,
  0x20, 0x00, 0x41, 0x00, 0x55, 0x00, 0x54, 0x00, 0x48, 0x00, 0x4f, 0x00,
  0x52, 0x00, 0x49, 0x00, 0x54, 0x00, 0x59, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x42, 0x00, 0x55, 0x00,
  0x49, 0x00, 0x4c, 0x00, 0x54, 0x00, 0x49, 0x00, 0x4e, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x09, 0x00, 0x00, 0x00, 0x57, 0x00, 0x49, 0x00, 0x4e, 0x00, 0x32, 0x00,
  0x4b, 0x00, 0x33, 0x00, 0x44, 0x00, 0x4f, 0x00, 0x4d, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x15, 0x00, 0x00, 0x00, 0x14, 0xcd, 0xfb, 0x2b, 0x07, 0x32, 0xfb, 0xb2,
  0xcc, 0x04, 0x9c, 0x4c, 0x07, 0x00, 0x00, 0x00, 0x28, 0x00, 0x02, 0x00,
  0x07, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x24, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x20, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0xe9, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x02, 0x00, 0x14, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x20, 0x00,
  0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

static bool lsarlookupnames2_out_check(struct torture_context *tctx,
									  struct lsa_LookupNames2 *r)
{
	torture_assert_int_equal(tctx, *r->out.count, 7, "count");
	torture_assert_int_equal(tctx, r->out.sids->count, 7, "sids count");
	torture_assert_ntstatus_ok(tctx, r->out.result, "return code");
	return true;
}

static const uint8_t lsarlookupnames3_in_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x2a, 0xab, 0xb8, 0x84, 0x36, 0xc6, 0xed, 0x4f,
  0x83, 0x16, 0x04, 0xe8, 0x63, 0x15, 0xeb, 0x84, 0x07, 0x00, 0x00, 0x00,
  0x07, 0x00, 0x00, 0x00, 0x22, 0x00, 0x22, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x1c, 0x00, 0x1c, 0x00, 0x02, 0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x00,
  0x03, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x1e, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x1a, 0x00, 0x1a, 0x00, 0x05, 0x00, 0x00, 0x00, 0x26, 0x00, 0x26, 0x00,
  0x06, 0x00, 0x00, 0x00, 0x10, 0x00, 0x10, 0x00, 0x07, 0x00, 0x00, 0x00,
  0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00,
  0x41, 0x00, 0x63, 0x00, 0x63, 0x00, 0x6f, 0x00, 0x75, 0x00, 0x6e, 0x00,
  0x74, 0x00, 0x20, 0x00, 0x4f, 0x00, 0x70, 0x00, 0x65, 0x00, 0x72, 0x00,
  0x61, 0x00, 0x74, 0x00, 0x6f, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00,
  0x41, 0x00, 0x64, 0x00, 0x6d, 0x00, 0x69, 0x00, 0x6e, 0x00, 0x69, 0x00,
  0x73, 0x00, 0x74, 0x00, 0x72, 0x00, 0x61, 0x00, 0x74, 0x00, 0x6f, 0x00,
  0x72, 0x00, 0x73, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x00, 0x00, 0x00, 0x53, 0x00, 0x55, 0x00, 0x50, 0x00, 0x50, 0x00,
  0x4f, 0x00, 0x52, 0x00, 0x54, 0x00, 0x5f, 0x00, 0x33, 0x00, 0x38, 0x00,
  0x38, 0x00, 0x39, 0x00, 0x34, 0x00, 0x35, 0x00, 0x61, 0x00, 0x30, 0x00,
  0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00,
  0x4e, 0x00, 0x45, 0x00, 0x54, 0x00, 0x57, 0x00, 0x4f, 0x00, 0x52, 0x00,
  0x4b, 0x00, 0x20, 0x00, 0x53, 0x00, 0x45, 0x00, 0x52, 0x00, 0x56, 0x00,
  0x49, 0x00, 0x43, 0x00, 0x45, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x4f, 0x00,
  0x43, 0x00, 0x41, 0x00, 0x4c, 0x00, 0x20, 0x00, 0x53, 0x00, 0x45, 0x00,
  0x52, 0x00, 0x56, 0x00, 0x49, 0x00, 0x43, 0x00, 0x45, 0x00, 0x00, 0x00,
  0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00,
  0x41, 0x00, 0x75, 0x00, 0x74, 0x00, 0x68, 0x00, 0x65, 0x00, 0x6e, 0x00,
  0x74, 0x00, 0x69, 0x00, 0x63, 0x00, 0x61, 0x00, 0x74, 0x00, 0x65, 0x00,
  0x64, 0x00, 0x20, 0x00, 0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00,
  0x73, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x08, 0x00, 0x00, 0x00, 0x45, 0x00, 0x76, 0x00, 0x65, 0x00, 0x72, 0x00,
  0x79, 0x00, 0x6f, 0x00, 0x6e, 0x00, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static bool lsarlookupnames3_in_check(struct torture_context *tctx,
									  struct lsa_LookupNames2 *r)
{
	/* FIXME: Handle */
	torture_assert_int_equal(tctx, r->in.num_names, 7, "num names");
	torture_assert_str_equal(tctx, r->in.names[0].string, "Account Operators", 
							 "names[0]");
	torture_assert_str_equal(tctx, r->in.names[1].string, "Administrators", 
							 "names[1]");
	torture_assert_int_equal(tctx, r->in.level, 1, "level");
	torture_assert_int_equal(tctx, r->in.unknown1, 0, "unknown 1");
	torture_assert_int_equal(tctx, r->in.unknown2, 0, "unknown 2");
	torture_assert_int_equal(tctx, *r->in.count, 0, "count");
	torture_assert_int_equal(tctx, r->in.sids->count, 0, "sids count");
	torture_assert(tctx, r->in.sids->sids == NULL, "sids sids");
	return true;
}

static const uint8_t lsarlookupnames3_out_data[] = {
  0x00, 0x00, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x02, 0x00,
  0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x18, 0x00, 0x1a, 0x00,
  0x08, 0x00, 0x02, 0x00, 0x0c, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00,
  0x10, 0x00, 0x02, 0x00, 0x14, 0x00, 0x02, 0x00, 0x0e, 0x00, 0x10, 0x00,
  0x18, 0x00, 0x02, 0x00, 0x1c, 0x00, 0x02, 0x00, 0x12, 0x00, 0x14, 0x00,
  0x20, 0x00, 0x02, 0x00, 0x24, 0x00, 0x02, 0x00, 0x0d, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x4e, 0x00, 0x54, 0x00,
  0x20, 0x00, 0x41, 0x00, 0x55, 0x00, 0x54, 0x00, 0x48, 0x00, 0x4f, 0x00,
  0x52, 0x00, 0x49, 0x00, 0x54, 0x00, 0x59, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x42, 0x00, 0x55, 0x00,
  0x49, 0x00, 0x4c, 0x00, 0x54, 0x00, 0x49, 0x00, 0x4e, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x09, 0x00, 0x00, 0x00, 0x57, 0x00, 0x49, 0x00, 0x4e, 0x00, 0x32, 0x00,
  0x4b, 0x00, 0x33, 0x00, 0x44, 0x00, 0x4f, 0x00, 0x4d, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x15, 0x00, 0x00, 0x00, 0x14, 0xcd, 0xfb, 0x2b, 0x07, 0x32, 0xfb, 0xb2,
  0xcc, 0x04, 0x9c, 0x4c, 0x07, 0x00, 0x00, 0x00, 0x28, 0x00, 0x02, 0x00,
  0x07, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x2c, 0x00, 0x02, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x30, 0x00, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x34, 0x00, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x02, 0x00, 0x38, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x20, 0x00,
  0x3c, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x40, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x44, 0x00, 0x02, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x24, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x20, 0x02, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x15, 0x00, 0x00, 0x00, 0x14, 0xcd, 0xfb, 0x2b, 0x07, 0x32, 0xfb, 0xb2,
  0xcc, 0x04, 0x9c, 0x4c, 0xe9, 0x03, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x14, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x13, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x0b, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
  0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static bool lsarlookupnames3_out_check(struct torture_context *tctx,
									  struct lsa_LookupNames3 *r)
{
	torture_assert_int_equal(tctx, *r->out.count, 7, "count");
	torture_assert_int_equal(tctx, r->out.sids->count, 7, "sids count");
	torture_assert_ntstatus_ok(tctx, r->out.result, "return code");
	return true;
}



static const uint8_t lsarlookupsids3_in_data[] = {
  0x07, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
  0x08, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x24, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x20, 0x02, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x15, 0x00, 0x00, 0x00,
  0x14, 0xcd, 0xfb, 0x2b, 0x07, 0x32, 0xfb, 0xb2, 0xcc, 0x04, 0x9c, 0x4c,
  0xe9, 0x03, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x14, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x13, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x0b, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static bool lsarlookupsids3_in_check(struct torture_context *tctx, 
									 struct lsa_LookupSids3 *r)
{
	/* FIXME: Handle */
	torture_assert_int_equal(tctx, r->in.sids->num_sids, 7, "num sids");
	torture_assert(tctx, r->in.sids->sids != NULL, "sids sids");
	torture_assert(tctx, r->in.sids->sids[0].sid != NULL, "sids sids");
	torture_assert(tctx, r->in.names != NULL, "names ptr");
	torture_assert_int_equal(tctx, r->in.names->count, 0, "names count");
	torture_assert(tctx, r->in.names->names == NULL, "names");
	torture_assert_int_equal(tctx, r->in.level, 1, "level");
	torture_assert(tctx, r->in.count != NULL, "count ptr");
	torture_assert_int_equal(tctx, *r->in.count, 7, "count");
	torture_assert_int_equal(tctx, r->in.unknown1, 0, "unknown 1");
	torture_assert_int_equal(tctx, r->in.unknown2, 0, "unknown 2");

	return true;
}

static const uint8_t lsarlookupsids3_out_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x07, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0xc0
};

static bool lsarlookupsids3_out_check(struct torture_context *tctx, 
				      struct lsa_LookupSids3 *r)
{
	/* FIXME: Handle */
	torture_assert(tctx, r->out.names != NULL, "names ptr");
	torture_assert(tctx, r->out.domains != NULL, "domains ptr");
	torture_assert_int_equal(tctx, r->out.domains->count, 4, "domains count");
	torture_assert_int_equal(tctx, r->out.domains->max_size, 32, "domains size");
	torture_assert_str_equal(tctx, r->out.domains->domains[0].name.string, "NT AUTHORITY", "trust info name");
	torture_assert_int_equal(tctx, r->out.names->count, 7, "names count");
	torture_assert_str_equal(tctx, r->out.names->names[0].name.string, "Account Operators", "name str 1");
	torture_assert_str_equal(tctx, r->out.names->names[1].name.string, "Administrators", "name str 2");
	torture_assert_str_equal(tctx, r->out.names->names[2].name.string, "SUPPORT_388945a0", "name str 3");
	torture_assert(tctx, r->out.count != NULL, "count ptr");
	torture_assert_int_equal(tctx, *r->out.count, 7, "count");
	torture_assert_ntstatus_ok(tctx, r->out.result, "return code");

	return true;
}

static const uint8_t lsarenumerateprivileges_in_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x2a, 0xab, 0xb8, 0x84, 0x36, 0xc6, 0xed, 0x4f,
  0x83, 0x16, 0x04, 0xe8, 0x63, 0x15, 0xeb, 0x84, 0x00, 0x00, 0x00, 0x00,
  0x64, 0x00, 0x00, 0x00
};

static bool lsarenumerateprivileges_in_check(struct torture_context *tctx,
											 struct lsa_EnumPrivs *r)
{
	/* FIXME handle */
	torture_assert(tctx, r->in.resume_handle != NULL, "resume handle ptr");
	torture_assert_int_equal(tctx, *r->in.resume_handle, 0, "resume handle");
	torture_assert_int_equal(tctx, r->in.max_count, 100, "max count");
	return true;
}

static const uint8_t lsarenumerateprivileges_out_data[] = {
  0x1d, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
  0x1d, 0x00, 0x00, 0x00, 0x2c, 0x00, 0x2e, 0x00, 0x04, 0x00, 0x02, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x00, 0x3c, 0x00,
  0x08, 0x00, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x2a, 0x00, 0x2c, 0x00, 0x0c, 0x00, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x32, 0x00, 0x10, 0x00, 0x02, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x00, 0x34, 0x00,
  0x14, 0x00, 0x02, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x1c, 0x00, 0x1e, 0x00, 0x18, 0x00, 0x02, 0x00, 0x07, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x26, 0x00, 0x28, 0x00, 0x1c, 0x00, 0x02, 0x00,
  0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x32, 0x00,
  0x20, 0x00, 0x02, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x2a, 0x00, 0x2c, 0x00, 0x24, 0x00, 0x02, 0x00, 0x0a, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x32, 0x00, 0x28, 0x00, 0x02, 0x00,
  0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x00, 0x2c, 0x00,
  0x2c, 0x00, 0x02, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x3e, 0x00, 0x40, 0x00, 0x30, 0x00, 0x02, 0x00, 0x0d, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x40, 0x00, 0x34, 0x00, 0x02, 0x00,
  0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x00, 0x34, 0x00,
  0x38, 0x00, 0x02, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x34, 0x00, 0x36, 0x00, 0x3c, 0x00, 0x02, 0x00, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x24, 0x00, 0x40, 0x00, 0x02, 0x00,
  0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x26, 0x00,
  0x44, 0x00, 0x02, 0x00, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x26, 0x00, 0x28, 0x00, 0x48, 0x00, 0x02, 0x00, 0x13, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x22, 0x00, 0x4c, 0x00, 0x02, 0x00,
  0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x22, 0x00,
  0x50, 0x00, 0x02, 0x00, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x38, 0x00, 0x3a, 0x00, 0x54, 0x00, 0x02, 0x00, 0x16, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x2e, 0x00, 0x30, 0x00, 0x58, 0x00, 0x02, 0x00,
  0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x00, 0x34, 0x00,
  0x5c, 0x00, 0x02, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x22, 0x00, 0x24, 0x00, 0x60, 0x00, 0x02, 0x00, 0x19, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x28, 0x00, 0x2a, 0x00, 0x64, 0x00, 0x02, 0x00,
  0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x00, 0x38, 0x00,
  0x68, 0x00, 0x02, 0x00, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x2e, 0x00, 0x30, 0x00, 0x6c, 0x00, 0x02, 0x00, 0x1c, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x2c, 0x00, 0x2e, 0x00, 0x70, 0x00, 0x02, 0x00,
  0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0x00, 0x30, 0x00,
  0x74, 0x00, 0x02, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00,
  0x53, 0x00, 0x65, 0x00, 0x43, 0x00, 0x72, 0x00, 0x65, 0x00, 0x61, 0x00,
  0x74, 0x00, 0x65, 0x00, 0x54, 0x00, 0x6f, 0x00, 0x6b, 0x00, 0x65, 0x00,
  0x6e, 0x00, 0x50, 0x00, 0x72, 0x00, 0x69, 0x00, 0x76, 0x00, 0x69, 0x00,
  0x6c, 0x00, 0x65, 0x00, 0x67, 0x00, 0x65, 0x00, 0x1e, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x53, 0x00, 0x65, 0x00,
  0x41, 0x00, 0x73, 0x00, 0x73, 0x00, 0x69, 0x00, 0x67, 0x00, 0x6e, 0x00,
  0x50, 0x00, 0x72, 0x00, 0x69, 0x00, 0x6d, 0x00, 0x61, 0x00, 0x72, 0x00,
  0x79, 0x00, 0x54, 0x00, 0x6f, 0x00, 0x6b, 0x00, 0x65, 0x00, 0x6e, 0x00,
  0x50, 0x00, 0x72, 0x00, 0x69, 0x00, 0x76, 0x00, 0x69, 0x00, 0x6c, 0x00,
  0x65, 0x00, 0x67, 0x00, 0x65, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00, 0x53, 0x00, 0x65, 0x00,
  0x4c, 0x00, 0x6f, 0x00, 0x63, 0x00, 0x6b, 0x00, 0x4d, 0x00, 0x65, 0x00,
  0x6d, 0x00, 0x6f, 0x00, 0x72, 0x00, 0x79, 0x00, 0x50, 0x00, 0x72, 0x00,
  0x69, 0x00, 0x76, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x67, 0x00,
  0x65, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x18, 0x00, 0x00, 0x00, 0x53, 0x00, 0x65, 0x00, 0x49, 0x00, 0x6e, 0x00,
  0x63, 0x00, 0x72, 0x00, 0x65, 0x00, 0x61, 0x00, 0x73, 0x00, 0x65, 0x00,
  0x51, 0x00, 0x75, 0x00, 0x6f, 0x00, 0x74, 0x00, 0x61, 0x00, 0x50, 0x00,
  0x72, 0x00, 0x69, 0x00, 0x76, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x65, 0x00,
  0x67, 0x00, 0x65, 0x00, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x19, 0x00, 0x00, 0x00, 0x53, 0x00, 0x65, 0x00, 0x4d, 0x00, 0x61, 0x00,
  0x63, 0x00, 0x68, 0x00, 0x69, 0x00, 0x6e, 0x00, 0x65, 0x00, 0x41, 0x00,
  0x63, 0x00, 0x63, 0x00, 0x6f, 0x00, 0x75, 0x00, 0x6e, 0x00, 0x74, 0x00,
  0x50, 0x00, 0x72, 0x00, 0x69, 0x00, 0x76, 0x00, 0x69, 0x00, 0x6c, 0x00,
  0x65, 0x00, 0x67, 0x00, 0x65, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x53, 0x00, 0x65, 0x00,
  0x54, 0x00, 0x63, 0x00, 0x62, 0x00, 0x50, 0x00, 0x72, 0x00, 0x69, 0x00,
  0x76, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x67, 0x00, 0x65, 0x00,
  0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00,
  0x53, 0x00, 0x65, 0x00, 0x53, 0x00, 0x65, 0x00, 0x63, 0x00, 0x75, 0x00,
  0x72, 0x00, 0x69, 0x00, 0x74, 0x00, 0x79, 0x00, 0x50, 0x00, 0x72, 0x00,
  0x69, 0x00, 0x76, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x67, 0x00,
  0x65, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x18, 0x00, 0x00, 0x00, 0x53, 0x00, 0x65, 0x00, 0x54, 0x00, 0x61, 0x00,
  0x6b, 0x00, 0x65, 0x00, 0x4f, 0x00, 0x77, 0x00, 0x6e, 0x00, 0x65, 0x00,
  0x72, 0x00, 0x73, 0x00, 0x68, 0x00, 0x69, 0x00, 0x70, 0x00, 0x50, 0x00,
  0x72, 0x00, 0x69, 0x00, 0x76, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x65, 0x00,
  0x67, 0x00, 0x65, 0x00, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x15, 0x00, 0x00, 0x00, 0x53, 0x00, 0x65, 0x00, 0x4c, 0x00, 0x6f, 0x00,
  0x61, 0x00, 0x64, 0x00, 0x44, 0x00, 0x72, 0x00, 0x69, 0x00, 0x76, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x50, 0x00, 0x72, 0x00, 0x69, 0x00, 0x76, 0x00,
  0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x67, 0x00, 0x65, 0x00, 0x00, 0x00,
  0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00,
  0x53, 0x00, 0x65, 0x00, 0x53, 0x00, 0x79, 0x00, 0x73, 0x00, 0x74, 0x00,
  0x65, 0x00, 0x6d, 0x00, 0x50, 0x00, 0x72, 0x00, 0x6f, 0x00, 0x66, 0x00,
  0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x50, 0x00, 0x72, 0x00, 0x69, 0x00,
  0x76, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x67, 0x00, 0x65, 0x00,
  0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00,
  0x53, 0x00, 0x65, 0x00, 0x53, 0x00, 0x79, 0x00, 0x73, 0x00, 0x74, 0x00,
  0x65, 0x00, 0x6d, 0x00, 0x74, 0x00, 0x69, 0x00, 0x6d, 0x00, 0x65, 0x00,
  0x50, 0x00, 0x72, 0x00, 0x69, 0x00, 0x76, 0x00, 0x69, 0x00, 0x6c, 0x00,
  0x65, 0x00, 0x67, 0x00, 0x65, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x53, 0x00, 0x65, 0x00,
  0x50, 0x00, 0x72, 0x00, 0x6f, 0x00, 0x66, 0x00, 0x69, 0x00, 0x6c, 0x00,
  0x65, 0x00, 0x53, 0x00, 0x69, 0x00, 0x6e, 0x00, 0x67, 0x00, 0x6c, 0x00,
  0x65, 0x00, 0x50, 0x00, 0x72, 0x00, 0x6f, 0x00, 0x63, 0x00, 0x65, 0x00,
  0x73, 0x00, 0x73, 0x00, 0x50, 0x00, 0x72, 0x00, 0x69, 0x00, 0x76, 0x00,
  0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x67, 0x00, 0x65, 0x00, 0x00, 0x00,
  0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00,
  0x53, 0x00, 0x65, 0x00, 0x49, 0x00, 0x6e, 0x00, 0x63, 0x00, 0x72, 0x00,
  0x65, 0x00, 0x61, 0x00, 0x73, 0x00, 0x65, 0x00, 0x42, 0x00, 0x61, 0x00,
  0x73, 0x00, 0x65, 0x00, 0x50, 0x00, 0x72, 0x00, 0x69, 0x00, 0x6f, 0x00,
  0x72, 0x00, 0x69, 0x00, 0x74, 0x00, 0x79, 0x00, 0x50, 0x00, 0x72, 0x00,
  0x69, 0x00, 0x76, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x67, 0x00,
  0x65, 0x00, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x19, 0x00, 0x00, 0x00, 0x53, 0x00, 0x65, 0x00, 0x43, 0x00, 0x72, 0x00,
  0x65, 0x00, 0x61, 0x00, 0x74, 0x00, 0x65, 0x00, 0x50, 0x00, 0x61, 0x00,
  0x67, 0x00, 0x65, 0x00, 0x66, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x65, 0x00,
  0x50, 0x00, 0x72, 0x00, 0x69, 0x00, 0x76, 0x00, 0x69, 0x00, 0x6c, 0x00,
  0x65, 0x00, 0x67, 0x00, 0x65, 0x00, 0x00, 0x00, 0x1b, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x00, 0x53, 0x00, 0x65, 0x00,
  0x43, 0x00, 0x72, 0x00, 0x65, 0x00, 0x61, 0x00, 0x74, 0x00, 0x65, 0x00,
  0x50, 0x00, 0x65, 0x00, 0x72, 0x00, 0x6d, 0x00, 0x61, 0x00, 0x6e, 0x00,
  0x65, 0x00, 0x6e, 0x00, 0x74, 0x00, 0x50, 0x00, 0x72, 0x00, 0x69, 0x00,
  0x76, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x67, 0x00, 0x65, 0x00,
  0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00,
  0x53, 0x00, 0x65, 0x00, 0x42, 0x00, 0x61, 0x00, 0x63, 0x00, 0x6b, 0x00,
  0x75, 0x00, 0x70, 0x00, 0x50, 0x00, 0x72, 0x00, 0x69, 0x00, 0x76, 0x00,
  0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x67, 0x00, 0x65, 0x00, 0x00, 0x00,
  0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00,
  0x53, 0x00, 0x65, 0x00, 0x52, 0x00, 0x65, 0x00, 0x73, 0x00, 0x74, 0x00,
  0x6f, 0x00, 0x72, 0x00, 0x65, 0x00, 0x50, 0x00, 0x72, 0x00, 0x69, 0x00,
  0x76, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x67, 0x00, 0x65, 0x00,
  0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00,
  0x53, 0x00, 0x65, 0x00, 0x53, 0x00, 0x68, 0x00, 0x75, 0x00, 0x74, 0x00,
  0x64, 0x00, 0x6f, 0x00, 0x77, 0x00, 0x6e, 0x00, 0x50, 0x00, 0x72, 0x00,
  0x69, 0x00, 0x76, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x67, 0x00,
  0x65, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x00, 0x00, 0x00, 0x53, 0x00, 0x65, 0x00, 0x44, 0x00, 0x65, 0x00,
  0x62, 0x00, 0x75, 0x00, 0x67, 0x00, 0x50, 0x00, 0x72, 0x00, 0x69, 0x00,
  0x76, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x67, 0x00, 0x65, 0x00,
  0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00,
  0x53, 0x00, 0x65, 0x00, 0x41, 0x00, 0x75, 0x00, 0x64, 0x00, 0x69, 0x00,
  0x74, 0x00, 0x50, 0x00, 0x72, 0x00, 0x69, 0x00, 0x76, 0x00, 0x69, 0x00,
  0x6c, 0x00, 0x65, 0x00, 0x67, 0x00, 0x65, 0x00, 0x1d, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x53, 0x00, 0x65, 0x00,
  0x53, 0x00, 0x79, 0x00, 0x73, 0x00, 0x74, 0x00, 0x65, 0x00, 0x6d, 0x00,
  0x45, 0x00, 0x6e, 0x00, 0x76, 0x00, 0x69, 0x00, 0x72, 0x00, 0x6f, 0x00,
  0x6e, 0x00, 0x6d, 0x00, 0x65, 0x00, 0x6e, 0x00, 0x74, 0x00, 0x50, 0x00,
  0x72, 0x00, 0x69, 0x00, 0x76, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x65, 0x00,
  0x67, 0x00, 0x65, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x17, 0x00, 0x00, 0x00, 0x53, 0x00, 0x65, 0x00, 0x43, 0x00, 0x68, 0x00,
  0x61, 0x00, 0x6e, 0x00, 0x67, 0x00, 0x65, 0x00, 0x4e, 0x00, 0x6f, 0x00,
  0x74, 0x00, 0x69, 0x00, 0x66, 0x00, 0x79, 0x00, 0x50, 0x00, 0x72, 0x00,
  0x69, 0x00, 0x76, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x67, 0x00,
  0x65, 0x00, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x19, 0x00, 0x00, 0x00, 0x53, 0x00, 0x65, 0x00, 0x52, 0x00, 0x65, 0x00,
  0x6d, 0x00, 0x6f, 0x00, 0x74, 0x00, 0x65, 0x00, 0x53, 0x00, 0x68, 0x00,
  0x75, 0x00, 0x74, 0x00, 0x64, 0x00, 0x6f, 0x00, 0x77, 0x00, 0x6e, 0x00,
  0x50, 0x00, 0x72, 0x00, 0x69, 0x00, 0x76, 0x00, 0x69, 0x00, 0x6c, 0x00,
  0x65, 0x00, 0x67, 0x00, 0x65, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x53, 0x00, 0x65, 0x00,
  0x55, 0x00, 0x6e, 0x00, 0x64, 0x00, 0x6f, 0x00, 0x63, 0x00, 0x6b, 0x00,
  0x50, 0x00, 0x72, 0x00, 0x69, 0x00, 0x76, 0x00, 0x69, 0x00, 0x6c, 0x00,
  0x65, 0x00, 0x67, 0x00, 0x65, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x53, 0x00, 0x65, 0x00,
  0x53, 0x00, 0x79, 0x00, 0x6e, 0x00, 0x63, 0x00, 0x41, 0x00, 0x67, 0x00,
  0x65, 0x00, 0x6e, 0x00, 0x74, 0x00, 0x50, 0x00, 0x72, 0x00, 0x69, 0x00,
  0x76, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x67, 0x00, 0x65, 0x00,
  0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x00, 0x00, 0x00,
  0x53, 0x00, 0x65, 0x00, 0x45, 0x00, 0x6e, 0x00, 0x61, 0x00, 0x62, 0x00,
  0x6c, 0x00, 0x65, 0x00, 0x44, 0x00, 0x65, 0x00, 0x6c, 0x00, 0x65, 0x00,
  0x67, 0x00, 0x61, 0x00, 0x74, 0x00, 0x69, 0x00, 0x6f, 0x00, 0x6e, 0x00,
  0x50, 0x00, 0x72, 0x00, 0x69, 0x00, 0x76, 0x00, 0x69, 0x00, 0x6c, 0x00,
  0x65, 0x00, 0x67, 0x00, 0x65, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x53, 0x00, 0x65, 0x00,
  0x4d, 0x00, 0x61, 0x00, 0x6e, 0x00, 0x61, 0x00, 0x67, 0x00, 0x65, 0x00,
  0x56, 0x00, 0x6f, 0x00, 0x6c, 0x00, 0x75, 0x00, 0x6d, 0x00, 0x65, 0x00,
  0x50, 0x00, 0x72, 0x00, 0x69, 0x00, 0x76, 0x00, 0x69, 0x00, 0x6c, 0x00,
  0x65, 0x00, 0x67, 0x00, 0x65, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x53, 0x00, 0x65, 0x00,
  0x49, 0x00, 0x6d, 0x00, 0x70, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00,
  0x6f, 0x00, 0x6e, 0x00, 0x61, 0x00, 0x74, 0x00, 0x65, 0x00, 0x50, 0x00,
  0x72, 0x00, 0x69, 0x00, 0x76, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x65, 0x00,
  0x67, 0x00, 0x65, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x17, 0x00, 0x00, 0x00, 0x53, 0x00, 0x65, 0x00, 0x43, 0x00, 0x72, 0x00,
  0x65, 0x00, 0x61, 0x00, 0x74, 0x00, 0x65, 0x00, 0x47, 0x00, 0x6c, 0x00,
  0x6f, 0x00, 0x62, 0x00, 0x61, 0x00, 0x6c, 0x00, 0x50, 0x00, 0x72, 0x00,
  0x69, 0x00, 0x76, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x67, 0x00,
  0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static bool lsarenumerateprivileges_out_check(struct torture_context *tctx,
											 struct lsa_EnumPrivs *r)
{
	torture_assert(tctx, r->out.resume_handle != NULL, "resume handle ptr");
	torture_assert_int_equal(tctx, *r->out.resume_handle, 29, "resume handle");
	torture_assert_str_equal(tctx, r->out.privs->privs[0].name.string, "SeCreateTokenPrivilege", "name");
	torture_assert_str_equal(tctx, r->out.privs->privs[1].name.string, "SeAssignPrimaryTokenPrivilege", "name");
	torture_assert_ntstatus_ok(tctx, r->out.result, "return code");
	return true;
}

struct torture_suite *ndr_lsa_suite(TALLOC_CTX *ctx)
{
	struct torture_suite *suite = torture_suite_create(ctx, "lsa");

	torture_suite_add_ndr_pull_fn_test(suite, lsa_OpenPolicy, lsaropenpolicy_in_data, NDR_IN, lsaropenpolicy_in_check);
	torture_suite_add_ndr_pull_fn_test(suite, lsa_OpenPolicy, lsaropenpolicy_out_data, NDR_OUT, lsaropenpolicy_out_check);

	torture_suite_add_ndr_pull_fn_test(suite, lsa_OpenPolicy2, lsaropenpolicy2_in_data, NDR_IN, lsaropenpolicy2_in_check);
	torture_suite_add_ndr_pull_fn_test(suite, lsa_OpenPolicy2, lsaropenpolicy2_out_data, NDR_OUT, lsaropenpolicy2_out_check);

	torture_suite_add_ndr_pull_fn_test(suite, lsa_LookupNames, lsarlookupnames_in_data, NDR_IN, lsarlookupnames_in_check);
	torture_suite_add_ndr_pull_fn_test(suite, lsa_LookupNames, lsarlookupnames_out_data, NDR_OUT, lsarlookupnames_out_check); 

	torture_suite_add_ndr_pull_fn_test(suite, lsa_LookupSids, lsarlookupsids_in_data, NDR_IN, lsarlookupsids_in_check);
	torture_suite_add_ndr_pull_fn_test(suite, lsa_LookupSids, lsarlookupsids_out_data, NDR_OUT, lsarlookupsids_out_check);

	torture_suite_add_ndr_pull_fn_test(suite, lsa_CreateAccount, lsarcreateaccount_in_data, NDR_IN, lsarcreateaccount_in_check);
	torture_suite_add_ndr_pull_fn_test(suite, lsa_CreateAccount, lsarcreateaccount_out_data, NDR_OUT, lsarcreateaccount_out_check);

	torture_suite_add_ndr_pull_fn_test(suite, lsa_Delete, lsardelete_in_data, NDR_IN, lsardelete_in_check);
	torture_suite_add_ndr_pull_fn_test(suite, lsa_Delete, lsardelete_out_data, NDR_OUT, lsardelete_out_check); 

	torture_suite_add_ndr_pull_fn_test(suite, lsa_CreateSecret, lsarcreatesecret_in_data, NDR_IN, lsarcreatesecret_in_check);
	torture_suite_add_ndr_pull_fn_test(suite, lsa_CreateSecret, lsarcreatesecret_out_data, NDR_OUT, lsarcreatesecret_out_check);

	torture_suite_add_ndr_pull_fn_test(suite, lsa_OpenSecret, lsaropensecret_in_data, NDR_IN, lsaropensecret_in_check);
	torture_suite_add_ndr_pull_fn_test(suite, lsa_OpenSecret, lsaropensecret_out_data, NDR_OUT, lsaropensecret_out_check);

	torture_suite_add_ndr_pull_fn_test(suite, lsa_SetSecret, lsarsetsecret_in_data, NDR_IN, lsarsetsecret_in_check);
	torture_suite_add_ndr_pull_fn_test(suite, lsa_SetSecret, lsarsetsecret_out_data, NDR_OUT, lsarsetsecret_out_check);

	torture_suite_add_ndr_pull_fn_test(suite, lsa_QuerySecret, lsarquerysecret_in_data, NDR_IN, lsarquerysecret_in_check);
	torture_suite_add_ndr_pull_fn_test(suite, lsa_QuerySecret, lsarquerysecret_out_data, NDR_OUT, lsarquerysecret_out_check);

	torture_suite_add_ndr_pull_fn_test(suite, lsa_CreateTrustedDomain, lsarcreatetrusteddomain_in_data, NDR_IN, lsarcreatetrusteddomain_in_check);
	torture_suite_add_ndr_pull_fn_test(suite, lsa_CreateTrustedDomain, lsarcreatetrusteddomain_out_data, NDR_OUT, lsarcreatetrusteddomain_out_check);

	torture_suite_add_ndr_pull_fn_test(suite, lsa_EnumAccounts, lsarenumerateaccounts_in_data, NDR_IN, lsarenumerateaccounts_in_check);
	torture_suite_add_ndr_pull_fn_test(suite, lsa_EnumAccounts, lsarenumerateaccounts_out_data, NDR_OUT, lsarenumerateaccounts_out_check);

	torture_suite_add_ndr_pull_fn_test(suite, lsa_LookupSids2, lsarlookupsids2_in_data, NDR_IN, lsarlookupsids2_in_check);
	torture_suite_add_ndr_pull_fn_test(suite, lsa_LookupSids2, lsarlookupsids2_out_data, NDR_OUT, lsarlookupsids2_out_check);

	torture_suite_add_ndr_pull_fn_test(suite, lsa_LookupNames2, lsarlookupnames2_in_data, NDR_IN, lsarlookupnames2_in_check);
	torture_suite_add_ndr_pull_fn_test(suite, lsa_LookupNames2, lsarlookupnames2_out_data, NDR_OUT, lsarlookupnames2_out_check);

	torture_suite_add_ndr_pull_fn_test(suite, lsa_LookupNames3, lsarlookupnames3_in_data, NDR_IN, lsarlookupnames3_in_check);
	torture_suite_add_ndr_pull_fn_test(suite, lsa_LookupNames3, lsarlookupnames3_out_data, NDR_OUT, lsarlookupnames3_out_check);

	torture_suite_add_ndr_pull_fn_test(suite, lsa_LookupSids3, lsarlookupsids3_in_data, NDR_IN, lsarlookupsids3_in_check);
	/* torture_suite_add_ndr_pull_fn_test(suite, lsa_LookupSids3, lsarlookupsids3_out_data, NDR_OUT, lsarlookupsids3_out_check); */

	torture_suite_add_ndr_pull_fn_test(suite, lsa_EnumPrivs, lsarenumerateprivileges_in_data, NDR_IN, lsarenumerateprivileges_in_check);
	torture_suite_add_ndr_pull_fn_test(suite, lsa_EnumPrivs, lsarenumerateprivileges_out_data, NDR_OUT, lsarenumerateprivileges_out_check);

	return suite;
}

