/**
 *  Copyright 2009 Opera Software ASA. All rights reserved.
 *
 * This file contains Original Code and/or Contributions to the Original 
 * Code as defined in the Opera Web Applications License (the License). 
 * You may not use this file except in compliance with the License. Please 
 * obtain a copy of the License at http://www.opera.com/license/owal/
 * and read it before using this file. 
 *
 * The Original Code and all Contributions to the Original Code distributed 
 * under the License are distributed on an AS IS basis, WITHOUT WARRANTY 
 * OF ANY KIND, EITHER EXPRESS OR IMPLIED, AND OPERA HEREBY DISCLAIMS ALL 
 * SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF 
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. 
 *
 * Please see the License for the specific language governing rights and 
 * limitations under the License.
 */
 
Node.prototype.dispatch = function(eventName, data)
{
    var evt = document.createEvent("Event");
    evt.initEvent(eventName, false, true);
    evt.data = data;
    document.dispatchEvent(evt);
}

var originalXHR = window.XMLHttpRequest;

window.XMLHttpRequest = function(options) {
	var self = this;
	options = options || {};
	this.timeout = options.timeout || 25;
	this.listeners = {};
	this.__xhr = new originalXHR();

	this.__xhr.onreadystatechange = function() {
		self.readyState = self.__xhr.readyState;

		if ( window.navigator && !window.navigator.onLine ) {
			self.error('Offline');
			self.abort();
		}
		if ( self.__xhr.readyState > 2 ) {
      clearTimeout(self.timer);
    }
    if ( self.__xhr.readyState == 3 ) {
      document.dispatch('XHR_receiving', {
        title: "Receiving data".toLocale(),
        cancel: function(){
          self.abort();
        }
      });
    }
    
		if ( self.__xhr.readyState == 4 ) {
			self.responseText = self.__xhr.responseText;
			self.status = self.__xhr.status;
			self.statusText = self.__xhr.statusText;
			self.responseXML = self.__xhr.responseXML;

			if ( self.__xhr.status >= 400 ) {
				self.error(self.__xhr.status + ': ' + self.__xhr.statusText);
			}
      document.dispatch('XHR_complete');
		}

		if ( self.onreadystatechange ) {
			self.onreadystatechange(self);
		}
	}
  
  this.addEventListener("networkError", function(){
      document.dispatch('XHR_error', {
          error: true,
          title: "Network Error".toLocale(),
          message: "Error message #1".toLocale(),
          retry: function(){
            self.send(self.data);
          },
          cancel: function(){
            self.abort();
          }
      });
  });
}
window.XMLHttpRequest.prototype = {
	addEventListener: function(type, listener) {
		this.listeners[type] = this.listeners[type] || [];
		this.listeners[type].push(listener);
	},
	removeEventListener: function(type, listener) {
		for ( var i = 0; i < (this.listeners[type]||[]).length; i++ ) {
			if ( this.listeners[type][i] == listener ) {
				this.listeners[type].splice(i, 1);
				return;
			}
		}
	},
	dispatchEvent: function(type, message) {
		for ( var i = 0; i < (this.listeners[type]||[]).length; i++ ) {
			this.listeners[type][i]({
				type: type,
				target: this,
				detail: message,
				toString: function() { return this.detail }
			});
		}
	},
	error: function(message) {
		this.dispatchEvent('networkError', message);
	},
	open: function(method, url, async, user, password) {
		this.__xhr.open.apply(this.__xhr, arguments);
	},
	setRequestHeader: function(header) {
		this.__xhr.setRequestHeader.apply(this.__xhr, arguments);
	},
  data: "",
	send: function(data) {
    document.dispatch('XHR_fetching', {
        title: "Requesting data".toLocale(),
        cancel: function(){
          self.abort();
        }
      });
		var self = this;
		try {
			this.timer = setTimeout(function() {
				self.error('Timeout');
				self.abort();
			}, this.timeout*1000);
      self.data = arguments;
			this.__xhr.send.apply(this.__xhr, arguments);
		} catch(ex) {
			clearTimeout(self.timer);
			self.error(ex.message);
		}
	},
	abort: function() {
		clearTimeout(this.timer);
		this.__xhr.abort.apply(this.__xhr, arguments);
	},
	getAllResponseHeaders: function() {
		return this_xhr.getAllResponseHeaders.apply(this.__xhr, arguments);
	},
	getResponseHeader: function(header) {
		return this_xhr.getResponseHeader.apply(this.__xhr, arguments);
	},
	overrideMimeType: function() {
		return this_xhr.overrideMimeType.apply(this.__xhr, arguments);
	}
}
