/* Generated by re2c 1.0.3 on Wed Sep 11 17:29:29 2024 */
#line 1 "ext/date/lib/parse_date.re"
/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2015-2023 Derick Rethans
 * Copyright (c) 2018 MongoDB, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "timelib.h"
#include "timelib_private.h"

#include <ctype.h>
#include <errno.h>
#include <math.h>
#include <assert.h>
#include <limits.h>

#if defined(_MSC_VER)
# define strtoll(s, f, b) _atoi64(s)
#elif !defined(HAVE_STRTOLL)
# if defined(HAVE_ATOLL)
#  define strtoll(s, f, b) atoll(s)
# else
#  define strtoll(s, f, b) strtol(s, f, b)
# endif
#endif

#define EOI      257
#define TIME     258
#define DATE     259

#define TIMELIB_XMLRPC_SOAP    260
#define TIMELIB_TIME12         261
#define TIMELIB_TIME24         262
#define TIMELIB_GNU_NOCOLON    263
#define TIMELIB_GNU_NOCOLON_TZ 264
#define TIMELIB_ISO_NOCOLON    265

#define TIMELIB_AMERICAN       266
#define TIMELIB_ISO_DATE       267
#define TIMELIB_DATE_FULL      268
#define TIMELIB_DATE_TEXT      269
#define TIMELIB_DATE_NOCOLON   270
#define TIMELIB_PG_YEARDAY     271
#define TIMELIB_PG_TEXT        272
#define TIMELIB_PG_REVERSE     273
#define TIMELIB_CLF            274
#define TIMELIB_DATE_NO_DAY    275
#define TIMELIB_SHORTDATE_WITH_TIME 276
#define TIMELIB_DATE_FULL_POINTED 277
#define TIMELIB_TIME24_WITH_ZONE 278
#define TIMELIB_ISO_WEEK       279
#define TIMELIB_LF_DAY_OF_MONTH 280
#define TIMELIB_WEEK_DAY_OF_MONTH 281

#define TIMELIB_TIMEZONE       300
#define TIMELIB_AGO            301

#define TIMELIB_RELATIVE       310

#define TIMELIB_ERROR          999

/* Some compilers like AIX, defines uchar in sys/types.h */
#undef uchar
typedef unsigned char uchar;

#define   BSIZE	   8192

#define   YYCTYPE      uchar
#define   YYCURSOR     cursor
#define   YYLIMIT      s->lim
#define   YYMARKER     s->ptr
#define   YYFILL(n)    return EOI;

#define   RET(i)       {s->cur = cursor; return i;}

#define timelib_string_free timelib_free

#define TIMELIB_HAVE_TIME() { if (s->time->have_time) { add_error(s, TIMELIB_ERR_DOUBLE_TIME, "Double time specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_time = 1; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->us = 0; } }
#define TIMELIB_UNHAVE_TIME() { s->time->have_time = 0; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->us = 0; }
#define TIMELIB_HAVE_DATE() { if (s->time->have_date) { add_error(s, TIMELIB_ERR_DOUBLE_DATE, "Double date specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_date = 1; } }
#define TIMELIB_UNHAVE_DATE() { s->time->have_date = 0; s->time->d = 0; s->time->m = 0; s->time->y = 0; }
#define TIMELIB_HAVE_RELATIVE() { s->time->have_relative = 1; }
#define TIMELIB_HAVE_WEEKDAY_RELATIVE() { s->time->have_relative = 1; s->time->relative.have_weekday_relative = 1; }
#define TIMELIB_HAVE_SPECIAL_RELATIVE() { s->time->have_relative = 1; s->time->relative.have_special_relative = 1; }
#define TIMELIB_HAVE_TZ() { s->cur = cursor; if (s->time->have_zone) { s->time->have_zone > 1 ? add_error(s, TIMELIB_ERR_DOUBLE_TZ, "Double timezone specification") : add_warning(s, TIMELIB_WARN_DOUBLE_TZ, "Double timezone specification"); timelib_string_free(str); s->time->have_zone++; return TIMELIB_ERROR; } else { s->time->have_zone++; } }

#define TIMELIB_INIT  s->cur = cursor; str = timelib_string(s); ptr = str
#define TIMELIB_DEINIT timelib_string_free(str)
#define TIMELIB_ADJUST_RELATIVE_WEEKDAY() if (in->time.have_weekday_relative && (in.rel.d > 0)) { in.rel.d -= 7; }

#define TIMELIB_PROCESS_YEAR(x, l) { \
	if (((x) == TIMELIB_UNSET) || ((l) >= 4)) { \
	/*	(x) = 0; */          \
	} else if ((x) < 100) {  \
		if ((x) < 70) {      \
			(x) += 2000;     \
		} else {             \
			(x) += 1900;     \
		}                    \
	}                        \
}

#ifdef DEBUG_PARSER
#define DEBUG_OUTPUT(s) printf("%s\n", s);
#define YYDEBUG(s,c) { if (s != -1) { printf("state: %d ", s); printf("[%c]\n", c); } }
#else
#define DEBUG_OUTPUT(s)
#define YYDEBUG(s,c)
#endif

typedef struct _timelib_elems {
	unsigned int   c; /* Number of elements */
	char         **v; /* Values */
} timelib_elems;

typedef struct _Scanner {
	int           fd;
	uchar        *lim, *str, *ptr, *cur, *tok, *pos;
	unsigned int  line, len;
	timelib_error_container *errors;

	timelib_time        *time;
	const timelib_tzdb  *tzdb;
} Scanner;

typedef struct _timelib_lookup_table {
	const char *name;
	int         type;
	int         value;
} timelib_lookup_table;

typedef struct _timelib_relunit {
	const char *name;
	int         unit;
	int         multiplier;
} timelib_relunit;

/* The timezone table. */
static const timelib_tz_lookup_table timelib_timezone_lookup[] = {
#include "timezonemap.h"
	{ NULL, 0, 0, NULL },
};

static const timelib_tz_lookup_table timelib_timezone_fallbackmap[] = {
#include "fallbackmap.h"
	{ NULL, 0, 0, NULL },
};

static const timelib_tz_lookup_table timelib_timezone_utc[] = {
	{ "utc", 0, 0, "UTC" },
};

#if defined(_POSIX_TZNAME_MAX)
# define MAX_ABBR_LEN _POSIX_TZNAME_MAX
#elif defined(TZNAME_MAX)
# define MAX_ABBR_LEN TZNAME_MAX
#else
# define MAX_ABBR_LEN 6
#endif

static timelib_relunit const timelib_relunit_lookup[] = {
	{ "ms",           TIMELIB_MICROSEC, 1000 },
	{ "msec",         TIMELIB_MICROSEC, 1000 },
	{ "msecs",        TIMELIB_MICROSEC, 1000 },
	{ "millisecond",  TIMELIB_MICROSEC, 1000 },
	{ "milliseconds", TIMELIB_MICROSEC, 1000 },
	{ "µs",           TIMELIB_MICROSEC,    1 },
	{ "usec",         TIMELIB_MICROSEC,    1 },
	{ "usecs",        TIMELIB_MICROSEC,    1 },
	{ "µsec",         TIMELIB_MICROSEC,    1 },
	{ "µsecs",        TIMELIB_MICROSEC,    1 },
	{ "microsecond",  TIMELIB_MICROSEC,    1 },
	{ "microseconds", TIMELIB_MICROSEC,    1 },
	{ "sec",         TIMELIB_SECOND,  1 },
	{ "secs",        TIMELIB_SECOND,  1 },
	{ "second",      TIMELIB_SECOND,  1 },
	{ "seconds",     TIMELIB_SECOND,  1 },
	{ "min",         TIMELIB_MINUTE,  1 },
	{ "mins",        TIMELIB_MINUTE,  1 },
	{ "minute",      TIMELIB_MINUTE,  1 },
	{ "minutes",     TIMELIB_MINUTE,  1 },
	{ "hour",        TIMELIB_HOUR,    1 },
	{ "hours",       TIMELIB_HOUR,    1 },
	{ "day",         TIMELIB_DAY,     1 },
	{ "days",        TIMELIB_DAY,     1 },
	{ "week",        TIMELIB_DAY,     7 },
	{ "weeks",       TIMELIB_DAY,     7 },
	{ "fortnight",   TIMELIB_DAY,    14 },
	{ "fortnights",  TIMELIB_DAY,    14 },
	{ "forthnight",  TIMELIB_DAY,    14 },
	{ "forthnights", TIMELIB_DAY,    14 },
	{ "month",       TIMELIB_MONTH,   1 },
	{ "months",      TIMELIB_MONTH,   1 },
	{ "year",        TIMELIB_YEAR,    1 },
	{ "years",       TIMELIB_YEAR,    1 },

	{ "mondays",     TIMELIB_WEEKDAY, 1 },
	{ "monday",      TIMELIB_WEEKDAY, 1 },
	{ "mon",         TIMELIB_WEEKDAY, 1 },
	{ "tuesdays",    TIMELIB_WEEKDAY, 2 },
	{ "tuesday",     TIMELIB_WEEKDAY, 2 },
	{ "tue",         TIMELIB_WEEKDAY, 2 },
	{ "wednesdays",  TIMELIB_WEEKDAY, 3 },
	{ "wednesday",   TIMELIB_WEEKDAY, 3 },
	{ "wed",         TIMELIB_WEEKDAY, 3 },
	{ "thursdays",   TIMELIB_WEEKDAY, 4 },
	{ "thursday",    TIMELIB_WEEKDAY, 4 },
	{ "thu",         TIMELIB_WEEKDAY, 4 },
	{ "fridays",     TIMELIB_WEEKDAY, 5 },
	{ "friday",      TIMELIB_WEEKDAY, 5 },
	{ "fri",         TIMELIB_WEEKDAY, 5 },
	{ "saturdays",   TIMELIB_WEEKDAY, 6 },
	{ "saturday",    TIMELIB_WEEKDAY, 6 },
	{ "sat",         TIMELIB_WEEKDAY, 6 },
	{ "sundays",     TIMELIB_WEEKDAY, 0 },
	{ "sunday",      TIMELIB_WEEKDAY, 0 },
	{ "sun",         TIMELIB_WEEKDAY, 0 },

	{ "weekday",     TIMELIB_SPECIAL, TIMELIB_SPECIAL_WEEKDAY },
	{ "weekdays",    TIMELIB_SPECIAL, TIMELIB_SPECIAL_WEEKDAY },
	{ NULL,          0,          0 }
};

/* The relative text table. */
static timelib_lookup_table const timelib_reltext_lookup[] = {
	{ "first",    0,  1 },
	{ "next",     0,  1 },
	{ "second",   0,  2 },
	{ "third",    0,  3 },
	{ "fourth",   0,  4 },
	{ "fifth",    0,  5 },
	{ "sixth",    0,  6 },
	{ "seventh",  0,  7 },
	{ "eight",    0,  8 },
	{ "eighth",   0,  8 },
	{ "ninth",    0,  9 },
	{ "tenth",    0, 10 },
	{ "eleventh", 0, 11 },
	{ "twelfth",  0, 12 },
	{ "last",     0, -1 },
	{ "previous", 0, -1 },
	{ "this",     1,  0 },
	{ NULL,       1,  0 }
};

/* The month table. */
static timelib_lookup_table const timelib_month_lookup[] = {
	{ "jan",  0,  1 },
	{ "feb",  0,  2 },
	{ "mar",  0,  3 },
	{ "apr",  0,  4 },
	{ "may",  0,  5 },
	{ "jun",  0,  6 },
	{ "jul",  0,  7 },
	{ "aug",  0,  8 },
	{ "sep",  0,  9 },
	{ "sept", 0,  9 },
	{ "oct",  0, 10 },
	{ "nov",  0, 11 },
	{ "dec",  0, 12 },
	{ "i",    0,  1 },
	{ "ii",   0,  2 },
	{ "iii",  0,  3 },
	{ "iv",   0,  4 },
	{ "v",    0,  5 },
	{ "vi",   0,  6 },
	{ "vii",  0,  7 },
	{ "viii", 0,  8 },
	{ "ix",   0,  9 },
	{ "x",    0, 10 },
	{ "xi",   0, 11 },
	{ "xii",  0, 12 },

	{ "january",   0,  1 },
	{ "february",  0,  2 },
	{ "march",     0,  3 },
	{ "april",     0,  4 },
	{ "may",       0,  5 },
	{ "june",      0,  6 },
	{ "july",      0,  7 },
	{ "august",    0,  8 },
	{ "september", 0,  9 },
	{ "october",   0, 10 },
	{ "november",  0, 11 },
	{ "december",  0, 12 },
	{  NULL,       0,  0 }
};

#if 0
static char* timelib_ltrim(char *s)
{
	char *ptr = s;
	while (ptr[0] == ' ' || ptr[0] == '\t') {
		ptr++;
	}
	return ptr;
}
#endif

#if 0
uchar *fill(Scanner *s, uchar *cursor){
	if(!s->eof){
		unsigned int cnt = s->tok - s->bot;
		if(cnt){
			memcpy(s->bot, s->tok, s->lim - s->tok);
			s->tok = s->bot;
			s->ptr -= cnt;
			cursor -= cnt;
			s->pos -= cnt;
			s->lim -= cnt;
		}
		if((s->top - s->lim) < BSIZE){
			uchar *buf = (uchar*) timelib_malloc(((s->lim - s->bot) + BSIZE)*sizeof(uchar));
			memcpy(buf, s->tok, s->lim - s->tok);
			s->tok = buf;
			s->ptr = &buf[s->ptr - s->bot];
			cursor = &buf[cursor - s->bot];
			s->pos = &buf[s->pos - s->bot];
			s->lim = &buf[s->lim - s->bot];
			s->top = &s->lim[BSIZE];
			timelib_free(s->bot);
			s->bot = buf;
		}
		if((cnt = read(s->fd, (char*) s->lim, BSIZE)) != BSIZE){
			s->eof = &s->lim[cnt]; *(s->eof)++ = '\n';
		}
		s->lim += cnt;
	}
	return cursor;
}
#endif

static timelib_error_message *alloc_error_message(timelib_error_message **messages, int *count)
{
	/* Realloc in power of two increments */
	int is_pow2 = (*count & (*count - 1)) == 0;

	if (is_pow2) {
		size_t alloc_size = *count ? (*count * 2) : 1;

		*messages = timelib_realloc(*messages, alloc_size * sizeof(timelib_error_message));
	}
	return *messages + (*count)++;
}

static void add_warning(Scanner *s, int error_code, const char *error)
{
	timelib_error_message *message = alloc_error_message(&s->errors->warning_messages, &s->errors->warning_count);

	message->error_code = error_code;
	message->position = s->tok ? s->tok - s->str : 0;
	message->character = s->tok ? *s->tok : 0;
	message->message = timelib_strdup(error);
}

static void add_error(Scanner *s, int error_code, const char *error)
{
	timelib_error_message *message = alloc_error_message(&s->errors->error_messages, &s->errors->error_count);

	message->error_code = error_code;
	message->position = s->tok ? s->tok - s->str : 0;
	message->character = s->tok ? *s->tok : 0;
	message->message = timelib_strdup(error);
}

static void add_pbf_warning(Scanner *s, int error_code, const char *error, const char *sptr, const char *cptr)
{
	timelib_error_message *message = alloc_error_message(&s->errors->warning_messages, &s->errors->warning_count);

	message->error_code = error_code;
	message->position = cptr - sptr;
	message->character = *cptr;
	message->message = timelib_strdup(error);
}

static void add_pbf_error(Scanner *s, int error_code, const char *error, const char *sptr, const char *cptr)
{
	timelib_error_message *message = alloc_error_message(&s->errors->error_messages, &s->errors->error_count);

	message->error_code = error_code;
	message->position = cptr - sptr;
	message->character = *cptr;
	message->message = timelib_strdup(error);
}

static timelib_sll timelib_meridian(const char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (!strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		++*ptr;
	}
	if (**ptr == 'M' || **ptr == 'm') {
		++*ptr;
	}
	if (**ptr == '.') {
		++*ptr;
	}
	return retval;
}

static timelib_sll timelib_meridian_with_check(const char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (**ptr && !strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if(!**ptr) {
		return TIMELIB_UNSET;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		++*ptr;
		if (**ptr != 'm' && **ptr != 'M') {
			return TIMELIB_UNSET;
		}
		++*ptr;
		if (**ptr != '.' ) {
			return TIMELIB_UNSET;
		}
		++*ptr;
	} else if (**ptr == 'm' || **ptr == 'M') {
		++*ptr;
	} else {
		return TIMELIB_UNSET;
	}
	return retval;
}

static char *timelib_string(Scanner *s)
{
	char *tmp = timelib_calloc(1, s->cur - s->tok + 1);
	memcpy(tmp, s->tok, s->cur - s->tok);

	return tmp;
}

static timelib_sll timelib_get_nr_ex(const char **ptr, int max_length, int *scanned_length)
{
	const char *begin, *end;
	char *str;
	timelib_sll tmp_nr = TIMELIB_UNSET;
	int len = 0;

	while ((**ptr < '0') || (**ptr > '9')) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}

	begin = *ptr;
	while ((**ptr >= '0') && (**ptr <= '9') && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	if (scanned_length) {
		*scanned_length = end - begin;
	}
	str = timelib_calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtoll(str, NULL, 10);
	timelib_free(str);
	return tmp_nr;
}

static timelib_sll timelib_get_nr(const char **ptr, int max_length)
{
	return timelib_get_nr_ex(ptr, max_length, NULL);
}

static void timelib_skip_day_suffix(const char **ptr)
{
	if (isspace(**ptr)) {
		return;
	}
	if (!timelib_strncasecmp(*ptr, "nd", 2) || !timelib_strncasecmp(*ptr, "rd", 2) ||!timelib_strncasecmp(*ptr, "st", 2) || !timelib_strncasecmp(*ptr, "th", 2)) {
		*ptr += 2;
	}
}

static timelib_sll timelib_get_frac_nr(const char **ptr)
{
	const char *begin, *end;
	char *str;
	double tmp_nr = TIMELIB_UNSET;

	while ((**ptr != '.') && (**ptr != ':') && ((**ptr < '0') || (**ptr > '9'))) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}
	begin = *ptr;
	while ((**ptr == '.') || (**ptr == ':') || ((**ptr >= '0') && (**ptr <= '9'))) {
		++*ptr;
	}
	end = *ptr;
	str = timelib_calloc(1, end - begin);
	memcpy(str, begin + 1, end - begin - 1);
	tmp_nr = strtod(str, NULL) * pow(10, 7 - (end - begin));
	timelib_free(str);
	return tmp_nr;
}

static timelib_ull timelib_get_signed_nr(Scanner *s, const char **ptr, int max_length)
{
	char *str, *str_ptr;
	timelib_sll tmp_nr = 0;
	int len = 0;

	/* Skip over non-numeric chars */

	while (((**ptr < '0') || (**ptr > '9')) && (**ptr != '+') && (**ptr != '-')) {
		if (**ptr == '\0') {
			add_error(s, TIMELIB_ERR_UNEXPECTED_DATA, "Found unexpected data");
			return 0;
		}
		++*ptr;
	}
	
	/* Allocate string to feed to strtoll(): sign + length + '\0' */
	str = timelib_calloc(1, max_length + 2);
	str[0] = '+'; /* First position is the sign */
	str_ptr = str + 1;

	while ((**ptr == '+') || (**ptr == '-')) {
		if (**ptr == '-') {
			str[0] = str[0] == '+' ? '-' : '+';
		}
		++*ptr;
	}

	while (((**ptr < '0') || (**ptr > '9'))) {
		if (**ptr == '\0') {
			timelib_free(str);
			add_error(s, TIMELIB_ERR_UNEXPECTED_DATA, "Found unexpected data");
			return 0;
		}
		++*ptr;
	}

	while ((**ptr >= '0') && (**ptr <= '9') && len < max_length) {
		*str_ptr = **ptr;
		++*ptr;
		++str_ptr;
		++len;
	}

	errno = 0;
	tmp_nr = strtoll(str, NULL, 10);
	if (errno == ERANGE) {
		timelib_free(str);
		add_error(s, TIMELIB_ERR_NUMBER_OUT_OF_RANGE, "Number out of range");
		return 0;
	}

	timelib_free(str);

	return tmp_nr;
}

static timelib_sll timelib_lookup_relative_text(const char **ptr, int *behavior)
{
	char *word;
	const char *begin = *ptr, *end;
	timelib_sll  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_reltext_lookup; tp->name; tp++) {
		if (timelib_strcasecmp(word, tp->name) == 0) {
			value = tp->value;
			*behavior = tp->type;
		}
	}

	timelib_free(word);
	return value;
}

static timelib_sll timelib_get_relative_text(const char **ptr, int *behavior)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_relative_text(ptr, behavior);
}

static timelib_long timelib_lookup_month(const char **ptr)
{
	char *word;
	const char *begin = *ptr, *end;
	timelib_long  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_month_lookup; tp->name; tp++) {
		if (timelib_strcasecmp(word, tp->name) == 0) {
			value = tp->value;
		}
	}

	timelib_free(word);
	return value;
}

static timelib_long timelib_get_month(const char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '.' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_month(ptr);
}

static void timelib_eat_spaces(const char **ptr)
{
	do {
		if (**ptr == ' ' || **ptr == '\t') {
			++*ptr;
			continue;
		}
		if ((*ptr)[0] == '\xe2' && (*ptr)[1] == '\x80' && (*ptr)[2] == '\xaf') { // NNBSP
			*ptr += 3;
			continue;
		}
		if ((*ptr)[0] == '\xc2' && (*ptr)[1] == '\xa0') { // NBSP
			*ptr += 2;
			continue;
		}
		break;
	} while (true);
}

static void timelib_eat_until_separator(const char **ptr)
{
	++*ptr;
	while (strchr(" \t.,:;/-0123456789", **ptr) == NULL) {
		++*ptr;
	}
}

static const timelib_relunit* timelib_lookup_relunit(const char **ptr)
{
	char *word;
	const char *begin = *ptr, *end;
	const timelib_relunit *tp, *value = NULL;

	while (**ptr != '\0' && **ptr != ' ' && **ptr != ',' && **ptr != '\t' && **ptr != ';' && **ptr != ':' &&
		**ptr != '/' && **ptr != '.' && **ptr != '-' && **ptr != '(' && **ptr != ')' ) {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_relunit_lookup; tp->name; tp++) {
		if (timelib_strcasecmp(word, tp->name) == 0) {
			value = tp;
			break;
		}
	}

	timelib_free(word);
	return value;
}

static void add_with_overflow(Scanner *s, timelib_sll *e, timelib_sll amount, int multiplier)
{
#if TIMELIB_HAVE_BUILTIN_SADDLL_OVERFLOW
	if (__builtin_saddll_overflow(*e, amount * multiplier, e)) {
		add_error(s, TIMELIB_ERR_NUMBER_OUT_OF_RANGE, "Number out of range");
	}
#else
	*e += (amount * multiplier);
#endif
}

/**
 * The time_part parameter is a flag. It can be TIMELIB_TIME_PART_KEEP in case
 * the time portion should not be reset to midnight, or
 * TIMELIB_TIME_PART_DONT_KEEP in case it does need to be reset. This is used
 * for not overwriting the time portion for 'X weekday'.
 */
static void timelib_set_relative(const char **ptr, timelib_sll amount, int behavior, Scanner *s, int time_part)
{
	const timelib_relunit* relunit;

	if (!(relunit = timelib_lookup_relunit(ptr))) {
		return;
	}

	switch (relunit->unit) {
		case TIMELIB_MICROSEC: add_with_overflow(s, &s->time->relative.us, amount, relunit->multiplier); break;
		case TIMELIB_SECOND:   add_with_overflow(s, &s->time->relative.s, amount, relunit->multiplier); break;
		case TIMELIB_MINUTE:   add_with_overflow(s, &s->time->relative.i, amount, relunit->multiplier); break;
		case TIMELIB_HOUR:     add_with_overflow(s, &s->time->relative.h, amount, relunit->multiplier); break;
		case TIMELIB_DAY:      add_with_overflow(s, &s->time->relative.d, amount, relunit->multiplier); break;
		case TIMELIB_MONTH:    add_with_overflow(s, &s->time->relative.m, amount, relunit->multiplier); break;
		case TIMELIB_YEAR:     add_with_overflow(s, &s->time->relative.y, amount, relunit->multiplier); break;

		case TIMELIB_WEEKDAY:
			TIMELIB_HAVE_WEEKDAY_RELATIVE();
			if (time_part != TIMELIB_TIME_PART_KEEP) {
				TIMELIB_UNHAVE_TIME();
			}
			s->time->relative.d += (amount > 0 ? amount - 1 : amount) * 7;
			s->time->relative.weekday = relunit->multiplier;
			s->time->relative.weekday_behavior = behavior;
			break;

		case TIMELIB_SPECIAL:
			TIMELIB_HAVE_SPECIAL_RELATIVE();
			if (time_part != TIMELIB_TIME_PART_KEEP) {
				TIMELIB_UNHAVE_TIME();
			}
			s->time->relative.special.type = relunit->multiplier;
			s->time->relative.special.amount = amount;
	}
}

static const timelib_tz_lookup_table* abbr_search(const char *word, timelib_long gmtoffset, int isdst)
{
	int first_found = 0;
	const timelib_tz_lookup_table  *tp, *first_found_elem = NULL;
	const timelib_tz_lookup_table  *fmp;

	if (timelib_strcasecmp("utc", word) == 0 || timelib_strcasecmp("gmt", word) == 0) {
		return timelib_timezone_utc;
	}

	for (tp = timelib_timezone_lookup; tp->name; tp++) {
		if (timelib_strcasecmp(word, tp->name) == 0) {
			if (!first_found) {
				first_found = 1;
				first_found_elem = tp;
				if (gmtoffset == -1) {
					return tp;
				}
			}
			if (tp->gmtoffset == gmtoffset) {
				return tp;
			}
		}
	}
	if (first_found) {
		return first_found_elem;
	}

	/* Still didn't find anything, let's find the zone solely based on
	 * offset/isdst then */
	for (fmp = timelib_timezone_fallbackmap; fmp->name; fmp++) {
		if (fmp->gmtoffset == gmtoffset && fmp->type == isdst) {
			return fmp;
		}
	}
	return NULL;
}

static timelib_long timelib_lookup_abbr(const char **ptr, int *dst, char **tz_abbr, int *found)
{
	char *word;
	const char *begin = *ptr, *end;
	timelib_long  value = 0;
	const timelib_tz_lookup_table *tp;

	/* Only include A-Z, a-z, 0-9, /, _, and - in abbreviations/TZ IDs */
	while (
		(**ptr >= 'A' && **ptr <= 'Z') ||
		(**ptr >= 'a' && **ptr <= 'z') ||
		(**ptr >= '0' && **ptr <= '9') ||
		**ptr == '/' || **ptr == '_' || **ptr == '-' || **ptr == '+'
	) {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	if (end - begin < MAX_ABBR_LEN && (tp = abbr_search(word, -1, 0))) {
		value = tp->gmtoffset;
		*dst = tp->type;
		value -= tp->type * 3600;
		*found = 1;
	} else {
		*found = 0;
	}

	*tz_abbr = word;
	return value;
}

#define sHOUR(a) (int)(a * 3600)
#define sMIN(a) (int)(a * 60)

static timelib_long timelib_parse_tz_cor(const char **ptr, int *tz_not_found)
{
	const char *begin = *ptr, *end;
	timelib_long  tmp;

	*tz_not_found = 1;

	while (isdigit(**ptr) || **ptr == ':') {
		++*ptr;
	}
	end = *ptr;
	switch (end - begin) {
		case 1: /* H */
		case 2: /* HH */
			*tz_not_found = 0;
			return sHOUR(strtol(begin, NULL, 10));

		case 3: /* H:M */
		case 4: /* H:MM, HH:M, HHMM */
			if (begin[1] == ':') {
				*tz_not_found = 0;
				tmp = sHOUR(strtol(begin, NULL, 10)) + sMIN(strtol(begin + 2, NULL, 10));
				return tmp;
			} else if (begin[2] == ':') {
				*tz_not_found = 0;
				tmp = sHOUR(strtol(begin, NULL, 10)) + sMIN(strtol(begin + 3, NULL, 10));
				return tmp;
			} else {
				*tz_not_found = 0;
				tmp = strtol(begin, NULL, 10);
				return sHOUR(tmp / 100) + sMIN(tmp % 100);
			}

		case 5: /* HH:MM */
			if (begin[2] != ':') {
				break;
			}

			*tz_not_found = 0;
			tmp = sHOUR(strtol(begin, NULL, 10)) + sMIN(strtol(begin + 3, NULL, 10));
			return tmp;

		case 6: /* HHMMSS */
			*tz_not_found = 0;
			tmp = strtol(begin, NULL, 10);
			tmp = sHOUR(tmp / 10000) + sMIN((tmp / 100) % 100) + (tmp % 100);
			return tmp;

		case 8: /* HH:MM:SS */
			if (begin[2] != ':' || begin[5] != ':') {
				break;
			}

			*tz_not_found = 0;
			tmp = sHOUR(strtol(begin, NULL, 10)) + sMIN(strtol(begin + 3, NULL, 10)) + strtol(begin + 6, NULL, 10);
			return tmp;

	}
	return 0;
}

static timelib_long timelib_parse_tz_minutes(const char **ptr, timelib_time *t)
{
	timelib_long retval = TIMELIB_UNSET;
	const char *begin = *ptr;

	/* First character must be +/- */
	if (**ptr != '+' && **ptr != '-') {
		return retval;
	}

	++*ptr;
	while (isdigit(**ptr)) {
		++*ptr;
	}

	if (*begin == '+') {
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		t->dst = 0;

		retval = sMIN(strtol(begin + 1, NULL, 10));
	} else if (*begin == '-') {
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		t->dst = 0;

		retval = -1 * sMIN(strtol(begin + 1, NULL, 10));
	}
	return retval;
}

timelib_long timelib_parse_zone(const char **ptr, int *dst, timelib_time *t, int *tz_not_found, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_wrapper)
{
	timelib_tzinfo *res;
	timelib_long            retval = 0;

	*tz_not_found = 0;

	while (**ptr == ' ' || **ptr == '\t' || **ptr == '(') {
		++*ptr;
	}
	if ((*ptr)[0] == 'G' && (*ptr)[1] == 'M' && (*ptr)[2] == 'T' && ((*ptr)[3] == '+' || (*ptr)[3] == '-')) {
		*ptr += 3;
	}
	if (**ptr == '+') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		t->dst = 0;

		retval = timelib_parse_tz_cor(ptr, tz_not_found);
	} else if (**ptr == '-') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		t->dst = 0;

		retval = -1 * timelib_parse_tz_cor(ptr, tz_not_found);
	} else {
		int found = 0;
		timelib_long offset = 0;
		char *tz_abbr;

		t->is_localtime = 1;

		/* First, we lookup by abbreviation only */
		offset = timelib_lookup_abbr(ptr, dst, &tz_abbr, &found);
		if (found) {
			t->zone_type = TIMELIB_ZONETYPE_ABBR;
			t->dst = *dst;
			timelib_time_tz_abbr_update(t, tz_abbr);
		}

		/* Otherwise, we look if we have a TimeZone identifier */
		if (!found || strcmp("UTC", tz_abbr) == 0) {
			int dummy_error_code;

			if ((res = tz_wrapper(tz_abbr, tzdb, &dummy_error_code)) != NULL) {
				t->tz_info = res;
				t->zone_type = TIMELIB_ZONETYPE_ID;
				found++;
			}
		}
		timelib_free(tz_abbr);
		*tz_not_found = (found == 0);
		retval = offset;
	}
	while (**ptr == ')') {
		++*ptr;
	}
	return retval;
}

#define timelib_split_free(arg) {       \
	int i;                         \
	for (i = 0; i < arg.c; i++) {  \
		timelib_free(arg.v[i]);    \
	}                              \
	if (arg.v) {                   \
		timelib_free(arg.v);       \
	}                              \
}

static int scan(Scanner *s, timelib_tz_get_wrapper tz_get_wrapper)
{
	uchar *cursor = s->cur;
	char *str;
	const char *ptr = NULL;

std:
	s->tok = cursor;
	s->len = 0;
#line 1151 "ext/date/lib/parse_date.re"



#line 1026 "<stdout>"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,  50,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		 50,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   4,  32,  20,  48,   0, 
		  8,   8,   8,   8,   8,   8,   8,   8, 
		  8,   8,   0,   0,   0,   0,   0,   0, 
		  0,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,   0,   0,   0,   0,   0, 
		  0, 192, 192, 192, 224, 192, 192, 192, 
		224, 192, 192, 192, 192, 192, 224, 192, 
		192, 192, 224, 224, 224, 192, 192, 192, 
		192, 192, 192,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
	};
	YYDEBUG(0, *YYCURSOR);
	if ((YYLIMIT - YYCURSOR) < 36) YYFILL(36);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 2) {
		goto yy6;
	}
	if (yych <= 'R') {
		if (yych <= '?') {
			if (yych <= ',') {
				if (yych <= '\'') {
					if (yych <= 0x00) goto yy2;
					if (yych <= 0x08) goto yy4;
					if (yych >= '\v') goto yy4;
				} else {
					if (yych <= '(') goto yy9;
					if (yych <= '*') goto yy4;
					if (yych <= '+') goto yy10;
					goto yy11;
				}
			} else {
				if (yych <= '0') {
					if (yych <= '-') goto yy10;
					if (yych <= '.') goto yy11;
					if (yych <= '/') goto yy4;
					goto yy13;
				} else {
					if (yych <= '2') {
						if (yych <= '1') goto yy14;
						goto yy15;
					} else {
						if (yych <= '3') goto yy16;
						if (yych <= '9') goto yy17;
						goto yy4;
					}
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'C') {
					if (yych <= '@') goto yy18;
					if (yych <= 'A') goto yy19;
					if (yych <= 'B') goto yy21;
					goto yy22;
				} else {
					if (yych <= 'E') {
						if (yych <= 'D') goto yy23;
						goto yy24;
					} else {
						if (yych <= 'F') goto yy25;
						if (yych <= 'G') goto yy26;
						goto yy22;
					}
				}
			} else {
				if (yych <= 'L') {
					if (yych <= 'I') goto yy27;
					if (yych <= 'J') goto yy28;
					if (yych <= 'K') goto yy22;
					goto yy29;
				} else {
					if (yych <= 'N') {
						if (yych <= 'M') goto yy30;
						goto yy31;
					} else {
						if (yych <= 'O') goto yy32;
						if (yych <= 'P') goto yy33;
						goto yy22;
					}
				}
			}
		}
	} else {
		if (yych <= 'k') {
			if (yych <= '`') {
				if (yych <= 'V') {
					if (yych <= 'S') goto yy34;
					if (yych <= 'T') goto yy35;
					if (yych <= 'U') goto yy22;
					goto yy36;
				} else {
					if (yych <= 'X') {
						if (yych <= 'W') goto yy37;
						goto yy38;
					} else {
						if (yych <= 'Y') goto yy39;
						if (yych <= 'Z') goto yy22;
						goto yy4;
					}
				}
			} else {
				if (yych <= 'd') {
					if (yych <= 'a') goto yy40;
					if (yych <= 'b') goto yy41;
					if (yych <= 'c') goto yy42;
					goto yy43;
				} else {
					if (yych <= 'f') {
						if (yych <= 'e') goto yy44;
						goto yy45;
					} else {
						if (yych == 'j') goto yy46;
						goto yy42;
					}
				}
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 'o') {
					if (yych <= 'l') goto yy47;
					if (yych <= 'm') goto yy48;
					if (yych <= 'n') goto yy49;
					goto yy50;
				} else {
					if (yych <= 'r') {
						if (yych <= 'p') goto yy51;
						goto yy42;
					} else {
						if (yych <= 's') goto yy52;
						if (yych <= 't') goto yy53;
						goto yy42;
					}
				}
			} else {
				if (yych <= 'z') {
					if (yych <= 'w') goto yy54;
					if (yych == 'y') goto yy55;
					goto yy42;
				} else {
					if (yych <= 0xC2) {
						if (yych <= 0xC1) goto yy4;
						goto yy56;
					} else {
						if (yych == 0xE2) goto yy57;
						goto yy4;
					}
				}
			}
		}
	}
yy2:
	YYDEBUG(2, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(3, *YYCURSOR);
#line 1984 "ext/date/lib/parse_date.re"
	{
		s->pos = cursor; s->line++;
		goto std;
	}
#line 1212 "<stdout>"
yy4:
	YYDEBUG(4, *YYCURSOR);
	++YYCURSOR;
yy5:
	YYDEBUG(5, *YYCURSOR);
#line 1990 "ext/date/lib/parse_date.re"
	{
		add_error(s, TIMELIB_ERR_UNEXPECTED_CHARACTER, "Unexpected character");
		goto std;
	}
#line 1223 "<stdout>"
yy6:
	YYDEBUG(6, *YYCURSOR);
	yyaccept = 0;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 25) YYFILL(25);
	yych = *YYCURSOR;
	YYDEBUG(7, *YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy6;
	}
	if (yych <= '/') goto yy8;
	if (yych <= '9') goto yy58;
yy8:
	YYDEBUG(8, *YYCURSOR);
#line 1979 "ext/date/lib/parse_date.re"
	{
		goto std;
	}
#line 1242 "<stdout>"
yy9:
	YYDEBUG(9, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy5;
	if (yych <= 'Z') goto yy42;
	if (yych <= '`') goto yy5;
	if (yych <= 'z') goto yy42;
	goto yy5;
yy10:
	YYDEBUG(10, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy62;
	}
	if (yych <= ' ') {
		if (yych == '\t') goto yy60;
		if (yych <= 0x1F) goto yy5;
		goto yy60;
	} else {
		if (yych <= '1') {
			if (yych <= '/') goto yy5;
			goto yy64;
		} else {
			if (yych <= '2') goto yy65;
			if (yych <= '9') goto yy66;
			goto yy5;
		}
	}
yy11:
	YYDEBUG(11, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(12, *YYCURSOR);
#line 1974 "ext/date/lib/parse_date.re"
	{
		goto std;
	}
#line 1280 "<stdout>"
yy13:
	YYDEBUG(13, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'a') {
		if (yych <= '@') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy67;
					goto yy5;
				} else {
					if (yych <= ' ') goto yy69;
					if (yych <= ',') goto yy5;
					goto yy70;
				}
			} else {
				if (yych <= '0') {
					if (yych <= '.') goto yy71;
					if (yych <= '/') goto yy72;
					goto yy73;
				} else {
					if (yych <= '9') goto yy74;
					if (yych <= ':') goto yy75;
					goto yy5;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'A') goto yy69;
					if (yych <= 'C') goto yy5;
					goto yy69;
				} else {
					if (yych == 'F') goto yy69;
					goto yy5;
				}
			} else {
				if (yych <= 'O') {
					if (yych <= 'J') goto yy69;
					if (yych <= 'L') goto yy5;
					goto yy69;
				} else {
					if (yych <= 'R') goto yy5;
					if (yych <= 'Y') goto yy69;
					if (yych <= '`') goto yy5;
					goto yy69;
				}
			}
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'h') {
				if (yych <= 'e') {
					if (yych == 'd') goto yy69;
					goto yy5;
				} else {
					if (yych == 'g') goto yy5;
					goto yy69;
				}
			} else {
				if (yych <= 'l') {
					if (yych == 'j') goto yy69;
					goto yy5;
				} else {
					if (yych == 'n') goto yy93;
					if (yych <= 'o') goto yy69;
					goto yy5;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 'r') goto yy94;
					if (yych <= 's') goto yy95;
					goto yy96;
				} else {
					if (yych == 'v') goto yy5;
					goto yy69;
				}
			} else {
				if (yych <= 0xC1) {
					if (yych == 'y') goto yy69;
					goto yy5;
				} else {
					if (yych <= 0xC2) goto yy97;
					if (yych == 0xE2) goto yy98;
					goto yy5;
				}
			}
		}
	}
yy14:
	YYDEBUG(14, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'a') {
		if (yych <= '@') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy99;
					goto yy5;
				} else {
					if (yych <= ' ') goto yy101;
					if (yych <= ',') goto yy5;
					goto yy70;
				}
			} else {
				if (yych <= '2') {
					if (yych <= '.') goto yy102;
					if (yych <= '/') goto yy72;
					goto yy74;
				} else {
					if (yych <= '9') goto yy103;
					if (yych <= ':') goto yy104;
					goto yy5;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'A') goto yy101;
					if (yych <= 'C') goto yy5;
					goto yy101;
				} else {
					if (yych == 'F') goto yy101;
					goto yy5;
				}
			} else {
				if (yych <= 'P') {
					if (yych <= 'J') goto yy101;
					if (yych <= 'L') goto yy5;
					goto yy101;
				} else {
					if (yych <= 'R') goto yy5;
					if (yych <= 'Y') goto yy101;
					if (yych <= '`') goto yy5;
					goto yy101;
				}
			}
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'h') {
				if (yych <= 'e') {
					if (yych == 'd') goto yy101;
					goto yy5;
				} else {
					if (yych == 'g') goto yy5;
					goto yy101;
				}
			} else {
				if (yych <= 'l') {
					if (yych == 'j') goto yy101;
					goto yy5;
				} else {
					if (yych == 'n') goto yy93;
					if (yych <= 'p') goto yy101;
					goto yy5;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 'r') goto yy94;
					if (yych <= 's') goto yy95;
					goto yy96;
				} else {
					if (yych == 'v') goto yy5;
					goto yy101;
				}
			} else {
				if (yych <= 0xC1) {
					if (yych == 'y') goto yy101;
					goto yy5;
				} else {
					if (yych <= 0xC2) goto yy107;
					if (yych == 0xE2) goto yy108;
					goto yy5;
				}
			}
		}
	}
yy15:
	YYDEBUG(15, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'a') {
		if (yych <= '@') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy99;
					goto yy5;
				} else {
					if (yych <= ' ') goto yy101;
					if (yych <= ',') goto yy5;
					goto yy70;
				}
			} else {
				if (yych <= '4') {
					if (yych <= '.') goto yy102;
					if (yych <= '/') goto yy72;
					goto yy103;
				} else {
					if (yych <= '9') goto yy109;
					if (yych <= ':') goto yy104;
					goto yy5;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'A') goto yy101;
					if (yych <= 'C') goto yy5;
					goto yy101;
				} else {
					if (yych == 'F') goto yy101;
					goto yy5;
				}
			} else {
				if (yych <= 'P') {
					if (yych <= 'J') goto yy101;
					if (yych <= 'L') goto yy5;
					goto yy101;
				} else {
					if (yych <= 'R') goto yy5;
					if (yych <= 'Y') goto yy101;
					if (yych <= '`') goto yy5;
					goto yy101;
				}
			}
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'h') {
				if (yych <= 'e') {
					if (yych == 'd') goto yy101;
					goto yy5;
				} else {
					if (yych == 'g') goto yy5;
					goto yy101;
				}
			} else {
				if (yych <= 'l') {
					if (yych == 'j') goto yy101;
					goto yy5;
				} else {
					if (yych == 'n') goto yy93;
					if (yych <= 'p') goto yy101;
					goto yy5;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 'r') goto yy94;
					if (yych <= 's') goto yy95;
					goto yy96;
				} else {
					if (yych == 'v') goto yy5;
					goto yy101;
				}
			} else {
				if (yych <= 0xC1) {
					if (yych == 'y') goto yy101;
					goto yy5;
				} else {
					if (yych <= 0xC2) goto yy107;
					if (yych == 0xE2) goto yy108;
					goto yy5;
				}
			}
		}
	}
yy16:
	YYDEBUG(16, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'a') {
		if (yych <= '@') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy99;
					goto yy5;
				} else {
					if (yych <= ' ') goto yy101;
					if (yych <= ',') goto yy5;
					goto yy70;
				}
			} else {
				if (yych <= '1') {
					if (yych <= '.') goto yy102;
					if (yych <= '/') goto yy72;
					goto yy109;
				} else {
					if (yych <= '9') goto yy110;
					if (yych <= ':') goto yy104;
					goto yy5;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'A') goto yy101;
					if (yych <= 'C') goto yy5;
					goto yy101;
				} else {
					if (yych == 'F') goto yy101;
					goto yy5;
				}
			} else {
				if (yych <= 'P') {
					if (yych <= 'J') goto yy101;
					if (yych <= 'L') goto yy5;
					goto yy101;
				} else {
					if (yych <= 'R') goto yy5;
					if (yych <= 'Y') goto yy101;
					if (yych <= '`') goto yy5;
					goto yy101;
				}
			}
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'h') {
				if (yych <= 'e') {
					if (yych == 'd') goto yy101;
					goto yy5;
				} else {
					if (yych == 'g') goto yy5;
					goto yy101;
				}
			} else {
				if (yych <= 'l') {
					if (yych == 'j') goto yy101;
					goto yy5;
				} else {
					if (yych == 'n') goto yy93;
					if (yych <= 'p') goto yy101;
					goto yy5;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 'r') goto yy94;
					if (yych <= 's') goto yy95;
					goto yy96;
				} else {
					if (yych == 'v') goto yy5;
					goto yy101;
				}
			} else {
				if (yych <= 0xC1) {
					if (yych == 'y') goto yy101;
					goto yy5;
				} else {
					if (yych <= 0xC2) goto yy107;
					if (yych == 0xE2) goto yy108;
					goto yy5;
				}
			}
		}
	}
yy17:
	YYDEBUG(17, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'c') {
		if (yych <= 'A') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy99;
					goto yy5;
				} else {
					if (yych <= ' ') goto yy101;
					if (yych <= ',') goto yy5;
					goto yy70;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '.') goto yy102;
					if (yych <= '/') goto yy72;
					goto yy110;
				} else {
					if (yych <= ':') goto yy104;
					if (yych <= '@') goto yy5;
					goto yy101;
				}
			}
		} else {
			if (yych <= 'J') {
				if (yych <= 'E') {
					if (yych == 'D') goto yy101;
					goto yy5;
				} else {
					if (yych == 'G') goto yy5;
					goto yy101;
				}
			} else {
				if (yych <= 'R') {
					if (yych <= 'L') goto yy5;
					if (yych <= 'P') goto yy101;
					goto yy5;
				} else {
					if (yych <= 'Y') goto yy101;
					if (yych == 'a') goto yy101;
					goto yy5;
				}
			}
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'i') {
				if (yych <= 'f') {
					if (yych == 'e') goto yy5;
					goto yy101;
				} else {
					if (yych == 'h') goto yy101;
					goto yy5;
				}
			} else {
				if (yych <= 'm') {
					if (yych <= 'j') goto yy101;
					if (yych <= 'l') goto yy5;
					goto yy101;
				} else {
					if (yych <= 'n') goto yy93;
					if (yych <= 'p') goto yy101;
					goto yy5;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 'r') goto yy94;
					if (yych <= 's') goto yy95;
					goto yy96;
				} else {
					if (yych == 'v') goto yy5;
					goto yy101;
				}
			} else {
				if (yych <= 0xC1) {
					if (yych == 'y') goto yy101;
					goto yy5;
				} else {
					if (yych <= 0xC2) goto yy107;
					if (yych == 0xE2) goto yy108;
					goto yy5;
				}
			}
		}
	}
yy18:
	YYDEBUG(18, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy112;
	}
	if (yych == '-') goto yy111;
	goto yy5;
yy19:
	YYDEBUG(19, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy115;
			if (yych >= 'A') goto yy116;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy117;
				goto yy116;
			} else {
				if (yych <= 'P') goto yy118;
				if (yych <= 'T') goto yy116;
				goto yy119;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy116;
			} else {
				if (yych == 'g') goto yy121;
				goto yy120;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy122;
				goto yy120;
			} else {
				if (yych <= 'u') goto yy123;
				if (yych <= 'z') goto yy120;
			}
		}
	}
yy20:
	YYDEBUG(20, *YYCURSOR);
#line 1889 "ext/date/lib/parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("tzcorrection | tz");
		TIMELIB_INIT;
		TIMELIB_HAVE_TZ();
		timelib_eat_spaces(&ptr);
		s->time->z = timelib_parse_zone(&ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
		if (tz_not_found) {
			add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIMEZONE;
	}
#line 1795 "<stdout>"
yy21:
	YYDEBUG(21, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy115;
		if (yych <= '@') goto yy20;
		goto yy124;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy116;
			goto yy20;
		} else {
			if (yych <= 'a') goto yy125;
			if (yych <= 'z') goto yy120;
			goto yy20;
		}
	}
yy22:
	YYDEBUG(22, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy115;
		goto yy20;
	} else {
		if (yych <= 'Z') goto yy116;
		if (yych <= '`') goto yy20;
		if (yych <= 'z') goto yy120;
		goto yy20;
	}
yy23:
	YYDEBUG(23, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'D') goto yy116;
			goto yy126;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy116;
			if (yych <= '`') goto yy20;
			goto yy120;
		} else {
			if (yych <= 'e') goto yy127;
			if (yych <= 'z') goto yy120;
			goto yy20;
		}
	}
yy24:
	YYDEBUG(24, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy115;
			goto yy20;
		} else {
			if (yych == 'I') goto yy128;
			if (yych <= 'K') goto yy116;
			goto yy129;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy116;
			if (yych <= '`') goto yy20;
			if (yych <= 'h') goto yy120;
			goto yy130;
		} else {
			if (yych == 'l') goto yy131;
			if (yych <= 'z') goto yy120;
			goto yy20;
		}
	}
yy25:
	YYDEBUG(25, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy20;
				goto yy115;
			} else {
				if (yych <= '@') goto yy20;
				if (yych <= 'D') goto yy116;
				goto yy132;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy133;
				goto yy116;
			} else {
				if (yych <= 'O') goto yy134;
				if (yych <= 'Q') goto yy116;
				goto yy135;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy116;
				if (yych <= '`') goto yy20;
				goto yy120;
			} else {
				if (yych <= 'e') goto yy136;
				if (yych <= 'h') goto yy120;
				goto yy137;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy138;
				goto yy120;
			} else {
				if (yych <= 'r') goto yy139;
				if (yych <= 'z') goto yy120;
				goto yy20;
			}
		}
	}
yy26:
	YYDEBUG(26, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == ')') goto yy115;
		if (yych <= '@') goto yy20;
		goto yy116;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'M') goto yy140;
			goto yy116;
		} else {
			if (yych <= '`') goto yy20;
			if (yych <= 'z') goto yy120;
			goto yy20;
		}
	}
yy27:
	YYDEBUG(27, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy20;
				goto yy142;
			} else {
				if (yych == ' ') goto yy142;
				goto yy20;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy115;
				goto yy20;
			} else {
				if (yych == '/') goto yy20;
				goto yy142;
			}
		}
	} else {
		if (yych <= 'V') {
			if (yych <= 'H') {
				if (yych <= '@') goto yy20;
				goto yy116;
			} else {
				if (yych <= 'I') goto yy146;
				if (yych <= 'U') goto yy116;
				goto yy147;
			}
		} else {
			if (yych <= 'Z') {
				if (yych == 'X') goto yy147;
				goto yy116;
			} else {
				if (yych <= '`') goto yy20;
				if (yych <= 'z') goto yy120;
				goto yy20;
			}
		}
	}
yy28:
	YYDEBUG(28, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy115;
			goto yy20;
		} else {
			if (yych <= 'A') goto yy148;
			if (yych <= 'T') goto yy116;
			goto yy149;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy116;
			if (yych <= '`') goto yy20;
			goto yy150;
		} else {
			if (yych == 'u') goto yy151;
			if (yych <= 'z') goto yy120;
			goto yy20;
		}
	}
yy29:
	YYDEBUG(29, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy115;
		if (yych <= '@') goto yy20;
		goto yy152;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy116;
			goto yy20;
		} else {
			if (yych <= 'a') goto yy153;
			if (yych <= 'z') goto yy120;
			goto yy20;
		}
	}
yy30:
	YYDEBUG(30, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy115;
			if (yych <= '@') goto yy20;
			goto yy154;
		} else {
			if (yych == 'I') goto yy155;
			if (yych <= 'N') goto yy116;
			goto yy156;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy116;
			if (yych <= '`') goto yy20;
			if (yych <= 'a') goto yy157;
			goto yy120;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy158;
				goto yy120;
			} else {
				if (yych <= 'o') goto yy159;
				if (yych <= 'z') goto yy120;
				goto yy20;
			}
		}
	}
yy31:
	YYDEBUG(31, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy115;
			if (yych <= '@') goto yy20;
			goto yy116;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy160;
				goto yy116;
			} else {
				if (yych <= 'I') goto yy161;
				if (yych <= 'N') goto yy116;
				goto yy162;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy116;
				goto yy20;
			} else {
				if (yych == 'e') goto yy163;
				goto yy120;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy164;
				goto yy120;
			} else {
				if (yych <= 'o') goto yy165;
				if (yych <= 'z') goto yy120;
				goto yy20;
			}
		}
	}
yy32:
	YYDEBUG(32, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'B') goto yy116;
			goto yy166;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy116;
			if (yych <= '`') goto yy20;
			goto yy120;
		} else {
			if (yych <= 'c') goto yy167;
			if (yych <= 'z') goto yy120;
			goto yy20;
		}
	}
yy33:
	YYDEBUG(33, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'Q') goto yy116;
			goto yy168;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy116;
			if (yych <= '`') goto yy20;
			goto yy120;
		} else {
			if (yych <= 'r') goto yy169;
			if (yych <= 'z') goto yy120;
			goto yy20;
		}
	}
yy34:
	YYDEBUG(34, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy20;
				goto yy115;
			} else {
				if (yych <= '@') goto yy20;
				if (yych <= 'A') goto yy170;
				goto yy116;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy171;
				goto yy116;
			} else {
				if (yych <= 'I') goto yy172;
				if (yych <= 'T') goto yy116;
				goto yy156;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy116;
				goto yy20;
			} else {
				if (yych <= 'a') goto yy173;
				if (yych <= 'd') goto yy120;
				goto yy174;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy175;
				goto yy120;
			} else {
				if (yych <= 'u') goto yy159;
				if (yych <= 'z') goto yy120;
				goto yy20;
			}
		}
	}
yy35:
	YYDEBUG(35, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy115;
	case '0':
	case '1':	goto yy176;
	case '2':	goto yy178;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy179;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'Z':	goto yy116;
	case 'E':	goto yy161;
	case 'H':	goto yy180;
	case 'O':	goto yy181;
	case 'U':	goto yy182;
	case 'W':	goto yy183;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'x':
	case 'y':
	case 'z':	goto yy120;
	case 'e':	goto yy164;
	case 'h':	goto yy184;
	case 'o':	goto yy185;
	case 'u':	goto yy186;
	case 'w':	goto yy187;
	default:	goto yy20;
	}
yy36:
	YYDEBUG(36, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy142;
			if (yych <= 0x1F) goto yy20;
			goto yy142;
		} else {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy142;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy20;
			if (yych <= '9') goto yy142;
			if (yych <= '@') goto yy20;
			goto yy116;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy188;
				goto yy116;
			} else {
				if (yych <= '`') goto yy20;
				if (yych <= 'z') goto yy120;
				goto yy20;
			}
		}
	}
yy37:
	YYDEBUG(37, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'D') goto yy116;
			goto yy189;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy116;
			if (yych <= '`') goto yy20;
			goto yy120;
		} else {
			if (yych <= 'e') goto yy190;
			if (yych <= 'z') goto yy120;
			goto yy20;
		}
	}
yy38:
	YYDEBUG(38, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy142;
			if (yych <= 0x1F) goto yy20;
			goto yy142;
		} else {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy142;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy20;
			if (yych <= '9') goto yy142;
			if (yych <= '@') goto yy20;
			goto yy116;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy146;
				goto yy116;
			} else {
				if (yych <= '`') goto yy20;
				if (yych <= 'z') goto yy120;
				goto yy20;
			}
		}
	}
yy39:
	YYDEBUG(39, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'D') goto yy116;
			goto yy191;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy116;
			if (yych <= '`') goto yy20;
			goto yy120;
		} else {
			if (yych <= 'e') goto yy192;
			if (yych <= 'z') goto yy120;
			goto yy20;
		}
	}
yy40:
	YYDEBUG(40, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy115;
			if (yych <= '@') goto yy20;
			goto yy116;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy117;
				goto yy116;
			} else {
				if (yych <= 'P') goto yy118;
				if (yych <= 'T') goto yy116;
				goto yy119;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy116;
				goto yy20;
			} else {
				if (yych == 'g') goto yy117;
				goto yy116;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy118;
				goto yy116;
			} else {
				if (yych <= 'u') goto yy119;
				if (yych <= 'z') goto yy116;
				goto yy20;
			}
		}
	}
yy41:
	YYDEBUG(41, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy115;
		if (yych <= '@') goto yy20;
		goto yy124;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy116;
			goto yy20;
		} else {
			if (yych <= 'a') goto yy124;
			if (yych <= 'z') goto yy116;
			goto yy20;
		}
	}
yy42:
	YYDEBUG(42, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy115;
		goto yy20;
	} else {
		if (yych <= 'Z') goto yy116;
		if (yych <= '`') goto yy20;
		if (yych <= 'z') goto yy116;
		goto yy20;
	}
yy43:
	YYDEBUG(43, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'D') goto yy116;
			goto yy126;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy116;
			if (yych <= '`') goto yy20;
			goto yy116;
		} else {
			if (yych <= 'e') goto yy126;
			if (yych <= 'z') goto yy116;
			goto yy20;
		}
	}
yy44:
	YYDEBUG(44, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy115;
			goto yy20;
		} else {
			if (yych == 'I') goto yy128;
			if (yych <= 'K') goto yy116;
			goto yy129;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy116;
			if (yych <= '`') goto yy20;
			if (yych <= 'h') goto yy116;
			goto yy128;
		} else {
			if (yych == 'l') goto yy129;
			if (yych <= 'z') goto yy116;
			goto yy20;
		}
	}
yy45:
	YYDEBUG(45, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy20;
				goto yy115;
			} else {
				if (yych <= '@') goto yy20;
				if (yych <= 'D') goto yy116;
				goto yy132;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy133;
				goto yy116;
			} else {
				if (yych <= 'O') goto yy134;
				if (yych <= 'Q') goto yy116;
				goto yy135;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy116;
				if (yych <= '`') goto yy20;
				goto yy116;
			} else {
				if (yych <= 'e') goto yy132;
				if (yych <= 'h') goto yy116;
				goto yy133;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy134;
				goto yy116;
			} else {
				if (yych <= 'r') goto yy135;
				if (yych <= 'z') goto yy116;
				goto yy20;
			}
		}
	}
yy46:
	YYDEBUG(46, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy115;
			goto yy20;
		} else {
			if (yych <= 'A') goto yy148;
			if (yych <= 'T') goto yy116;
			goto yy149;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy116;
			if (yych <= '`') goto yy20;
			goto yy148;
		} else {
			if (yych == 'u') goto yy149;
			if (yych <= 'z') goto yy116;
			goto yy20;
		}
	}
yy47:
	YYDEBUG(47, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy115;
		if (yych <= '@') goto yy20;
		goto yy152;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy116;
			goto yy20;
		} else {
			if (yych <= 'a') goto yy152;
			if (yych <= 'z') goto yy116;
			goto yy20;
		}
	}
yy48:
	YYDEBUG(48, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy115;
			if (yych <= '@') goto yy20;
			goto yy154;
		} else {
			if (yych == 'I') goto yy155;
			if (yych <= 'N') goto yy116;
			goto yy156;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy116;
			if (yych <= '`') goto yy20;
			if (yych <= 'a') goto yy154;
			goto yy116;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy155;
				goto yy116;
			} else {
				if (yych <= 'o') goto yy156;
				if (yych <= 'z') goto yy116;
				goto yy20;
			}
		}
	}
yy49:
	YYDEBUG(49, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy115;
			if (yych <= '@') goto yy20;
			goto yy116;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy160;
				goto yy116;
			} else {
				if (yych <= 'I') goto yy161;
				if (yych <= 'N') goto yy116;
				goto yy162;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy116;
				goto yy20;
			} else {
				if (yych == 'e') goto yy160;
				goto yy116;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy161;
				goto yy116;
			} else {
				if (yych <= 'o') goto yy162;
				if (yych <= 'z') goto yy116;
				goto yy20;
			}
		}
	}
yy50:
	YYDEBUG(50, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'B') goto yy116;
			goto yy166;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy116;
			if (yych <= '`') goto yy20;
			goto yy116;
		} else {
			if (yych <= 'c') goto yy166;
			if (yych <= 'z') goto yy116;
			goto yy20;
		}
	}
yy51:
	YYDEBUG(51, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'Q') goto yy116;
			goto yy168;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy116;
			if (yych <= '`') goto yy20;
			goto yy116;
		} else {
			if (yych <= 'r') goto yy168;
			if (yych <= 'z') goto yy116;
			goto yy20;
		}
	}
yy52:
	YYDEBUG(52, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy20;
				goto yy115;
			} else {
				if (yych <= '@') goto yy20;
				if (yych <= 'A') goto yy170;
				goto yy116;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy171;
				goto yy116;
			} else {
				if (yych <= 'I') goto yy172;
				if (yych <= 'T') goto yy116;
				goto yy156;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy116;
				goto yy20;
			} else {
				if (yych <= 'a') goto yy170;
				if (yych <= 'd') goto yy116;
				goto yy171;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy172;
				goto yy116;
			} else {
				if (yych <= 'u') goto yy156;
				if (yych <= 'z') goto yy116;
				goto yy20;
			}
		}
	}
yy53:
	YYDEBUG(53, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy115;
	case '0':
	case '1':	goto yy176;
	case '2':	goto yy178;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy179;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'x':
	case 'y':
	case 'z':	goto yy116;
	case 'E':
	case 'e':	goto yy161;
	case 'H':
	case 'h':	goto yy180;
	case 'O':
	case 'o':	goto yy181;
	case 'U':
	case 'u':	goto yy182;
	case 'W':
	case 'w':	goto yy183;
	default:	goto yy20;
	}
yy54:
	YYDEBUG(54, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'D') goto yy116;
			goto yy189;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy116;
			if (yych <= '`') goto yy20;
			goto yy116;
		} else {
			if (yych <= 'e') goto yy189;
			if (yych <= 'z') goto yy116;
			goto yy20;
		}
	}
yy55:
	YYDEBUG(55, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'D') goto yy116;
			goto yy191;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy116;
			if (yych <= '`') goto yy20;
			goto yy116;
		} else {
			if (yych <= 'e') goto yy191;
			if (yych <= 'z') goto yy116;
			goto yy20;
		}
	}
yy56:
	YYDEBUG(56, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 0xA0) goto yy193;
	goto yy5;
yy57:
	YYDEBUG(57, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 0x80) goto yy194;
	goto yy5;
yy58:
	YYDEBUG(58, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy196;
		if (yych <= '9') goto yy197;
		goto yy196;
	} else {
		if (yych <= 0xC2) goto yy97;
		if (yych == 0xE2) goto yy98;
		goto yy196;
	}
yy59:
	YYDEBUG(59, *YYCURSOR);
	YYCURSOR = YYMARKER;
	if (yyaccept <= 16) {
		if (yyaccept <= 8) {
			if (yyaccept <= 4) {
				if (yyaccept <= 2) {
					if (yyaccept <= 1) {
						if (yyaccept == 0) {
							goto yy8;
						} else {
							goto yy5;
						}
					} else {
						goto yy20;
					}
				} else {
					if (yyaccept == 3) {
						goto yy81;
					} else {
						goto yy177;
					}
				}
			} else {
				if (yyaccept <= 6) {
					if (yyaccept == 5) {
						goto yy224;
					} else {
						goto yy260;
					}
				} else {
					if (yyaccept == 7) {
						goto yy295;
					} else {
						goto yy293;
					}
				}
			}
		} else {
			if (yyaccept <= 12) {
				if (yyaccept <= 10) {
					if (yyaccept == 9) {
						goto yy315;
					} else {
						goto yy325;
					}
				} else {
					if (yyaccept == 11) {
						goto yy351;
					} else {
						goto yy420;
					}
				}
			} else {
				if (yyaccept <= 14) {
					if (yyaccept == 13) {
						goto yy422;
					} else {
						goto yy526;
					}
				} else {
					if (yyaccept == 15) {
						goto yy567;
					} else {
						goto yy722;
					}
				}
			}
		}
	} else {
		if (yyaccept <= 25) {
			if (yyaccept <= 21) {
				if (yyaccept <= 19) {
					if (yyaccept <= 18) {
						if (yyaccept == 17) {
							goto yy739;
						} else {
							goto yy752;
						}
					} else {
						goto yy777;
					}
				} else {
					if (yyaccept == 20) {
						goto yy849;
					} else {
						goto yy926;
					}
				}
			} else {
				if (yyaccept <= 23) {
					if (yyaccept == 22) {
						goto yy600;
					} else {
						goto yy942;
					}
				} else {
					if (yyaccept == 24) {
						goto yy982;
					} else {
						goto yy1025;
					}
				}
			}
		} else {
			if (yyaccept <= 29) {
				if (yyaccept <= 27) {
					if (yyaccept == 26) {
						goto yy1043;
					} else {
						goto yy1048;
					}
				} else {
					if (yyaccept == 28) {
						goto yy1107;
					} else {
						goto yy1145;
					}
				}
			} else {
				if (yyaccept <= 31) {
					if (yyaccept == 30) {
						goto yy1172;
					} else {
						goto yy1175;
					}
				} else {
					if (yyaccept == 32) {
						goto yy1329;
					} else {
						goto yy1375;
					}
				}
			}
		}
	}
yy60:
	YYDEBUG(60, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 25) YYFILL(25);
	yych = *YYCURSOR;
	YYDEBUG(61, *YYCURSOR);
	if (yych <= 0x1F) {
		if (yych == '\t') goto yy60;
		goto yy59;
	} else {
		if (yych <= ' ') goto yy60;
		if (yych <= '/') goto yy59;
		if (yych <= '9') goto yy58;
		goto yy59;
	}
yy62:
	YYDEBUG(62, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 25) YYFILL(25);
	yych = *YYCURSOR;
	YYDEBUG(63, *YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy62;
	}
	if (yych <= 0x1F) {
		if (yych == '\t') goto yy60;
		goto yy59;
	} else {
		if (yych <= ' ') goto yy60;
		if (yych <= '/') goto yy59;
		if (yych <= '9') goto yy58;
		goto yy59;
	}
yy64:
	YYDEBUG(64, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'E') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy20;
					goto yy196;
				} else {
					if (yych == ' ') goto yy196;
					goto yy20;
				}
			} else {
				if (yych <= ':') {
					if (yych <= '9') goto yy202;
					goto yy203;
				} else {
					if (yych == 'D') goto yy196;
					goto yy20;
				}
			}
		} else {
			if (yych <= 'M') {
				if (yych <= 'G') {
					if (yych <= 'F') goto yy196;
					goto yy20;
				} else {
					if (yych <= 'H') goto yy196;
					if (yych <= 'L') goto yy20;
					goto yy196;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'R') goto yy20;
					goto yy196;
				} else {
					if (yych == 'W') goto yy196;
					goto yy20;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy196;
					goto yy20;
				} else {
					if (yych == 'e') goto yy20;
					goto yy196;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy20;
					goto yy196;
				} else {
					if (yych == 'm') goto yy196;
					goto yy20;
				}
			}
		} else {
			if (yych <= 'y') {
				if (yych <= 'v') {
					if (yych <= 'u') goto yy196;
					goto yy20;
				} else {
					if (yych == 'x') goto yy20;
					goto yy196;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 0xC1) goto yy20;
					goto yy97;
				} else {
					if (yych == 0xE2) goto yy98;
					goto yy20;
				}
			}
		}
	}
yy65:
	YYDEBUG(65, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'C') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy20;
					goto yy196;
				} else {
					if (yych == ' ') goto yy196;
					goto yy20;
				}
			} else {
				if (yych <= '5') {
					if (yych <= '4') goto yy202;
					goto yy204;
				} else {
					if (yych <= '9') goto yy205;
					if (yych <= ':') goto yy203;
					goto yy20;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy196;
					goto yy20;
				} else {
					if (yych == 'G') goto yy20;
					goto yy196;
				}
			} else {
				if (yych <= 'R') {
					if (yych == 'M') goto yy196;
					goto yy20;
				} else {
					if (yych == 'V') goto yy20;
					goto yy196;
				}
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'e') {
				if (yych <= 'Y') {
					if (yych <= 'X') goto yy20;
					goto yy196;
				} else {
					if (yych == 'd') goto yy196;
					goto yy20;
				}
			} else {
				if (yych <= 'g') {
					if (yych <= 'f') goto yy196;
					goto yy20;
				} else {
					if (yych <= 'h') goto yy196;
					if (yych <= 'l') goto yy20;
					goto yy196;
				}
			}
		} else {
			if (yych <= 'x') {
				if (yych <= 'u') {
					if (yych <= 'r') goto yy20;
					goto yy196;
				} else {
					if (yych == 'w') goto yy196;
					goto yy20;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 'y') goto yy196;
					if (yych <= 0xC1) goto yy20;
					goto yy97;
				} else {
					if (yych == 0xE2) goto yy98;
					goto yy20;
				}
			}
		}
	}
yy66:
	YYDEBUG(66, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'D') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy20;
					goto yy196;
				} else {
					if (yych == ' ') goto yy196;
					goto yy20;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '5') goto yy204;
					goto yy205;
				} else {
					if (yych <= ':') goto yy203;
					if (yych <= 'C') goto yy20;
					goto yy196;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych <= 'F') {
					if (yych <= 'E') goto yy20;
					goto yy196;
				} else {
					if (yych == 'H') goto yy196;
					goto yy20;
				}
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy196;
					goto yy20;
				} else {
					if (yych == 'V') goto yy20;
					goto yy196;
				}
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'e') {
				if (yych <= 'Y') {
					if (yych <= 'X') goto yy20;
					goto yy196;
				} else {
					if (yych == 'd') goto yy196;
					goto yy20;
				}
			} else {
				if (yych <= 'g') {
					if (yych <= 'f') goto yy196;
					goto yy20;
				} else {
					if (yych <= 'h') goto yy196;
					if (yych <= 'l') goto yy20;
					goto yy196;
				}
			}
		} else {
			if (yych <= 'x') {
				if (yych <= 'u') {
					if (yych <= 'r') goto yy20;
					goto yy196;
				} else {
					if (yych == 'w') goto yy196;
					goto yy20;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 'y') goto yy196;
					if (yych <= 0xC1) goto yy20;
					goto yy97;
				} else {
					if (yych == 0xE2) goto yy98;
					goto yy20;
				}
			}
		}
	}
yy67:
	YYDEBUG(67, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy69;
	if (yych <= '0') goto yy208;
	if (yych <= '1') goto yy209;
	if (yych <= '9') goto yy210;
	goto yy69;
yy68:
	YYDEBUG(68, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy69:
	YYDEBUG(69, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'G') {
			if (yych <= '.') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy68;
					goto yy59;
				} else {
					if (yych <= ' ') goto yy68;
					if (yych <= ',') goto yy59;
					goto yy206;
				}
			} else {
				if (yych <= 'C') {
					if (yych == 'A') goto yy76;
					goto yy59;
				} else {
					if (yych <= 'D') goto yy77;
					if (yych == 'F') goto yy78;
					goto yy59;
				}
			}
		} else {
			if (yych <= 'N') {
				if (yych <= 'J') {
					if (yych <= 'H') goto yy79;
					if (yych <= 'I') goto yy80;
					goto yy82;
				} else {
					if (yych <= 'L') goto yy59;
					if (yych <= 'M') goto yy83;
					goto yy84;
				}
			} else {
				if (yych <= 'S') {
					if (yych <= 'O') goto yy85;
					if (yych <= 'R') goto yy59;
					goto yy86;
				} else {
					if (yych <= 'T') goto yy87;
					if (yych <= 'U') goto yy88;
					if (yych <= 'V') goto yy89;
					goto yy90;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= '`') {
					if (yych <= 'X') goto yy91;
					if (yych <= 'Y') goto yy92;
					goto yy59;
				} else {
					if (yych <= 'a') goto yy76;
					if (yych <= 'c') goto yy59;
					goto yy77;
				}
			} else {
				if (yych <= 'g') {
					if (yych == 'f') goto yy78;
					goto yy59;
				} else {
					if (yych <= 'h') goto yy79;
					if (yych == 'j') goto yy82;
					goto yy59;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'o') {
					if (yych <= 'm') goto yy83;
					if (yych <= 'n') goto yy84;
					goto yy85;
				} else {
					if (yych <= 'r') goto yy59;
					if (yych <= 's') goto yy86;
					if (yych <= 't') goto yy87;
					goto yy88;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy90;
					goto yy59;
				} else {
					if (yych <= 'y') goto yy92;
					if (yych == 0xC2) goto yy211;
					goto yy59;
				}
			}
		}
	}
yy70:
	YYDEBUG(70, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy207;
	if (yych <= '0') goto yy212;
	if (yych <= '1') goto yy213;
	if (yych <= '9') goto yy214;
	goto yy207;
yy71:
	YYDEBUG(71, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy207;
		if (yych <= '0') goto yy219;
		goto yy220;
	} else {
		if (yych <= '5') goto yy221;
		if (yych <= '9') goto yy222;
		goto yy207;
	}
yy72:
	YYDEBUG(72, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':	goto yy223;
	case '3':	goto yy225;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy226;
	case 'A':
	case 'a':	goto yy227;
	case 'D':
	case 'd':	goto yy228;
	case 'F':
	case 'f':	goto yy229;
	case 'J':
	case 'j':	goto yy230;
	case 'M':
	case 'm':	goto yy231;
	case 'N':
	case 'n':	goto yy232;
	case 'O':
	case 'o':	goto yy233;
	case 'S':
	case 's':	goto yy234;
	default:	goto yy59;
	}
yy73:
	YYDEBUG(73, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'm') {
		if (yych <= '.') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy69;
				goto yy67;
			} else {
				if (yych <= ',') goto yy69;
				if (yych <= '-') goto yy235;
				goto yy71;
			}
		} else {
			if (yych <= '5') {
				if (yych <= '/') goto yy72;
				goto yy236;
			} else {
				if (yych <= '9') goto yy237;
				if (yych <= ':') goto yy75;
				goto yy69;
			}
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'q') {
				if (yych <= 'n') goto yy93;
				goto yy69;
			} else {
				if (yych <= 'r') goto yy94;
				if (yych <= 's') goto yy95;
				goto yy96;
			}
		} else {
			if (yych <= 0xC2) {
				if (yych <= 0xC1) goto yy69;
				goto yy97;
			} else {
				if (yych == 0xE2) goto yy98;
				goto yy69;
			}
		}
	}
yy74:
	YYDEBUG(74, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'm') {
		if (yych <= '.') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy101;
				goto yy99;
			} else {
				if (yych <= ',') goto yy101;
				if (yych <= '-') goto yy235;
				goto yy102;
			}
		} else {
			if (yych <= '5') {
				if (yych <= '/') goto yy72;
				goto yy236;
			} else {
				if (yych <= '9') goto yy237;
				if (yych <= ':') goto yy104;
				goto yy101;
			}
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'q') {
				if (yych <= 'n') goto yy93;
				goto yy101;
			} else {
				if (yych <= 'r') goto yy94;
				if (yych <= 's') goto yy95;
				goto yy96;
			}
		} else {
			if (yych <= 0xC2) {
				if (yych <= 0xC1) goto yy101;
				goto yy107;
			} else {
				if (yych == 0xE2) goto yy108;
				goto yy101;
			}
		}
	}
yy75:
	YYDEBUG(75, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '5') goto yy238;
	if (yych <= '9') goto yy239;
	goto yy59;
yy76:
	YYDEBUG(76, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy240;
		if (yych <= 'T') goto yy59;
		goto yy241;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy59;
			goto yy240;
		} else {
			if (yych == 'u') goto yy241;
			goto yy59;
		}
	}
yy77:
	YYDEBUG(77, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy242;
		if (yych <= 'D') goto yy59;
		goto yy243;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy59;
			goto yy242;
		} else {
			if (yych == 'e') goto yy243;
			goto yy59;
		}
	}
yy78:
	YYDEBUG(78, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy244;
			goto yy59;
		} else {
			if (yych <= 'O') goto yy245;
			if (yych <= 'Q') goto yy59;
			goto yy246;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy244;
			goto yy59;
		} else {
			if (yych <= 'o') goto yy245;
			if (yych == 'r') goto yy246;
			goto yy59;
		}
	}
yy79:
	YYDEBUG(79, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy247;
	if (yych == 'o') goto yy247;
	goto yy59;
yy80:
	YYDEBUG(80, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy248;
		} else {
			if (yych <= ' ') goto yy248;
			if (yych <= ',') goto yy81;
			if (yych <= '.') goto yy248;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= '9') goto yy250;
			if (yych == 'I') goto yy252;
		} else {
			if (yych == 'W') goto yy81;
			if (yych <= 'X') goto yy253;
		}
	}
yy81:
	YYDEBUG(81, *YYCURSOR);
#line 1636 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("datenoyearrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr(&ptr, 2);
		timelib_skip_day_suffix(&ptr);
		s->time->m = timelib_get_month(&ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 3611 "<stdout>"
yy82:
	YYDEBUG(82, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy254;
		if (yych <= 'T') goto yy59;
		goto yy255;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy59;
			goto yy254;
		} else {
			if (yych == 'u') goto yy255;
			goto yy59;
		}
	}
yy83:
	YYDEBUG(83, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= 'I') {
			if (yych == 'A') goto yy256;
			if (yych <= 'H') goto yy59;
			goto yy257;
		} else {
			if (yych == 'O') goto yy258;
			if (yych <= 'R') goto yy59;
			goto yy259;
		}
	} else {
		if (yych <= 'i') {
			if (yych == 'a') goto yy256;
			if (yych <= 'h') goto yy59;
			goto yy257;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto yy59;
				goto yy258;
			} else {
				if (yych == 's') goto yy259;
				goto yy59;
			}
		}
	}
yy84:
	YYDEBUG(84, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy261;
	if (yych == 'o') goto yy261;
	goto yy59;
yy85:
	YYDEBUG(85, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy262;
	if (yych == 'c') goto yy262;
	goto yy59;
yy86:
	YYDEBUG(86, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy263;
			goto yy59;
		} else {
			if (yych <= 'E') goto yy264;
			if (yych <= 'T') goto yy59;
			goto yy265;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy263;
			goto yy59;
		} else {
			if (yych <= 'e') goto yy264;
			if (yych == 'u') goto yy265;
			goto yy59;
		}
	}
yy87:
	YYDEBUG(87, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy266;
		if (yych <= 'T') goto yy59;
		goto yy267;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy59;
			goto yy266;
		} else {
			if (yych == 'u') goto yy267;
			goto yy59;
		}
	}
yy88:
	YYDEBUG(88, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy268;
	if (yych == 's') goto yy268;
	goto yy59;
yy89:
	YYDEBUG(89, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy81;
			goto yy248;
		} else {
			if (yych == ' ') goto yy248;
			goto yy81;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy248;
			if (yych <= '/') goto yy81;
			goto yy250;
		} else {
			if (yych == 'I') goto yy91;
			goto yy81;
		}
	}
yy90:
	YYDEBUG(90, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy269;
	if (yych == 'e') goto yy269;
	goto yy59;
yy91:
	YYDEBUG(91, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy81;
			goto yy248;
		} else {
			if (yych == ' ') goto yy248;
			goto yy81;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy248;
			if (yych <= '/') goto yy81;
			goto yy250;
		} else {
			if (yych == 'I') goto yy252;
			goto yy81;
		}
	}
yy92:
	YYDEBUG(92, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy270;
	if (yych == 'e') goto yy270;
	goto yy59;
yy93:
	YYDEBUG(93, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'c') {
		if (yych == 'O') goto yy261;
		goto yy59;
	} else {
		if (yych <= 'd') goto yy271;
		if (yych == 'o') goto yy261;
		goto yy59;
	}
yy94:
	YYDEBUG(94, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy271;
	goto yy59;
yy95:
	YYDEBUG(95, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '`') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy263;
			goto yy59;
		} else {
			if (yych <= 'E') goto yy264;
			if (yych == 'U') goto yy265;
			goto yy59;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'a') goto yy263;
			if (yych <= 'd') goto yy59;
			goto yy264;
		} else {
			if (yych <= 's') goto yy59;
			if (yych <= 't') goto yy271;
			if (yych <= 'u') goto yy265;
			goto yy59;
		}
	}
yy96:
	YYDEBUG(96, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy266;
		if (yych <= 'T') goto yy59;
		goto yy267;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy59;
			goto yy272;
		} else {
			if (yych == 'u') goto yy267;
			goto yy59;
		}
	}
yy97:
	YYDEBUG(97, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych == 0xA0) goto yy273;
	if (yych == 0xB5) goto yy274;
	goto yy59;
yy98:
	YYDEBUG(98, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0x80) goto yy275;
	goto yy59;
yy99:
	YYDEBUG(99, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy101;
	if (yych <= '0') goto yy208;
	if (yych <= '1') goto yy209;
	if (yych <= '9') goto yy210;
	goto yy101;
yy100:
	YYDEBUG(100, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy101:
	YYDEBUG(101, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'G') {
			if (yych <= '.') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy100;
					goto yy59;
				} else {
					if (yych <= ' ') goto yy100;
					if (yych <= ',') goto yy59;
					goto yy206;
				}
			} else {
				if (yych <= 'C') {
					if (yych == 'A') goto yy105;
					goto yy59;
				} else {
					if (yych <= 'D') goto yy77;
					if (yych == 'F') goto yy78;
					goto yy59;
				}
			}
		} else {
			if (yych <= 'O') {
				if (yych <= 'J') {
					if (yych <= 'H') goto yy79;
					if (yych <= 'I') goto yy80;
					goto yy82;
				} else {
					if (yych <= 'L') goto yy59;
					if (yych <= 'M') goto yy83;
					if (yych <= 'N') goto yy84;
					goto yy85;
				}
			} else {
				if (yych <= 'S') {
					if (yych <= 'P') goto yy106;
					if (yych <= 'R') goto yy59;
					goto yy86;
				} else {
					if (yych <= 'T') goto yy87;
					if (yych <= 'U') goto yy88;
					if (yych <= 'V') goto yy89;
					goto yy90;
				}
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'e') {
				if (yych <= '`') {
					if (yych <= 'X') goto yy91;
					if (yych <= 'Y') goto yy92;
					goto yy59;
				} else {
					if (yych <= 'a') goto yy105;
					if (yych == 'd') goto yy77;
					goto yy59;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'f') goto yy78;
					if (yych <= 'g') goto yy59;
					goto yy79;
				} else {
					if (yych == 'j') goto yy82;
					if (yych <= 'l') goto yy59;
					goto yy83;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'p') {
					if (yych <= 'n') goto yy84;
					if (yych <= 'o') goto yy85;
					goto yy106;
				} else {
					if (yych <= 'r') goto yy59;
					if (yych <= 's') goto yy86;
					if (yych <= 't') goto yy87;
					goto yy88;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy90;
					goto yy59;
				} else {
					if (yych <= 'y') goto yy92;
					if (yych == 0xC2) goto yy211;
					goto yy59;
				}
			}
		}
	}
yy102:
	YYDEBUG(102, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy207;
		if (yych <= '0') goto yy276;
		goto yy277;
	} else {
		if (yych <= '5') goto yy278;
		if (yych <= '9') goto yy279;
		goto yy207;
	}
yy103:
	YYDEBUG(103, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'm') {
		if (yych <= '.') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy69;
				goto yy67;
			} else {
				if (yych <= ',') goto yy69;
				if (yych <= '-') goto yy235;
				goto yy71;
			}
		} else {
			if (yych <= '5') {
				if (yych <= '/') goto yy280;
				goto yy236;
			} else {
				if (yych <= '9') goto yy237;
				if (yych <= ':') goto yy75;
				goto yy69;
			}
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'q') {
				if (yych <= 'n') goto yy93;
				goto yy69;
			} else {
				if (yych <= 'r') goto yy94;
				if (yych <= 's') goto yy95;
				goto yy96;
			}
		} else {
			if (yych <= 0xC2) {
				if (yych <= 0xC1) goto yy69;
				goto yy97;
			} else {
				if (yych == 0xE2) goto yy98;
				goto yy69;
			}
		}
	}
yy104:
	YYDEBUG(104, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '5') goto yy281;
	if (yych <= '9') goto yy282;
	goto yy59;
yy105:
	YYDEBUG(105, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= 'L') {
			if (yych == '.') goto yy283;
			goto yy59;
		} else {
			if (yych <= 'M') goto yy284;
			if (yych == 'P') goto yy240;
			goto yy59;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'U') goto yy241;
			if (yych == 'm') goto yy284;
			goto yy59;
		} else {
			if (yych <= 'p') goto yy240;
			if (yych == 'u') goto yy241;
			goto yy59;
		}
	}
yy106:
	YYDEBUG(106, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == '.') goto yy283;
		goto yy59;
	} else {
		if (yych <= 'M') goto yy284;
		if (yych == 'm') goto yy284;
		goto yy59;
	}
yy107:
	YYDEBUG(107, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych == 0xA0) goto yy285;
	if (yych == 0xB5) goto yy274;
	goto yy59;
yy108:
	YYDEBUG(108, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0x80) goto yy286;
	goto yy59;
yy109:
	YYDEBUG(109, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'n') {
		if (yych <= '-') {
			if (yych == '\t') goto yy67;
			if (yych <= ',') goto yy69;
			goto yy235;
		} else {
			if (yych <= '/') {
				if (yych <= '.') goto yy287;
				goto yy280;
			} else {
				if (yych <= '9') goto yy237;
				if (yych <= 'm') goto yy69;
				goto yy93;
			}
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'q') goto yy69;
			if (yych <= 'r') goto yy94;
			if (yych <= 's') goto yy95;
			goto yy96;
		} else {
			if (yych <= 0xC2) {
				if (yych <= 0xC1) goto yy69;
				goto yy97;
			} else {
				if (yych == 0xE2) goto yy98;
				goto yy69;
			}
		}
	}
yy110:
	YYDEBUG(110, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych == '-') goto yy288;
		if (yych <= '/') goto yy196;
		goto yy237;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy196;
			goto yy97;
		} else {
			if (yych == 0xE2) goto yy98;
			goto yy196;
		}
	}
yy111:
	YYDEBUG(111, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy112;
	}
	goto yy59;
yy112:
	YYDEBUG(112, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 7) YYFILL(7);
	yych = *YYCURSOR;
	YYDEBUG(113, *YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy112;
	}
	if (yych == '.') goto yy289;
	YYDEBUG(114, *YYCURSOR);
#line 1211 "ext/date/lib/parse_date.re"
	{
		timelib_ull i;

		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_DATE();
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TZ();

		i = timelib_get_signed_nr(s, &ptr, 24);
		s->time->y = 1970;
		s->time->m = 1;
		s->time->d = 1;
		s->time->h = s->time->i = s->time->s = 0;
		s->time->us = 0;
		s->time->relative.s += i;
		s->time->is_localtime = 1;
		s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
		s->time->z = 0;
		s->time->dst = 0;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 4151 "<stdout>"
yy115:
	YYDEBUG(115, *YYCURSOR);
	++YYCURSOR;
	goto yy20;
yy116:
	YYDEBUG(116, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy115;
		goto yy20;
	} else {
		if (yych <= 'Z') goto yy291;
		if (yych <= '`') goto yy20;
		if (yych <= 'z') goto yy291;
		goto yy20;
	}
yy117:
	YYDEBUG(117, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'N') goto yy291;
			goto yy292;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy291;
			if (yych <= '`') goto yy20;
			goto yy291;
		} else {
			if (yych <= 'o') goto yy292;
			if (yych <= 'z') goto yy291;
			goto yy20;
		}
	}
yy118:
	YYDEBUG(118, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'Q') goto yy291;
			goto yy294;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy291;
			if (yych <= '`') goto yy20;
			goto yy291;
		} else {
			if (yych <= 'r') goto yy294;
			if (yych <= 'z') goto yy291;
			goto yy20;
		}
	}
yy119:
	YYDEBUG(119, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'F') goto yy291;
			goto yy296;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy291;
			if (yych <= '`') goto yy20;
			goto yy291;
		} else {
			if (yych <= 'g') goto yy296;
			if (yych <= 'z') goto yy291;
			goto yy20;
		}
	}
yy120:
	YYDEBUG(120, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy115;
			goto yy20;
		} else {
			if (yych == '.') goto yy20;
			goto yy297;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy20;
			if (yych <= 'Z') goto yy291;
			goto yy20;
		} else {
			if (yych <= '_') goto yy297;
			if (yych <= '`') goto yy20;
			if (yych <= 'z') goto yy298;
			goto yy20;
		}
	}
yy121:
	YYDEBUG(121, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy291;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy292;
			if (yych <= 'Z') goto yy291;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy20;
				goto yy298;
			} else {
				if (yych <= 'o') goto yy299;
				if (yych <= 'z') goto yy298;
				goto yy20;
			}
		}
	}
yy122:
	YYDEBUG(122, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy291;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy294;
			if (yych <= 'Z') goto yy291;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy20;
				goto yy298;
			} else {
				if (yych <= 'r') goto yy300;
				if (yych <= 'z') goto yy298;
				goto yy20;
			}
		}
	}
yy123:
	YYDEBUG(123, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy291;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy296;
			if (yych <= 'Z') goto yy291;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy20;
				goto yy298;
			} else {
				if (yych <= 'g') goto yy301;
				if (yych <= 'z') goto yy298;
				goto yy20;
			}
		}
	}
yy124:
	YYDEBUG(124, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'B') goto yy291;
			goto yy302;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy291;
			if (yych <= '`') goto yy20;
			goto yy291;
		} else {
			if (yych <= 'c') goto yy302;
			if (yych <= 'z') goto yy291;
			goto yy20;
		}
	}
yy125:
	YYDEBUG(125, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy291;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'C') goto yy302;
			if (yych <= 'Z') goto yy291;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy20;
				goto yy298;
			} else {
				if (yych <= 'c') goto yy303;
				if (yych <= 'z') goto yy298;
				goto yy20;
			}
		}
	}
yy126:
	YYDEBUG(126, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'B') goto yy291;
			goto yy304;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy291;
			if (yych <= '`') goto yy20;
			goto yy291;
		} else {
			if (yych <= 'c') goto yy304;
			if (yych <= 'z') goto yy291;
			goto yy20;
		}
	}
yy127:
	YYDEBUG(127, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy291;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'C') goto yy304;
			if (yych <= 'Z') goto yy291;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy20;
				goto yy298;
			} else {
				if (yych <= 'c') goto yy305;
				if (yych <= 'z') goto yy298;
				goto yy20;
			}
		}
	}
yy128:
	YYDEBUG(128, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'F') goto yy291;
			goto yy306;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy291;
			if (yych <= '`') goto yy20;
			goto yy291;
		} else {
			if (yych <= 'g') goto yy306;
			if (yych <= 'z') goto yy291;
			goto yy20;
		}
	}
yy129:
	YYDEBUG(129, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'D') goto yy291;
			goto yy307;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy291;
			if (yych <= '`') goto yy20;
			goto yy291;
		} else {
			if (yych <= 'e') goto yy307;
			if (yych <= 'z') goto yy291;
			goto yy20;
		}
	}
yy130:
	YYDEBUG(130, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy291;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy306;
			if (yych <= 'Z') goto yy291;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy20;
				goto yy298;
			} else {
				if (yych <= 'g') goto yy308;
				if (yych <= 'z') goto yy298;
				goto yy20;
			}
		}
	}
yy131:
	YYDEBUG(131, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy291;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy307;
			if (yych <= 'Z') goto yy291;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy20;
				goto yy298;
			} else {
				if (yych <= 'e') goto yy309;
				if (yych <= 'z') goto yy298;
				goto yy20;
			}
		}
	}
yy132:
	YYDEBUG(132, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'A') goto yy291;
			goto yy310;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy291;
			if (yych <= '`') goto yy20;
			goto yy291;
		} else {
			if (yych <= 'b') goto yy310;
			if (yych <= 'z') goto yy291;
			goto yy20;
		}
	}
yy133:
	YYDEBUG(133, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= '@') {
			if (yych == ')') goto yy115;
			goto yy20;
		} else {
			if (yych == 'F') goto yy311;
			if (yych <= 'Q') goto yy291;
			goto yy312;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy291;
			if (yych <= '`') goto yy20;
			if (yych <= 'e') goto yy291;
			goto yy311;
		} else {
			if (yych == 'r') goto yy312;
			if (yych <= 'z') goto yy291;
			goto yy20;
		}
	}
yy134:
	YYDEBUG(134, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'T') goto yy291;
			goto yy313;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy291;
			if (yych <= '`') goto yy20;
			goto yy291;
		} else {
			if (yych <= 'u') goto yy313;
			if (yych <= 'z') goto yy291;
			goto yy20;
		}
	}
yy135:
	YYDEBUG(135, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= '@') {
			if (yych == ')') goto yy115;
			goto yy20;
		} else {
			if (yych == 'I') goto yy314;
			if (yych <= 'N') goto yy291;
			goto yy316;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy291;
			if (yych <= '`') goto yy20;
			if (yych <= 'h') goto yy291;
			goto yy314;
		} else {
			if (yych == 'o') goto yy316;
			if (yych <= 'z') goto yy291;
			goto yy20;
		}
	}
yy136:
	YYDEBUG(136, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy291;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy310;
			if (yych <= 'Z') goto yy291;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy20;
				goto yy298;
			} else {
				if (yych <= 'b') goto yy317;
				if (yych <= 'z') goto yy298;
				goto yy20;
			}
		}
	}
yy137:
	YYDEBUG(137, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy20;
				goto yy115;
			} else {
				if (yych == '-') goto yy297;
				goto yy20;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy297;
				goto yy20;
			} else {
				if (yych == 'F') goto yy311;
				goto yy291;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'R') goto yy312;
				goto yy291;
			} else {
				if (yych == '_') goto yy297;
				goto yy20;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'f') goto yy318;
				goto yy298;
			} else {
				if (yych <= 'r') goto yy319;
				if (yych <= 'z') goto yy298;
				goto yy20;
			}
		}
	}
yy138:
	YYDEBUG(138, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy291;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy313;
			if (yych <= 'Z') goto yy291;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy20;
				goto yy298;
			} else {
				if (yych <= 'u') goto yy320;
				if (yych <= 'z') goto yy298;
				goto yy20;
			}
		}
	}
yy139:
	YYDEBUG(139, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy20;
				goto yy115;
			} else {
				if (yych == '-') goto yy297;
				goto yy20;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy297;
				goto yy20;
			} else {
				if (yych == 'I') goto yy314;
				goto yy291;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'O') goto yy316;
				goto yy291;
			} else {
				if (yych == '_') goto yy297;
				goto yy20;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'i') goto yy321;
				goto yy298;
			} else {
				if (yych <= 'o') goto yy322;
				if (yych <= 'z') goto yy298;
				goto yy20;
			}
		}
	}
yy140:
	YYDEBUG(140, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == ')') goto yy115;
		if (yych <= '@') goto yy20;
		goto yy291;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'T') goto yy323;
			goto yy291;
		} else {
			if (yych <= '`') goto yy20;
			if (yych <= 'z') goto yy291;
			goto yy20;
		}
	}
yy141:
	YYDEBUG(141, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 26) YYFILL(26);
	yych = *YYCURSOR;
yy142:
	YYDEBUG(142, *YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy141;
	}
	if (yych <= '/') goto yy59;
	if (yych <= '2') goto yy143;
	if (yych <= '3') goto yy144;
	if (yych <= '9') goto yy145;
	goto yy59;
yy143:
	YYDEBUG(143, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy324;
				goto yy59;
			} else {
				if (yych <= '\t') goto yy326;
				if (yych <= 0x1F) goto yy59;
				goto yy326;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy326;
				goto yy59;
			} else {
				if (yych <= '.') goto yy326;
				if (yych <= '/') goto yy59;
				goto yy328;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy59;
				goto yy326;
			} else {
				if (yych == 'h') goto yy326;
				goto yy59;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy329;
				if (yych <= 'q') goto yy59;
				goto yy329;
			} else {
				if (yych <= 's') goto yy330;
				if (yych <= 't') goto yy331;
				goto yy59;
			}
		}
	}
yy144:
	YYDEBUG(144, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy324;
				goto yy59;
			} else {
				if (yych <= '\t') goto yy326;
				if (yych <= 0x1F) goto yy59;
				goto yy326;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy326;
				goto yy59;
			} else {
				if (yych <= '.') goto yy326;
				if (yych <= '/') goto yy59;
				goto yy328;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= '9') goto yy332;
				if (yych <= 'c') goto yy59;
				goto yy326;
			} else {
				if (yych == 'h') goto yy326;
				goto yy59;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy329;
				if (yych <= 'q') goto yy59;
				goto yy329;
			} else {
				if (yych <= 's') goto yy330;
				if (yych <= 't') goto yy331;
				goto yy59;
			}
		}
	}
yy145:
	YYDEBUG(145, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy324;
				goto yy59;
			} else {
				if (yych <= '\t') goto yy326;
				if (yych <= 0x1F) goto yy59;
				goto yy326;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy326;
				goto yy59;
			} else {
				if (yych <= '.') goto yy326;
				if (yych <= '/') goto yy59;
				goto yy332;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy59;
				goto yy326;
			} else {
				if (yych == 'h') goto yy326;
				goto yy59;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy329;
				if (yych <= 'q') goto yy59;
				goto yy329;
			} else {
				if (yych <= 's') goto yy330;
				if (yych <= 't') goto yy331;
				goto yy59;
			}
		}
	}
yy146:
	YYDEBUG(146, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy142;
			if (yych <= 0x1F) goto yy20;
			goto yy142;
		} else {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy142;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy20;
			if (yych <= '9') goto yy142;
			if (yych <= '@') goto yy20;
			goto yy291;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy333;
				goto yy291;
			} else {
				if (yych <= '`') goto yy20;
				if (yych <= 'z') goto yy291;
				goto yy20;
			}
		}
	}
yy147:
	YYDEBUG(147, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy142;
			goto yy20;
		} else {
			if (yych <= ' ') goto yy142;
			if (yych == ')') goto yy115;
			goto yy20;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy20;
			if (yych <= '9') goto yy142;
			goto yy20;
		} else {
			if (yych <= 'Z') goto yy291;
			if (yych <= '`') goto yy20;
			if (yych <= 'z') goto yy291;
			goto yy20;
		}
	}
yy148:
	YYDEBUG(148, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'M') goto yy291;
			goto yy334;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy291;
			if (yych <= '`') goto yy20;
			goto yy291;
		} else {
			if (yych <= 'n') goto yy334;
			if (yych <= 'z') goto yy291;
			goto yy20;
		}
	}
yy149:
	YYDEBUG(149, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= '@') {
			if (yych == ')') goto yy115;
			goto yy20;
		} else {
			if (yych == 'L') goto yy335;
			if (yych <= 'M') goto yy291;
			goto yy336;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy291;
			if (yych <= '`') goto yy20;
			if (yych <= 'k') goto yy291;
			goto yy335;
		} else {
			if (yych == 'n') goto yy336;
			if (yych <= 'z') goto yy291;
			goto yy20;
		}
	}
yy150:
	YYDEBUG(150, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy291;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy334;
			if (yych <= 'Z') goto yy291;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy20;
				goto yy298;
			} else {
				if (yych <= 'n') goto yy337;
				if (yych <= 'z') goto yy298;
				goto yy20;
			}
		}
	}
yy151:
	YYDEBUG(151, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy20;
				goto yy115;
			} else {
				if (yych == '-') goto yy297;
				goto yy20;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy297;
				goto yy20;
			} else {
				if (yych == 'L') goto yy335;
				goto yy291;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'N') goto yy336;
				goto yy291;
			} else {
				if (yych == '_') goto yy297;
				goto yy20;
			}
		} else {
			if (yych <= 'm') {
				if (yych == 'l') goto yy338;
				goto yy298;
			} else {
				if (yych <= 'n') goto yy339;
				if (yych <= 'z') goto yy298;
				goto yy20;
			}
		}
	}
yy152:
	YYDEBUG(152, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'R') goto yy291;
			goto yy340;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy291;
			if (yych <= '`') goto yy20;
			goto yy291;
		} else {
			if (yych <= 's') goto yy340;
			if (yych <= 'z') goto yy291;
			goto yy20;
		}
	}
yy153:
	YYDEBUG(153, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy291;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy340;
			if (yych <= 'Z') goto yy291;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy20;
				goto yy298;
			} else {
				if (yych <= 's') goto yy341;
				if (yych <= 'z') goto yy298;
				goto yy20;
			}
		}
	}
yy154:
	YYDEBUG(154, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= '@') {
			if (yych == ')') goto yy115;
			goto yy20;
		} else {
			if (yych == 'R') goto yy342;
			if (yych <= 'X') goto yy291;
			goto yy343;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy291;
			if (yych <= '`') goto yy20;
			if (yych <= 'q') goto yy291;
			goto yy342;
		} else {
			if (yych == 'y') goto yy343;
			if (yych <= 'z') goto yy291;
			goto yy20;
		}
	}
yy155:
	YYDEBUG(155, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'C') goto yy291;
			goto yy344;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy291;
			if (yych <= '`') goto yy20;
			goto yy291;
		} else {
			if (yych <= 'd') goto yy344;
			if (yych <= 'z') goto yy291;
			goto yy20;
		}
	}
yy156:
	YYDEBUG(156, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'M') goto yy291;
			goto yy314;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy291;
			if (yych <= '`') goto yy20;
			goto yy291;
		} else {
			if (yych <= 'n') goto yy314;
			if (yych <= 'z') goto yy291;
			goto yy20;
		}
	}
yy157:
	YYDEBUG(157, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy20;
				goto yy115;
			} else {
				if (yych == '-') goto yy297;
				goto yy20;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy297;
				goto yy20;
			} else {
				if (yych == 'R') goto yy342;
				goto yy291;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'Y') goto yy343;
				goto yy291;
			} else {
				if (yych == '_') goto yy297;
				goto yy20;
			}
		} else {
			if (yych <= 'x') {
				if (yych == 'r') goto yy345;
				goto yy298;
			} else {
				if (yych <= 'y') goto yy346;
				if (yych <= 'z') goto yy298;
				goto yy20;
			}
		}
	}
yy158:
	YYDEBUG(158, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy291;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy344;
			if (yych <= 'Z') goto yy291;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy20;
				goto yy298;
			} else {
				if (yych <= 'd') goto yy347;
				if (yych <= 'z') goto yy298;
				goto yy20;
			}
		}
	}
yy159:
	YYDEBUG(159, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy291;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy314;
			if (yych <= 'Z') goto yy291;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy20;
				goto yy298;
			} else {
				if (yych <= 'n') goto yy321;
				if (yych <= 'z') goto yy298;
				goto yy20;
			}
		}
	}
yy160:
	YYDEBUG(160, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'W') goto yy291;
			goto yy348;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy291;
			if (yych <= '`') goto yy20;
			goto yy291;
		} else {
			if (yych <= 'x') goto yy348;
			if (yych <= 'z') goto yy291;
			goto yy20;
		}
	}
yy161:
	YYDEBUG(161, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'M') goto yy291;
			goto yy311;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy291;
			if (yych <= '`') goto yy20;
			goto yy291;
		} else {
			if (yych <= 'n') goto yy311;
			if (yych <= 'z') goto yy291;
			goto yy20;
		}
	}
yy162:
	YYDEBUG(162, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'W') {
		if (yych <= 'N') {
			if (yych == ')') goto yy115;
			if (yych <= '@') goto yy20;
			goto yy291;
		} else {
			if (yych <= 'O') goto yy349;
			if (yych <= 'U') goto yy291;
			if (yych <= 'V') goto yy304;
			goto yy350;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'Z') goto yy291;
			if (yych <= '`') goto yy20;
			if (yych <= 'n') goto yy291;
			goto yy349;
		} else {
			if (yych <= 'v') {
				if (yych <= 'u') goto yy291;
				goto yy304;
			} else {
				if (yych <= 'w') goto yy350;
				if (yych <= 'z') goto yy291;
				goto yy20;
			}
		}
	}
yy163:
	YYDEBUG(163, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy291;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'X') goto yy348;
			if (yych <= 'Z') goto yy291;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'w') {
				if (yych <= '`') goto yy20;
				goto yy298;
			} else {
				if (yych <= 'x') goto yy352;
				if (yych <= 'z') goto yy298;
				goto yy20;
			}
		}
	}
yy164:
	YYDEBUG(164, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy291;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy311;
			if (yych <= 'Z') goto yy291;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy20;
				goto yy298;
			} else {
				if (yych <= 'n') goto yy318;
				if (yych <= 'z') goto yy298;
				goto yy20;
			}
		}
	}
yy165:
	YYDEBUG(165, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy20;
				goto yy115;
			} else {
				if (yych == '-') goto yy297;
				goto yy20;
			}
		} else {
			if (yych <= 'N') {
				if (yych <= '/') goto yy297;
				if (yych <= '@') goto yy20;
				goto yy291;
			} else {
				if (yych <= 'O') goto yy349;
				if (yych <= 'U') goto yy291;
				goto yy304;
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= '^') {
				if (yych <= 'W') goto yy350;
				if (yych <= 'Z') goto yy291;
				goto yy20;
			} else {
				if (yych <= '_') goto yy297;
				if (yych <= '`') goto yy20;
				goto yy298;
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 'o') goto yy353;
				if (yych <= 'u') goto yy298;
				goto yy305;
			} else {
				if (yych <= 'w') goto yy354;
				if (yych <= 'z') goto yy298;
				goto yy20;
			}
		}
	}
yy166:
	YYDEBUG(166, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'S') goto yy291;
			goto yy355;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy291;
			if (yych <= '`') goto yy20;
			goto yy291;
		} else {
			if (yych <= 't') goto yy355;
			if (yych <= 'z') goto yy291;
			goto yy20;
		}
	}
yy167:
	YYDEBUG(167, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy291;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy355;
			if (yych <= 'Z') goto yy291;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy20;
				goto yy298;
			} else {
				if (yych <= 't') goto yy356;
				if (yych <= 'z') goto yy298;
				goto yy20;
			}
		}
	}
yy168:
	YYDEBUG(168, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'D') goto yy291;
			goto yy357;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy291;
			if (yych <= '`') goto yy20;
			goto yy291;
		} else {
			if (yych <= 'e') goto yy357;
			if (yych <= 'z') goto yy291;
			goto yy20;
		}
	}
yy169:
	YYDEBUG(169, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy291;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy357;
			if (yych <= 'Z') goto yy291;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy20;
				goto yy298;
			} else {
				if (yych <= 'e') goto yy358;
				if (yych <= 'z') goto yy298;
				goto yy20;
			}
		}
	}
yy170:
	YYDEBUG(170, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'S') goto yy291;
			goto yy359;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy291;
			if (yych <= '`') goto yy20;
			goto yy291;
		} else {
			if (yych <= 't') goto yy359;
			if (yych <= 'z') goto yy291;
			goto yy20;
		}
	}
yy171:
	YYDEBUG(171, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= 'B') {
			if (yych == ')') goto yy115;
			if (yych <= '@') goto yy20;
			goto yy291;
		} else {
			if (yych <= 'O') {
				if (yych <= 'C') goto yy360;
				goto yy291;
			} else {
				if (yych <= 'P') goto yy361;
				if (yych <= 'U') goto yy291;
				goto yy362;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy291;
				goto yy20;
			} else {
				if (yych == 'c') goto yy360;
				goto yy291;
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'p') goto yy361;
				goto yy291;
			} else {
				if (yych <= 'v') goto yy362;
				if (yych <= 'z') goto yy291;
				goto yy20;
			}
		}
	}
yy172:
	YYDEBUG(172, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'W') goto yy291;
			goto yy311;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy291;
			if (yych <= '`') goto yy20;
			goto yy291;
		} else {
			if (yych <= 'x') goto yy311;
			if (yych <= 'z') goto yy291;
			goto yy20;
		}
	}
yy173:
	YYDEBUG(173, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy291;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy359;
			if (yych <= 'Z') goto yy291;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy20;
				goto yy298;
			} else {
				if (yych <= 't') goto yy363;
				if (yych <= 'z') goto yy298;
				goto yy20;
			}
		}
	}
yy174:
	YYDEBUG(174, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '/') {
			if (yych <= ',') {
				if (yych == ')') goto yy115;
				goto yy20;
			} else {
				if (yych == '.') goto yy20;
				goto yy297;
			}
		} else {
			if (yych <= 'C') {
				if (yych <= '@') goto yy20;
				if (yych <= 'B') goto yy291;
				goto yy360;
			} else {
				if (yych == 'P') goto yy361;
				goto yy291;
			}
		}
	} else {
		if (yych <= 'b') {
			if (yych <= '^') {
				if (yych <= 'V') goto yy362;
				if (yych <= 'Z') goto yy291;
				goto yy20;
			} else {
				if (yych <= '_') goto yy297;
				if (yych <= '`') goto yy20;
				goto yy298;
			}
		} else {
			if (yych <= 'p') {
				if (yych <= 'c') goto yy364;
				if (yych <= 'o') goto yy298;
				goto yy365;
			} else {
				if (yych == 'v') goto yy366;
				if (yych <= 'z') goto yy298;
				goto yy20;
			}
		}
	}
yy175:
	YYDEBUG(175, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy291;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'X') goto yy311;
			if (yych <= 'Z') goto yy291;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'w') {
				if (yych <= '`') goto yy20;
				goto yy298;
			} else {
				if (yych <= 'x') goto yy318;
				if (yych <= 'z') goto yy298;
				goto yy20;
			}
		}
	}
yy176:
	YYDEBUG(176, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy75;
	} else {
		if (yych <= '9') goto yy367;
		if (yych <= ':') goto yy75;
	}
yy177:
	YYDEBUG(177, *YYCURSOR);
#line 1377 "ext/date/lib/parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("timetiny24 | timeshort24 | timelong24 | iso8601long");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr(&ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->i = timelib_get_nr(&ptr, 2);
			if (*ptr == ':' || *ptr == '.') {
				s->time->s = timelib_get_nr(&ptr, 2);

				if (*ptr == '.') {
					s->time->us = timelib_get_frac_nr(&ptr);
				}
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_parse_zone(&ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
#line 5904 "<stdout>"
yy178:
	YYDEBUG(178, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy75;
		goto yy177;
	} else {
		if (yych <= '4') goto yy367;
		if (yych == ':') goto yy75;
		goto yy177;
	}
yy179:
	YYDEBUG(179, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy75;
	if (yych == ':') goto yy75;
	goto yy177;
yy180:
	YYDEBUG(180, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy115;
			goto yy20;
		} else {
			if (yych == 'I') goto yy368;
			if (yych <= 'T') goto yy291;
			goto yy369;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy291;
			if (yych <= '`') goto yy20;
			if (yych <= 'h') goto yy291;
			goto yy368;
		} else {
			if (yych == 'u') goto yy369;
			if (yych <= 'z') goto yy291;
			goto yy20;
		}
	}
yy181:
	YYDEBUG(181, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= '@') {
			if (yych == ')') goto yy115;
			goto yy20;
		} else {
			if (yych == 'D') goto yy370;
			if (yych <= 'L') goto yy291;
			goto yy371;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy291;
			if (yych <= '`') goto yy20;
			if (yych <= 'c') goto yy291;
			goto yy370;
		} else {
			if (yych == 'm') goto yy371;
			if (yych <= 'z') goto yy291;
			goto yy20;
		}
	}
yy182:
	YYDEBUG(182, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'D') goto yy291;
			goto yy372;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy291;
			if (yych <= '`') goto yy20;
			goto yy291;
		} else {
			if (yych <= 'e') goto yy372;
			if (yych <= 'z') goto yy291;
			goto yy20;
		}
	}
yy183:
	YYDEBUG(183, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'D') goto yy291;
			goto yy373;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy291;
			if (yych <= '`') goto yy20;
			goto yy291;
		} else {
			if (yych <= 'e') goto yy373;
			if (yych <= 'z') goto yy291;
			goto yy20;
		}
	}
yy184:
	YYDEBUG(184, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy20;
				goto yy115;
			} else {
				if (yych == '-') goto yy297;
				goto yy20;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy297;
				goto yy20;
			} else {
				if (yych == 'I') goto yy368;
				goto yy291;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'U') goto yy369;
				goto yy291;
			} else {
				if (yych == '_') goto yy297;
				goto yy20;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy374;
				goto yy298;
			} else {
				if (yych <= 'u') goto yy375;
				if (yych <= 'z') goto yy298;
				goto yy20;
			}
		}
	}
yy185:
	YYDEBUG(185, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy20;
				goto yy115;
			} else {
				if (yych == '-') goto yy297;
				goto yy20;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy297;
				goto yy20;
			} else {
				if (yych == 'D') goto yy370;
				goto yy291;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'M') goto yy371;
				goto yy291;
			} else {
				if (yych == '_') goto yy297;
				goto yy20;
			}
		} else {
			if (yych <= 'l') {
				if (yych == 'd') goto yy376;
				goto yy298;
			} else {
				if (yych <= 'm') goto yy377;
				if (yych <= 'z') goto yy298;
				goto yy20;
			}
		}
	}
yy186:
	YYDEBUG(186, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy291;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy372;
			if (yych <= 'Z') goto yy291;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy20;
				goto yy298;
			} else {
				if (yych <= 'e') goto yy378;
				if (yych <= 'z') goto yy298;
				goto yy20;
			}
		}
	}
yy187:
	YYDEBUG(187, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy291;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy373;
			if (yych <= 'Z') goto yy291;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy20;
				goto yy298;
			} else {
				if (yych <= 'e') goto yy379;
				if (yych <= 'z') goto yy298;
				goto yy20;
			}
		}
	}
yy188:
	YYDEBUG(188, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy142;
			if (yych <= 0x1F) goto yy20;
			goto yy142;
		} else {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy142;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy20;
			if (yych <= '9') goto yy142;
			if (yych <= '@') goto yy20;
			goto yy291;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy380;
				goto yy291;
			} else {
				if (yych <= '`') goto yy20;
				if (yych <= 'z') goto yy291;
				goto yy20;
			}
		}
	}
yy189:
	YYDEBUG(189, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= '@') {
			if (yych == ')') goto yy115;
			goto yy20;
		} else {
			if (yych <= 'C') goto yy291;
			if (yych <= 'D') goto yy381;
			goto yy382;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy291;
			if (yych <= '`') goto yy20;
			goto yy291;
		} else {
			if (yych <= 'd') goto yy381;
			if (yych <= 'e') goto yy382;
			if (yych <= 'z') goto yy291;
			goto yy20;
		}
	}
yy190:
	YYDEBUG(190, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych <= '/') {
				if (yych <= '.') goto yy20;
				goto yy297;
			} else {
				if (yych <= '@') goto yy20;
				if (yych <= 'C') goto yy291;
				goto yy381;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'E') goto yy382;
				goto yy291;
			} else {
				if (yych == '_') goto yy297;
				goto yy20;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy298;
				goto yy383;
			} else {
				if (yych <= 'e') goto yy384;
				if (yych <= 'z') goto yy298;
				goto yy20;
			}
		}
	}
yy191:
	YYDEBUG(191, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'R') goto yy291;
			goto yy385;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy291;
			if (yych <= '`') goto yy20;
			goto yy291;
		} else {
			if (yych <= 's') goto yy385;
			if (yych <= 'z') goto yy291;
			goto yy20;
		}
	}
yy192:
	YYDEBUG(192, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy291;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy385;
			if (yych <= 'Z') goto yy291;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy20;
				goto yy298;
			} else {
				if (yych <= 's') goto yy386;
				if (yych <= 'z') goto yy298;
				goto yy20;
			}
		}
	}
yy193:
	YYDEBUG(193, *YYCURSOR);
	yyaccept = 0;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xC2) goto yy387;
	goto yy8;
yy194:
	YYDEBUG(194, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xAF) goto yy388;
	goto yy59;
yy195:
	YYDEBUG(195, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy196:
	YYDEBUG(196, *YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy195;
				if (yych <= 0x1F) goto yy59;
				goto yy195;
			} else {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy59;
					goto yy198;
				} else {
					if (yych == 'F') goto yy199;
					goto yy59;
				}
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy79;
					goto yy59;
				} else {
					if (yych <= 'M') goto yy200;
					if (yych <= 'R') goto yy59;
					goto yy201;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'T') goto yy87;
					goto yy88;
				} else {
					if (yych == 'W') goto yy90;
					goto yy59;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy92;
					goto yy59;
				} else {
					if (yych <= 'd') goto yy198;
					if (yych <= 'e') goto yy59;
					goto yy199;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy59;
					goto yy79;
				} else {
					if (yych == 'm') goto yy200;
					goto yy59;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 's') goto yy201;
					goto yy87;
				} else {
					if (yych <= 'u') goto yy88;
					if (yych <= 'v') goto yy59;
					goto yy90;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy59;
					goto yy92;
				} else {
					if (yych == 0xC2) goto yy211;
					goto yy59;
				}
			}
		}
	}
yy197:
	YYDEBUG(197, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy196;
		if (yych <= '9') goto yy389;
		goto yy196;
	} else {
		if (yych <= 0xC2) goto yy97;
		if (yych == 0xE2) goto yy98;
		goto yy196;
	}
yy198:
	YYDEBUG(198, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy242;
	if (yych == 'a') goto yy242;
	goto yy59;
yy199:
	YYDEBUG(199, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy245;
		if (yych <= 'Q') goto yy59;
		goto yy246;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy59;
			goto yy245;
		} else {
			if (yych == 'r') goto yy246;
			goto yy59;
		}
	}
yy200:
	YYDEBUG(200, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= 'N') {
			if (yych == 'I') goto yy257;
			goto yy59;
		} else {
			if (yych <= 'O') goto yy258;
			if (yych <= 'R') goto yy59;
			goto yy259;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'i') goto yy257;
			goto yy59;
		} else {
			if (yych <= 'o') goto yy258;
			if (yych == 's') goto yy259;
			goto yy59;
		}
	}
yy201:
	YYDEBUG(201, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy263;
			goto yy59;
		} else {
			if (yych <= 'E') goto yy390;
			if (yych <= 'T') goto yy59;
			goto yy265;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy263;
			goto yy59;
		} else {
			if (yych <= 'e') goto yy390;
			if (yych == 'u') goto yy265;
			goto yy59;
		}
	}
yy202:
	YYDEBUG(202, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'D') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy20;
					goto yy196;
				} else {
					if (yych == ' ') goto yy196;
					goto yy20;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '5') goto yy391;
					goto yy392;
				} else {
					if (yych <= ':') goto yy393;
					if (yych <= 'C') goto yy20;
					goto yy196;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych <= 'F') {
					if (yych <= 'E') goto yy20;
					goto yy196;
				} else {
					if (yych == 'H') goto yy196;
					goto yy20;
				}
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy196;
					goto yy20;
				} else {
					if (yych == 'V') goto yy20;
					goto yy196;
				}
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'e') {
				if (yych <= 'Y') {
					if (yych <= 'X') goto yy20;
					goto yy196;
				} else {
					if (yych == 'd') goto yy196;
					goto yy20;
				}
			} else {
				if (yych <= 'g') {
					if (yych <= 'f') goto yy196;
					goto yy20;
				} else {
					if (yych <= 'h') goto yy196;
					if (yych <= 'l') goto yy20;
					goto yy196;
				}
			}
		} else {
			if (yych <= 'x') {
				if (yych <= 'u') {
					if (yych <= 'r') goto yy20;
					goto yy196;
				} else {
					if (yych == 'w') goto yy196;
					goto yy20;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 'y') goto yy196;
					if (yych <= 0xC1) goto yy20;
					goto yy97;
				} else {
					if (yych == 0xE2) goto yy98;
					goto yy20;
				}
			}
		}
	}
yy203:
	YYDEBUG(203, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '5') goto yy394;
	if (yych <= '9') goto yy115;
	goto yy59;
yy204:
	YYDEBUG(204, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy196;
				if (yych <= 0x1F) goto yy20;
				goto yy196;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy20;
					goto yy392;
				} else {
					if (yych == 'D') goto yy196;
					goto yy20;
				}
			}
		} else {
			if (yych <= 'M') {
				if (yych <= 'G') {
					if (yych <= 'F') goto yy196;
					goto yy20;
				} else {
					if (yych <= 'H') goto yy196;
					if (yych <= 'L') goto yy20;
					goto yy196;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'R') goto yy20;
					goto yy196;
				} else {
					if (yych == 'W') goto yy196;
					goto yy20;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy196;
					goto yy20;
				} else {
					if (yych == 'e') goto yy20;
					goto yy196;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy20;
					goto yy196;
				} else {
					if (yych == 'm') goto yy196;
					goto yy20;
				}
			}
		} else {
			if (yych <= 'y') {
				if (yych <= 'v') {
					if (yych <= 'u') goto yy196;
					goto yy20;
				} else {
					if (yych == 'x') goto yy20;
					goto yy196;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 0xC1) goto yy20;
					goto yy97;
				} else {
					if (yych == 0xE2) goto yy98;
					goto yy20;
				}
			}
		}
	}
yy205:
	YYDEBUG(205, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy196;
				if (yych <= 0x1F) goto yy20;
				goto yy196;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy20;
					goto yy395;
				} else {
					if (yych == 'D') goto yy196;
					goto yy20;
				}
			}
		} else {
			if (yych <= 'M') {
				if (yych <= 'G') {
					if (yych <= 'F') goto yy196;
					goto yy20;
				} else {
					if (yych <= 'H') goto yy196;
					if (yych <= 'L') goto yy20;
					goto yy196;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'R') goto yy20;
					goto yy196;
				} else {
					if (yych == 'W') goto yy196;
					goto yy20;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy196;
					goto yy20;
				} else {
					if (yych == 'e') goto yy20;
					goto yy196;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy20;
					goto yy196;
				} else {
					if (yych == 'm') goto yy196;
					goto yy20;
				}
			}
		} else {
			if (yych <= 'y') {
				if (yych <= 'v') {
					if (yych <= 'u') goto yy196;
					goto yy20;
				} else {
					if (yych == 'x') goto yy20;
					goto yy196;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 0xC1) goto yy20;
					goto yy97;
				} else {
					if (yych == 0xE2) goto yy98;
					goto yy20;
				}
			}
		}
	}
yy206:
	YYDEBUG(206, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy207:
	YYDEBUG(207, *YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy206;
	case 'A':
	case 'a':	goto yy76;
	case 'D':
	case 'd':	goto yy215;
	case 'F':
	case 'f':	goto yy216;
	case 'I':	goto yy80;
	case 'J':
	case 'j':	goto yy82;
	case 'M':
	case 'm':	goto yy217;
	case 'N':
	case 'n':	goto yy84;
	case 'O':
	case 'o':	goto yy85;
	case 'S':
	case 's':	goto yy218;
	case 'V':	goto yy89;
	case 'X':	goto yy91;
	default:	goto yy59;
	}
yy208:
	YYDEBUG(208, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy59;
		if (yych <= '-') goto yy396;
		goto yy397;
	} else {
		if (yych <= '/') goto yy59;
		if (yych <= '9') goto yy210;
		goto yy59;
	}
yy209:
	YYDEBUG(209, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy59;
		if (yych <= '-') goto yy396;
		goto yy397;
	} else {
		if (yych <= '/') goto yy59;
		if (yych >= '3') goto yy59;
	}
yy210:
	YYDEBUG(210, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy59;
	if (yych <= '-') goto yy396;
	if (yych <= '.') goto yy397;
	goto yy59;
yy211:
	YYDEBUG(211, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 0xB5) goto yy274;
	goto yy59;
yy212:
	YYDEBUG(212, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy59;
		if (yych <= '-') goto yy398;
		goto yy396;
	} else {
		if (yych <= '/') goto yy59;
		if (yych <= '9') goto yy214;
		goto yy59;
	}
yy213:
	YYDEBUG(213, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy59;
		if (yych <= '-') goto yy398;
		goto yy396;
	} else {
		if (yych <= '/') goto yy59;
		if (yych >= '3') goto yy59;
	}
yy214:
	YYDEBUG(214, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy59;
	if (yych <= '-') goto yy398;
	if (yych <= '.') goto yy396;
	goto yy59;
yy215:
	YYDEBUG(215, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy243;
	if (yych == 'e') goto yy243;
	goto yy59;
yy216:
	YYDEBUG(216, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy244;
	if (yych == 'e') goto yy244;
	goto yy59;
yy217:
	YYDEBUG(217, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy256;
	if (yych == 'a') goto yy256;
	goto yy59;
yy218:
	YYDEBUG(218, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy399;
	if (yych == 'e') goto yy399;
	goto yy59;
yy219:
	YYDEBUG(219, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy177;
		if (yych <= '-') goto yy396;
		goto yy400;
	} else {
		if (yych <= '/') goto yy177;
		if (yych <= '9') goto yy222;
		if (yych <= ':') goto yy401;
		goto yy177;
	}
yy220:
	YYDEBUG(220, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') goto yy177;
		if (yych <= '-') goto yy396;
		if (yych <= '.') goto yy400;
		goto yy177;
	} else {
		if (yych <= '2') goto yy222;
		if (yych <= '9') goto yy239;
		if (yych <= ':') goto yy401;
		goto yy177;
	}
yy221:
	YYDEBUG(221, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy177;
		if (yych <= '-') goto yy396;
		goto yy400;
	} else {
		if (yych <= '/') goto yy177;
		if (yych <= '9') goto yy239;
		if (yych <= ':') goto yy401;
		goto yy177;
	}
yy222:
	YYDEBUG(222, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy177;
		if (yych <= '-') goto yy396;
		goto yy400;
	} else {
		if (yych == ':') goto yy401;
		goto yy177;
	}
yy223:
	YYDEBUG(223, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych >= '/') goto yy402;
		} else {
			if (yych <= '9') goto yy226;
			if (yych >= 'n') goto yy403;
		}
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy403;
		} else {
			if (yych <= 's') goto yy404;
			if (yych <= 't') goto yy405;
		}
	}
yy224:
	YYDEBUG(224, *YYCURSOR);
#line 1471 "ext/date/lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("americanshort | american");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_nr(&ptr, 2);
		s->time->d = timelib_get_nr(&ptr, 2);
		if (*ptr == '/') {
			s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
			TIMELIB_PROCESS_YEAR(s->time->y, length);
		}
		TIMELIB_DEINIT;
		return TIMELIB_AMERICAN;
	}
#line 6948 "<stdout>"
yy225:
	YYDEBUG(225, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych <= '.') goto yy224;
			goto yy402;
		} else {
			if (yych <= '1') goto yy226;
			if (yych <= 'm') goto yy224;
			goto yy403;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy224;
			goto yy403;
		} else {
			if (yych <= 's') goto yy404;
			if (yych <= 't') goto yy405;
			goto yy224;
		}
	}
yy226:
	YYDEBUG(226, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy402;
		if (yych <= 'm') goto yy224;
		goto yy403;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy224;
			goto yy403;
		} else {
			if (yych <= 's') goto yy404;
			if (yych <= 't') goto yy405;
			goto yy224;
		}
	}
yy227:
	YYDEBUG(227, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy406;
		if (yych <= 'T') goto yy59;
		goto yy407;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy59;
			goto yy406;
		} else {
			if (yych == 'u') goto yy407;
			goto yy59;
		}
	}
yy228:
	YYDEBUG(228, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy408;
	if (yych == 'e') goto yy408;
	goto yy59;
yy229:
	YYDEBUG(229, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy409;
	if (yych == 'e') goto yy409;
	goto yy59;
yy230:
	YYDEBUG(230, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy410;
		if (yych <= 'T') goto yy59;
		goto yy411;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy59;
			goto yy410;
		} else {
			if (yych == 'u') goto yy411;
			goto yy59;
		}
	}
yy231:
	YYDEBUG(231, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy412;
	if (yych == 'a') goto yy412;
	goto yy59;
yy232:
	YYDEBUG(232, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy413;
	if (yych == 'o') goto yy413;
	goto yy59;
yy233:
	YYDEBUG(233, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy414;
	if (yych == 'c') goto yy414;
	goto yy59;
yy234:
	YYDEBUG(234, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy415;
	if (yych == 'e') goto yy415;
	goto yy59;
yy235:
	YYDEBUG(235, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy207;
	if (yych <= '0') goto yy416;
	if (yych <= '1') goto yy417;
	if (yych <= '9') goto yy214;
	goto yy207;
yy236:
	YYDEBUG(236, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych == '-') goto yy418;
		if (yych <= '/') goto yy196;
		goto yy419;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy196;
			goto yy97;
		} else {
			if (yych == 0xE2) goto yy98;
			goto yy196;
		}
	}
yy237:
	YYDEBUG(237, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych == '-') goto yy418;
		if (yych <= '/') goto yy196;
		goto yy421;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy196;
			goto yy97;
		} else {
			if (yych == 0xE2) goto yy98;
			goto yy196;
		}
	}
yy238:
	YYDEBUG(238, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy401;
		goto yy177;
	} else {
		if (yych <= '9') goto yy239;
		if (yych <= ':') goto yy401;
		goto yy177;
	}
yy239:
	YYDEBUG(239, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy401;
	if (yych == ':') goto yy401;
	goto yy177;
yy240:
	YYDEBUG(240, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy423;
	if (yych == 'r') goto yy423;
	goto yy59;
yy241:
	YYDEBUG(241, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy424;
	if (yych == 'g') goto yy424;
	goto yy59;
yy242:
	YYDEBUG(242, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy425;
	if (yych == 'y') goto yy425;
	goto yy59;
yy243:
	YYDEBUG(243, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy426;
	if (yych == 'c') goto yy426;
	goto yy59;
yy244:
	YYDEBUG(244, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy427;
	if (yych == 'b') goto yy427;
	goto yy59;
yy245:
	YYDEBUG(245, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy428;
	if (yych == 'r') goto yy428;
	goto yy59;
yy246:
	YYDEBUG(246, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy429;
	if (yych == 'i') goto yy429;
	goto yy59;
yy247:
	YYDEBUG(247, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy430;
	if (yych == 'u') goto yy430;
	goto yy59;
yy248:
	YYDEBUG(248, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
	YYDEBUG(249, *YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy248;
		if (yych <= 0x1F) goto yy59;
		goto yy248;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy59;
			goto yy248;
		} else {
			if (yych <= '/') goto yy59;
			if (yych >= ':') goto yy59;
		}
	}
yy250:
	YYDEBUG(250, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy251;
	if (yych <= '9') goto yy431;
yy251:
	YYDEBUG(251, *YYCURSOR);
#line 1553 "ext/date/lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("datefull");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr(&ptr, 2);
		timelib_skip_day_suffix(&ptr);
		s->time->m = timelib_get_month(&ptr);
		s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL;
	}
#line 7205 "<stdout>"
yy252:
	YYDEBUG(252, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy81;
			goto yy248;
		} else {
			if (yych == ' ') goto yy248;
			goto yy81;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy248;
			if (yych <= '/') goto yy81;
			goto yy250;
		} else {
			if (yych != 'I') goto yy81;
		}
	}
yy253:
	YYDEBUG(253, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy248;
		if (yych <= 0x1F) goto yy81;
		goto yy248;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy81;
			goto yy248;
		} else {
			if (yych <= '/') goto yy81;
			if (yych <= '9') goto yy250;
			goto yy81;
		}
	}
yy254:
	YYDEBUG(254, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy432;
	if (yych == 'n') goto yy432;
	goto yy59;
yy255:
	YYDEBUG(255, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy433;
		if (yych <= 'M') goto yy59;
		goto yy434;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy59;
			goto yy433;
		} else {
			if (yych == 'n') goto yy434;
			goto yy59;
		}
	}
yy256:
	YYDEBUG(256, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy435;
		if (yych <= 'X') goto yy59;
		goto yy253;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy59;
			goto yy435;
		} else {
			if (yych == 'y') goto yy253;
			goto yy59;
		}
	}
yy257:
	YYDEBUG(257, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= 'K') {
			if (yych == 'C') goto yy436;
			goto yy59;
		} else {
			if (yych <= 'L') goto yy437;
			if (yych <= 'M') goto yy59;
			goto yy438;
		}
	} else {
		if (yych <= 'k') {
			if (yych == 'c') goto yy436;
			goto yy59;
		} else {
			if (yych <= 'l') goto yy437;
			if (yych == 'n') goto yy438;
			goto yy59;
		}
	}
yy258:
	YYDEBUG(258, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy439;
	if (yych == 'n') goto yy439;
	goto yy59;
yy259:
	YYDEBUG(259, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy440;
	if (yych == 'e') goto yy440;
yy260:
	YYDEBUG(260, *YYCURSOR);
#line 1958 "ext/date/lib/parse_date.re"
	{
		timelib_ull i;
		DEBUG_OUTPUT("relative");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_signed_nr(s, &ptr, 24);
			timelib_eat_spaces(&ptr);
			timelib_set_relative(&ptr, i, 1, s, TIMELIB_TIME_PART_KEEP);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 7334 "<stdout>"
yy261:
	YYDEBUG(261, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy426;
	if (yych == 'v') goto yy426;
	goto yy59;
yy262:
	YYDEBUG(262, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy441;
	if (yych == 't') goto yy441;
	goto yy59;
yy263:
	YYDEBUG(263, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy442;
	if (yych == 't') goto yy442;
	goto yy59;
yy264:
	YYDEBUG(264, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy443;
		if (yych <= 'O') goto yy59;
		goto yy444;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy59;
			goto yy443;
		} else {
			if (yych == 'p') goto yy444;
			goto yy59;
		}
	}
yy265:
	YYDEBUG(265, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy429;
	if (yych == 'n') goto yy429;
	goto yy59;
yy266:
	YYDEBUG(266, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy445;
	if (yych == 'u') goto yy445;
	goto yy59;
yy267:
	YYDEBUG(267, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy446;
	if (yych == 'e') goto yy446;
	goto yy59;
yy268:
	YYDEBUG(268, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy440;
	if (yych == 'e') goto yy440;
	goto yy59;
yy269:
	YYDEBUG(269, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy59;
		if (yych <= 'D') goto yy447;
		goto yy448;
	} else {
		if (yych <= 'c') goto yy59;
		if (yych <= 'd') goto yy447;
		if (yych <= 'e') goto yy448;
		goto yy59;
	}
yy270:
	YYDEBUG(270, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy430;
	if (yych == 'a') goto yy430;
	goto yy59;
yy271:
	YYDEBUG(271, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') {
		if (yych == '\t') goto yy287;
		goto yy207;
	} else {
		if (yych <= '-') goto yy449;
		if (yych <= '.') goto yy287;
		if (yych <= '/') goto yy280;
		goto yy207;
	}
yy272:
	YYDEBUG(272, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy207;
			goto yy287;
		} else {
			if (yych <= ',') goto yy207;
			if (yych <= '-') goto yy449;
			goto yy287;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= '/') goto yy280;
			if (yych <= 'T') goto yy207;
			goto yy445;
		} else {
			if (yych == 'u') goto yy445;
			goto yy207;
		}
	}
yy273:
	YYDEBUG(273, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
	if (yych <= 'c') {
		if (yych <= 'M') {
			if (yych <= 'F') {
				if (yych == 'D') goto yy198;
				if (yych <= 'E') goto yy59;
				goto yy199;
			} else {
				if (yych == 'H') goto yy79;
				if (yych <= 'L') goto yy59;
				goto yy200;
			}
		} else {
			if (yych <= 'U') {
				if (yych <= 'R') goto yy59;
				if (yych <= 'S') goto yy201;
				if (yych <= 'T') goto yy87;
				goto yy88;
			} else {
				if (yych <= 'W') {
					if (yych <= 'V') goto yy59;
					goto yy90;
				} else {
					if (yych == 'Y') goto yy92;
					goto yy59;
				}
			}
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'g') {
				if (yych <= 'd') goto yy198;
				if (yych == 'f') goto yy199;
				goto yy59;
			} else {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy79;
					goto yy59;
				} else {
					if (yych <= 'm') goto yy200;
					if (yych <= 'r') goto yy59;
					goto yy201;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') goto yy87;
				if (yych <= 'u') goto yy88;
				if (yych <= 'v') goto yy59;
				goto yy90;
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy59;
					goto yy92;
				} else {
					if (yych == 0xC2) goto yy97;
					goto yy59;
				}
			}
		}
	}
yy274:
	YYDEBUG(274, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy259;
	if (yych == 's') goto yy259;
	goto yy59;
yy275:
	YYDEBUG(275, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xAF) goto yy450;
	goto yy59;
yy276:
	YYDEBUG(276, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy177;
		if (yych <= '-') goto yy396;
		goto yy451;
	} else {
		if (yych <= '/') goto yy177;
		if (yych <= '9') goto yy452;
		if (yych <= ':') goto yy453;
		goto yy177;
	}
yy277:
	YYDEBUG(277, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') goto yy177;
		if (yych <= '-') goto yy396;
		if (yych <= '.') goto yy451;
		goto yy177;
	} else {
		if (yych <= '2') goto yy452;
		if (yych <= '9') goto yy454;
		if (yych <= ':') goto yy453;
		goto yy177;
	}
yy278:
	YYDEBUG(278, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy177;
		if (yych <= '-') goto yy396;
		goto yy451;
	} else {
		if (yych <= '/') goto yy177;
		if (yych <= '9') goto yy454;
		if (yych <= ':') goto yy453;
		goto yy177;
	}
yy279:
	YYDEBUG(279, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy177;
		if (yych <= '-') goto yy396;
		goto yy451;
	} else {
		if (yych == ':') goto yy453;
		goto yy177;
	}
yy280:
	YYDEBUG(280, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy227;
	case 'D':
	case 'd':	goto yy228;
	case 'F':
	case 'f':	goto yy229;
	case 'J':
	case 'j':	goto yy230;
	case 'M':
	case 'm':	goto yy231;
	case 'N':
	case 'n':	goto yy232;
	case 'O':
	case 'o':	goto yy233;
	case 'S':
	case 's':	goto yy234;
	default:	goto yy59;
	}
yy281:
	YYDEBUG(281, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy453;
		goto yy177;
	} else {
		if (yych <= '9') goto yy455;
		if (yych <= ':') goto yy453;
		goto yy177;
	}
yy282:
	YYDEBUG(282, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy453;
	if (yych == ':') goto yy453;
	goto yy177;
yy283:
	YYDEBUG(283, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy284;
	if (yych != 'm') goto yy59;
yy284:
	YYDEBUG(284, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy456;
		if (yych == '\t') goto yy456;
		goto yy59;
	} else {
		if (yych <= ' ') goto yy456;
		if (yych == '.') goto yy458;
		goto yy59;
	}
yy285:
	YYDEBUG(285, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
	if (yych <= '`') {
		if (yych <= 'M') {
			if (yych <= 'E') {
				if (yych <= 'A') {
					if (yych <= '@') goto yy59;
					goto yy106;
				} else {
					if (yych == 'D') goto yy198;
					goto yy59;
				}
			} else {
				if (yych <= 'G') {
					if (yych <= 'F') goto yy199;
					goto yy59;
				} else {
					if (yych <= 'H') goto yy79;
					if (yych <= 'L') goto yy59;
					goto yy200;
				}
			}
		} else {
			if (yych <= 'T') {
				if (yych <= 'P') {
					if (yych <= 'O') goto yy59;
					goto yy106;
				} else {
					if (yych <= 'R') goto yy59;
					if (yych <= 'S') goto yy201;
					goto yy87;
				}
			} else {
				if (yych <= 'W') {
					if (yych <= 'U') goto yy88;
					if (yych <= 'V') goto yy59;
					goto yy90;
				} else {
					if (yych == 'Y') goto yy92;
					goto yy59;
				}
			}
		}
	} else {
		if (yych <= 'p') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'a') goto yy106;
					goto yy59;
				} else {
					if (yych <= 'd') goto yy198;
					if (yych <= 'e') goto yy59;
					goto yy199;
				}
			} else {
				if (yych <= 'l') {
					if (yych == 'h') goto yy79;
					goto yy59;
				} else {
					if (yych <= 'm') goto yy200;
					if (yych <= 'o') goto yy59;
					goto yy106;
				}
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 's') {
					if (yych <= 'r') goto yy59;
					goto yy201;
				} else {
					if (yych <= 't') goto yy87;
					if (yych <= 'u') goto yy88;
					goto yy59;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'w') goto yy90;
					if (yych <= 'x') goto yy59;
					goto yy92;
				} else {
					if (yych == 0xC2) goto yy107;
					goto yy59;
				}
			}
		}
	}
yy286:
	YYDEBUG(286, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xAF) goto yy459;
	goto yy59;
yy287:
	YYDEBUG(287, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy207;
	if (yych <= '0') goto yy208;
	if (yych <= '1') goto yy209;
	if (yych <= '9') goto yy210;
	goto yy207;
yy288:
	YYDEBUG(288, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy460;
	case '1':	goto yy461;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy462;
	case 'A':
	case 'a':	goto yy463;
	case 'D':
	case 'd':	goto yy464;
	case 'F':
	case 'f':	goto yy465;
	case 'J':
	case 'j':	goto yy466;
	case 'M':
	case 'm':	goto yy467;
	case 'N':
	case 'n':	goto yy468;
	case 'O':
	case 'o':	goto yy469;
	case 'S':
	case 's':	goto yy470;
	default:	goto yy59;
	}
yy289:
	YYDEBUG(289, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy290;
	if (yych <= '9') goto yy471;
yy290:
	YYDEBUG(290, *YYCURSOR);
#line 1237 "ext/date/lib/parse_date.re"
	{
		timelib_sll i;
		timelib_ull us;
		const char *ptr_before;
		bool is_negative;

		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_DATE();
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TZ();

		is_negative = *(ptr + 1) == '-';

		i = timelib_get_signed_nr(s, &ptr, 24);

		ptr_before = ptr;
		us = timelib_get_signed_nr(s, &ptr, 6);
		us = us * pow(10, 7 - (ptr - ptr_before));
		if (is_negative) {
			us *= -1;
		}

		s->time->y = 1970;
		s->time->m = 1;
		s->time->d = 1;
		s->time->h = s->time->i = s->time->s = 0;
		s->time->us = 0;
		s->time->relative.s += i;
		s->time->relative.us = us;
		s->time->is_localtime = 1;
		s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
		s->time->z = 0;
		s->time->dst = 0;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 7819 "<stdout>"
yy291:
	YYDEBUG(291, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy115;
		goto yy20;
	} else {
		if (yych <= 'Z') goto yy472;
		if (yych <= '`') goto yy20;
		if (yych <= 'z') goto yy472;
		goto yy20;
	}
yy292:
	YYDEBUG(292, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy115;
	} else {
		if (yych <= 'Z') goto yy472;
		if (yych <= '`') goto yy293;
		if (yych <= 'z') goto yy472;
	}
yy293:
	YYDEBUG(293, *YYCURSOR);
#line 1799 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("ago");
		TIMELIB_INIT;
		s->time->relative.y = 0 - s->time->relative.y;
		s->time->relative.m = 0 - s->time->relative.m;
		s->time->relative.d = 0 - s->time->relative.d;
		s->time->relative.h = 0 - s->time->relative.h;
		s->time->relative.i = 0 - s->time->relative.i;
		s->time->relative.s = 0 - s->time->relative.s;
		s->time->relative.weekday = 0 - s->time->relative.weekday;
		if (s->time->relative.weekday == 0) {
			s->time->relative.weekday = -7;
		}
		if (s->time->relative.have_special_relative && s->time->relative.special.type == TIMELIB_SPECIAL_WEEKDAY) {
			s->time->relative.special.amount = 0 - s->time->relative.special.amount;
		}
		TIMELIB_DEINIT;
		return TIMELIB_AGO;
	}
#line 7864 "<stdout>"
yy294:
	YYDEBUG(294, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych >= '\t') goto yy142;
			} else {
				if (yych == ' ') goto yy142;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy115;
			} else {
				if (yych <= '-') goto yy473;
				if (yych <= '.') goto yy142;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy142;
			} else {
				if (yych == 'I') goto yy474;
				goto yy472;
			}
		} else {
			if (yych <= 'h') {
				if (yych >= 'a') goto yy472;
			} else {
				if (yych <= 'i') goto yy474;
				if (yych <= 'z') goto yy472;
			}
		}
	}
yy295:
	YYDEBUG(295, *YYCURSOR);
#line 1879 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("monthtext");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_lookup_month(&ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 7912 "<stdout>"
yy296:
	YYDEBUG(296, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy295;
				goto yy142;
			} else {
				if (yych == ' ') goto yy142;
				goto yy295;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy115;
				goto yy295;
			} else {
				if (yych <= '-') goto yy473;
				if (yych <= '.') goto yy142;
				goto yy295;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy142;
				goto yy295;
			} else {
				if (yych == 'U') goto yy475;
				goto yy472;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy295;
				goto yy472;
			} else {
				if (yych <= 'u') goto yy475;
				if (yych <= 'z') goto yy472;
				goto yy295;
			}
		}
	}
yy297:
	YYDEBUG(297, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 64) {
		goto yy476;
	}
	goto yy59;
yy298:
	YYDEBUG(298, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy115;
			goto yy20;
		} else {
			if (yych == '.') goto yy20;
			goto yy297;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy20;
			if (yych <= 'Z') goto yy472;
			goto yy20;
		} else {
			if (yych <= '_') goto yy297;
			if (yych <= '`') goto yy20;
			if (yych <= 'z') goto yy478;
			goto yy20;
		}
	}
yy299:
	YYDEBUG(299, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy115;
			goto yy293;
		} else {
			if (yych == '.') goto yy293;
			goto yy297;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy293;
			if (yych <= 'Z') goto yy472;
			goto yy293;
		} else {
			if (yych <= '_') goto yy297;
			if (yych <= '`') goto yy293;
			if (yych <= 'z') goto yy478;
			goto yy293;
		}
	}
yy300:
	YYDEBUG(300, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy295;
				goto yy142;
			} else {
				if (yych == ' ') goto yy142;
				goto yy295;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy115;
				if (yych <= ',') goto yy295;
				goto yy479;
			} else {
				if (yych == '/') goto yy297;
				goto yy142;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'H') {
				if (yych <= '@') goto yy295;
				goto yy472;
			} else {
				if (yych <= 'I') goto yy474;
				if (yych <= 'Z') goto yy472;
				goto yy295;
			}
		} else {
			if (yych <= 'h') {
				if (yych <= '_') goto yy297;
				if (yych <= '`') goto yy295;
				goto yy478;
			} else {
				if (yych <= 'i') goto yy480;
				if (yych <= 'z') goto yy478;
				goto yy295;
			}
		}
	}
yy301:
	YYDEBUG(301, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy295;
				goto yy142;
			} else {
				if (yych == ' ') goto yy142;
				goto yy295;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy115;
				if (yych <= ',') goto yy295;
				goto yy479;
			} else {
				if (yych == '/') goto yy297;
				goto yy142;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'T') {
				if (yych <= '@') goto yy295;
				goto yy472;
			} else {
				if (yych <= 'U') goto yy475;
				if (yych <= 'Z') goto yy472;
				goto yy295;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '_') goto yy297;
				if (yych <= '`') goto yy295;
				goto yy478;
			} else {
				if (yych <= 'u') goto yy481;
				if (yych <= 'z') goto yy478;
				goto yy295;
			}
		}
	}
yy302:
	YYDEBUG(302, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'K') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'J') goto yy472;
			goto yy482;
		}
	} else {
		if (yych <= 'j') {
			if (yych <= 'Z') goto yy472;
			if (yych <= '`') goto yy20;
			goto yy472;
		} else {
			if (yych <= 'k') goto yy482;
			if (yych <= 'z') goto yy472;
			goto yy20;
		}
	}
yy303:
	YYDEBUG(303, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'J') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy472;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'K') goto yy482;
			if (yych <= 'Z') goto yy472;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'j') {
				if (yych <= '`') goto yy20;
				goto yy478;
			} else {
				if (yych <= 'k') goto yy483;
				if (yych <= 'z') goto yy478;
				goto yy20;
			}
		}
	}
yy304:
	YYDEBUG(304, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy295;
				goto yy142;
			} else {
				if (yych == ' ') goto yy142;
				goto yy295;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy115;
				goto yy295;
			} else {
				if (yych <= '-') goto yy473;
				if (yych <= '.') goto yy142;
				goto yy295;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy142;
				goto yy295;
			} else {
				if (yych == 'E') goto yy484;
				goto yy472;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy295;
				goto yy472;
			} else {
				if (yych <= 'e') goto yy484;
				if (yych <= 'z') goto yy472;
				goto yy295;
			}
		}
	}
yy305:
	YYDEBUG(305, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy295;
				goto yy142;
			} else {
				if (yych == ' ') goto yy142;
				goto yy295;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy115;
				if (yych <= ',') goto yy295;
				goto yy479;
			} else {
				if (yych == '/') goto yy297;
				goto yy142;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy295;
				goto yy472;
			} else {
				if (yych <= 'E') goto yy484;
				if (yych <= 'Z') goto yy472;
				goto yy295;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy297;
				if (yych <= '`') goto yy295;
				goto yy478;
			} else {
				if (yych <= 'e') goto yy485;
				if (yych <= 'z') goto yy478;
				goto yy295;
			}
		}
	}
yy306:
	YYDEBUG(306, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'G') goto yy472;
			goto yy486;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy472;
			if (yych <= '`') goto yy20;
			goto yy472;
		} else {
			if (yych <= 'h') goto yy486;
			if (yych <= 'z') goto yy472;
			goto yy20;
		}
	}
yy307:
	YYDEBUG(307, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'U') goto yy472;
			goto yy487;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy472;
			if (yych <= '`') goto yy20;
			goto yy472;
		} else {
			if (yych <= 'v') goto yy487;
			if (yych <= 'z') goto yy472;
			goto yy20;
		}
	}
yy308:
	YYDEBUG(308, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy472;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy486;
			if (yych <= 'Z') goto yy472;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy20;
				goto yy478;
			} else {
				if (yych <= 'h') goto yy488;
				if (yych <= 'z') goto yy478;
				goto yy20;
			}
		}
	}
yy309:
	YYDEBUG(309, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy472;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'V') goto yy487;
			if (yych <= 'Z') goto yy472;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'u') {
				if (yych <= '`') goto yy20;
				goto yy478;
			} else {
				if (yych <= 'v') goto yy489;
				if (yych <= 'z') goto yy478;
				goto yy20;
			}
		}
	}
yy310:
	YYDEBUG(310, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy295;
				goto yy142;
			} else {
				if (yych == ' ') goto yy142;
				goto yy295;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy115;
				goto yy295;
			} else {
				if (yych <= '-') goto yy473;
				if (yych <= '.') goto yy142;
				goto yy295;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy142;
				goto yy295;
			} else {
				if (yych == 'R') goto yy490;
				goto yy472;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy295;
				goto yy472;
			} else {
				if (yych <= 'r') goto yy490;
				if (yych <= 'z') goto yy472;
				goto yy295;
			}
		}
	}
yy311:
	YYDEBUG(311, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'S') goto yy472;
			goto yy491;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy472;
			if (yych <= '`') goto yy20;
			goto yy472;
		} else {
			if (yych <= 't') goto yy491;
			if (yych <= 'z') goto yy472;
			goto yy20;
		}
	}
yy312:
	YYDEBUG(312, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'R') goto yy472;
			goto yy492;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy472;
			if (yych <= '`') goto yy20;
			goto yy472;
		} else {
			if (yych <= 's') goto yy492;
			if (yych <= 'z') goto yy472;
			goto yy20;
		}
	}
yy313:
	YYDEBUG(313, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'Q') goto yy472;
			goto yy493;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy472;
			if (yych <= '`') goto yy20;
			goto yy472;
		} else {
			if (yych <= 'r') goto yy493;
			if (yych <= 'z') goto yy472;
			goto yy20;
		}
	}
yy314:
	YYDEBUG(314, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych >= ')') goto yy115;
		} else {
			if (yych <= '@') goto yy315;
			if (yych <= 'C') goto yy472;
			goto yy494;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy472;
			if (yych >= 'a') goto yy472;
		} else {
			if (yych <= 'd') goto yy494;
			if (yych <= 'z') goto yy472;
		}
	}
yy315:
	YYDEBUG(315, *YYCURSOR);
#line 1820 "ext/date/lib/parse_date.re"
	{
		const timelib_relunit* relunit;
		DEBUG_OUTPUT("daytext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_WEEKDAY_RELATIVE();
		TIMELIB_UNHAVE_TIME();
		relunit = timelib_lookup_relunit(&ptr);
		s->time->relative.weekday = relunit->multiplier;
		if (s->time->relative.weekday_behavior != 2) {
			s->time->relative.weekday_behavior = 1;
		}

		TIMELIB_DEINIT;
		return TIMELIB_WEEKDAY;
	}
#line 8504 "<stdout>"
yy316:
	YYDEBUG(316, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'M') goto yy472;
			goto yy495;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy472;
			if (yych <= '`') goto yy20;
			goto yy472;
		} else {
			if (yych <= 'n') goto yy495;
			if (yych <= 'z') goto yy472;
			goto yy20;
		}
	}
yy317:
	YYDEBUG(317, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy295;
				goto yy142;
			} else {
				if (yych == ' ') goto yy142;
				goto yy295;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy115;
				if (yych <= ',') goto yy295;
				goto yy479;
			} else {
				if (yych == '/') goto yy297;
				goto yy142;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'Q') {
				if (yych <= '@') goto yy295;
				goto yy472;
			} else {
				if (yych <= 'R') goto yy490;
				if (yych <= 'Z') goto yy472;
				goto yy295;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '_') goto yy297;
				if (yych <= '`') goto yy295;
				goto yy478;
			} else {
				if (yych <= 'r') goto yy496;
				if (yych <= 'z') goto yy478;
				goto yy295;
			}
		}
	}
yy318:
	YYDEBUG(318, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy472;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy491;
			if (yych <= 'Z') goto yy472;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy20;
				goto yy478;
			} else {
				if (yych <= 't') goto yy497;
				if (yych <= 'z') goto yy478;
				goto yy20;
			}
		}
	}
yy319:
	YYDEBUG(319, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy472;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy492;
			if (yych <= 'Z') goto yy472;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy20;
				goto yy478;
			} else {
				if (yych <= 's') goto yy498;
				if (yych <= 'z') goto yy478;
				goto yy20;
			}
		}
	}
yy320:
	YYDEBUG(320, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy472;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy493;
			if (yych <= 'Z') goto yy472;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy20;
				goto yy478;
			} else {
				if (yych <= 'r') goto yy499;
				if (yych <= 'z') goto yy478;
				goto yy20;
			}
		}
	}
yy321:
	YYDEBUG(321, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy315;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy315;
			goto yy472;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy494;
			if (yych <= 'Z') goto yy472;
			if (yych <= '^') goto yy315;
			goto yy297;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy315;
				goto yy478;
			} else {
				if (yych <= 'd') goto yy500;
				if (yych <= 'z') goto yy478;
				goto yy315;
			}
		}
	}
yy322:
	YYDEBUG(322, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy472;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy495;
			if (yych <= 'Z') goto yy472;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy20;
				goto yy478;
			} else {
				if (yych <= 'n') goto yy501;
				if (yych <= 'z') goto yy478;
				goto yy20;
			}
		}
	}
yy323:
	YYDEBUG(323, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych == '+') goto yy502;
			goto yy20;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '-') goto yy502;
			if (yych <= '@') goto yy20;
			goto yy472;
		} else {
			if (yych <= '`') goto yy20;
			if (yych <= 'z') goto yy472;
			goto yy20;
		}
	}
yy324:
	YYDEBUG(324, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '0') {
			if (yych >= '0') goto yy503;
		} else {
			if (yych <= '1') goto yy504;
			if (yych <= '2') goto yy505;
			goto yy506;
		}
	} else {
		if (yych <= 'T') {
			if (yych >= 'T') goto yy507;
		} else {
			if (yych == 't') goto yy507;
		}
	}
yy325:
	YYDEBUG(325, *YYCURSOR);
#line 1622 "ext/date/lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("datetextual | datenoyear");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month(&ptr);
		s->time->d = timelib_get_nr(&ptr, 2);
		s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 8785 "<stdout>"
yy326:
	YYDEBUG(326, *YYCURSOR);
	yyaccept = 10;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 21) YYFILL(21);
	yych = *YYCURSOR;
yy327:
	YYDEBUG(327, *YYCURSOR);
	if (yybm[0+yych] & 32) {
		goto yy326;
	}
	if (yych <= '2') {
		if (yych <= '/') goto yy325;
		if (yych <= '0') goto yy508;
		if (yych <= '1') goto yy509;
		goto yy510;
	} else {
		if (yych <= '9') goto yy511;
		if (yych == 'T') goto yy507;
		goto yy325;
	}
yy328:
	YYDEBUG(328, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy324;
				goto yy59;
			} else {
				if (yych <= '\t') goto yy326;
				if (yych <= 0x1F) goto yy59;
				goto yy326;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy326;
				goto yy59;
			} else {
				if (yych <= '.') goto yy326;
				if (yych <= '/') goto yy59;
				goto yy512;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy59;
				goto yy326;
			} else {
				if (yych == 'h') goto yy326;
				goto yy59;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy329;
				if (yych <= 'q') goto yy59;
			} else {
				if (yych <= 's') goto yy330;
				if (yych <= 't') goto yy331;
				goto yy59;
			}
		}
	}
yy329:
	YYDEBUG(329, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'd') goto yy513;
	goto yy327;
yy330:
	YYDEBUG(330, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 't') goto yy513;
	goto yy327;
yy331:
	YYDEBUG(331, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'h') goto yy513;
	goto yy327;
yy332:
	YYDEBUG(332, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy512;
	goto yy59;
yy333:
	YYDEBUG(333, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy142;
			goto yy20;
		} else {
			if (yych <= ' ') goto yy142;
			if (yych == ')') goto yy115;
			goto yy20;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy20;
			if (yych <= '9') goto yy142;
			goto yy20;
		} else {
			if (yych <= 'Z') goto yy472;
			if (yych <= '`') goto yy20;
			if (yych <= 'z') goto yy472;
			goto yy20;
		}
	}
yy334:
	YYDEBUG(334, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy295;
				goto yy142;
			} else {
				if (yych == ' ') goto yy142;
				goto yy295;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy115;
				goto yy295;
			} else {
				if (yych <= '-') goto yy473;
				if (yych <= '.') goto yy142;
				goto yy295;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy142;
				goto yy295;
			} else {
				if (yych == 'U') goto yy514;
				goto yy472;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy295;
				goto yy472;
			} else {
				if (yych <= 'u') goto yy514;
				if (yych <= 'z') goto yy472;
				goto yy295;
			}
		}
	}
yy335:
	YYDEBUG(335, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy295;
				goto yy142;
			} else {
				if (yych == ' ') goto yy142;
				goto yy295;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy115;
				goto yy295;
			} else {
				if (yych <= '-') goto yy473;
				if (yych <= '.') goto yy142;
				goto yy295;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy142;
				goto yy295;
			} else {
				if (yych == 'Y') goto yy515;
				goto yy472;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy295;
				goto yy472;
			} else {
				if (yych <= 'y') goto yy515;
				if (yych <= 'z') goto yy472;
				goto yy295;
			}
		}
	}
yy336:
	YYDEBUG(336, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy295;
				goto yy142;
			} else {
				if (yych == ' ') goto yy142;
				goto yy295;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy115;
				goto yy295;
			} else {
				if (yych <= '-') goto yy473;
				if (yych <= '.') goto yy142;
				goto yy295;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy142;
				goto yy295;
			} else {
				if (yych == 'E') goto yy515;
				goto yy472;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy295;
				goto yy472;
			} else {
				if (yych <= 'e') goto yy515;
				if (yych <= 'z') goto yy472;
				goto yy295;
			}
		}
	}
yy337:
	YYDEBUG(337, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy295;
				goto yy142;
			} else {
				if (yych == ' ') goto yy142;
				goto yy295;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy115;
				if (yych <= ',') goto yy295;
				goto yy479;
			} else {
				if (yych == '/') goto yy297;
				goto yy142;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'T') {
				if (yych <= '@') goto yy295;
				goto yy472;
			} else {
				if (yych <= 'U') goto yy514;
				if (yych <= 'Z') goto yy472;
				goto yy295;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '_') goto yy297;
				if (yych <= '`') goto yy295;
				goto yy478;
			} else {
				if (yych <= 'u') goto yy516;
				if (yych <= 'z') goto yy478;
				goto yy295;
			}
		}
	}
yy338:
	YYDEBUG(338, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy295;
				goto yy142;
			} else {
				if (yych == ' ') goto yy142;
				goto yy295;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy115;
				if (yych <= ',') goto yy295;
				goto yy479;
			} else {
				if (yych == '/') goto yy297;
				goto yy142;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'X') {
				if (yych <= '@') goto yy295;
				goto yy472;
			} else {
				if (yych <= 'Y') goto yy515;
				if (yych <= 'Z') goto yy472;
				goto yy295;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '_') goto yy297;
				if (yych <= '`') goto yy295;
				goto yy478;
			} else {
				if (yych <= 'y') goto yy517;
				if (yych <= 'z') goto yy478;
				goto yy295;
			}
		}
	}
yy339:
	YYDEBUG(339, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy295;
				goto yy142;
			} else {
				if (yych == ' ') goto yy142;
				goto yy295;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy115;
				if (yych <= ',') goto yy295;
				goto yy479;
			} else {
				if (yych == '/') goto yy297;
				goto yy142;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy295;
				goto yy472;
			} else {
				if (yych <= 'E') goto yy515;
				if (yych <= 'Z') goto yy472;
				goto yy295;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy297;
				if (yych <= '`') goto yy295;
				goto yy478;
			} else {
				if (yych <= 'e') goto yy517;
				if (yych <= 'z') goto yy478;
				goto yy295;
			}
		}
	}
yy340:
	YYDEBUG(340, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'S') goto yy472;
			goto yy518;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy472;
			if (yych <= '`') goto yy20;
			goto yy472;
		} else {
			if (yych <= 't') goto yy518;
			if (yych <= 'z') goto yy472;
			goto yy20;
		}
	}
yy341:
	YYDEBUG(341, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy472;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy518;
			if (yych <= 'Z') goto yy472;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy20;
				goto yy478;
			} else {
				if (yych <= 't') goto yy519;
				if (yych <= 'z') goto yy478;
				goto yy20;
			}
		}
	}
yy342:
	YYDEBUG(342, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy295;
				goto yy142;
			} else {
				if (yych == ' ') goto yy142;
				goto yy295;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy115;
				goto yy295;
			} else {
				if (yych <= '-') goto yy473;
				if (yych <= '.') goto yy142;
				goto yy295;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy142;
				goto yy295;
			} else {
				if (yych == 'C') goto yy520;
				goto yy472;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy295;
				goto yy472;
			} else {
				if (yych <= 'c') goto yy520;
				if (yych <= 'z') goto yy472;
				goto yy295;
			}
		}
	}
yy343:
	YYDEBUG(343, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy142;
			if (yych <= 0x1F) goto yy295;
			goto yy142;
		} else {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy295;
			goto yy473;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy295;
			if (yych <= '9') goto yy142;
			goto yy295;
		} else {
			if (yych <= 'Z') goto yy472;
			if (yych <= '`') goto yy295;
			if (yych <= 'z') goto yy472;
			goto yy295;
		}
	}
yy344:
	YYDEBUG(344, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'M') goto yy472;
			goto yy521;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy472;
			if (yych <= '`') goto yy20;
			goto yy472;
		} else {
			if (yych <= 'n') goto yy521;
			if (yych <= 'z') goto yy472;
			goto yy20;
		}
	}
yy345:
	YYDEBUG(345, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy295;
				goto yy142;
			} else {
				if (yych == ' ') goto yy142;
				goto yy295;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy115;
				if (yych <= ',') goto yy295;
				goto yy479;
			} else {
				if (yych == '/') goto yy297;
				goto yy142;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'B') {
				if (yych <= '@') goto yy295;
				goto yy472;
			} else {
				if (yych <= 'C') goto yy520;
				if (yych <= 'Z') goto yy472;
				goto yy295;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '_') goto yy297;
				if (yych <= '`') goto yy295;
				goto yy478;
			} else {
				if (yych <= 'c') goto yy522;
				if (yych <= 'z') goto yy478;
				goto yy295;
			}
		}
	}
yy346:
	YYDEBUG(346, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy142;
			if (yych <= 0x1F) goto yy295;
			goto yy142;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy295;
				goto yy115;
			} else {
				if (yych <= ',') goto yy295;
				if (yych <= '-') goto yy479;
				goto yy142;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy297;
			if (yych <= '9') goto yy142;
			if (yych <= '@') goto yy295;
			goto yy472;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy295;
				goto yy297;
			} else {
				if (yych <= '`') goto yy295;
				if (yych <= 'z') goto yy478;
				goto yy295;
			}
		}
	}
yy347:
	YYDEBUG(347, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy472;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy521;
			if (yych <= 'Z') goto yy472;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy20;
				goto yy478;
			} else {
				if (yych <= 'n') goto yy523;
				if (yych <= 'z') goto yy478;
				goto yy20;
			}
		}
	}
yy348:
	YYDEBUG(348, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'S') goto yy472;
			goto yy524;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy472;
			if (yych <= '`') goto yy20;
			goto yy472;
		} else {
			if (yych <= 't') goto yy524;
			if (yych <= 'z') goto yy472;
			goto yy20;
		}
	}
yy349:
	YYDEBUG(349, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'M') goto yy472;
			goto yy525;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy472;
			if (yych <= '`') goto yy20;
			goto yy472;
		} else {
			if (yych <= 'n') goto yy525;
			if (yych <= 'z') goto yy472;
			goto yy20;
		}
	}
yy350:
	YYDEBUG(350, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy115;
	} else {
		if (yych <= 'Z') goto yy472;
		if (yych <= '`') goto yy351;
		if (yych <= 'z') goto yy472;
	}
yy351:
	YYDEBUG(351, *YYCURSOR);
#line 1168 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("now");
		TIMELIB_INIT;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 9487 "<stdout>"
yy352:
	YYDEBUG(352, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy472;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy524;
			if (yych <= 'Z') goto yy472;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy20;
				goto yy478;
			} else {
				if (yych <= 't') goto yy527;
				if (yych <= 'z') goto yy478;
				goto yy20;
			}
		}
	}
yy353:
	YYDEBUG(353, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy472;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy525;
			if (yych <= 'Z') goto yy472;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy20;
				goto yy478;
			} else {
				if (yych <= 'n') goto yy528;
				if (yych <= 'z') goto yy478;
				goto yy20;
			}
		}
	}
yy354:
	YYDEBUG(354, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy115;
			goto yy351;
		} else {
			if (yych == '.') goto yy351;
			goto yy297;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy351;
			if (yych <= 'Z') goto yy472;
			goto yy351;
		} else {
			if (yych <= '_') goto yy297;
			if (yych <= '`') goto yy351;
			if (yych <= 'z') goto yy478;
			goto yy351;
		}
	}
yy355:
	YYDEBUG(355, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy295;
				goto yy142;
			} else {
				if (yych == ' ') goto yy142;
				goto yy295;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy115;
				goto yy295;
			} else {
				if (yych <= '-') goto yy473;
				if (yych <= '.') goto yy142;
				goto yy295;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy142;
				goto yy295;
			} else {
				if (yych == 'O') goto yy529;
				goto yy472;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy295;
				goto yy472;
			} else {
				if (yych <= 'o') goto yy529;
				if (yych <= 'z') goto yy472;
				goto yy295;
			}
		}
	}
yy356:
	YYDEBUG(356, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy295;
				goto yy142;
			} else {
				if (yych == ' ') goto yy142;
				goto yy295;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy115;
				if (yych <= ',') goto yy295;
				goto yy479;
			} else {
				if (yych == '/') goto yy297;
				goto yy142;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'N') {
				if (yych <= '@') goto yy295;
				goto yy472;
			} else {
				if (yych <= 'O') goto yy529;
				if (yych <= 'Z') goto yy472;
				goto yy295;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '_') goto yy297;
				if (yych <= '`') goto yy295;
				goto yy478;
			} else {
				if (yych <= 'o') goto yy530;
				if (yych <= 'z') goto yy478;
				goto yy295;
			}
		}
	}
yy357:
	YYDEBUG(357, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'U') goto yy472;
			goto yy531;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy472;
			if (yych <= '`') goto yy20;
			goto yy472;
		} else {
			if (yych <= 'v') goto yy531;
			if (yych <= 'z') goto yy472;
			goto yy20;
		}
	}
yy358:
	YYDEBUG(358, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy472;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'V') goto yy531;
			if (yych <= 'Z') goto yy472;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'u') {
				if (yych <= '`') goto yy20;
				goto yy478;
			} else {
				if (yych <= 'v') goto yy532;
				if (yych <= 'z') goto yy478;
				goto yy20;
			}
		}
	}
yy359:
	YYDEBUG(359, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy315;
			goto yy115;
		} else {
			if (yych <= '@') goto yy315;
			if (yych <= 'T') goto yy472;
			goto yy533;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy472;
			if (yych <= '`') goto yy315;
			goto yy472;
		} else {
			if (yych <= 'u') goto yy533;
			if (yych <= 'z') goto yy472;
			goto yy315;
		}
	}
yy360:
	YYDEBUG(360, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'N') goto yy472;
			goto yy534;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy472;
			if (yych <= '`') goto yy20;
			goto yy472;
		} else {
			if (yych <= 'o') goto yy534;
			if (yych <= 'z') goto yy472;
			goto yy20;
		}
	}
yy361:
	YYDEBUG(361, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy295;
				goto yy142;
			} else {
				if (yych == ' ') goto yy142;
				goto yy295;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy115;
				goto yy295;
			} else {
				if (yych <= '-') goto yy473;
				if (yych <= '.') goto yy142;
				goto yy295;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy142;
				goto yy295;
			} else {
				if (yych == 'T') goto yy535;
				goto yy472;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy295;
				goto yy472;
			} else {
				if (yych <= 't') goto yy535;
				if (yych <= 'z') goto yy472;
				goto yy295;
			}
		}
	}
yy362:
	YYDEBUG(362, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'D') goto yy472;
			goto yy536;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy472;
			if (yych <= '`') goto yy20;
			goto yy472;
		} else {
			if (yych <= 'e') goto yy536;
			if (yych <= 'z') goto yy472;
			goto yy20;
		}
	}
yy363:
	YYDEBUG(363, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy315;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy315;
			goto yy472;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy533;
			if (yych <= 'Z') goto yy472;
			if (yych <= '^') goto yy315;
			goto yy297;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy315;
				goto yy478;
			} else {
				if (yych <= 'u') goto yy537;
				if (yych <= 'z') goto yy478;
				goto yy315;
			}
		}
	}
yy364:
	YYDEBUG(364, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy472;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy534;
			if (yych <= 'Z') goto yy472;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy20;
				goto yy478;
			} else {
				if (yych <= 'o') goto yy538;
				if (yych <= 'z') goto yy478;
				goto yy20;
			}
		}
	}
yy365:
	YYDEBUG(365, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy295;
				goto yy142;
			} else {
				if (yych == ' ') goto yy142;
				goto yy295;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy115;
				if (yych <= ',') goto yy295;
				goto yy479;
			} else {
				if (yych == '/') goto yy297;
				goto yy142;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'S') {
				if (yych <= '@') goto yy295;
				goto yy472;
			} else {
				if (yych <= 'T') goto yy535;
				if (yych <= 'Z') goto yy472;
				goto yy295;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '_') goto yy297;
				if (yych <= '`') goto yy295;
				goto yy478;
			} else {
				if (yych <= 't') goto yy539;
				if (yych <= 'z') goto yy478;
				goto yy295;
			}
		}
	}
yy366:
	YYDEBUG(366, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy472;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy536;
			if (yych <= 'Z') goto yy472;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy20;
				goto yy478;
			} else {
				if (yych <= 'e') goto yy540;
				if (yych <= 'z') goto yy478;
				goto yy20;
			}
		}
	}
yy367:
	YYDEBUG(367, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy75;
		goto yy177;
	} else {
		if (yych <= '5') goto yy541;
		if (yych == ':') goto yy75;
		goto yy177;
	}
yy368:
	YYDEBUG(368, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= '@') {
			if (yych == ')') goto yy115;
			goto yy20;
		} else {
			if (yych <= 'Q') goto yy472;
			if (yych <= 'R') goto yy542;
			goto yy524;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy472;
			if (yych <= '`') goto yy20;
			goto yy472;
		} else {
			if (yych <= 'r') goto yy542;
			if (yych <= 's') goto yy524;
			if (yych <= 'z') goto yy472;
			goto yy20;
		}
	}
yy369:
	YYDEBUG(369, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy315;
			goto yy115;
		} else {
			if (yych <= '@') goto yy315;
			if (yych <= 'Q') goto yy472;
			goto yy543;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy472;
			if (yych <= '`') goto yy315;
			goto yy472;
		} else {
			if (yych <= 'r') goto yy543;
			if (yych <= 'z') goto yy472;
			goto yy315;
		}
	}
yy370:
	YYDEBUG(370, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy115;
		if (yych <= '@') goto yy20;
		goto yy544;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy472;
			goto yy20;
		} else {
			if (yych <= 'a') goto yy544;
			if (yych <= 'z') goto yy472;
			goto yy20;
		}
	}
yy371:
	YYDEBUG(371, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'N') goto yy472;
			goto yy545;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy472;
			if (yych <= '`') goto yy20;
			goto yy472;
		} else {
			if (yych <= 'o') goto yy545;
			if (yych <= 'z') goto yy472;
			goto yy20;
		}
	}
yy372:
	YYDEBUG(372, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy315;
			goto yy115;
		} else {
			if (yych <= '@') goto yy315;
			if (yych <= 'R') goto yy472;
			goto yy546;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy472;
			if (yych <= '`') goto yy315;
			goto yy472;
		} else {
			if (yych <= 's') goto yy546;
			if (yych <= 'z') goto yy472;
			goto yy315;
		}
	}
yy373:
	YYDEBUG(373, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'K') goto yy472;
			goto yy547;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy472;
			if (yych <= '`') goto yy20;
			goto yy472;
		} else {
			if (yych <= 'l') goto yy547;
			if (yych <= 'z') goto yy472;
			goto yy20;
		}
	}
yy374:
	YYDEBUG(374, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych <= '/') {
				if (yych <= '.') goto yy20;
				goto yy297;
			} else {
				if (yych <= '@') goto yy20;
				if (yych <= 'Q') goto yy472;
				goto yy542;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'S') goto yy524;
				goto yy472;
			} else {
				if (yych == '_') goto yy297;
				goto yy20;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy478;
				goto yy548;
			} else {
				if (yych <= 's') goto yy527;
				if (yych <= 'z') goto yy478;
				goto yy20;
			}
		}
	}
yy375:
	YYDEBUG(375, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy315;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy315;
			goto yy472;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy543;
			if (yych <= 'Z') goto yy472;
			if (yych <= '^') goto yy315;
			goto yy297;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy315;
				goto yy478;
			} else {
				if (yych <= 'r') goto yy549;
				if (yych <= 'z') goto yy478;
				goto yy315;
			}
		}
	}
yy376:
	YYDEBUG(376, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy115;
			goto yy20;
		} else {
			if (yych == '.') goto yy20;
			if (yych <= '/') goto yy297;
			goto yy20;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy544;
			if (yych <= 'Z') goto yy472;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= '`') goto yy20;
			if (yych <= 'a') goto yy550;
			if (yych <= 'z') goto yy478;
			goto yy20;
		}
	}
yy377:
	YYDEBUG(377, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy472;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy545;
			if (yych <= 'Z') goto yy472;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy20;
				goto yy478;
			} else {
				if (yych <= 'o') goto yy551;
				if (yych <= 'z') goto yy478;
				goto yy20;
			}
		}
	}
yy378:
	YYDEBUG(378, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy315;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy315;
			goto yy472;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy546;
			if (yych <= 'Z') goto yy472;
			if (yych <= '^') goto yy315;
			goto yy297;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy315;
				goto yy478;
			} else {
				if (yych <= 's') goto yy552;
				if (yych <= 'z') goto yy478;
				goto yy315;
			}
		}
	}
yy379:
	YYDEBUG(379, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'K') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy472;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'L') goto yy547;
			if (yych <= 'Z') goto yy472;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'k') {
				if (yych <= '`') goto yy20;
				goto yy478;
			} else {
				if (yych <= 'l') goto yy553;
				if (yych <= 'z') goto yy478;
				goto yy20;
			}
		}
	}
yy380:
	YYDEBUG(380, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy142;
			if (yych <= 0x1F) goto yy20;
			goto yy142;
		} else {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy142;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy20;
			if (yych <= '9') goto yy142;
			if (yych <= '@') goto yy20;
			goto yy472;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy554;
				goto yy472;
			} else {
				if (yych <= '`') goto yy20;
				if (yych <= 'z') goto yy472;
				goto yy20;
			}
		}
	}
yy381:
	YYDEBUG(381, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy315;
			goto yy115;
		} else {
			if (yych <= '@') goto yy315;
			if (yych <= 'M') goto yy472;
			goto yy555;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy472;
			if (yych <= '`') goto yy315;
			goto yy472;
		} else {
			if (yych <= 'n') goto yy555;
			if (yych <= 'z') goto yy472;
			goto yy315;
		}
	}
yy382:
	YYDEBUG(382, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'K') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'J') goto yy472;
			goto yy546;
		}
	} else {
		if (yych <= 'j') {
			if (yych <= 'Z') goto yy472;
			if (yych <= '`') goto yy20;
			goto yy472;
		} else {
			if (yych <= 'k') goto yy546;
			if (yych <= 'z') goto yy472;
			goto yy20;
		}
	}
yy383:
	YYDEBUG(383, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy315;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy315;
			goto yy472;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy555;
			if (yych <= 'Z') goto yy472;
			if (yych <= '^') goto yy315;
			goto yy297;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy315;
				goto yy478;
			} else {
				if (yych <= 'n') goto yy556;
				if (yych <= 'z') goto yy478;
				goto yy315;
			}
		}
	}
yy384:
	YYDEBUG(384, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'J') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy472;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'K') goto yy546;
			if (yych <= 'Z') goto yy472;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'j') {
				if (yych <= '`') goto yy20;
				goto yy478;
			} else {
				if (yych <= 'k') goto yy552;
				if (yych <= 'z') goto yy478;
				goto yy20;
			}
		}
	}
yy385:
	YYDEBUG(385, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'S') goto yy472;
			goto yy557;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy472;
			if (yych <= '`') goto yy20;
			goto yy472;
		} else {
			if (yych <= 't') goto yy557;
			if (yych <= 'z') goto yy472;
			goto yy20;
		}
	}
yy386:
	YYDEBUG(386, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy472;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy557;
			if (yych <= 'Z') goto yy472;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy20;
				goto yy478;
			} else {
				if (yych <= 't') goto yy558;
				if (yych <= 'z') goto yy478;
				goto yy20;
			}
		}
	}
yy387:
	YYDEBUG(387, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xA0) goto yy193;
	goto yy59;
yy388:
	YYDEBUG(388, *YYCURSOR);
	yyaccept = 0;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xE2) goto yy559;
	goto yy8;
yy389:
	YYDEBUG(389, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy196;
		if (yych <= '9') goto yy560;
		goto yy196;
	} else {
		if (yych <= 0xC2) goto yy97;
		if (yych == 0xE2) goto yy98;
		goto yy196;
	}
yy390:
	YYDEBUG(390, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy443;
	if (yych == 'c') goto yy443;
	goto yy59;
yy391:
	YYDEBUG(391, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy196;
				if (yych <= 0x1F) goto yy20;
				goto yy196;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy20;
					goto yy561;
				} else {
					if (yych == 'D') goto yy196;
					goto yy20;
				}
			}
		} else {
			if (yych <= 'M') {
				if (yych <= 'G') {
					if (yych <= 'F') goto yy196;
					goto yy20;
				} else {
					if (yych <= 'H') goto yy196;
					if (yych <= 'L') goto yy20;
					goto yy196;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'R') goto yy20;
					goto yy196;
				} else {
					if (yych == 'W') goto yy196;
					goto yy20;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy196;
					goto yy20;
				} else {
					if (yych == 'e') goto yy20;
					goto yy196;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy20;
					goto yy196;
				} else {
					if (yych == 'm') goto yy196;
					goto yy20;
				}
			}
		} else {
			if (yych <= 'y') {
				if (yych <= 'v') {
					if (yych <= 'u') goto yy196;
					goto yy20;
				} else {
					if (yych == 'x') goto yy20;
					goto yy196;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 0xC1) goto yy20;
					goto yy97;
				} else {
					if (yych == 0xE2) goto yy98;
					goto yy20;
				}
			}
		}
	}
yy392:
	YYDEBUG(392, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy196;
				if (yych <= 0x1F) goto yy20;
				goto yy196;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy20;
					goto yy562;
				} else {
					if (yych == 'D') goto yy196;
					goto yy20;
				}
			}
		} else {
			if (yych <= 'M') {
				if (yych <= 'G') {
					if (yych <= 'F') goto yy196;
					goto yy20;
				} else {
					if (yych <= 'H') goto yy196;
					if (yych <= 'L') goto yy20;
					goto yy196;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'R') goto yy20;
					goto yy196;
				} else {
					if (yych == 'W') goto yy196;
					goto yy20;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy196;
					goto yy20;
				} else {
					if (yych == 'e') goto yy20;
					goto yy196;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy20;
					goto yy196;
				} else {
					if (yych == 'm') goto yy196;
					goto yy20;
				}
			}
		} else {
			if (yych <= 'y') {
				if (yych <= 'v') {
					if (yych <= 'u') goto yy196;
					goto yy20;
				} else {
					if (yych == 'x') goto yy20;
					goto yy196;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 0xC1) goto yy20;
					goto yy97;
				} else {
					if (yych == 0xE2) goto yy98;
					goto yy20;
				}
			}
		}
	}
yy393:
	YYDEBUG(393, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '5') goto yy563;
	if (yych <= '9') goto yy115;
	goto yy59;
yy394:
	YYDEBUG(394, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy20;
	if (yych <= '9') goto yy115;
	goto yy20;
yy395:
	YYDEBUG(395, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy196;
		if (yych <= '9') goto yy562;
		goto yy196;
	} else {
		if (yych <= 0xC2) goto yy97;
		if (yych == 0xE2) goto yy98;
		goto yy196;
	}
yy396:
	YYDEBUG(396, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy564;
	goto yy59;
yy397:
	YYDEBUG(397, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy565;
	goto yy59;
yy398:
	YYDEBUG(398, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '2') goto yy566;
	if (yych <= '3') goto yy568;
	if (yych <= '9') goto yy569;
	goto yy59;
yy399:
	YYDEBUG(399, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy444;
	if (yych == 'p') goto yy444;
	goto yy59;
yy400:
	YYDEBUG(400, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '5') goto yy570;
	if (yych <= '6') goto yy571;
	if (yych <= '9') goto yy572;
	goto yy59;
yy401:
	YYDEBUG(401, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '5') goto yy573;
	if (yych <= '6') goto yy574;
	if (yych <= '9') goto yy575;
	goto yy59;
yy402:
	YYDEBUG(402, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy576;
	goto yy59;
yy403:
	YYDEBUG(403, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy577;
	goto yy59;
yy404:
	YYDEBUG(404, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy577;
	goto yy59;
yy405:
	YYDEBUG(405, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy577;
	goto yy59;
yy406:
	YYDEBUG(406, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy578;
	if (yych == 'r') goto yy578;
	goto yy59;
yy407:
	YYDEBUG(407, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy578;
	if (yych == 'g') goto yy578;
	goto yy59;
yy408:
	YYDEBUG(408, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy578;
	if (yych == 'c') goto yy578;
	goto yy59;
yy409:
	YYDEBUG(409, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy578;
	if (yych == 'b') goto yy578;
	goto yy59;
yy410:
	YYDEBUG(410, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy578;
	if (yych == 'n') goto yy578;
	goto yy59;
yy411:
	YYDEBUG(411, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy578;
		if (yych <= 'M') goto yy59;
		goto yy578;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy59;
			goto yy578;
		} else {
			if (yych == 'n') goto yy578;
			goto yy59;
		}
	}
yy412:
	YYDEBUG(412, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy578;
		if (yych <= 'X') goto yy59;
		goto yy578;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy59;
			goto yy578;
		} else {
			if (yych == 'y') goto yy578;
			goto yy59;
		}
	}
yy413:
	YYDEBUG(413, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy578;
	if (yych == 'v') goto yy578;
	goto yy59;
yy414:
	YYDEBUG(414, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy578;
	if (yych == 't') goto yy578;
	goto yy59;
yy415:
	YYDEBUG(415, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy579;
	if (yych == 'p') goto yy579;
	goto yy59;
yy416:
	YYDEBUG(416, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy59;
		if (yych <= '-') goto yy398;
		goto yy396;
	} else {
		if (yych <= '/') goto yy59;
		if (yych <= '9') goto yy580;
		goto yy59;
	}
yy417:
	YYDEBUG(417, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy59;
		if (yych <= '-') goto yy398;
		goto yy396;
	} else {
		if (yych <= '/') goto yy59;
		if (yych <= '2') goto yy580;
		goto yy59;
	}
yy418:
	YYDEBUG(418, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy581;
	case '1':	goto yy582;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy462;
	case 'A':
	case 'a':	goto yy463;
	case 'D':
	case 'd':	goto yy464;
	case 'F':
	case 'f':	goto yy465;
	case 'J':
	case 'j':	goto yy466;
	case 'M':
	case 'm':	goto yy467;
	case 'N':
	case 'n':	goto yy468;
	case 'O':
	case 'o':	goto yy469;
	case 'S':
	case 's':	goto yy470;
	default:	goto yy59;
	}
yy419:
	YYDEBUG(419, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '5') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy584;
				} else {
					if (yych <= ' ') goto yy584;
					if (yych >= '-') goto yy585;
				}
			} else {
				if (yych <= '0') {
					if (yych <= '.') goto yy586;
					if (yych <= '/') goto yy587;
					goto yy588;
				} else {
					if (yych <= '1') goto yy589;
					if (yych <= '2') goto yy590;
					if (yych <= '3') goto yy591;
					goto yy592;
				}
			}
		} else {
			if (yych <= 'C') {
				if (yych <= ':') {
					if (yych <= '6') goto yy593;
					if (yych <= '9') goto yy594;
					goto yy595;
				} else {
					if (yych == 'A') goto yy584;
				}
			} else {
				if (yych <= 'F') {
					if (yych != 'E') goto yy584;
				} else {
					if (yych <= 'G') goto yy420;
					if (yych <= 'J') goto yy584;
					if (yych >= 'M') goto yy584;
				}
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'a') {
				if (yych <= 'W') {
					if (yych <= 'R') goto yy420;
					if (yych <= 'V') goto yy584;
					goto yy607;
				} else {
					if (yych <= 'Y') goto yy584;
					if (yych >= 'a') goto yy584;
				}
			} else {
				if (yych <= 'e') {
					if (yych == 'd') goto yy584;
				} else {
					if (yych == 'g') goto yy420;
					if (yych <= 'h') goto yy584;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'o') {
					if (yych <= 'j') goto yy584;
					if (yych >= 'm') goto yy584;
				} else {
					if (yych <= 'r') goto yy420;
					if (yych != 'v') goto yy584;
				}
			} else {
				if (yych <= 0xC1) {
					if (yych == 'y') goto yy584;
				} else {
					if (yych <= 0xC2) goto yy97;
					if (yych == 0xE2) goto yy98;
				}
			}
		}
	}
yy420:
	YYDEBUG(420, *YYCURSOR);
#line 1405 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("gnunocolon");
		TIMELIB_INIT;
		switch (s->time->have_time) {
			case 0:
				s->time->h = timelib_get_nr(&ptr, 2);
				s->time->i = timelib_get_nr(&ptr, 2);
				s->time->s = 0;
				break;
			case 1:
				s->time->y = timelib_get_nr(&ptr, 4);
				break;
			default:
				TIMELIB_DEINIT;
				add_error(s, TIMELIB_ERR_DOUBLE_TIME, "Double time specification");
				return TIMELIB_ERROR;
		}
		s->time->have_time++;
		TIMELIB_DEINIT;
		return TIMELIB_GNU_NOCOLON;
	}
#line 11012 "<stdout>"
yy421:
	YYDEBUG(421, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '3') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy584;
				} else {
					if (yych <= ' ') goto yy584;
					if (yych >= '-') goto yy585;
				}
			} else {
				if (yych <= '0') {
					if (yych <= '.') goto yy586;
					if (yych <= '/') goto yy587;
					goto yy609;
				} else {
					if (yych <= '1') goto yy610;
					if (yych <= '2') goto yy611;
					goto yy612;
				}
			}
		} else {
			if (yych <= 'D') {
				if (yych <= '@') {
					if (yych <= '9') goto yy594;
					if (yych <= ':') goto yy595;
				} else {
					if (yych <= 'A') goto yy584;
					if (yych >= 'D') goto yy584;
				}
			} else {
				if (yych <= 'G') {
					if (yych == 'F') goto yy584;
				} else {
					if (yych <= 'J') goto yy584;
					if (yych <= 'L') goto yy422;
					if (yych <= 'O') goto yy584;
				}
			}
		}
	} else {
		if (yych <= 'j') {
			if (yych <= 'c') {
				if (yych <= 'Y') {
					if (yych == 'W') goto yy607;
					goto yy584;
				} else {
					if (yych == 'a') goto yy584;
				}
			} else {
				if (yych <= 'f') {
					if (yych != 'e') goto yy584;
				} else {
					if (yych == 'h') goto yy584;
					if (yych >= 'j') goto yy584;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'l') goto yy422;
					if (yych <= 'o') goto yy584;
				} else {
					if (yych != 'v') goto yy584;
				}
			} else {
				if (yych <= 0xC1) {
					if (yych == 'y') goto yy584;
				} else {
					if (yych <= 0xC2) goto yy97;
					if (yych == 0xE2) goto yy98;
				}
			}
		}
	}
yy422:
	YYDEBUG(422, *YYCURSOR);
#line 1790 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("year4");
		TIMELIB_INIT;
		s->time->y = timelib_get_nr(&ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
#line 11101 "<stdout>"
yy423:
	YYDEBUG(423, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy248;
			goto yy81;
		} else {
			if (yych <= ' ') goto yy248;
			if (yych <= ',') goto yy81;
			goto yy248;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy81;
			if (yych <= '9') goto yy250;
			goto yy81;
		} else {
			if (yych <= 'I') goto yy613;
			if (yych == 'i') goto yy613;
			goto yy81;
		}
	}
yy424:
	YYDEBUG(424, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy248;
			goto yy81;
		} else {
			if (yych <= ' ') goto yy248;
			if (yych <= ',') goto yy81;
			goto yy248;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy81;
			if (yych <= '9') goto yy250;
			goto yy81;
		} else {
			if (yych <= 'U') goto yy614;
			if (yych == 'u') goto yy614;
			goto yy81;
		}
	}
yy425:
	YYDEBUG(425, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy615;
	if (yych == 's') goto yy615;
	goto yy260;
yy426:
	YYDEBUG(426, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy248;
			goto yy81;
		} else {
			if (yych <= ' ') goto yy248;
			if (yych <= ',') goto yy81;
			goto yy248;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy81;
			if (yych <= '9') goto yy250;
			goto yy81;
		} else {
			if (yych <= 'E') goto yy616;
			if (yych == 'e') goto yy616;
			goto yy81;
		}
	}
yy427:
	YYDEBUG(427, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy248;
			goto yy81;
		} else {
			if (yych <= ' ') goto yy248;
			if (yych <= ',') goto yy81;
			goto yy248;
		}
	} else {
		if (yych <= 'Q') {
			if (yych <= '/') goto yy81;
			if (yych <= '9') goto yy250;
			goto yy81;
		} else {
			if (yych <= 'R') goto yy617;
			if (yych == 'r') goto yy617;
			goto yy81;
		}
	}
yy428:
	YYDEBUG(428, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy618;
	if (yych == 't') goto yy618;
	goto yy59;
yy429:
	YYDEBUG(429, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy198;
	if (yych == 'd') goto yy198;
	goto yy260;
yy430:
	YYDEBUG(430, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy425;
	if (yych == 'r') goto yy425;
	goto yy59;
yy431:
	YYDEBUG(431, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy251;
	if (yych <= '9') goto yy619;
	goto yy251;
yy432:
	YYDEBUG(432, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy248;
			goto yy81;
		} else {
			if (yych <= ' ') goto yy248;
			if (yych <= ',') goto yy81;
			goto yy248;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy81;
			if (yych <= '9') goto yy250;
			goto yy81;
		} else {
			if (yych <= 'U') goto yy620;
			if (yych == 'u') goto yy620;
			goto yy81;
		}
	}
yy433:
	YYDEBUG(433, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy248;
			goto yy81;
		} else {
			if (yych <= ' ') goto yy248;
			if (yych <= ',') goto yy81;
			goto yy248;
		}
	} else {
		if (yych <= 'X') {
			if (yych <= '/') goto yy81;
			if (yych <= '9') goto yy250;
			goto yy81;
		} else {
			if (yych <= 'Y') goto yy253;
			if (yych == 'y') goto yy253;
			goto yy81;
		}
	}
yy434:
	YYDEBUG(434, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy248;
			goto yy81;
		} else {
			if (yych <= ' ') goto yy248;
			if (yych <= ',') goto yy81;
			goto yy248;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy81;
			if (yych <= '9') goto yy250;
			goto yy81;
		} else {
			if (yych <= 'E') goto yy253;
			if (yych == 'e') goto yy253;
			goto yy81;
		}
	}
yy435:
	YYDEBUG(435, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy248;
			goto yy81;
		} else {
			if (yych <= ' ') goto yy248;
			if (yych <= ',') goto yy81;
			goto yy248;
		}
	} else {
		if (yych <= 'B') {
			if (yych <= '/') goto yy81;
			if (yych <= '9') goto yy250;
			goto yy81;
		} else {
			if (yych <= 'C') goto yy621;
			if (yych == 'c') goto yy621;
			goto yy81;
		}
	}
yy436:
	YYDEBUG(436, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy622;
	if (yych == 'r') goto yy622;
	goto yy59;
yy437:
	YYDEBUG(437, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy623;
	if (yych == 'l') goto yy623;
	goto yy59;
yy438:
	YYDEBUG(438, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy615;
		if (yych <= 'T') goto yy260;
		goto yy624;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy260;
			goto yy615;
		} else {
			if (yych == 'u') goto yy624;
			goto yy260;
		}
	}
yy439:
	YYDEBUG(439, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == 'D') goto yy198;
		if (yych <= 'S') goto yy260;
		goto yy625;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy260;
			goto yy198;
		} else {
			if (yych == 't') goto yy625;
			goto yy260;
		}
	}
yy440:
	YYDEBUG(440, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy425;
	if (yych == 'c') goto yy425;
	goto yy59;
yy441:
	YYDEBUG(441, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy248;
			goto yy81;
		} else {
			if (yych <= ' ') goto yy248;
			if (yych <= ',') goto yy81;
			goto yy248;
		}
	} else {
		if (yych <= 'N') {
			if (yych <= '/') goto yy81;
			if (yych <= '9') goto yy250;
			goto yy81;
		} else {
			if (yych <= 'O') goto yy626;
			if (yych == 'o') goto yy626;
			goto yy81;
		}
	}
yy442:
	YYDEBUG(442, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy627;
	if (yych == 'u') goto yy627;
	goto yy260;
yy443:
	YYDEBUG(443, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy628;
		if (yych <= 'R') goto yy260;
		goto yy615;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy260;
			goto yy628;
		} else {
			if (yych == 's') goto yy615;
			goto yy260;
		}
	}
yy444:
	YYDEBUG(444, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy248;
			goto yy81;
		} else {
			if (yych <= ' ') goto yy248;
			if (yych <= ',') goto yy81;
			goto yy248;
		}
	} else {
		if (yych <= 'S') {
			if (yych <= '/') goto yy81;
			if (yych <= '9') goto yy250;
			goto yy81;
		} else {
			if (yych <= 'T') goto yy426;
			if (yych == 't') goto yy426;
			goto yy81;
		}
	}
yy445:
	YYDEBUG(445, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy629;
	if (yych == 'r') goto yy629;
	goto yy260;
yy446:
	YYDEBUG(446, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'S') goto yy630;
	if (yych == 's') goto yy630;
	goto yy260;
yy447:
	YYDEBUG(447, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'N') goto yy631;
	if (yych == 'n') goto yy631;
	goto yy260;
yy448:
	YYDEBUG(448, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy632;
	if (yych == 'k') goto yy632;
	goto yy59;
yy449:
	YYDEBUG(449, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy207;
	if (yych <= '0') goto yy633;
	if (yych <= '1') goto yy634;
	if (yych <= '9') goto yy635;
	goto yy207;
yy450:
	YYDEBUG(450, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
	if (yych <= 'd') {
		if (yych <= 'R') {
			if (yych <= 'F') {
				if (yych == 'D') goto yy198;
				if (yych <= 'E') goto yy59;
				goto yy199;
			} else {
				if (yych <= 'H') {
					if (yych <= 'G') goto yy59;
					goto yy79;
				} else {
					if (yych == 'M') goto yy200;
					goto yy59;
				}
			}
		} else {
			if (yych <= 'V') {
				if (yych <= 'S') goto yy201;
				if (yych <= 'T') goto yy87;
				if (yych <= 'U') goto yy88;
				goto yy59;
			} else {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy90;
					goto yy59;
				} else {
					if (yych <= 'Y') goto yy92;
					if (yych <= 'c') goto yy59;
					goto yy198;
				}
			}
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'h') {
				if (yych == 'f') goto yy199;
				if (yych <= 'g') goto yy59;
				goto yy79;
			} else {
				if (yych <= 'm') {
					if (yych <= 'l') goto yy59;
					goto yy200;
				} else {
					if (yych <= 'r') goto yy59;
					if (yych <= 's') goto yy201;
					goto yy87;
				}
			}
		} else {
			if (yych <= 'y') {
				if (yych <= 'v') {
					if (yych <= 'u') goto yy88;
					goto yy59;
				} else {
					if (yych <= 'w') goto yy90;
					if (yych <= 'x') goto yy59;
					goto yy92;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 0xC1) goto yy59;
					goto yy211;
				} else {
					if (yych == 0xE2) goto yy98;
					goto yy59;
				}
			}
		}
	}
yy451:
	YYDEBUG(451, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '5') goto yy636;
	if (yych <= '6') goto yy637;
	if (yych <= '9') goto yy572;
	goto yy59;
yy452:
	YYDEBUG(452, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= ',') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy177;
				goto yy638;
			} else {
				if (yych == ' ') goto yy638;
				goto yy177;
			}
		} else {
			if (yych <= '9') {
				if (yych <= '-') goto yy396;
				if (yych <= '.') goto yy451;
				goto yy177;
			} else {
				if (yych <= ':') goto yy453;
				if (yych <= '@') goto yy177;
				goto yy106;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'P') {
				if (yych <= 'O') goto yy177;
				goto yy106;
			} else {
				if (yych == 'a') goto yy106;
				goto yy177;
			}
		} else {
			if (yych <= 0xC2) {
				if (yych <= 'p') goto yy106;
				if (yych <= 0xC1) goto yy177;
				goto yy640;
			} else {
				if (yych == 0xE2) goto yy641;
				goto yy177;
			}
		}
	}
yy453:
	YYDEBUG(453, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '5') goto yy642;
	if (yych <= '6') goto yy643;
	if (yych <= '9') goto yy575;
	goto yy59;
yy454:
	YYDEBUG(454, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy177;
				goto yy638;
			} else {
				if (yych == ' ') goto yy638;
				goto yy177;
			}
		} else {
			if (yych <= '9') {
				if (yych <= '.') goto yy453;
				goto yy177;
			} else {
				if (yych <= ':') goto yy453;
				if (yych <= '@') goto yy177;
				goto yy106;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'P') {
				if (yych <= 'O') goto yy177;
				goto yy106;
			} else {
				if (yych == 'a') goto yy106;
				goto yy177;
			}
		} else {
			if (yych <= 0xC2) {
				if (yych <= 'p') goto yy106;
				if (yych <= 0xC1) goto yy177;
				goto yy640;
			} else {
				if (yych == 0xE2) goto yy641;
				goto yy177;
			}
		}
	}
yy455:
	YYDEBUG(455, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy177;
				goto yy638;
			} else {
				if (yych == ' ') goto yy638;
				goto yy177;
			}
		} else {
			if (yych <= '9') {
				if (yych <= '.') goto yy453;
				goto yy177;
			} else {
				if (yych <= ':') goto yy644;
				if (yych <= '@') goto yy177;
				goto yy106;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'P') {
				if (yych <= 'O') goto yy177;
				goto yy106;
			} else {
				if (yych == 'a') goto yy106;
				goto yy177;
			}
		} else {
			if (yych <= 0xC2) {
				if (yych <= 'p') goto yy106;
				if (yych <= 0xC1) goto yy177;
				goto yy640;
			} else {
				if (yych == 0xE2) goto yy641;
				goto yy177;
			}
		}
	}
yy456:
	YYDEBUG(456, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(457, *YYCURSOR);
#line 1339 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("timetiny12 | timeshort12 | timelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr(&ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->i = timelib_get_nr(&ptr, 2);
			if (*ptr == ':' || *ptr == '.') {
				s->time->s = timelib_get_nr(&ptr, 2);
			}
		}
		timelib_eat_spaces(&ptr);
		s->time->h += timelib_meridian(&ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME12;
	}
#line 11725 "<stdout>"
yy458:
	YYDEBUG(458, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy456;
		if (yych <= 0x08) goto yy59;
		goto yy456;
	} else {
		if (yych == ' ') goto yy456;
		goto yy59;
	}
yy459:
	YYDEBUG(459, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
	if (yych <= 'a') {
		if (yych <= 'O') {
			if (yych <= 'E') {
				if (yych <= 'A') {
					if (yych <= '@') goto yy59;
					goto yy106;
				} else {
					if (yych == 'D') goto yy198;
					goto yy59;
				}
			} else {
				if (yych <= 'H') {
					if (yych <= 'F') goto yy199;
					if (yych <= 'G') goto yy59;
					goto yy79;
				} else {
					if (yych == 'M') goto yy200;
					goto yy59;
				}
			}
		} else {
			if (yych <= 'U') {
				if (yych <= 'R') {
					if (yych <= 'P') goto yy106;
					goto yy59;
				} else {
					if (yych <= 'S') goto yy201;
					if (yych <= 'T') goto yy87;
					goto yy88;
				}
			} else {
				if (yych <= 'X') {
					if (yych == 'W') goto yy90;
					goto yy59;
				} else {
					if (yych <= 'Y') goto yy92;
					if (yych <= '`') goto yy59;
					goto yy106;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'g') {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy59;
					goto yy198;
				} else {
					if (yych == 'f') goto yy199;
					goto yy59;
				}
			} else {
				if (yych <= 'm') {
					if (yych <= 'h') goto yy79;
					if (yych <= 'l') goto yy59;
					goto yy200;
				} else {
					if (yych == 'p') goto yy106;
					goto yy59;
				}
			}
		} else {
			if (yych <= 'x') {
				if (yych <= 'u') {
					if (yych <= 's') goto yy201;
					if (yych <= 't') goto yy87;
					goto yy88;
				} else {
					if (yych == 'w') goto yy90;
					goto yy59;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 'y') goto yy92;
					if (yych <= 0xC1) goto yy59;
					goto yy211;
				} else {
					if (yych == 0xE2) goto yy108;
					goto yy59;
				}
			}
		}
	}
yy460:
	YYDEBUG(460, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy645;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy646;
	goto yy59;
yy461:
	YYDEBUG(461, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy645;
	if (yych <= '/') goto yy59;
	if (yych <= '2') goto yy646;
	goto yy59;
yy462:
	YYDEBUG(462, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy645;
	goto yy59;
yy463:
	YYDEBUG(463, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy647;
		if (yych <= 'T') goto yy59;
		goto yy648;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy59;
			goto yy647;
		} else {
			if (yych == 'u') goto yy648;
			goto yy59;
		}
	}
yy464:
	YYDEBUG(464, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy649;
	if (yych == 'e') goto yy649;
	goto yy59;
yy465:
	YYDEBUG(465, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy650;
	if (yych == 'e') goto yy650;
	goto yy59;
yy466:
	YYDEBUG(466, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy651;
		if (yych <= 'T') goto yy59;
		goto yy652;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy59;
			goto yy651;
		} else {
			if (yych == 'u') goto yy652;
			goto yy59;
		}
	}
yy467:
	YYDEBUG(467, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy653;
	if (yych == 'a') goto yy653;
	goto yy59;
yy468:
	YYDEBUG(468, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy654;
	if (yych == 'o') goto yy654;
	goto yy59;
yy469:
	YYDEBUG(469, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy655;
	if (yych == 'c') goto yy655;
	goto yy59;
yy470:
	YYDEBUG(470, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy656;
	if (yych == 'e') goto yy656;
	goto yy59;
yy471:
	YYDEBUG(471, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy290;
	if (yych <= '9') goto yy657;
	goto yy290;
yy472:
	YYDEBUG(472, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy115;
		goto yy20;
	} else {
		if (yych <= 'Z') goto yy658;
		if (yych <= '`') goto yy20;
		if (yych <= 'z') goto yy658;
		goto yy20;
	}
yy473:
	YYDEBUG(473, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy142;
	if (yych <= '2') goto yy659;
	if (yych <= '3') goto yy660;
	goto yy142;
yy474:
	YYDEBUG(474, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'K') goto yy658;
			goto yy661;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy658;
			if (yych <= '`') goto yy20;
			goto yy658;
		} else {
			if (yych <= 'l') goto yy661;
			if (yych <= 'z') goto yy658;
			goto yy20;
		}
	}
yy475:
	YYDEBUG(475, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'R') goto yy658;
			goto yy662;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy658;
			if (yych <= '`') goto yy20;
			goto yy658;
		} else {
			if (yych <= 's') goto yy662;
			if (yych <= 'z') goto yy658;
			goto yy20;
		}
	}
yy476:
	YYDEBUG(476, *YYCURSOR);
	yyaccept = 2;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(477, *YYCURSOR);
	if (yybm[0+yych] & 64) {
		goto yy476;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy297;
		goto yy20;
	} else {
		if (yych <= '/') goto yy297;
		if (yych == '_') goto yy297;
		goto yy20;
	}
yy478:
	YYDEBUG(478, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy115;
			goto yy20;
		} else {
			if (yych == '.') goto yy20;
			goto yy297;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy20;
			if (yych <= 'Z') goto yy658;
			goto yy20;
		} else {
			if (yych <= '_') goto yy297;
			if (yych <= '`') goto yy20;
			if (yych <= 'z') goto yy663;
			goto yy20;
		}
	}
yy479:
	YYDEBUG(479, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 64) {
		goto yy476;
	}
	if (yych <= '/') goto yy142;
	if (yych <= '2') goto yy659;
	if (yych <= '3') goto yy660;
	goto yy142;
yy480:
	YYDEBUG(480, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'K') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy658;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'L') goto yy661;
			if (yych <= 'Z') goto yy658;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'k') {
				if (yych <= '`') goto yy20;
				goto yy663;
			} else {
				if (yych <= 'l') goto yy664;
				if (yych <= 'z') goto yy663;
				goto yy20;
			}
		}
	}
yy481:
	YYDEBUG(481, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy658;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy662;
			if (yych <= 'Z') goto yy658;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy20;
				goto yy663;
			} else {
				if (yych <= 's') goto yy665;
				if (yych <= 'z') goto yy663;
				goto yy20;
			}
		}
	}
yy482:
	YYDEBUG(482, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych == ' ') goto yy666;
		if (yych <= '(') goto yy20;
		goto yy115;
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy20;
			goto yy658;
		} else {
			if (yych <= '`') goto yy20;
			if (yych <= 'z') goto yy658;
			goto yy20;
		}
	}
yy483:
	YYDEBUG(483, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= '(') {
			if (yych == ' ') goto yy666;
			goto yy20;
		} else {
			if (yych <= ')') goto yy115;
			if (yych == '-') goto yy297;
			goto yy20;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '/') goto yy297;
			if (yych <= '@') goto yy20;
			if (yych <= 'Z') goto yy658;
			goto yy20;
		} else {
			if (yych <= '_') goto yy297;
			if (yych <= '`') goto yy20;
			if (yych <= 'z') goto yy663;
			goto yy20;
		}
	}
yy484:
	YYDEBUG(484, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'L') goto yy658;
			goto yy667;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy658;
			if (yych <= '`') goto yy20;
			goto yy658;
		} else {
			if (yych <= 'm') goto yy667;
			if (yych <= 'z') goto yy658;
			goto yy20;
		}
	}
yy485:
	YYDEBUG(485, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy658;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy667;
			if (yych <= 'Z') goto yy658;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy20;
				goto yy663;
			} else {
				if (yych <= 'm') goto yy668;
				if (yych <= 'z') goto yy663;
				goto yy20;
			}
		}
	}
yy486:
	YYDEBUG(486, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'S') goto yy658;
			goto yy669;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy658;
			if (yych <= '`') goto yy20;
			goto yy658;
		} else {
			if (yych <= 't') goto yy669;
			if (yych <= 'z') goto yy658;
			goto yy20;
		}
	}
yy487:
	YYDEBUG(487, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'D') goto yy658;
			goto yy670;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy658;
			if (yych <= '`') goto yy20;
			goto yy658;
		} else {
			if (yych <= 'e') goto yy670;
			if (yych <= 'z') goto yy658;
			goto yy20;
		}
	}
yy488:
	YYDEBUG(488, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy658;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy669;
			if (yych <= 'Z') goto yy658;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy20;
				goto yy663;
			} else {
				if (yych <= 't') goto yy671;
				if (yych <= 'z') goto yy663;
				goto yy20;
			}
		}
	}
yy489:
	YYDEBUG(489, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy658;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy670;
			if (yych <= 'Z') goto yy658;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy20;
				goto yy663;
			} else {
				if (yych <= 'e') goto yy672;
				if (yych <= 'z') goto yy663;
				goto yy20;
			}
		}
	}
yy490:
	YYDEBUG(490, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'T') goto yy658;
			goto yy673;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy658;
			if (yych <= '`') goto yy20;
			goto yy658;
		} else {
			if (yych <= 'u') goto yy673;
			if (yych <= 'z') goto yy658;
			goto yy20;
		}
	}
yy491:
	YYDEBUG(491, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'G') goto yy658;
			goto yy674;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy658;
			if (yych <= '`') goto yy20;
			goto yy658;
		} else {
			if (yych <= 'h') goto yy674;
			if (yych <= 'z') goto yy658;
			goto yy20;
		}
	}
yy492:
	YYDEBUG(492, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'S') goto yy658;
			goto yy675;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy658;
			if (yych <= '`') goto yy20;
			goto yy658;
		} else {
			if (yych <= 't') goto yy675;
			if (yych <= 'z') goto yy658;
			goto yy20;
		}
	}
yy493:
	YYDEBUG(493, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'S') goto yy658;
			goto yy676;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy658;
			if (yych <= '`') goto yy20;
			goto yy658;
		} else {
			if (yych <= 't') goto yy676;
			if (yych <= 'z') goto yy658;
			goto yy20;
		}
	}
yy494:
	YYDEBUG(494, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy115;
		if (yych <= '@') goto yy20;
		goto yy677;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy658;
			goto yy20;
		} else {
			if (yych <= 'a') goto yy677;
			if (yych <= 'z') goto yy658;
			goto yy20;
		}
	}
yy495:
	YYDEBUG(495, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'S') goto yy658;
			goto yy678;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy658;
			if (yych <= '`') goto yy20;
			goto yy658;
		} else {
			if (yych <= 't') goto yy678;
			if (yych <= 'z') goto yy658;
			goto yy20;
		}
	}
yy496:
	YYDEBUG(496, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy658;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy673;
			if (yych <= 'Z') goto yy658;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy20;
				goto yy663;
			} else {
				if (yych <= 'u') goto yy679;
				if (yych <= 'z') goto yy663;
				goto yy20;
			}
		}
	}
yy497:
	YYDEBUG(497, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy658;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy674;
			if (yych <= 'Z') goto yy658;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy20;
				goto yy663;
			} else {
				if (yych <= 'h') goto yy680;
				if (yych <= 'z') goto yy663;
				goto yy20;
			}
		}
	}
yy498:
	YYDEBUG(498, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy658;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy675;
			if (yych <= 'Z') goto yy658;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy20;
				goto yy663;
			} else {
				if (yych <= 't') goto yy681;
				if (yych <= 'z') goto yy663;
				goto yy20;
			}
		}
	}
yy499:
	YYDEBUG(499, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy658;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy676;
			if (yych <= 'Z') goto yy658;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy20;
				goto yy663;
			} else {
				if (yych <= 't') goto yy682;
				if (yych <= 'z') goto yy663;
				goto yy20;
			}
		}
	}
yy500:
	YYDEBUG(500, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy115;
			goto yy20;
		} else {
			if (yych == '.') goto yy20;
			if (yych <= '/') goto yy297;
			goto yy20;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy677;
			if (yych <= 'Z') goto yy658;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= '`') goto yy20;
			if (yych <= 'a') goto yy683;
			if (yych <= 'z') goto yy663;
			goto yy20;
		}
	}
yy501:
	YYDEBUG(501, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy658;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy678;
			if (yych <= 'Z') goto yy658;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy20;
				goto yy663;
			} else {
				if (yych <= 't') goto yy684;
				if (yych <= 'z') goto yy663;
				goto yy20;
			}
		}
	}
yy502:
	YYDEBUG(502, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '1') goto yy685;
	if (yych <= '2') goto yy686;
	if (yych <= '9') goto yy687;
	goto yy59;
yy503:
	YYDEBUG(503, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy688;
		goto yy59;
	} else {
		if (yych <= '0') goto yy689;
		if (yych <= '9') goto yy506;
		if (yych <= ':') goto yy688;
		goto yy59;
	}
yy504:
	YYDEBUG(504, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy690;
		goto yy59;
	} else {
		if (yych <= '2') goto yy506;
		if (yych <= '9') goto yy689;
		if (yych <= ':') goto yy690;
		goto yy59;
	}
yy505:
	YYDEBUG(505, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy690;
		goto yy59;
	} else {
		if (yych <= '4') goto yy689;
		if (yych == ':') goto yy690;
		goto yy59;
	}
yy506:
	YYDEBUG(506, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy690;
	if (yych == ':') goto yy690;
	goto yy59;
yy507:
	YYDEBUG(507, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '1') goto yy691;
	if (yych <= '2') goto yy692;
	if (yych <= '9') goto yy689;
	goto yy59;
yy508:
	YYDEBUG(508, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy688;
		goto yy325;
	} else {
		if (yych <= '0') goto yy693;
		if (yych <= '9') goto yy694;
		if (yych <= ':') goto yy688;
		goto yy325;
	}
yy509:
	YYDEBUG(509, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy690;
		goto yy325;
	} else {
		if (yych <= '2') goto yy694;
		if (yych <= '9') goto yy693;
		if (yych <= ':') goto yy690;
		goto yy325;
	}
yy510:
	YYDEBUG(510, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy690;
		goto yy325;
	} else {
		if (yych <= '4') goto yy693;
		if (yych <= '9') goto yy695;
		if (yych <= ':') goto yy690;
		goto yy325;
	}
yy511:
	YYDEBUG(511, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy690;
		goto yy325;
	} else {
		if (yych <= '9') goto yy695;
		if (yych <= ':') goto yy690;
		goto yy325;
	}
yy512:
	YYDEBUG(512, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy696;
	goto yy59;
yy513:
	YYDEBUG(513, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x00) goto yy324;
	goto yy327;
yy514:
	YYDEBUG(514, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy115;
		if (yych <= '@') goto yy20;
		goto yy698;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy658;
			goto yy20;
		} else {
			if (yych <= 'a') goto yy698;
			if (yych <= 'z') goto yy658;
			goto yy20;
		}
	}
yy515:
	YYDEBUG(515, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy142;
			goto yy295;
		} else {
			if (yych <= ' ') goto yy142;
			if (yych == ')') goto yy115;
			goto yy295;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy295;
			if (yych <= '9') goto yy142;
			goto yy295;
		} else {
			if (yych <= 'Z') goto yy658;
			if (yych <= '`') goto yy295;
			if (yych <= 'z') goto yy658;
			goto yy295;
		}
	}
yy516:
	YYDEBUG(516, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy115;
			goto yy20;
		} else {
			if (yych == '.') goto yy20;
			if (yych <= '/') goto yy297;
			goto yy20;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy698;
			if (yych <= 'Z') goto yy658;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= '`') goto yy20;
			if (yych <= 'a') goto yy699;
			if (yych <= 'z') goto yy663;
			goto yy20;
		}
	}
yy517:
	YYDEBUG(517, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy142;
			if (yych <= 0x1F) goto yy295;
			goto yy142;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy295;
				goto yy115;
			} else {
				if (yych <= ',') goto yy295;
				if (yych <= '-') goto yy700;
				goto yy142;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy297;
			if (yych <= '9') goto yy142;
			if (yych <= '@') goto yy295;
			goto yy658;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy295;
				goto yy297;
			} else {
				if (yych <= '`') goto yy295;
				if (yych <= 'z') goto yy663;
				goto yy295;
			}
		}
	}
yy518:
	YYDEBUG(518, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy701;
			goto yy20;
		} else {
			if (yych <= ' ') goto yy703;
			if (yych == ')') goto yy115;
			goto yy20;
		}
	} else {
		if (yych <= 0xC1) {
			if (yych <= 'Z') goto yy658;
			if (yych <= '`') goto yy20;
			if (yych <= 'z') goto yy658;
			goto yy20;
		} else {
			if (yych <= 0xC2) goto yy704;
			if (yych == 0xE2) goto yy705;
			goto yy20;
		}
	}
yy519:
	YYDEBUG(519, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy20;
				goto yy701;
			} else {
				if (yych == ' ') goto yy703;
				goto yy20;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy115;
				goto yy20;
			} else {
				if (yych == '.') goto yy20;
				goto yy297;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= '@') goto yy20;
				goto yy658;
			} else {
				if (yych == '_') goto yy297;
				goto yy20;
			}
		} else {
			if (yych <= 0xC2) {
				if (yych <= 'z') goto yy663;
				if (yych <= 0xC1) goto yy20;
				goto yy704;
			} else {
				if (yych == 0xE2) goto yy705;
				goto yy20;
			}
		}
	}
yy520:
	YYDEBUG(520, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'G') goto yy658;
			goto yy661;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy658;
			if (yych <= '`') goto yy20;
			goto yy658;
		} else {
			if (yych <= 'h') goto yy661;
			if (yych <= 'z') goto yy658;
			goto yy20;
		}
	}
yy521:
	YYDEBUG(521, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'H') goto yy658;
			goto yy706;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy658;
			if (yych <= '`') goto yy20;
			goto yy658;
		} else {
			if (yych <= 'i') goto yy706;
			if (yych <= 'z') goto yy658;
			goto yy20;
		}
	}
yy522:
	YYDEBUG(522, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy658;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy661;
			if (yych <= 'Z') goto yy658;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy20;
				goto yy663;
			} else {
				if (yych <= 'h') goto yy664;
				if (yych <= 'z') goto yy663;
				goto yy20;
			}
		}
	}
yy523:
	YYDEBUG(523, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy658;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'I') goto yy706;
			if (yych <= 'Z') goto yy658;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy20;
				goto yy663;
			} else {
				if (yych <= 'i') goto yy707;
				if (yych <= 'z') goto yy663;
				goto yy20;
			}
		}
	}
yy524:
	YYDEBUG(524, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy701;
			goto yy20;
		} else {
			if (yych <= ' ') goto yy701;
			if (yych == ')') goto yy115;
			goto yy20;
		}
	} else {
		if (yych <= 0xC1) {
			if (yych <= 'Z') goto yy658;
			if (yych <= '`') goto yy20;
			if (yych <= 'z') goto yy658;
			goto yy20;
		} else {
			if (yych <= 0xC2) goto yy704;
			if (yych == 0xE2) goto yy705;
			goto yy20;
		}
	}
yy525:
	YYDEBUG(525, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy115;
	} else {
		if (yych <= 'Z') goto yy658;
		if (yych <= '`') goto yy526;
		if (yych <= 'z') goto yy658;
	}
yy526:
	YYDEBUG(526, *YYCURSOR);
#line 1177 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("noon");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();
		s->time->h = 12;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 13063 "<stdout>"
yy527:
	YYDEBUG(527, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy20;
				goto yy701;
			} else {
				if (yych == ' ') goto yy701;
				goto yy20;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy115;
				goto yy20;
			} else {
				if (yych == '.') goto yy20;
				goto yy297;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= '@') goto yy20;
				goto yy658;
			} else {
				if (yych == '_') goto yy297;
				goto yy20;
			}
		} else {
			if (yych <= 0xC2) {
				if (yych <= 'z') goto yy663;
				if (yych <= 0xC1) goto yy20;
				goto yy704;
			} else {
				if (yych == 0xE2) goto yy705;
				goto yy20;
			}
		}
	}
yy528:
	YYDEBUG(528, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy115;
			goto yy526;
		} else {
			if (yych == '.') goto yy526;
			goto yy297;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy526;
			if (yych <= 'Z') goto yy658;
			goto yy526;
		} else {
			if (yych <= '_') goto yy297;
			if (yych <= '`') goto yy526;
			if (yych <= 'z') goto yy663;
			goto yy526;
		}
	}
yy529:
	YYDEBUG(529, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'A') goto yy658;
			goto yy708;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy658;
			if (yych <= '`') goto yy20;
			goto yy658;
		} else {
			if (yych <= 'b') goto yy708;
			if (yych <= 'z') goto yy658;
			goto yy20;
		}
	}
yy530:
	YYDEBUG(530, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy658;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy708;
			if (yych <= 'Z') goto yy658;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy20;
				goto yy663;
			} else {
				if (yych <= 'b') goto yy709;
				if (yych <= 'z') goto yy663;
				goto yy20;
			}
		}
	}
yy531:
	YYDEBUG(531, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'H') goto yy658;
			goto yy710;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy658;
			if (yych <= '`') goto yy20;
			goto yy658;
		} else {
			if (yych <= 'i') goto yy710;
			if (yych <= 'z') goto yy658;
			goto yy20;
		}
	}
yy532:
	YYDEBUG(532, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy658;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'I') goto yy710;
			if (yych <= 'Z') goto yy658;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy20;
				goto yy663;
			} else {
				if (yych <= 'i') goto yy711;
				if (yych <= 'z') goto yy663;
				goto yy20;
			}
		}
	}
yy533:
	YYDEBUG(533, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'Q') goto yy658;
			goto yy712;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy658;
			if (yych <= '`') goto yy20;
			goto yy658;
		} else {
			if (yych <= 'r') goto yy712;
			if (yych <= 'z') goto yy658;
			goto yy20;
		}
	}
yy534:
	YYDEBUG(534, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'M') goto yy658;
			goto yy713;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy658;
			if (yych <= '`') goto yy20;
			goto yy658;
		} else {
			if (yych <= 'n') goto yy713;
			if (yych <= 'z') goto yy658;
			goto yy20;
		}
	}
yy535:
	YYDEBUG(535, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy295;
				goto yy142;
			} else {
				if (yych == ' ') goto yy142;
				goto yy295;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy115;
				goto yy295;
			} else {
				if (yych <= '-') goto yy473;
				if (yych <= '.') goto yy142;
				goto yy295;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy142;
				goto yy295;
			} else {
				if (yych == 'E') goto yy714;
				goto yy658;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy295;
				goto yy658;
			} else {
				if (yych <= 'e') goto yy714;
				if (yych <= 'z') goto yy658;
				goto yy295;
			}
		}
	}
yy536:
	YYDEBUG(536, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'M') goto yy658;
			goto yy715;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy658;
			if (yych <= '`') goto yy20;
			goto yy658;
		} else {
			if (yych <= 'n') goto yy715;
			if (yych <= 'z') goto yy658;
			goto yy20;
		}
	}
yy537:
	YYDEBUG(537, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy658;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy712;
			if (yych <= 'Z') goto yy658;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy20;
				goto yy663;
			} else {
				if (yych <= 'r') goto yy716;
				if (yych <= 'z') goto yy663;
				goto yy20;
			}
		}
	}
yy538:
	YYDEBUG(538, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy658;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy713;
			if (yych <= 'Z') goto yy658;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy20;
				goto yy663;
			} else {
				if (yych <= 'n') goto yy717;
				if (yych <= 'z') goto yy663;
				goto yy20;
			}
		}
	}
yy539:
	YYDEBUG(539, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy295;
				goto yy142;
			} else {
				if (yych == ' ') goto yy142;
				goto yy295;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy115;
				if (yych <= ',') goto yy295;
				goto yy479;
			} else {
				if (yych == '/') goto yy297;
				goto yy142;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy295;
				goto yy658;
			} else {
				if (yych <= 'E') goto yy714;
				if (yych <= 'Z') goto yy658;
				goto yy295;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy297;
				if (yych <= '`') goto yy295;
				goto yy663;
			} else {
				if (yych <= 'e') goto yy718;
				if (yych <= 'z') goto yy663;
				goto yy295;
			}
		}
	}
yy540:
	YYDEBUG(540, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy658;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy715;
			if (yych <= 'Z') goto yy658;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy20;
				goto yy663;
			} else {
				if (yych <= 'n') goto yy719;
				if (yych <= 'z') goto yy663;
				goto yy20;
			}
		}
	}
yy541:
	YYDEBUG(541, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy720;
	goto yy59;
yy542:
	YYDEBUG(542, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'C') goto yy658;
			goto yy674;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy658;
			if (yych <= '`') goto yy20;
			goto yy658;
		} else {
			if (yych <= 'd') goto yy674;
			if (yych <= 'z') goto yy658;
			goto yy20;
		}
	}
yy543:
	YYDEBUG(543, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'R') goto yy658;
			goto yy712;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy658;
			if (yych <= '`') goto yy20;
			goto yy658;
		} else {
			if (yych <= 's') goto yy712;
			if (yych <= 'z') goto yy658;
			goto yy20;
		}
	}
yy544:
	YYDEBUG(544, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'X') goto yy658;
			goto yy721;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy658;
			if (yych <= '`') goto yy20;
			goto yy658;
		} else {
			if (yych <= 'y') goto yy721;
			if (yych <= 'z') goto yy658;
			goto yy20;
		}
	}
yy545:
	YYDEBUG(545, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'Q') goto yy658;
			goto yy723;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy658;
			if (yych <= '`') goto yy20;
			goto yy658;
		} else {
			if (yych <= 'r') goto yy723;
			if (yych <= 'z') goto yy658;
			goto yy20;
		}
	}
yy546:
	YYDEBUG(546, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'C') goto yy658;
			goto yy724;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy658;
			if (yych <= '`') goto yy20;
			goto yy658;
		} else {
			if (yych <= 'd') goto yy724;
			if (yych <= 'z') goto yy658;
			goto yy20;
		}
	}
yy547:
	YYDEBUG(547, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'F') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'E') goto yy658;
			goto yy715;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'Z') goto yy658;
			if (yych <= '`') goto yy20;
			goto yy658;
		} else {
			if (yych <= 'f') goto yy715;
			if (yych <= 'z') goto yy658;
			goto yy20;
		}
	}
yy548:
	YYDEBUG(548, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy658;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy674;
			if (yych <= 'Z') goto yy658;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy20;
				goto yy663;
			} else {
				if (yych <= 'd') goto yy680;
				if (yych <= 'z') goto yy663;
				goto yy20;
			}
		}
	}
yy549:
	YYDEBUG(549, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy658;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy712;
			if (yych <= 'Z') goto yy658;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy20;
				goto yy663;
			} else {
				if (yych <= 's') goto yy716;
				if (yych <= 'z') goto yy663;
				goto yy20;
			}
		}
	}
yy550:
	YYDEBUG(550, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy658;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy721;
			if (yych <= 'Z') goto yy658;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy20;
				goto yy663;
			} else {
				if (yych <= 'y') goto yy725;
				if (yych <= 'z') goto yy663;
				goto yy20;
			}
		}
	}
yy551:
	YYDEBUG(551, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy658;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy723;
			if (yych <= 'Z') goto yy658;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy20;
				goto yy663;
			} else {
				if (yych <= 'r') goto yy726;
				if (yych <= 'z') goto yy663;
				goto yy20;
			}
		}
	}
yy552:
	YYDEBUG(552, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy658;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy724;
			if (yych <= 'Z') goto yy658;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy20;
				goto yy663;
			} else {
				if (yych <= 'd') goto yy727;
				if (yych <= 'z') goto yy663;
				goto yy20;
			}
		}
	}
yy553:
	YYDEBUG(553, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy658;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'F') goto yy715;
			if (yych <= 'Z') goto yy658;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'e') {
				if (yych <= '`') goto yy20;
				goto yy663;
			} else {
				if (yych <= 'f') goto yy719;
				if (yych <= 'z') goto yy663;
				goto yy20;
			}
		}
	}
yy554:
	YYDEBUG(554, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy142;
			goto yy20;
		} else {
			if (yych <= ' ') goto yy142;
			if (yych == ')') goto yy115;
			goto yy20;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy20;
			if (yych <= '9') goto yy142;
			goto yy20;
		} else {
			if (yych <= 'Z') goto yy658;
			if (yych <= '`') goto yy20;
			if (yych <= 'z') goto yy658;
			goto yy20;
		}
	}
yy555:
	YYDEBUG(555, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'D') goto yy658;
			goto yy728;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy658;
			if (yych <= '`') goto yy20;
			goto yy658;
		} else {
			if (yych <= 'e') goto yy728;
			if (yych <= 'z') goto yy658;
			goto yy20;
		}
	}
yy556:
	YYDEBUG(556, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy658;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy728;
			if (yych <= 'Z') goto yy658;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy20;
				goto yy663;
			} else {
				if (yych <= 'e') goto yy729;
				if (yych <= 'z') goto yy663;
				goto yy20;
			}
		}
	}
yy557:
	YYDEBUG(557, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'D') goto yy658;
			goto yy730;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy658;
			if (yych <= '`') goto yy20;
			goto yy658;
		} else {
			if (yych <= 'e') goto yy730;
			if (yych <= 'z') goto yy658;
			goto yy20;
		}
	}
yy558:
	YYDEBUG(558, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy658;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy730;
			if (yych <= 'Z') goto yy658;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy20;
				goto yy663;
			} else {
				if (yych <= 'e') goto yy731;
				if (yych <= 'z') goto yy663;
				goto yy20;
			}
		}
	}
yy559:
	YYDEBUG(559, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0x80) goto yy194;
	goto yy59;
yy560:
	YYDEBUG(560, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy196;
		if (yych <= '9') goto yy594;
		goto yy196;
	} else {
		if (yych <= 0xC2) goto yy97;
		if (yych == 0xE2) goto yy98;
		goto yy196;
	}
yy561:
	YYDEBUG(561, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= '9') {
			if (yych <= ',') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy20;
					goto yy196;
				} else {
					if (yych == ' ') goto yy196;
					goto yy20;
				}
			} else {
				if (yych <= '/') {
					if (yych <= '-') goto yy732;
					goto yy20;
				} else {
					if (yych <= '5') goto yy733;
					if (yych <= '6') goto yy734;
					goto yy735;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy20;
					goto yy196;
				} else {
					if (yych == 'F') goto yy196;
					goto yy20;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'H') goto yy196;
					if (yych <= 'L') goto yy20;
					goto yy196;
				} else {
					if (yych <= 'R') goto yy20;
					if (yych <= 'U') goto yy196;
					goto yy20;
				}
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy196;
					goto yy20;
				} else {
					if (yych <= 'Y') goto yy196;
					if (yych <= 'c') goto yy20;
					goto yy196;
				}
			} else {
				if (yych <= 'g') {
					if (yych == 'f') goto yy196;
					goto yy20;
				} else {
					if (yych <= 'h') goto yy196;
					if (yych <= 'l') goto yy20;
					goto yy196;
				}
			}
		} else {
			if (yych <= 'x') {
				if (yych <= 'u') {
					if (yych <= 'r') goto yy20;
					goto yy196;
				} else {
					if (yych == 'w') goto yy196;
					goto yy20;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 'y') goto yy196;
					if (yych <= 0xC1) goto yy20;
					goto yy97;
				} else {
					if (yych == 0xE2) goto yy98;
					goto yy20;
				}
			}
		}
	}
yy562:
	YYDEBUG(562, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych == '-') goto yy732;
		if (yych <= '/') goto yy196;
		goto yy735;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy196;
			goto yy97;
		} else {
			if (yych == 0xE2) goto yy98;
			goto yy196;
		}
	}
yy563:
	YYDEBUG(563, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy20;
	if (yych <= '9') goto yy736;
	goto yy20;
yy564:
	YYDEBUG(564, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy737;
	goto yy59;
yy565:
	YYDEBUG(565, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy738;
	goto yy59;
yy566:
	YYDEBUG(566, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy567;
		if (yych <= '9') goto yy740;
		if (yych >= 'n') goto yy741;
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy741;
		} else {
			if (yych <= 's') goto yy742;
			if (yych <= 't') goto yy743;
		}
	}
yy567:
	YYDEBUG(567, *YYCURSOR);
#line 1539 "ext/date/lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("gnudateshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
		s->time->m = timelib_get_nr(&ptr, 2);
		s->time->d = timelib_get_nr(&ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 14122 "<stdout>"
yy568:
	YYDEBUG(568, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '1') {
			if (yych <= '/') goto yy567;
			goto yy740;
		} else {
			if (yych <= '9') goto yy737;
			if (yych <= 'm') goto yy567;
			goto yy741;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy567;
			goto yy741;
		} else {
			if (yych <= 's') goto yy742;
			if (yych <= 't') goto yy743;
			goto yy567;
		}
	}
yy569:
	YYDEBUG(569, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy567;
		if (yych <= '9') goto yy737;
		if (yych <= 'm') goto yy567;
		goto yy741;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy567;
			goto yy741;
		} else {
			if (yych <= 's') goto yy742;
			if (yych <= 't') goto yy743;
			goto yy567;
		}
	}
yy570:
	YYDEBUG(570, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy744;
	if (yych <= '/') goto yy177;
	if (yych <= '9') goto yy745;
	goto yy177;
yy571:
	YYDEBUG(571, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy744;
		goto yy177;
	} else {
		if (yych <= '0') goto yy745;
		if (yych <= '9') goto yy738;
		goto yy177;
	}
yy572:
	YYDEBUG(572, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy744;
	if (yych <= '/') goto yy177;
	if (yych <= '9') goto yy738;
	goto yy177;
yy573:
	YYDEBUG(573, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy744;
	if (yych <= '/') goto yy177;
	if (yych <= '9') goto yy575;
	goto yy177;
yy574:
	YYDEBUG(574, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy744;
	if (yych != '0') goto yy177;
yy575:
	YYDEBUG(575, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy744;
	goto yy177;
yy576:
	YYDEBUG(576, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy224;
	if (yych <= '9') goto yy746;
	goto yy224;
yy577:
	YYDEBUG(577, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '/') goto yy402;
	goto yy224;
yy578:
	YYDEBUG(578, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '/') goto yy747;
	goto yy59;
yy579:
	YYDEBUG(579, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '/') goto yy747;
		goto yy59;
	} else {
		if (yych <= 'T') goto yy578;
		if (yych == 't') goto yy578;
		goto yy59;
	}
yy580:
	YYDEBUG(580, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy59;
	if (yych <= '-') goto yy748;
	if (yych <= '.') goto yy396;
	goto yy59;
yy581:
	YYDEBUG(581, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy645;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy462;
	goto yy59;
yy582:
	YYDEBUG(582, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy645;
	if (yych <= '/') goto yy59;
	if (yych <= '2') goto yy462;
	goto yy59;
yy583:
	YYDEBUG(583, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy584:
	YYDEBUG(584, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'G') {
			if (yych <= '.') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy583;
					goto yy59;
				} else {
					if (yych <= ' ') goto yy583;
					if (yych <= ',') goto yy59;
					goto yy749;
				}
			} else {
				if (yych <= 'C') {
					if (yych == 'A') goto yy596;
					goto yy59;
				} else {
					if (yych <= 'D') goto yy597;
					if (yych == 'F') goto yy598;
					goto yy59;
				}
			}
		} else {
			if (yych <= 'N') {
				if (yych <= 'J') {
					if (yych <= 'H') goto yy79;
					if (yych <= 'I') goto yy599;
					goto yy601;
				} else {
					if (yych <= 'L') goto yy59;
					if (yych <= 'M') goto yy602;
					goto yy603;
				}
			} else {
				if (yych <= 'S') {
					if (yych <= 'O') goto yy604;
					if (yych <= 'R') goto yy59;
					goto yy605;
				} else {
					if (yych <= 'T') goto yy87;
					if (yych <= 'U') goto yy88;
					if (yych <= 'V') goto yy606;
					goto yy90;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= '`') {
					if (yych <= 'X') goto yy608;
					if (yych <= 'Y') goto yy92;
					goto yy59;
				} else {
					if (yych <= 'a') goto yy596;
					if (yych <= 'c') goto yy59;
					goto yy597;
				}
			} else {
				if (yych <= 'g') {
					if (yych == 'f') goto yy598;
					goto yy59;
				} else {
					if (yych <= 'h') goto yy79;
					if (yych == 'j') goto yy601;
					goto yy59;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'o') {
					if (yych <= 'm') goto yy602;
					if (yych <= 'n') goto yy603;
					goto yy604;
				} else {
					if (yych <= 'r') goto yy59;
					if (yych <= 's') goto yy605;
					if (yych <= 't') goto yy87;
					goto yy88;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy90;
					goto yy59;
				} else {
					if (yych <= 'y') goto yy92;
					if (yych == 0xC2) goto yy211;
					goto yy59;
				}
			}
		}
	}
yy585:
	YYDEBUG(585, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy751;
	case '1':	goto yy753;
	case '2':	goto yy754;
	case '3':	goto yy755;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy756;
	case 'A':
	case 'a':	goto yy757;
	case 'D':
	case 'd':	goto yy758;
	case 'F':
	case 'f':	goto yy759;
	case 'J':
	case 'j':	goto yy760;
	case 'M':
	case 'm':	goto yy761;
	case 'N':
	case 'n':	goto yy762;
	case 'O':
	case 'o':	goto yy763;
	case 'S':
	case 's':	goto yy764;
	case 'W':	goto yy765;
	default:	goto yy750;
	}
yy586:
	YYDEBUG(586, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy750;
	if (yych <= '0') goto yy766;
	if (yych <= '2') goto yy767;
	if (yych <= '3') goto yy768;
	goto yy750;
yy587:
	YYDEBUG(587, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '0') goto yy773;
	if (yych <= '1') goto yy774;
	if (yych <= '9') goto yy775;
	goto yy59;
yy588:
	YYDEBUG(588, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy196;
		if (yych <= '0') goto yy776;
		if (yych <= '9') goto yy778;
		goto yy196;
	} else {
		if (yych <= 0xC2) goto yy97;
		if (yych == 0xE2) goto yy98;
		goto yy196;
	}
yy589:
	YYDEBUG(589, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy196;
		if (yych <= '2') goto yy778;
		if (yych <= '9') goto yy779;
		goto yy196;
	} else {
		if (yych <= 0xC2) goto yy97;
		if (yych == 0xE2) goto yy98;
		goto yy196;
	}
yy590:
	YYDEBUG(590, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy196;
		if (yych <= '9') goto yy779;
		goto yy196;
	} else {
		if (yych <= 0xC2) goto yy97;
		if (yych == 0xE2) goto yy98;
		goto yy196;
	}
yy591:
	YYDEBUG(591, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '/') goto yy196;
		if (yych <= '5') goto yy779;
		if (yych <= '6') goto yy780;
		goto yy781;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy196;
			goto yy97;
		} else {
			if (yych == 0xE2) goto yy98;
			goto yy196;
		}
	}
yy592:
	YYDEBUG(592, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy196;
		if (yych <= '9') goto yy781;
		goto yy196;
	} else {
		if (yych <= 0xC2) goto yy97;
		if (yych == 0xE2) goto yy98;
		goto yy196;
	}
yy593:
	YYDEBUG(593, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy196;
		if (yych <= '0') goto yy781;
		if (yych <= '9') goto yy782;
		goto yy196;
	} else {
		if (yych <= 0xC2) goto yy97;
		if (yych == 0xE2) goto yy98;
		goto yy196;
	}
yy594:
	YYDEBUG(594, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy196;
		if (yych <= '9') goto yy782;
		goto yy196;
	} else {
		if (yych <= 0xC2) goto yy97;
		if (yych == 0xE2) goto yy98;
		goto yy196;
	}
yy595:
	YYDEBUG(595, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '0') goto yy783;
	if (yych <= '1') goto yy784;
	goto yy59;
yy596:
	YYDEBUG(596, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy785;
		if (yych <= 'T') goto yy59;
		goto yy786;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy59;
			goto yy785;
		} else {
			if (yych == 'u') goto yy786;
			goto yy59;
		}
	}
yy597:
	YYDEBUG(597, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy242;
		if (yych <= 'D') goto yy59;
		goto yy787;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy59;
			goto yy242;
		} else {
			if (yych == 'e') goto yy787;
			goto yy59;
		}
	}
yy598:
	YYDEBUG(598, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy788;
			goto yy59;
		} else {
			if (yych <= 'O') goto yy245;
			if (yych <= 'Q') goto yy59;
			goto yy246;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy788;
			goto yy59;
		} else {
			if (yych <= 'o') goto yy245;
			if (yych == 'r') goto yy246;
			goto yy59;
		}
	}
yy599:
	YYDEBUG(599, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'I') goto yy789;
	} else {
		if (yych == 'W') goto yy600;
		if (yych <= 'X') goto yy790;
	}
yy600:
	YYDEBUG(600, *YYCURSOR);
#line 1608 "ext/date/lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("datenodayrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
		s->time->m = timelib_get_month(&ptr);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
#line 14586 "<stdout>"
yy601:
	YYDEBUG(601, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy791;
		if (yych <= 'T') goto yy59;
		goto yy792;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy59;
			goto yy791;
		} else {
			if (yych == 'u') goto yy792;
			goto yy59;
		}
	}
yy602:
	YYDEBUG(602, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= 'I') {
			if (yych == 'A') goto yy793;
			if (yych <= 'H') goto yy59;
			goto yy257;
		} else {
			if (yych == 'O') goto yy258;
			if (yych <= 'R') goto yy59;
			goto yy259;
		}
	} else {
		if (yych <= 'i') {
			if (yych == 'a') goto yy793;
			if (yych <= 'h') goto yy59;
			goto yy257;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto yy59;
				goto yy258;
			} else {
				if (yych == 's') goto yy259;
				goto yy59;
			}
		}
	}
yy603:
	YYDEBUG(603, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy794;
	if (yych == 'o') goto yy794;
	goto yy59;
yy604:
	YYDEBUG(604, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy795;
	if (yych == 'c') goto yy795;
	goto yy59;
yy605:
	YYDEBUG(605, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy263;
			goto yy59;
		} else {
			if (yych <= 'E') goto yy796;
			if (yych <= 'T') goto yy59;
			goto yy265;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy263;
			goto yy59;
		} else {
			if (yych <= 'e') goto yy796;
			if (yych == 'u') goto yy265;
			goto yy59;
		}
	}
yy606:
	YYDEBUG(606, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy608;
	goto yy600;
yy607:
	YYDEBUG(607, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy59;
		if (yych <= '0') goto yy797;
		if (yych <= '4') goto yy798;
		goto yy799;
	} else {
		if (yych <= 'E') {
			if (yych <= 'D') goto yy59;
			goto yy269;
		} else {
			if (yych == 'e') goto yy269;
			goto yy59;
		}
	}
yy608:
	YYDEBUG(608, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy789;
	goto yy600;
yy609:
	YYDEBUG(609, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy196;
		if (yych <= '0') goto yy800;
		if (yych <= '9') goto yy801;
		goto yy196;
	} else {
		if (yych <= 0xC2) goto yy97;
		if (yych == 0xE2) goto yy98;
		goto yy196;
	}
yy610:
	YYDEBUG(610, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy196;
		if (yych <= '2') goto yy801;
		if (yych <= '9') goto yy802;
		goto yy196;
	} else {
		if (yych <= 0xC2) goto yy97;
		if (yych == 0xE2) goto yy98;
		goto yy196;
	}
yy611:
	YYDEBUG(611, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy196;
		if (yych <= '9') goto yy802;
		goto yy196;
	} else {
		if (yych <= 0xC2) goto yy97;
		if (yych == 0xE2) goto yy98;
		goto yy196;
	}
yy612:
	YYDEBUG(612, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '/') goto yy196;
		if (yych <= '5') goto yy802;
		if (yych <= '6') goto yy803;
		goto yy782;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy196;
			goto yy97;
		} else {
			if (yych == 0xE2) goto yy98;
			goto yy196;
		}
	}
yy613:
	YYDEBUG(613, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy253;
	if (yych == 'l') goto yy253;
	goto yy59;
yy614:
	YYDEBUG(614, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy804;
	if (yych == 's') goto yy804;
	goto yy59;
yy615:
	YYDEBUG(615, *YYCURSOR);
	++YYCURSOR;
	goto yy260;
yy616:
	YYDEBUG(616, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy626;
	if (yych == 'm') goto yy626;
	goto yy59;
yy617:
	YYDEBUG(617, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy620;
	if (yych == 'u') goto yy620;
	goto yy59;
yy618:
	YYDEBUG(618, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy805;
		if (yych <= 'M') goto yy59;
		goto yy806;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy59;
			goto yy805;
		} else {
			if (yych == 'n') goto yy806;
			goto yy59;
		}
	}
yy619:
	YYDEBUG(619, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy251;
	if (yych <= '9') goto yy807;
	goto yy251;
yy620:
	YYDEBUG(620, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy808;
	if (yych == 'a') goto yy808;
	goto yy59;
yy621:
	YYDEBUG(621, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy253;
	if (yych == 'h') goto yy253;
	goto yy59;
yy622:
	YYDEBUG(622, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy809;
	if (yych == 'o') goto yy809;
	goto yy59;
yy623:
	YYDEBUG(623, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy809;
	if (yych == 'i') goto yy809;
	goto yy59;
yy624:
	YYDEBUG(624, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy810;
	if (yych == 't') goto yy810;
	goto yy59;
yy625:
	YYDEBUG(625, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy425;
	if (yych == 'h') goto yy425;
	goto yy59;
yy626:
	YYDEBUG(626, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy811;
	if (yych == 'b') goto yy811;
	goto yy59;
yy627:
	YYDEBUG(627, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy630;
	if (yych == 'r') goto yy630;
	goto yy59;
yy628:
	YYDEBUG(628, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy812;
	if (yych == 'n') goto yy812;
	goto yy59;
yy629:
	YYDEBUG(629, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy630;
	if (yych != 's') goto yy59;
yy630:
	YYDEBUG(630, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy198;
	if (yych == 'd') goto yy198;
	goto yy59;
yy631:
	YYDEBUG(631, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy629;
	if (yych == 'e') goto yy629;
	goto yy59;
yy632:
	YYDEBUG(632, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'D') goto yy198;
		if (yych <= 'R') goto yy260;
		goto yy615;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy260;
			goto yy198;
		} else {
			if (yych == 's') goto yy615;
			goto yy260;
		}
	}
yy633:
	YYDEBUG(633, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy59;
	if (yych <= '.') goto yy396;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy635;
	goto yy59;
yy634:
	YYDEBUG(634, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy59;
	if (yych <= '.') goto yy396;
	if (yych <= '/') goto yy59;
	if (yych >= '3') goto yy59;
yy635:
	YYDEBUG(635, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy59;
	if (yych <= '.') goto yy396;
	goto yy59;
yy636:
	YYDEBUG(636, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy744;
	if (yych <= '/') goto yy177;
	if (yych <= '9') goto yy813;
	goto yy177;
yy637:
	YYDEBUG(637, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy744;
		goto yy177;
	} else {
		if (yych <= '0') goto yy813;
		if (yych <= '9') goto yy738;
		goto yy177;
	}
yy638:
	YYDEBUG(638, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(639, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy638;
			goto yy59;
		} else {
			if (yych <= ' ') goto yy638;
			if (yych <= '@') goto yy59;
			goto yy106;
		}
	} else {
		if (yych <= '`') {
			if (yych == 'P') goto yy106;
			goto yy59;
		} else {
			if (yych <= 'a') goto yy106;
			if (yych == 'p') goto yy106;
			goto yy59;
		}
	}
yy640:
	YYDEBUG(640, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xA0) goto yy814;
	goto yy59;
yy641:
	YYDEBUG(641, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0x80) goto yy815;
	goto yy59;
yy642:
	YYDEBUG(642, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy744;
	if (yych <= '/') goto yy177;
	if (yych <= '9') goto yy816;
	goto yy177;
yy643:
	YYDEBUG(643, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy744;
	if (yych == '0') goto yy816;
	goto yy177;
yy644:
	YYDEBUG(644, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '5') goto yy817;
	if (yych <= '6') goto yy818;
	if (yych <= '9') goto yy575;
	goto yy59;
yy645:
	YYDEBUG(645, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '2') goto yy819;
	if (yych <= '3') goto yy820;
	if (yych <= '9') goto yy821;
	goto yy59;
yy646:
	YYDEBUG(646, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy822;
	goto yy59;
yy647:
	YYDEBUG(647, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy823;
	if (yych == 'r') goto yy823;
	goto yy59;
yy648:
	YYDEBUG(648, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy823;
	if (yych == 'g') goto yy823;
	goto yy59;
yy649:
	YYDEBUG(649, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy823;
	if (yych == 'c') goto yy823;
	goto yy59;
yy650:
	YYDEBUG(650, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy823;
	if (yych == 'b') goto yy823;
	goto yy59;
yy651:
	YYDEBUG(651, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy823;
	if (yych == 'n') goto yy823;
	goto yy59;
yy652:
	YYDEBUG(652, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy823;
		if (yych <= 'M') goto yy59;
		goto yy823;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy59;
			goto yy823;
		} else {
			if (yych == 'n') goto yy823;
			goto yy59;
		}
	}
yy653:
	YYDEBUG(653, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy823;
		if (yych <= 'X') goto yy59;
		goto yy823;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy59;
			goto yy823;
		} else {
			if (yych == 'y') goto yy823;
			goto yy59;
		}
	}
yy654:
	YYDEBUG(654, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy823;
	if (yych == 'v') goto yy823;
	goto yy59;
yy655:
	YYDEBUG(655, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy823;
	if (yych == 't') goto yy823;
	goto yy59;
yy656:
	YYDEBUG(656, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy824;
	if (yych == 'p') goto yy824;
	goto yy59;
yy657:
	YYDEBUG(657, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy290;
	if (yych <= '9') goto yy825;
	goto yy290;
yy658:
	YYDEBUG(658, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy115;
		goto yy20;
	} else {
		if (yych <= 'Z') goto yy826;
		if (yych <= '`') goto yy20;
		if (yych <= 'z') goto yy826;
		goto yy20;
	}
yy659:
	YYDEBUG(659, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy324;
				goto yy59;
			} else {
				if (yych <= '\t') goto yy326;
				if (yych <= 0x1F) goto yy59;
				goto yy326;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy326;
				goto yy59;
			} else {
				if (yych <= '.') goto yy326;
				if (yych <= '/') goto yy59;
				goto yy827;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy59;
				goto yy326;
			} else {
				if (yych == 'h') goto yy326;
				goto yy59;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy329;
				if (yych <= 'q') goto yy59;
				goto yy329;
			} else {
				if (yych <= 's') goto yy330;
				if (yych <= 't') goto yy331;
				goto yy59;
			}
		}
	}
yy660:
	YYDEBUG(660, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy324;
				goto yy59;
			} else {
				if (yych <= '\t') goto yy326;
				if (yych <= 0x1F) goto yy59;
				goto yy326;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy326;
				goto yy59;
			} else {
				if (yych <= '.') goto yy326;
				if (yych <= '/') goto yy59;
				goto yy827;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= '9') goto yy332;
				if (yych <= 'c') goto yy59;
				goto yy326;
			} else {
				if (yych == 'h') goto yy326;
				goto yy59;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy329;
				if (yych <= 'q') goto yy59;
				goto yy329;
			} else {
				if (yych <= 's') goto yy330;
				if (yych <= 't') goto yy331;
				goto yy59;
			}
		}
	}
yy661:
	YYDEBUG(661, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy142;
			goto yy295;
		} else {
			if (yych <= ' ') goto yy142;
			if (yych == ')') goto yy115;
			goto yy295;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy295;
			if (yych <= '9') goto yy142;
			goto yy295;
		} else {
			if (yych <= 'Z') goto yy826;
			if (yych <= '`') goto yy295;
			if (yych <= 'z') goto yy826;
			goto yy295;
		}
	}
yy662:
	YYDEBUG(662, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'S') goto yy826;
			goto yy828;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy826;
			if (yych <= '`') goto yy20;
			goto yy826;
		} else {
			if (yych <= 't') goto yy828;
			if (yych <= 'z') goto yy826;
			goto yy20;
		}
	}
yy663:
	YYDEBUG(663, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy115;
			goto yy20;
		} else {
			if (yych == '.') goto yy20;
			goto yy297;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy20;
			if (yych <= 'Z') goto yy826;
			goto yy20;
		} else {
			if (yych <= '_') goto yy297;
			if (yych <= '`') goto yy20;
			if (yych <= 'z') goto yy829;
			goto yy20;
		}
	}
yy664:
	YYDEBUG(664, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy142;
			if (yych <= 0x1F) goto yy295;
			goto yy142;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy295;
				goto yy115;
			} else {
				if (yych <= ',') goto yy295;
				if (yych <= '-') goto yy700;
				goto yy142;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy297;
			if (yych <= '9') goto yy142;
			if (yych <= '@') goto yy295;
			goto yy826;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy295;
				goto yy297;
			} else {
				if (yych <= '`') goto yy295;
				if (yych <= 'z') goto yy829;
				goto yy295;
			}
		}
	}
yy665:
	YYDEBUG(665, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy826;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy828;
			if (yych <= 'Z') goto yy826;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy20;
				goto yy829;
			} else {
				if (yych <= 't') goto yy830;
				if (yych <= 'z') goto yy829;
				goto yy20;
			}
		}
	}
yy666:
	YYDEBUG(666, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy831;
	if (yych == 'o') goto yy831;
	goto yy59;
yy667:
	YYDEBUG(667, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'A') goto yy826;
			goto yy832;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy826;
			if (yych <= '`') goto yy20;
			goto yy826;
		} else {
			if (yych <= 'b') goto yy832;
			if (yych <= 'z') goto yy826;
			goto yy20;
		}
	}
yy668:
	YYDEBUG(668, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy826;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy832;
			if (yych <= 'Z') goto yy826;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy20;
				goto yy829;
			} else {
				if (yych <= 'b') goto yy833;
				if (yych <= 'z') goto yy829;
				goto yy20;
			}
		}
	}
yy669:
	YYDEBUG(669, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy834;
			if (yych <= 0x1F) goto yy20;
			goto yy834;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy20;
				goto yy115;
			} else {
				if (yych <= '@') goto yy20;
				if (yych <= 'G') goto yy826;
				goto yy836;
			}
		}
	} else {
		if (yych <= 'z') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy826;
				goto yy20;
			} else {
				if (yych == 'h') goto yy836;
				goto yy826;
			}
		} else {
			if (yych <= 0xC2) {
				if (yych <= 0xC1) goto yy20;
				goto yy837;
			} else {
				if (yych == 0xE2) goto yy838;
				goto yy20;
			}
		}
	}
yy670:
	YYDEBUG(670, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'M') goto yy826;
			goto yy839;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy826;
			if (yych <= '`') goto yy20;
			goto yy826;
		} else {
			if (yych <= 'n') goto yy839;
			if (yych <= 'z') goto yy826;
			goto yy20;
		}
	}
yy671:
	YYDEBUG(671, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= 0x1F) {
				if (yych == '\t') goto yy834;
				goto yy20;
			} else {
				if (yych <= ' ') goto yy834;
				if (yych <= '(') goto yy20;
				goto yy115;
			}
		} else {
			if (yych <= '.') {
				if (yych == '-') goto yy297;
				goto yy20;
			} else {
				if (yych <= '/') goto yy297;
				if (yych <= '@') goto yy20;
				goto yy826;
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= '^') {
				if (yych <= 'H') goto yy836;
				if (yych <= 'Z') goto yy826;
				goto yy20;
			} else {
				if (yych <= '_') goto yy297;
				if (yych <= '`') goto yy20;
				goto yy829;
			}
		} else {
			if (yych <= 0xC1) {
				if (yych <= 'h') goto yy840;
				if (yych <= 'z') goto yy829;
				goto yy20;
			} else {
				if (yych <= 0xC2) goto yy837;
				if (yych == 0xE2) goto yy838;
				goto yy20;
			}
		}
	}
yy672:
	YYDEBUG(672, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy826;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy839;
			if (yych <= 'Z') goto yy826;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy20;
				goto yy829;
			} else {
				if (yych <= 'n') goto yy841;
				if (yych <= 'z') goto yy829;
				goto yy20;
			}
		}
	}
yy673:
	YYDEBUG(673, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy115;
		if (yych <= '@') goto yy20;
		goto yy842;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy826;
			goto yy20;
		} else {
			if (yych <= 'a') goto yy842;
			if (yych <= 'z') goto yy826;
			goto yy20;
		}
	}
yy674:
	YYDEBUG(674, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy834;
			goto yy20;
		} else {
			if (yych <= ' ') goto yy834;
			if (yych == ')') goto yy115;
			goto yy20;
		}
	} else {
		if (yych <= 0xC1) {
			if (yych <= 'Z') goto yy826;
			if (yych <= '`') goto yy20;
			if (yych <= 'z') goto yy826;
			goto yy20;
		} else {
			if (yych <= 0xC2) goto yy837;
			if (yych == 0xE2) goto yy838;
			goto yy20;
		}
	}
yy675:
	YYDEBUG(675, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy834;
			goto yy20;
		} else {
			if (yych <= ' ') goto yy843;
			if (yych == ')') goto yy115;
			goto yy20;
		}
	} else {
		if (yych <= 0xC1) {
			if (yych <= 'Z') goto yy826;
			if (yych <= '`') goto yy20;
			if (yych <= 'z') goto yy826;
			goto yy20;
		} else {
			if (yych <= 0xC2) goto yy837;
			if (yych == 0xE2) goto yy838;
			goto yy20;
		}
	}
yy676:
	YYDEBUG(676, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'G') goto yy826;
			goto yy836;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy826;
			if (yych <= '`') goto yy20;
			goto yy826;
		} else {
			if (yych <= 'h') goto yy836;
			if (yych <= 'z') goto yy826;
			goto yy20;
		}
	}
yy677:
	YYDEBUG(677, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'X') goto yy826;
			goto yy844;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy826;
			if (yych <= '`') goto yy20;
			goto yy826;
		} else {
			if (yych <= 'y') goto yy844;
			if (yych <= 'z') goto yy826;
			goto yy20;
		}
	}
yy678:
	YYDEBUG(678, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych == ' ') goto yy666;
		if (yych <= '(') goto yy20;
		goto yy115;
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy20;
			goto yy826;
		} else {
			if (yych <= '`') goto yy20;
			if (yych <= 'z') goto yy826;
			goto yy20;
		}
	}
yy679:
	YYDEBUG(679, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy115;
			goto yy20;
		} else {
			if (yych == '.') goto yy20;
			if (yych <= '/') goto yy297;
			goto yy20;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy842;
			if (yych <= 'Z') goto yy826;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= '`') goto yy20;
			if (yych <= 'a') goto yy845;
			if (yych <= 'z') goto yy829;
			goto yy20;
		}
	}
yy680:
	YYDEBUG(680, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy20;
				goto yy834;
			} else {
				if (yych == ' ') goto yy834;
				goto yy20;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy115;
				goto yy20;
			} else {
				if (yych == '.') goto yy20;
				goto yy297;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= '@') goto yy20;
				goto yy826;
			} else {
				if (yych == '_') goto yy297;
				goto yy20;
			}
		} else {
			if (yych <= 0xC2) {
				if (yych <= 'z') goto yy829;
				if (yych <= 0xC1) goto yy20;
				goto yy837;
			} else {
				if (yych == 0xE2) goto yy838;
				goto yy20;
			}
		}
	}
yy681:
	YYDEBUG(681, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy20;
				goto yy834;
			} else {
				if (yych == ' ') goto yy843;
				goto yy20;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy115;
				goto yy20;
			} else {
				if (yych == '.') goto yy20;
				goto yy297;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= '@') goto yy20;
				goto yy826;
			} else {
				if (yych == '_') goto yy297;
				goto yy20;
			}
		} else {
			if (yych <= 0xC2) {
				if (yych <= 'z') goto yy829;
				if (yych <= 0xC1) goto yy20;
				goto yy837;
			} else {
				if (yych == 0xE2) goto yy838;
				goto yy20;
			}
		}
	}
yy682:
	YYDEBUG(682, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy826;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy836;
			if (yych <= 'Z') goto yy826;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy20;
				goto yy829;
			} else {
				if (yych <= 'h') goto yy840;
				if (yych <= 'z') goto yy829;
				goto yy20;
			}
		}
	}
yy683:
	YYDEBUG(683, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy826;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy844;
			if (yych <= 'Z') goto yy826;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy20;
				goto yy829;
			} else {
				if (yych <= 'y') goto yy846;
				if (yych <= 'z') goto yy829;
				goto yy20;
			}
		}
	}
yy684:
	YYDEBUG(684, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= '(') {
			if (yych == ' ') goto yy666;
			goto yy20;
		} else {
			if (yych <= ')') goto yy115;
			if (yych == '-') goto yy297;
			goto yy20;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '/') goto yy297;
			if (yych <= '@') goto yy20;
			if (yych <= 'Z') goto yy826;
			goto yy20;
		} else {
			if (yych <= '_') goto yy297;
			if (yych <= '`') goto yy20;
			if (yych <= 'z') goto yy829;
			goto yy20;
		}
	}
yy685:
	YYDEBUG(685, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy20;
	if (yych <= '9') goto yy847;
	if (yych <= ':') goto yy203;
	goto yy20;
yy686:
	YYDEBUG(686, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '5') {
		if (yych <= '/') goto yy20;
		if (yych <= '4') goto yy847;
		goto yy394;
	} else {
		if (yych <= '9') goto yy115;
		if (yych <= ':') goto yy203;
		goto yy20;
	}
yy687:
	YYDEBUG(687, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy20;
	if (yych <= '5') goto yy394;
	if (yych <= '9') goto yy115;
	if (yych <= ':') goto yy203;
	goto yy20;
yy688:
	YYDEBUG(688, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '5') goto yy848;
	if (yych <= '9') goto yy850;
	goto yy59;
yy689:
	YYDEBUG(689, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy688;
	if (yych == ':') goto yy688;
	goto yy59;
yy690:
	YYDEBUG(690, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '5') goto yy851;
	if (yych <= '9') goto yy852;
	goto yy59;
yy691:
	YYDEBUG(691, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy688;
		goto yy59;
	} else {
		if (yych <= '9') goto yy689;
		if (yych <= ':') goto yy688;
		goto yy59;
	}
yy692:
	YYDEBUG(692, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy688;
		goto yy59;
	} else {
		if (yych <= '4') goto yy689;
		if (yych == ':') goto yy688;
		goto yy59;
	}
yy693:
	YYDEBUG(693, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy688;
		goto yy325;
	} else {
		if (yych <= '9') goto yy853;
		if (yych <= ':') goto yy688;
		goto yy325;
	}
yy694:
	YYDEBUG(694, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy690;
		goto yy325;
	} else {
		if (yych <= '9') goto yy853;
		if (yych <= ':') goto yy690;
		goto yy325;
	}
yy695:
	YYDEBUG(695, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy325;
	if (yych <= '9') goto yy853;
	goto yy325;
yy696:
	YYDEBUG(696, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(697, *YYCURSOR);
#line 1594 "ext/date/lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("datenoday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month(&ptr);
		s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
#line 15974 "<stdout>"
yy698:
	YYDEBUG(698, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'Q') goto yy826;
			goto yy854;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy826;
			if (yych <= '`') goto yy20;
			goto yy826;
		} else {
			if (yych <= 'r') goto yy854;
			if (yych <= 'z') goto yy826;
			goto yy20;
		}
	}
yy699:
	YYDEBUG(699, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy826;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy854;
			if (yych <= 'Z') goto yy826;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy20;
				goto yy829;
			} else {
				if (yych <= 'r') goto yy855;
				if (yych <= 'z') goto yy829;
				goto yy20;
			}
		}
	}
yy700:
	YYDEBUG(700, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 64) {
		goto yy476;
	}
	goto yy142;
yy701:
	YYDEBUG(701, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy702:
	YYDEBUG(702, *YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy701;
				if (yych <= 0x1F) goto yy59;
				goto yy701;
			} else {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy59;
					goto yy856;
				} else {
					if (yych == 'F') goto yy857;
					goto yy59;
				}
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy858;
					goto yy59;
				} else {
					if (yych <= 'M') goto yy859;
					if (yych <= 'R') goto yy59;
					goto yy860;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'T') goto yy861;
					goto yy862;
				} else {
					if (yych == 'W') goto yy863;
					goto yy59;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy864;
					goto yy59;
				} else {
					if (yych <= 'd') goto yy856;
					if (yych <= 'e') goto yy59;
					goto yy857;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy59;
					goto yy858;
				} else {
					if (yych == 'm') goto yy859;
					goto yy59;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 's') goto yy860;
					goto yy861;
				} else {
					if (yych <= 'u') goto yy862;
					if (yych <= 'v') goto yy59;
					goto yy863;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy59;
					goto yy864;
				} else {
					if (yych == 0xC2) goto yy865;
					goto yy59;
				}
			}
		}
	}
yy703:
	YYDEBUG(703, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy866;
	if (yych == 'd') goto yy866;
	goto yy702;
yy704:
	YYDEBUG(704, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 0xA0) goto yy867;
	goto yy59;
yy705:
	YYDEBUG(705, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0x80) goto yy868;
	goto yy59;
yy706:
	YYDEBUG(706, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'F') goto yy826;
			goto yy869;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy826;
			if (yych <= '`') goto yy20;
			goto yy826;
		} else {
			if (yych <= 'g') goto yy869;
			if (yych <= 'z') goto yy826;
			goto yy20;
		}
	}
yy707:
	YYDEBUG(707, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy826;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy869;
			if (yych <= 'Z') goto yy826;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy20;
				goto yy829;
			} else {
				if (yych <= 'g') goto yy870;
				if (yych <= 'z') goto yy829;
				goto yy20;
			}
		}
	}
yy708:
	YYDEBUG(708, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'D') goto yy826;
			goto yy871;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy826;
			if (yych <= '`') goto yy20;
			goto yy826;
		} else {
			if (yych <= 'e') goto yy871;
			if (yych <= 'z') goto yy826;
			goto yy20;
		}
	}
yy709:
	YYDEBUG(709, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy826;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy871;
			if (yych <= 'Z') goto yy826;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy20;
				goto yy829;
			} else {
				if (yych <= 'e') goto yy872;
				if (yych <= 'z') goto yy829;
				goto yy20;
			}
		}
	}
yy710:
	YYDEBUG(710, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'N') goto yy826;
			goto yy873;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy826;
			if (yych <= '`') goto yy20;
			goto yy826;
		} else {
			if (yych <= 'o') goto yy873;
			if (yych <= 'z') goto yy826;
			goto yy20;
		}
	}
yy711:
	YYDEBUG(711, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy826;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy873;
			if (yych <= 'Z') goto yy826;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy20;
				goto yy829;
			} else {
				if (yych <= 'o') goto yy874;
				if (yych <= 'z') goto yy829;
				goto yy20;
			}
		}
	}
yy712:
	YYDEBUG(712, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'C') goto yy826;
			goto yy875;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy826;
			if (yych <= '`') goto yy20;
			goto yy826;
		} else {
			if (yych <= 'd') goto yy875;
			if (yych <= 'z') goto yy826;
			goto yy20;
		}
	}
yy713:
	YYDEBUG(713, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'C') goto yy826;
			goto yy836;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy826;
			if (yych <= '`') goto yy20;
			goto yy826;
		} else {
			if (yych <= 'd') goto yy836;
			if (yych <= 'z') goto yy826;
			goto yy20;
		}
	}
yy714:
	YYDEBUG(714, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'L') goto yy826;
			goto yy876;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy826;
			if (yych <= '`') goto yy20;
			goto yy826;
		} else {
			if (yych <= 'm') goto yy876;
			if (yych <= 'z') goto yy826;
			goto yy20;
		}
	}
yy715:
	YYDEBUG(715, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'S') goto yy826;
			goto yy877;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy826;
			if (yych <= '`') goto yy20;
			goto yy826;
		} else {
			if (yych <= 't') goto yy877;
			if (yych <= 'z') goto yy826;
			goto yy20;
		}
	}
yy716:
	YYDEBUG(716, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy826;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy875;
			if (yych <= 'Z') goto yy826;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy20;
				goto yy829;
			} else {
				if (yych <= 'd') goto yy878;
				if (yych <= 'z') goto yy829;
				goto yy20;
			}
		}
	}
yy717:
	YYDEBUG(717, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy826;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy836;
			if (yych <= 'Z') goto yy826;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy20;
				goto yy829;
			} else {
				if (yych <= 'd') goto yy840;
				if (yych <= 'z') goto yy829;
				goto yy20;
			}
		}
	}
yy718:
	YYDEBUG(718, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy826;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy876;
			if (yych <= 'Z') goto yy826;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy20;
				goto yy829;
			} else {
				if (yych <= 'm') goto yy879;
				if (yych <= 'z') goto yy829;
				goto yy20;
			}
		}
	}
yy719:
	YYDEBUG(719, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy826;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy877;
			if (yych <= 'Z') goto yy826;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy20;
				goto yy829;
			} else {
				if (yych <= 't') goto yy880;
				if (yych <= 'z') goto yy829;
				goto yy20;
			}
		}
	}
yy720:
	YYDEBUG(720, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy420;
	if (yych <= '5') goto yy881;
	if (yych <= '6') goto yy882;
	goto yy420;
yy721:
	YYDEBUG(721, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy115;
	} else {
		if (yych <= 'Z') goto yy826;
		if (yych <= '`') goto yy722;
		if (yych <= 'z') goto yy826;
	}
yy722:
	YYDEBUG(722, *YYCURSOR);
#line 1189 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("midnight | today");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 16544 "<stdout>"
yy723:
	YYDEBUG(723, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'Q') goto yy826;
			goto yy883;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy826;
			if (yych <= '`') goto yy20;
			goto yy826;
		} else {
			if (yych <= 'r') goto yy883;
			if (yych <= 'z') goto yy826;
			goto yy20;
		}
	}
yy724:
	YYDEBUG(724, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy115;
		if (yych <= '@') goto yy20;
		goto yy884;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy826;
			goto yy20;
		} else {
			if (yych <= 'a') goto yy884;
			if (yych <= 'z') goto yy826;
			goto yy20;
		}
	}
yy725:
	YYDEBUG(725, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy115;
			goto yy722;
		} else {
			if (yych == '.') goto yy722;
			goto yy297;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy722;
			if (yych <= 'Z') goto yy826;
			goto yy722;
		} else {
			if (yych <= '_') goto yy297;
			if (yych <= '`') goto yy722;
			if (yych <= 'z') goto yy829;
			goto yy722;
		}
	}
yy726:
	YYDEBUG(726, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy826;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy883;
			if (yych <= 'Z') goto yy826;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy20;
				goto yy829;
			} else {
				if (yych <= 'r') goto yy885;
				if (yych <= 'z') goto yy829;
				goto yy20;
			}
		}
	}
yy727:
	YYDEBUG(727, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy115;
			goto yy20;
		} else {
			if (yych == '.') goto yy20;
			if (yych <= '/') goto yy297;
			goto yy20;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy884;
			if (yych <= 'Z') goto yy826;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= '`') goto yy20;
			if (yych <= 'a') goto yy886;
			if (yych <= 'z') goto yy829;
			goto yy20;
		}
	}
yy728:
	YYDEBUG(728, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'R') goto yy826;
			goto yy887;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy826;
			if (yych <= '`') goto yy20;
			goto yy826;
		} else {
			if (yych <= 's') goto yy887;
			if (yych <= 'z') goto yy826;
			goto yy20;
		}
	}
yy729:
	YYDEBUG(729, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy826;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy887;
			if (yych <= 'Z') goto yy826;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy20;
				goto yy829;
			} else {
				if (yych <= 's') goto yy888;
				if (yych <= 'z') goto yy829;
				goto yy20;
			}
		}
	}
yy730:
	YYDEBUG(730, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy20;
			goto yy115;
		} else {
			if (yych <= '@') goto yy20;
			if (yych <= 'Q') goto yy826;
			goto yy889;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy826;
			if (yych <= '`') goto yy20;
			goto yy826;
		} else {
			if (yych <= 'r') goto yy889;
			if (yych <= 'z') goto yy826;
			goto yy20;
		}
	}
yy731:
	YYDEBUG(731, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		} else {
			if (yych == '/') goto yy297;
			if (yych <= '@') goto yy20;
			goto yy826;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy889;
			if (yych <= 'Z') goto yy826;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy20;
				goto yy829;
			} else {
				if (yych <= 'r') goto yy890;
				if (yych <= 'z') goto yy829;
				goto yy20;
			}
		}
	}
yy732:
	YYDEBUG(732, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '0') goto yy891;
	if (yych <= '1') goto yy892;
	goto yy59;
yy733:
	YYDEBUG(733, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych == '-') goto yy893;
		if (yych <= '/') goto yy196;
		goto yy894;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy196;
			goto yy97;
		} else {
			if (yych == 0xE2) goto yy98;
			goto yy196;
		}
	}
yy734:
	YYDEBUG(734, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych <= ',') goto yy196;
			goto yy893;
		} else {
			if (yych <= '/') goto yy196;
			if (yych <= '0') goto yy894;
			goto yy895;
		}
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy196;
			goto yy97;
		} else {
			if (yych == 0xE2) goto yy98;
			goto yy196;
		}
	}
yy735:
	YYDEBUG(735, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych == '-') goto yy893;
		if (yych <= '/') goto yy196;
		goto yy895;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy196;
			goto yy97;
		} else {
			if (yych == 0xE2) goto yy98;
			goto yy196;
		}
	}
yy736:
	YYDEBUG(736, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == ':') goto yy896;
	goto yy20;
yy737:
	YYDEBUG(737, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy897;
	goto yy59;
yy738:
	YYDEBUG(738, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy739;
	if (yych <= '9') goto yy897;
yy739:
	YYDEBUG(739, *YYCURSOR);
#line 1580 "ext/date/lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("pointed date YY");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr(&ptr, 2);
		s->time->m = timelib_get_nr(&ptr, 2);
		s->time->y = timelib_get_nr_ex(&ptr, 2, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
#line 16867 "<stdout>"
yy740:
	YYDEBUG(740, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy567;
		if (yych <= '9') goto yy897;
		if (yych <= 'm') goto yy567;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy567;
		} else {
			if (yych <= 's') goto yy742;
			if (yych <= 't') goto yy743;
			goto yy567;
		}
	}
yy741:
	YYDEBUG(741, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy898;
	goto yy59;
yy742:
	YYDEBUG(742, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy898;
	goto yy59;
yy743:
	YYDEBUG(743, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy898;
	goto yy59;
yy744:
	YYDEBUG(744, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy899;
	goto yy59;
yy745:
	YYDEBUG(745, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy744;
	if (yych <= '/') goto yy177;
	if (yych <= '9') goto yy897;
	goto yy177;
yy746:
	YYDEBUG(746, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy224;
	if (yych <= '9') goto yy901;
	goto yy224;
yy747:
	YYDEBUG(747, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy902;
	goto yy59;
yy748:
	YYDEBUG(748, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '2') goto yy903;
	if (yych <= '3') goto yy904;
	if (yych <= '9') goto yy569;
	goto yy59;
yy749:
	YYDEBUG(749, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy750:
	YYDEBUG(750, *YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy749;
	case 'A':
	case 'a':	goto yy596;
	case 'D':
	case 'd':	goto yy769;
	case 'F':
	case 'f':	goto yy770;
	case 'I':	goto yy599;
	case 'J':
	case 'j':	goto yy601;
	case 'M':
	case 'm':	goto yy771;
	case 'N':
	case 'n':	goto yy603;
	case 'O':
	case 'o':	goto yy604;
	case 'S':
	case 's':	goto yy772;
	case 'V':	goto yy606;
	case 'X':	goto yy608;
	default:	goto yy59;
	}
yy751:
	YYDEBUG(751, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '-') goto yy905;
	} else {
		if (yych <= '0') goto yy906;
		if (yych <= '9') goto yy907;
	}
yy752:
	YYDEBUG(752, *YYCURSOR);
#line 1525 "ext/date/lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("gnudateshorter");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
		s->time->m = timelib_get_nr(&ptr, 2);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 16992 "<stdout>"
yy753:
	YYDEBUG(753, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '-') goto yy905;
		goto yy752;
	} else {
		if (yych <= '2') goto yy907;
		if (yych <= '9') goto yy908;
		goto yy752;
	}
yy754:
	YYDEBUG(754, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy905;
	if (yych <= '/') goto yy752;
	if (yych <= '9') goto yy908;
	goto yy752;
yy755:
	YYDEBUG(755, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '-') goto yy905;
		goto yy752;
	} else {
		if (yych <= '5') goto yy908;
		if (yych <= '6') goto yy909;
		goto yy752;
	}
yy756:
	YYDEBUG(756, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy905;
	goto yy752;
yy757:
	YYDEBUG(757, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy910;
		if (yych <= 'T') goto yy59;
		goto yy911;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy59;
			goto yy910;
		} else {
			if (yych == 'u') goto yy911;
			goto yy59;
		}
	}
yy758:
	YYDEBUG(758, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy912;
	if (yych == 'e') goto yy912;
	goto yy59;
yy759:
	YYDEBUG(759, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy913;
	if (yych == 'e') goto yy913;
	goto yy59;
yy760:
	YYDEBUG(760, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy914;
		if (yych <= 'T') goto yy59;
		goto yy915;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy59;
			goto yy914;
		} else {
			if (yych == 'u') goto yy915;
			goto yy59;
		}
	}
yy761:
	YYDEBUG(761, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy916;
	if (yych == 'a') goto yy916;
	goto yy59;
yy762:
	YYDEBUG(762, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy917;
	if (yych == 'o') goto yy917;
	goto yy59;
yy763:
	YYDEBUG(763, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy918;
	if (yych == 'c') goto yy918;
	goto yy59;
yy764:
	YYDEBUG(764, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy919;
	if (yych == 'e') goto yy919;
	goto yy59;
yy765:
	YYDEBUG(765, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '0') goto yy797;
	if (yych <= '4') goto yy798;
	if (yych <= '5') goto yy799;
	goto yy59;
yy766:
	YYDEBUG(766, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '0') goto yy920;
	if (yych <= '9') goto yy908;
	goto yy59;
yy767:
	YYDEBUG(767, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy908;
	goto yy59;
yy768:
	YYDEBUG(768, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '5') goto yy908;
	if (yych <= '6') goto yy909;
	goto yy59;
yy769:
	YYDEBUG(769, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy787;
	if (yych == 'e') goto yy787;
	goto yy59;
yy770:
	YYDEBUG(770, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy788;
	if (yych == 'e') goto yy788;
	goto yy59;
yy771:
	YYDEBUG(771, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy793;
	if (yych == 'a') goto yy793;
	goto yy59;
yy772:
	YYDEBUG(772, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy921;
	if (yych == 'e') goto yy921;
	goto yy59;
yy773:
	YYDEBUG(773, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy59;
	if (yych <= '/') goto yy922;
	if (yych <= '9') goto yy923;
	goto yy59;
yy774:
	YYDEBUG(774, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy59;
	if (yych <= '/') goto yy922;
	if (yych <= '2') goto yy923;
	goto yy59;
yy775:
	YYDEBUG(775, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '/') goto yy922;
	goto yy59;
yy776:
	YYDEBUG(776, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'C') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych >= '\t') goto yy196;
				} else {
					if (yych == ' ') goto yy196;
				}
			} else {
				if (yych <= '2') {
					if (yych <= '0') goto yy924;
					goto yy925;
				} else {
					if (yych <= '3') goto yy927;
					if (yych <= '9') goto yy928;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy196;
				} else {
					if (yych != 'G') goto yy196;
				}
			} else {
				if (yych <= 'R') {
					if (yych == 'M') goto yy196;
				} else {
					if (yych != 'V') goto yy196;
				}
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'e') {
				if (yych <= 'Y') {
					if (yych >= 'Y') goto yy196;
				} else {
					if (yych == 'd') goto yy196;
				}
			} else {
				if (yych <= 'g') {
					if (yych <= 'f') goto yy196;
				} else {
					if (yych <= 'h') goto yy196;
					if (yych >= 'm') goto yy196;
				}
			}
		} else {
			if (yych <= 'x') {
				if (yych <= 'u') {
					if (yych >= 's') goto yy196;
				} else {
					if (yych == 'w') goto yy196;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 'y') goto yy196;
					if (yych >= 0xC2) goto yy97;
				} else {
					if (yych == 0xE2) goto yy98;
				}
			}
		}
	}
yy777:
	YYDEBUG(777, *YYCURSOR);
#line 1451 "ext/date/lib/parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("iso8601nocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr(&ptr, 2);
		s->time->i = timelib_get_nr(&ptr, 2);
		s->time->s = timelib_get_nr(&ptr, 2);

		if (*ptr != '\0') {
			s->time->z = timelib_parse_zone(&ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_ISO_NOCOLON;
	}
#line 17260 "<stdout>"
yy778:
	YYDEBUG(778, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'D') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy777;
					goto yy196;
				} else {
					if (yych == ' ') goto yy196;
					goto yy777;
				}
			} else {
				if (yych <= '3') {
					if (yych <= '2') goto yy925;
					goto yy927;
				} else {
					if (yych <= '9') goto yy928;
					if (yych <= 'C') goto yy777;
					goto yy196;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych <= 'F') {
					if (yych <= 'E') goto yy777;
					goto yy196;
				} else {
					if (yych == 'H') goto yy196;
					goto yy777;
				}
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy196;
					goto yy777;
				} else {
					if (yych == 'V') goto yy777;
					goto yy196;
				}
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'e') {
				if (yych <= 'Y') {
					if (yych <= 'X') goto yy777;
					goto yy196;
				} else {
					if (yych == 'd') goto yy196;
					goto yy777;
				}
			} else {
				if (yych <= 'g') {
					if (yych <= 'f') goto yy196;
					goto yy777;
				} else {
					if (yych <= 'h') goto yy196;
					if (yych <= 'l') goto yy777;
					goto yy196;
				}
			}
		} else {
			if (yych <= 'x') {
				if (yych <= 'u') {
					if (yych <= 'r') goto yy777;
					goto yy196;
				} else {
					if (yych == 'w') goto yy196;
					goto yy777;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 'y') goto yy196;
					if (yych <= 0xC1) goto yy777;
					goto yy97;
				} else {
					if (yych == 0xE2) goto yy98;
					goto yy777;
				}
			}
		}
	}
yy779:
	YYDEBUG(779, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy196;
				if (yych <= 0x1F) goto yy777;
				goto yy196;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy777;
					goto yy928;
				} else {
					if (yych == 'D') goto yy196;
					goto yy777;
				}
			}
		} else {
			if (yych <= 'M') {
				if (yych <= 'G') {
					if (yych <= 'F') goto yy196;
					goto yy777;
				} else {
					if (yych <= 'H') goto yy196;
					if (yych <= 'L') goto yy777;
					goto yy196;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'R') goto yy777;
					goto yy196;
				} else {
					if (yych == 'W') goto yy196;
					goto yy777;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy196;
					goto yy777;
				} else {
					if (yych == 'e') goto yy777;
					goto yy196;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy777;
					goto yy196;
				} else {
					if (yych == 'm') goto yy196;
					goto yy777;
				}
			}
		} else {
			if (yych <= 'y') {
				if (yych <= 'v') {
					if (yych <= 'u') goto yy196;
					goto yy777;
				} else {
					if (yych == 'x') goto yy777;
					goto yy196;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 0xC1) goto yy777;
					goto yy97;
				} else {
					if (yych == 0xE2) goto yy98;
					goto yy777;
				}
			}
		}
	}
yy780:
	YYDEBUG(780, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'E') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy777;
					goto yy196;
				} else {
					if (yych == ' ') goto yy196;
					goto yy777;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '6') goto yy928;
					goto yy929;
				} else {
					if (yych == 'D') goto yy196;
					goto yy777;
				}
			}
		} else {
			if (yych <= 'M') {
				if (yych <= 'G') {
					if (yych <= 'F') goto yy196;
					goto yy777;
				} else {
					if (yych <= 'H') goto yy196;
					if (yych <= 'L') goto yy777;
					goto yy196;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'R') goto yy777;
					goto yy196;
				} else {
					if (yych == 'W') goto yy196;
					goto yy777;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy196;
					goto yy777;
				} else {
					if (yych == 'e') goto yy777;
					goto yy196;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy777;
					goto yy196;
				} else {
					if (yych == 'm') goto yy196;
					goto yy777;
				}
			}
		} else {
			if (yych <= 'y') {
				if (yych <= 'v') {
					if (yych <= 'u') goto yy196;
					goto yy777;
				} else {
					if (yych == 'x') goto yy777;
					goto yy196;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 0xC1) goto yy777;
					goto yy97;
				} else {
					if (yych == 0xE2) goto yy98;
					goto yy777;
				}
			}
		}
	}
yy781:
	YYDEBUG(781, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy196;
				if (yych <= 0x1F) goto yy777;
				goto yy196;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy777;
					goto yy929;
				} else {
					if (yych == 'D') goto yy196;
					goto yy777;
				}
			}
		} else {
			if (yych <= 'M') {
				if (yych <= 'G') {
					if (yych <= 'F') goto yy196;
					goto yy777;
				} else {
					if (yych <= 'H') goto yy196;
					if (yych <= 'L') goto yy777;
					goto yy196;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'R') goto yy777;
					goto yy196;
				} else {
					if (yych == 'W') goto yy196;
					goto yy777;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy196;
					goto yy777;
				} else {
					if (yych == 'e') goto yy777;
					goto yy196;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy777;
					goto yy196;
				} else {
					if (yych == 'm') goto yy196;
					goto yy777;
				}
			}
		} else {
			if (yych <= 'y') {
				if (yych <= 'v') {
					if (yych <= 'u') goto yy196;
					goto yy777;
				} else {
					if (yych == 'x') goto yy777;
					goto yy196;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 0xC1) goto yy777;
					goto yy97;
				} else {
					if (yych == 0xE2) goto yy98;
					goto yy777;
				}
			}
		}
	}
yy782:
	YYDEBUG(782, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy196;
		if (yych <= '9') goto yy929;
		goto yy196;
	} else {
		if (yych <= 0xC2) goto yy97;
		if (yych == 0xE2) goto yy98;
		goto yy196;
	}
yy783:
	YYDEBUG(783, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy930;
	goto yy59;
yy784:
	YYDEBUG(784, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '2') goto yy930;
	goto yy59;
yy785:
	YYDEBUG(785, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy931;
	if (yych == 'r') goto yy931;
	goto yy59;
yy786:
	YYDEBUG(786, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy932;
	if (yych == 'g') goto yy932;
	goto yy59;
yy787:
	YYDEBUG(787, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy933;
	if (yych == 'c') goto yy933;
	goto yy59;
yy788:
	YYDEBUG(788, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy934;
	if (yych == 'b') goto yy934;
	goto yy59;
yy789:
	YYDEBUG(789, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != 'I') goto yy600;
yy790:
	YYDEBUG(790, *YYCURSOR);
	++YYCURSOR;
	goto yy600;
yy791:
	YYDEBUG(791, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy935;
	if (yych == 'n') goto yy935;
	goto yy59;
yy792:
	YYDEBUG(792, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy936;
		if (yych <= 'M') goto yy59;
		goto yy937;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy59;
			goto yy936;
		} else {
			if (yych == 'n') goto yy937;
			goto yy59;
		}
	}
yy793:
	YYDEBUG(793, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy938;
		if (yych <= 'X') goto yy59;
		goto yy790;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy59;
			goto yy938;
		} else {
			if (yych == 'y') goto yy790;
			goto yy59;
		}
	}
yy794:
	YYDEBUG(794, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy933;
	if (yych == 'v') goto yy933;
	goto yy59;
yy795:
	YYDEBUG(795, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy939;
	if (yych == 't') goto yy939;
	goto yy59;
yy796:
	YYDEBUG(796, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy443;
		if (yych <= 'O') goto yy59;
		goto yy940;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy59;
			goto yy443;
		} else {
			if (yych == 'p') goto yy940;
			goto yy59;
		}
	}
yy797:
	YYDEBUG(797, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy59;
	if (yych <= '9') goto yy941;
	goto yy59;
yy798:
	YYDEBUG(798, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy941;
	goto yy59;
yy799:
	YYDEBUG(799, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '3') goto yy941;
	goto yy59;
yy800:
	YYDEBUG(800, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '0') {
			if (yych <= '/') goto yy196;
			goto yy924;
		} else {
			if (yych <= '2') goto yy925;
			if (yych <= '3') goto yy927;
			goto yy928;
		}
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy196;
			goto yy97;
		} else {
			if (yych == 0xE2) goto yy98;
			goto yy196;
		}
	}
yy801:
	YYDEBUG(801, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '/') goto yy196;
		if (yych <= '2') goto yy925;
		if (yych <= '3') goto yy927;
		goto yy928;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy196;
			goto yy97;
		} else {
			if (yych == 0xE2) goto yy98;
			goto yy196;
		}
	}
yy802:
	YYDEBUG(802, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy196;
		if (yych <= '9') goto yy928;
		goto yy196;
	} else {
		if (yych <= 0xC2) goto yy97;
		if (yych == 0xE2) goto yy98;
		goto yy196;
	}
yy803:
	YYDEBUG(803, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy196;
		if (yych <= '6') goto yy928;
		if (yych <= '9') goto yy929;
		goto yy196;
	} else {
		if (yych <= 0xC2) goto yy97;
		if (yych == 0xE2) goto yy98;
		goto yy196;
	}
yy804:
	YYDEBUG(804, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy253;
	if (yych == 't') goto yy253;
	goto yy59;
yy805:
	YYDEBUG(805, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy806;
	if (yych != 'n') goto yy59;
yy806:
	YYDEBUG(806, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy943;
	if (yych == 'i') goto yy943;
	goto yy59;
yy807:
	YYDEBUG(807, *YYCURSOR);
	++YYCURSOR;
	goto yy251;
yy808:
	YYDEBUG(808, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy944;
	if (yych == 'r') goto yy944;
	goto yy59;
yy809:
	YYDEBUG(809, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy945;
	if (yych == 's') goto yy945;
	goto yy59;
yy810:
	YYDEBUG(810, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy425;
	if (yych == 'e') goto yy425;
	goto yy59;
yy811:
	YYDEBUG(811, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy946;
	if (yych == 'e') goto yy946;
	goto yy59;
yy812:
	YYDEBUG(812, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy425;
	if (yych == 'd') goto yy425;
	goto yy59;
yy813:
	YYDEBUG(813, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy177;
				goto yy638;
			} else {
				if (yych == ' ') goto yy638;
				goto yy177;
			}
		} else {
			if (yych <= '/') {
				if (yych <= '.') goto yy744;
				goto yy177;
			} else {
				if (yych <= '9') goto yy897;
				if (yych <= '@') goto yy177;
				goto yy106;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'P') {
				if (yych <= 'O') goto yy177;
				goto yy106;
			} else {
				if (yych == 'a') goto yy106;
				goto yy177;
			}
		} else {
			if (yych <= 0xC2) {
				if (yych <= 'p') goto yy106;
				if (yych <= 0xC1) goto yy177;
				goto yy640;
			} else {
				if (yych == 0xE2) goto yy641;
				goto yy177;
			}
		}
	}
yy814:
	YYDEBUG(814, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= '`') {
		if (yych <= 'A') {
			if (yych <= '@') goto yy59;
			goto yy106;
		} else {
			if (yych == 'P') goto yy106;
			goto yy59;
		}
	} else {
		if (yych <= 'p') {
			if (yych <= 'a') goto yy106;
			if (yych <= 'o') goto yy59;
			goto yy106;
		} else {
			if (yych == 0xC2) goto yy640;
			goto yy59;
		}
	}
yy815:
	YYDEBUG(815, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xAF) goto yy947;
	goto yy59;
yy816:
	YYDEBUG(816, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy638;
			if (yych <= 0x1F) goto yy177;
			goto yy638;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy177;
				goto yy744;
			} else {
				if (yych == 'A') goto yy106;
				goto yy177;
			}
		}
	} else {
		if (yych <= 'p') {
			if (yych <= '`') {
				if (yych <= 'P') goto yy106;
				goto yy177;
			} else {
				if (yych <= 'a') goto yy106;
				if (yych <= 'o') goto yy177;
				goto yy106;
			}
		} else {
			if (yych <= 0xC2) {
				if (yych <= 0xC1) goto yy177;
				goto yy640;
			} else {
				if (yych == 0xE2) goto yy641;
				goto yy177;
			}
		}
	}
yy817:
	YYDEBUG(817, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy744;
	if (yych <= '/') goto yy177;
	if (yych <= '9') goto yy948;
	goto yy177;
yy818:
	YYDEBUG(818, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy744;
	if (yych == '0') goto yy948;
	goto yy177;
yy819:
	YYDEBUG(819, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy567;
		if (yych <= '9') goto yy821;
		if (yych <= 'm') goto yy567;
		goto yy741;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy567;
			goto yy741;
		} else {
			if (yych <= 's') goto yy742;
			if (yych <= 't') goto yy743;
			goto yy567;
		}
	}
yy820:
	YYDEBUG(820, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy567;
		if (yych <= '1') goto yy821;
		if (yych <= 'm') goto yy567;
		goto yy741;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy567;
			goto yy741;
		} else {
			if (yych <= 's') goto yy742;
			if (yych <= 't') goto yy743;
			goto yy567;
		}
	}
yy821:
	YYDEBUG(821, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy741;
		goto yy567;
	} else {
		if (yych <= 'r') goto yy741;
		if (yych <= 's') goto yy742;
		if (yych <= 't') goto yy743;
		goto yy567;
	}
yy822:
	YYDEBUG(822, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '2') goto yy949;
	if (yych <= '3') goto yy950;
	if (yych <= '9') goto yy821;
	goto yy59;
yy823:
	YYDEBUG(823, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy951;
	goto yy59;
yy824:
	YYDEBUG(824, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '-') goto yy951;
		goto yy59;
	} else {
		if (yych <= 'T') goto yy823;
		if (yych == 't') goto yy823;
		goto yy59;
	}
yy825:
	YYDEBUG(825, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy290;
	if (yych <= '9') goto yy952;
	goto yy290;
yy826:
	YYDEBUG(826, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy115;
	goto yy20;
yy827:
	YYDEBUG(827, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy324;
				goto yy59;
			} else {
				if (yych <= '\t') goto yy326;
				if (yych <= 0x1F) goto yy59;
				goto yy326;
			}
		} else {
			if (yych <= '-') {
				if (yych <= '+') goto yy59;
				if (yych <= ',') goto yy326;
				goto yy953;
			} else {
				if (yych <= '.') goto yy326;
				if (yych <= '/') goto yy59;
				goto yy512;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy59;
				goto yy326;
			} else {
				if (yych == 'h') goto yy326;
				goto yy59;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy329;
				if (yych <= 'q') goto yy59;
				goto yy329;
			} else {
				if (yych <= 's') goto yy330;
				if (yych <= 't') goto yy331;
				goto yy59;
			}
		}
	}
yy828:
	YYDEBUG(828, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy295;
			goto yy142;
		} else {
			if (yych == ' ') goto yy142;
			goto yy295;
		}
	} else {
		if (yych <= '.') {
			if (yych <= ')') goto yy115;
			if (yych <= ',') goto yy295;
			goto yy142;
		} else {
			if (yych <= '/') goto yy295;
			if (yych <= '9') goto yy142;
			goto yy295;
		}
	}
yy829:
	YYDEBUG(829, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy954;
	}
	if (yych <= '-') {
		if (yych == ')') goto yy115;
		if (yych <= ',') goto yy20;
		goto yy297;
	} else {
		if (yych <= '/') {
			if (yych <= '.') goto yy20;
			goto yy297;
		} else {
			if (yych == '_') goto yy297;
			goto yy20;
		}
	}
yy830:
	YYDEBUG(830, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy954;
	}
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy142;
			goto yy295;
		} else {
			if (yych <= ' ') goto yy142;
			if (yych == ')') goto yy115;
			goto yy295;
		}
	} else {
		if (yych <= '/') {
			if (yych <= '-') goto yy700;
			if (yych <= '.') goto yy142;
			goto yy297;
		} else {
			if (yych <= '9') goto yy142;
			if (yych == '_') goto yy297;
			goto yy295;
		}
	}
yy831:
	YYDEBUG(831, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy956;
	if (yych == 'f') goto yy956;
	goto yy59;
yy832:
	YYDEBUG(832, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy115;
		goto yy20;
	} else {
		if (yych <= 'E') goto yy957;
		if (yych == 'e') goto yy957;
		goto yy20;
	}
yy833:
	YYDEBUG(833, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= ',') {
			if (yych == ')') goto yy115;
			goto yy20;
		} else {
			if (yych == '.') goto yy20;
			if (yych <= '/') goto yy297;
			goto yy20;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'E') goto yy957;
			if (yych == '_') goto yy297;
			goto yy20;
		} else {
			if (yych == 'e') goto yy958;
			if (yych <= 'z') goto yy954;
			goto yy20;
		}
	}
yy834:
	YYDEBUG(834, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy835:
	YYDEBUG(835, *YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy834;
				if (yych <= 0x1F) goto yy59;
				goto yy834;
			} else {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy59;
					goto yy856;
				} else {
					if (yych == 'F') goto yy857;
					goto yy59;
				}
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy858;
					goto yy59;
				} else {
					if (yych <= 'M') goto yy859;
					if (yych <= 'R') goto yy59;
					goto yy860;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'T') goto yy861;
					goto yy862;
				} else {
					if (yych == 'W') goto yy959;
					goto yy59;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy864;
					goto yy59;
				} else {
					if (yych <= 'd') goto yy856;
					if (yych <= 'e') goto yy59;
					goto yy857;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy59;
					goto yy858;
				} else {
					if (yych == 'm') goto yy859;
					goto yy59;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 's') goto yy860;
					goto yy861;
				} else {
					if (yych <= 'u') goto yy862;
					if (yych <= 'v') goto yy59;
					goto yy959;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy59;
					goto yy864;
				} else {
					if (yych == 0xC2) goto yy865;
					goto yy59;
				}
			}
		}
	}
yy836:
	YYDEBUG(836, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy20;
			goto yy834;
		} else {
			if (yych == ' ') goto yy834;
			goto yy20;
		}
	} else {
		if (yych <= 0xC2) {
			if (yych <= ')') goto yy115;
			if (yych <= 0xC1) goto yy20;
		} else {
			if (yych == 0xE2) goto yy838;
			goto yy20;
		}
	}
yy837:
	YYDEBUG(837, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 0xA0) goto yy960;
	goto yy59;
yy838:
	YYDEBUG(838, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0x80) goto yy961;
	goto yy59;
yy839:
	YYDEBUG(839, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == ')') goto yy115;
		goto yy20;
	} else {
		if (yych <= 'T') goto yy962;
		if (yych == 't') goto yy962;
		goto yy20;
	}
yy840:
	YYDEBUG(840, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy954;
	}
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy834;
			if (yych <= 0x1F) goto yy20;
			goto yy834;
		} else {
			if (yych == ')') goto yy115;
			if (yych <= ',') goto yy20;
			goto yy297;
		}
	} else {
		if (yych <= '_') {
			if (yych == '/') goto yy297;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= 0xC2) {
				if (yych <= 0xC1) goto yy20;
				goto yy837;
			} else {
				if (yych == 0xE2) goto yy838;
				goto yy20;
			}
		}
	}
yy841:
	YYDEBUG(841, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= ',') {
			if (yych == ')') goto yy115;
			goto yy20;
		} else {
			if (yych == '.') goto yy20;
			if (yych <= '/') goto yy297;
			goto yy20;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'T') goto yy962;
			if (yych == '_') goto yy297;
			goto yy20;
		} else {
			if (yych == 't') goto yy963;
			if (yych <= 'z') goto yy954;
			goto yy20;
		}
	}
yy842:
	YYDEBUG(842, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == ')') goto yy115;
		goto yy20;
	} else {
		if (yych <= 'R') goto yy964;
		if (yych == 'r') goto yy964;
		goto yy20;
	}
yy843:
	YYDEBUG(843, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy866;
	if (yych == 'd') goto yy866;
	goto yy835;
yy844:
	YYDEBUG(844, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == ')') goto yy115;
		goto yy315;
	} else {
		if (yych <= 'S') goto yy965;
		if (yych == 's') goto yy965;
		goto yy315;
	}
yy845:
	YYDEBUG(845, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= ',') {
			if (yych == ')') goto yy115;
			goto yy20;
		} else {
			if (yych == '.') goto yy20;
			if (yych <= '/') goto yy297;
			goto yy20;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'R') goto yy964;
			if (yych == '_') goto yy297;
			goto yy20;
		} else {
			if (yych == 'r') goto yy966;
			if (yych <= 'z') goto yy954;
			goto yy20;
		}
	}
yy846:
	YYDEBUG(846, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= ',') {
			if (yych == ')') goto yy115;
			goto yy315;
		} else {
			if (yych == '.') goto yy315;
			if (yych <= '/') goto yy297;
			goto yy315;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'S') goto yy965;
			if (yych == '_') goto yy297;
			goto yy315;
		} else {
			if (yych == 's') goto yy967;
			if (yych <= 'z') goto yy954;
			goto yy315;
		}
	}
yy847:
	YYDEBUG(847, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy20;
	if (yych <= '5') goto yy968;
	if (yych <= '9') goto yy115;
	if (yych <= ':') goto yy393;
	goto yy20;
yy848:
	YYDEBUG(848, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy969;
	} else {
		if (yych <= '9') goto yy850;
		if (yych <= ':') goto yy969;
	}
yy849:
	YYDEBUG(849, *YYCURSOR);
#line 1928 "ext/date/lib/parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("dateshortwithtimeshort | dateshortwithtimelong | dateshortwithtimelongtz");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month(&ptr);
		s->time->d = timelib_get_nr(&ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr(&ptr, 2);
		s->time->i = timelib_get_nr(&ptr, 2);
		if (*ptr == ':') {
			s->time->s = timelib_get_nr(&ptr, 2);

			if (*ptr == '.') {
				s->time->us = timelib_get_frac_nr(&ptr);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_parse_zone(&ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
#line 18517 "<stdout>"
yy850:
	YYDEBUG(850, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy969;
	if (yych == ':') goto yy969;
	goto yy849;
yy851:
	YYDEBUG(851, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy970;
		goto yy849;
	} else {
		if (yych <= '9') goto yy971;
		if (yych <= ':') goto yy970;
		goto yy849;
	}
yy852:
	YYDEBUG(852, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy970;
	if (yych == ':') goto yy970;
	goto yy849;
yy853:
	YYDEBUG(853, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy325;
	if (yych <= '9') goto yy972;
	goto yy325;
yy854:
	YYDEBUG(854, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy115;
		goto yy20;
	} else {
		if (yych <= 'Y') goto yy973;
		if (yych == 'y') goto yy973;
		goto yy20;
	}
yy855:
	YYDEBUG(855, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy115;
			goto yy20;
		} else {
			if (yych == '.') goto yy20;
			if (yych <= '/') goto yy297;
			goto yy20;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy973;
			if (yych == '_') goto yy297;
			goto yy20;
		} else {
			if (yych == 'y') goto yy974;
			if (yych <= 'z') goto yy954;
			goto yy20;
		}
	}
yy856:
	YYDEBUG(856, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy975;
	if (yych == 'a') goto yy975;
	goto yy59;
yy857:
	YYDEBUG(857, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy976;
		if (yych <= 'Q') goto yy59;
		goto yy977;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy59;
			goto yy976;
		} else {
			if (yych == 'r') goto yy977;
			goto yy59;
		}
	}
yy858:
	YYDEBUG(858, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy978;
	if (yych == 'o') goto yy978;
	goto yy59;
yy859:
	YYDEBUG(859, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= 'N') {
			if (yych == 'I') goto yy979;
			goto yy59;
		} else {
			if (yych <= 'O') goto yy980;
			if (yych <= 'R') goto yy59;
			goto yy981;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'i') goto yy979;
			goto yy59;
		} else {
			if (yych <= 'o') goto yy980;
			if (yych == 's') goto yy981;
			goto yy59;
		}
	}
yy860:
	YYDEBUG(860, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy983;
			goto yy59;
		} else {
			if (yych <= 'E') goto yy984;
			if (yych <= 'T') goto yy59;
			goto yy985;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy983;
			goto yy59;
		} else {
			if (yych <= 'e') goto yy984;
			if (yych == 'u') goto yy985;
			goto yy59;
		}
	}
yy861:
	YYDEBUG(861, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy986;
		if (yych <= 'T') goto yy59;
		goto yy987;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy59;
			goto yy986;
		} else {
			if (yych == 'u') goto yy987;
			goto yy59;
		}
	}
yy862:
	YYDEBUG(862, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy988;
	if (yych == 's') goto yy988;
	goto yy59;
yy863:
	YYDEBUG(863, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy989;
	if (yych == 'e') goto yy989;
	goto yy59;
yy864:
	YYDEBUG(864, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy990;
	if (yych == 'e') goto yy990;
	goto yy59;
yy865:
	YYDEBUG(865, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 0xB5) goto yy991;
	goto yy59;
yy866:
	YYDEBUG(866, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy992;
	if (yych == 'a') goto yy992;
	goto yy59;
yy867:
	YYDEBUG(867, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
	if (yych <= 'c') {
		if (yych <= 'M') {
			if (yych <= 'F') {
				if (yych == 'D') goto yy856;
				if (yych <= 'E') goto yy59;
				goto yy857;
			} else {
				if (yych == 'H') goto yy858;
				if (yych <= 'L') goto yy59;
				goto yy859;
			}
		} else {
			if (yych <= 'U') {
				if (yych <= 'R') goto yy59;
				if (yych <= 'S') goto yy860;
				if (yych <= 'T') goto yy861;
				goto yy862;
			} else {
				if (yych <= 'W') {
					if (yych <= 'V') goto yy59;
					goto yy863;
				} else {
					if (yych == 'Y') goto yy864;
					goto yy59;
				}
			}
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'g') {
				if (yych <= 'd') goto yy856;
				if (yych == 'f') goto yy857;
				goto yy59;
			} else {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy858;
					goto yy59;
				} else {
					if (yych <= 'm') goto yy859;
					if (yych <= 'r') goto yy59;
					goto yy860;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') goto yy861;
				if (yych <= 'u') goto yy862;
				if (yych <= 'v') goto yy59;
				goto yy863;
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy59;
					goto yy864;
				} else {
					if (yych == 0xC2) goto yy993;
					goto yy59;
				}
			}
		}
	}
yy868:
	YYDEBUG(868, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xAF) goto yy994;
	goto yy59;
yy869:
	YYDEBUG(869, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy115;
		goto yy20;
	} else {
		if (yych <= 'H') goto yy995;
		if (yych == 'h') goto yy995;
		goto yy20;
	}
yy870:
	YYDEBUG(870, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy115;
			goto yy20;
		} else {
			if (yych == '.') goto yy20;
			if (yych <= '/') goto yy297;
			goto yy20;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy995;
			if (yych == '_') goto yy297;
			goto yy20;
		} else {
			if (yych == 'h') goto yy996;
			if (yych <= 'z') goto yy954;
			goto yy20;
		}
	}
yy871:
	YYDEBUG(871, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Q') {
		if (yych == ')') goto yy115;
		goto yy20;
	} else {
		if (yych <= 'R') goto yy973;
		if (yych == 'r') goto yy973;
		goto yy20;
	}
yy872:
	YYDEBUG(872, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= ',') {
			if (yych == ')') goto yy115;
			goto yy20;
		} else {
			if (yych == '.') goto yy20;
			if (yych <= '/') goto yy297;
			goto yy20;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'R') goto yy973;
			if (yych == '_') goto yy297;
			goto yy20;
		} else {
			if (yych == 'r') goto yy974;
			if (yych <= 'z') goto yy954;
			goto yy20;
		}
	}
yy873:
	YYDEBUG(873, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == ')') goto yy115;
		goto yy20;
	} else {
		if (yych <= 'U') goto yy997;
		if (yych == 'u') goto yy997;
		goto yy20;
	}
yy874:
	YYDEBUG(874, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= ',') {
			if (yych == ')') goto yy115;
			goto yy20;
		} else {
			if (yych == '.') goto yy20;
			if (yych <= '/') goto yy297;
			goto yy20;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'U') goto yy997;
			if (yych == '_') goto yy297;
			goto yy20;
		} else {
			if (yych == 'u') goto yy998;
			if (yych <= 'z') goto yy954;
			goto yy20;
		}
	}
yy875:
	YYDEBUG(875, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy115;
		goto yy20;
	} else {
		if (yych <= 'A') goto yy999;
		if (yych == 'a') goto yy999;
		goto yy20;
	}
yy876:
	YYDEBUG(876, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych == ')') goto yy115;
		goto yy20;
	} else {
		if (yych <= 'B') goto yy1000;
		if (yych == 'b') goto yy1000;
		goto yy20;
	}
yy877:
	YYDEBUG(877, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy115;
		goto yy20;
	} else {
		if (yych <= 'H') goto yy1001;
		if (yych == 'h') goto yy1001;
		goto yy20;
	}
yy878:
	YYDEBUG(878, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy115;
			goto yy20;
		} else {
			if (yych == '.') goto yy20;
			if (yych <= '/') goto yy297;
			goto yy20;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy999;
			if (yych <= '^') goto yy20;
			goto yy297;
		} else {
			if (yych <= '`') goto yy20;
			if (yych <= 'a') goto yy1002;
			if (yych <= 'z') goto yy954;
			goto yy20;
		}
	}
yy879:
	YYDEBUG(879, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= ',') {
			if (yych == ')') goto yy115;
			goto yy20;
		} else {
			if (yych == '.') goto yy20;
			if (yych <= '/') goto yy297;
			goto yy20;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'B') goto yy1000;
			if (yych == '_') goto yy297;
			goto yy20;
		} else {
			if (yych == 'b') goto yy1003;
			if (yych <= 'z') goto yy954;
			goto yy20;
		}
	}
yy880:
	YYDEBUG(880, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy115;
			goto yy20;
		} else {
			if (yych == '.') goto yy20;
			if (yych <= '/') goto yy297;
			goto yy20;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy1001;
			if (yych == '_') goto yy297;
			goto yy20;
		} else {
			if (yych == 'h') goto yy1004;
			if (yych <= 'z') goto yy954;
			goto yy20;
		}
	}
yy881:
	YYDEBUG(881, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy1005;
	goto yy59;
yy882:
	YYDEBUG(882, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1005;
	goto yy59;
yy883:
	YYDEBUG(883, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == ')') goto yy115;
		goto yy20;
	} else {
		if (yych <= 'O') goto yy1006;
		if (yych == 'o') goto yy1006;
		goto yy20;
	}
yy884:
	YYDEBUG(884, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy115;
		goto yy20;
	} else {
		if (yych <= 'Y') goto yy1007;
		if (yych == 'y') goto yy1007;
		goto yy20;
	}
yy885:
	YYDEBUG(885, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= ',') {
			if (yych == ')') goto yy115;
			goto yy20;
		} else {
			if (yych == '.') goto yy20;
			if (yych <= '/') goto yy297;
			goto yy20;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'O') goto yy1006;
			if (yych == '_') goto yy297;
			goto yy20;
		} else {
			if (yych == 'o') goto yy1008;
			if (yych <= 'z') goto yy954;
			goto yy20;
		}
	}
yy886:
	YYDEBUG(886, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy115;
			goto yy20;
		} else {
			if (yych == '.') goto yy20;
			if (yych <= '/') goto yy297;
			goto yy20;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy1007;
			if (yych == '_') goto yy297;
			goto yy20;
		} else {
			if (yych == 'y') goto yy1009;
			if (yych <= 'z') goto yy954;
			goto yy20;
		}
	}
yy887:
	YYDEBUG(887, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy115;
		goto yy20;
	} else {
		if (yych <= 'D') goto yy1010;
		if (yych == 'd') goto yy1010;
		goto yy20;
	}
yy888:
	YYDEBUG(888, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= ',') {
			if (yych == ')') goto yy115;
			goto yy20;
		} else {
			if (yych == '.') goto yy20;
			if (yych <= '/') goto yy297;
			goto yy20;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'D') goto yy1010;
			if (yych == '_') goto yy297;
			goto yy20;
		} else {
			if (yych == 'd') goto yy1011;
			if (yych <= 'z') goto yy954;
			goto yy20;
		}
	}
yy889:
	YYDEBUG(889, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy115;
		goto yy20;
	} else {
		if (yych <= 'D') goto yy1012;
		if (yych == 'd') goto yy1012;
		goto yy20;
	}
yy890:
	YYDEBUG(890, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= ',') {
			if (yych == ')') goto yy115;
			goto yy20;
		} else {
			if (yych == '.') goto yy20;
			if (yych <= '/') goto yy297;
			goto yy20;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'D') goto yy1012;
			if (yych == '_') goto yy297;
			goto yy20;
		} else {
			if (yych == 'd') goto yy1013;
			if (yych <= 'z') goto yy954;
			goto yy20;
		}
	}
yy891:
	YYDEBUG(891, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy1014;
	goto yy59;
yy892:
	YYDEBUG(892, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '2') goto yy1014;
	goto yy59;
yy893:
	YYDEBUG(893, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '0') goto yy1015;
	if (yych <= '1') goto yy1016;
	goto yy59;
yy894:
	YYDEBUG(894, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'D') {
			if (yych <= ',') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy20;
					goto yy196;
				} else {
					if (yych == ' ') goto yy196;
					goto yy20;
				}
			} else {
				if (yych <= '/') {
					if (yych <= '-') goto yy893;
					goto yy20;
				} else {
					if (yych <= '9') goto yy1017;
					if (yych <= 'C') goto yy20;
					goto yy196;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych <= 'F') {
					if (yych <= 'E') goto yy20;
					goto yy196;
				} else {
					if (yych == 'H') goto yy196;
					goto yy20;
				}
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy196;
					goto yy20;
				} else {
					if (yych == 'V') goto yy20;
					goto yy196;
				}
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'e') {
				if (yych <= 'Y') {
					if (yych <= 'X') goto yy20;
					goto yy196;
				} else {
					if (yych == 'd') goto yy196;
					goto yy20;
				}
			} else {
				if (yych <= 'g') {
					if (yych <= 'f') goto yy196;
					goto yy20;
				} else {
					if (yych <= 'h') goto yy196;
					if (yych <= 'l') goto yy20;
					goto yy196;
				}
			}
		} else {
			if (yych <= 'x') {
				if (yych <= 'u') {
					if (yych <= 'r') goto yy20;
					goto yy196;
				} else {
					if (yych == 'w') goto yy196;
					goto yy20;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 'y') goto yy196;
					if (yych <= 0xC1) goto yy20;
					goto yy97;
				} else {
					if (yych == 0xE2) goto yy98;
					goto yy20;
				}
			}
		}
	}
yy895:
	YYDEBUG(895, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych == '-') goto yy893;
		if (yych <= '/') goto yy196;
		goto yy1017;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy196;
			goto yy97;
		} else {
			if (yych == 0xE2) goto yy98;
			goto yy196;
		}
	}
yy896:
	YYDEBUG(896, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '5') goto yy1018;
	if (yych <= '6') goto yy1019;
	goto yy59;
yy897:
	YYDEBUG(897, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy1020;
	goto yy59;
yy898:
	YYDEBUG(898, *YYCURSOR);
	++YYCURSOR;
	goto yy567;
yy899:
	YYDEBUG(899, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(900, *YYCURSOR);
	if (yych <= '/') goto yy177;
	if (yych <= '9') goto yy899;
	goto yy177;
yy901:
	YYDEBUG(901, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy224;
	if (yych <= '9') goto yy1022;
	goto yy224;
yy902:
	YYDEBUG(902, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy1023;
	goto yy59;
yy903:
	YYDEBUG(903, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy567;
		if (yych <= '9') goto yy1024;
		if (yych <= 'm') goto yy567;
		goto yy741;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy567;
			goto yy741;
		} else {
			if (yych <= 's') goto yy742;
			if (yych <= 't') goto yy743;
			goto yy567;
		}
	}
yy904:
	YYDEBUG(904, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '1') {
			if (yych <= '/') goto yy567;
			goto yy1024;
		} else {
			if (yych <= '9') goto yy737;
			if (yych <= 'm') goto yy567;
			goto yy741;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy567;
			goto yy741;
		} else {
			if (yych <= 's') goto yy742;
			if (yych <= 't') goto yy743;
			goto yy567;
		}
	}
yy905:
	YYDEBUG(905, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '2') goto yy1026;
	if (yych <= '3') goto yy1027;
	if (yych <= '9') goto yy1028;
	goto yy59;
yy906:
	YYDEBUG(906, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy1029;
	if (yych <= '0') goto yy752;
	if (yych <= '9') goto yy1030;
	goto yy752;
yy907:
	YYDEBUG(907, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy1029;
	if (yych <= '/') goto yy752;
	if (yych <= '9') goto yy1030;
	goto yy752;
yy908:
	YYDEBUG(908, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy1030;
	goto yy59;
yy909:
	YYDEBUG(909, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '6') goto yy1030;
	goto yy59;
yy910:
	YYDEBUG(910, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1031;
	if (yych == 'r') goto yy1031;
	goto yy59;
yy911:
	YYDEBUG(911, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1032;
	if (yych == 'g') goto yy1032;
	goto yy59;
yy912:
	YYDEBUG(912, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1033;
	if (yych == 'c') goto yy1033;
	goto yy59;
yy913:
	YYDEBUG(913, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy1034;
	if (yych == 'b') goto yy1034;
	goto yy59;
yy914:
	YYDEBUG(914, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1035;
	if (yych == 'n') goto yy1035;
	goto yy59;
yy915:
	YYDEBUG(915, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy1036;
		if (yych <= 'M') goto yy59;
		goto yy1037;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy59;
			goto yy1036;
		} else {
			if (yych == 'n') goto yy1037;
			goto yy59;
		}
	}
yy916:
	YYDEBUG(916, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy1038;
		if (yych <= 'X') goto yy59;
		goto yy1039;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy59;
			goto yy1038;
		} else {
			if (yych == 'y') goto yy1039;
			goto yy59;
		}
	}
yy917:
	YYDEBUG(917, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy1033;
	if (yych == 'v') goto yy1033;
	goto yy59;
yy918:
	YYDEBUG(918, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1040;
	if (yych == 't') goto yy1040;
	goto yy59;
yy919:
	YYDEBUG(919, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy1041;
	if (yych == 'p') goto yy1041;
	goto yy59;
yy920:
	YYDEBUG(920, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy59;
	if (yych <= '9') goto yy1030;
	goto yy59;
yy921:
	YYDEBUG(921, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy940;
	if (yych == 'p') goto yy940;
	goto yy59;
yy922:
	YYDEBUG(922, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '2') goto yy1042;
	if (yych <= '3') goto yy1044;
	if (yych <= '9') goto yy1045;
	goto yy59;
yy923:
	YYDEBUG(923, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '/') goto yy1046;
	goto yy59;
yy924:
	YYDEBUG(924, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy196;
		if (yych <= '9') goto yy1047;
		goto yy196;
	} else {
		if (yych <= 0xC2) goto yy97;
		if (yych == 0xE2) goto yy98;
		goto yy196;
	}
yy925:
	YYDEBUG(925, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy196;
				if (yych >= ' ') goto yy196;
			} else {
				if (yych <= '9') {
					if (yych >= '0') goto yy1047;
				} else {
					if (yych == 'D') goto yy196;
				}
			}
		} else {
			if (yych <= 'M') {
				if (yych <= 'G') {
					if (yych <= 'F') goto yy196;
				} else {
					if (yych <= 'H') goto yy196;
					if (yych >= 'M') goto yy196;
				}
			} else {
				if (yych <= 'U') {
					if (yych >= 'S') goto yy196;
				} else {
					if (yych == 'W') goto yy196;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy196;
				} else {
					if (yych != 'e') goto yy196;
				}
			} else {
				if (yych <= 'h') {
					if (yych >= 'h') goto yy196;
				} else {
					if (yych == 'm') goto yy196;
				}
			}
		} else {
			if (yych <= 'y') {
				if (yych <= 'v') {
					if (yych <= 'u') goto yy196;
				} else {
					if (yych != 'x') goto yy196;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych >= 0xC2) goto yy97;
				} else {
					if (yych == 0xE2) goto yy98;
				}
			}
		}
	}
yy926:
	YYDEBUG(926, *YYCURSOR);
#line 1686 "ext/date/lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("pgydotd");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
		s->time->d = timelib_get_nr(&ptr, 3);
		s->time->m = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_YEARDAY;
	}
#line 19574 "<stdout>"
yy927:
	YYDEBUG(927, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'E') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy926;
					goto yy196;
				} else {
					if (yych == ' ') goto yy196;
					goto yy926;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '1') goto yy1047;
					goto yy1049;
				} else {
					if (yych == 'D') goto yy196;
					goto yy926;
				}
			}
		} else {
			if (yych <= 'M') {
				if (yych <= 'G') {
					if (yych <= 'F') goto yy196;
					goto yy926;
				} else {
					if (yych <= 'H') goto yy196;
					if (yych <= 'L') goto yy926;
					goto yy196;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'R') goto yy926;
					goto yy196;
				} else {
					if (yych == 'W') goto yy196;
					goto yy926;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy196;
					goto yy926;
				} else {
					if (yych == 'e') goto yy926;
					goto yy196;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy926;
					goto yy196;
				} else {
					if (yych == 'm') goto yy196;
					goto yy926;
				}
			}
		} else {
			if (yych <= 'y') {
				if (yych <= 'v') {
					if (yych <= 'u') goto yy196;
					goto yy926;
				} else {
					if (yych == 'x') goto yy926;
					goto yy196;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 0xC1) goto yy926;
					goto yy97;
				} else {
					if (yych == 0xE2) goto yy98;
					goto yy926;
				}
			}
		}
	}
yy928:
	YYDEBUG(928, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy196;
				if (yych <= 0x1F) goto yy926;
				goto yy196;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy926;
					goto yy1049;
				} else {
					if (yych == 'D') goto yy196;
					goto yy926;
				}
			}
		} else {
			if (yych <= 'M') {
				if (yych <= 'G') {
					if (yych <= 'F') goto yy196;
					goto yy926;
				} else {
					if (yych <= 'H') goto yy196;
					if (yych <= 'L') goto yy926;
					goto yy196;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'R') goto yy926;
					goto yy196;
				} else {
					if (yych == 'W') goto yy196;
					goto yy926;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy196;
					goto yy926;
				} else {
					if (yych == 'e') goto yy926;
					goto yy196;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy926;
					goto yy196;
				} else {
					if (yych == 'm') goto yy196;
					goto yy926;
				}
			}
		} else {
			if (yych <= 'y') {
				if (yych <= 'v') {
					if (yych <= 'u') goto yy196;
					goto yy926;
				} else {
					if (yych == 'x') goto yy926;
					goto yy196;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 0xC1) goto yy926;
					goto yy97;
				} else {
					if (yych == 0xE2) goto yy98;
					goto yy926;
				}
			}
		}
	}
yy929:
	YYDEBUG(929, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy196;
		if (yych <= '9') goto yy1049;
		goto yy196;
	} else {
		if (yych <= 0xC2) goto yy97;
		if (yych == 0xE2) goto yy98;
		goto yy196;
	}
yy930:
	YYDEBUG(930, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1050;
	goto yy59;
yy931:
	YYDEBUG(931, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'I') goto yy1051;
	if (yych == 'i') goto yy1051;
	goto yy600;
yy932:
	YYDEBUG(932, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy1052;
	if (yych == 'u') goto yy1052;
	goto yy600;
yy933:
	YYDEBUG(933, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy1053;
	if (yych == 'e') goto yy1053;
	goto yy600;
yy934:
	YYDEBUG(934, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy1054;
	if (yych == 'r') goto yy1054;
	goto yy600;
yy935:
	YYDEBUG(935, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy1055;
	if (yych == 'u') goto yy1055;
	goto yy600;
yy936:
	YYDEBUG(936, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy790;
	if (yych == 'y') goto yy790;
	goto yy600;
yy937:
	YYDEBUG(937, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy790;
	if (yych == 'e') goto yy790;
	goto yy600;
yy938:
	YYDEBUG(938, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'C') goto yy1056;
	if (yych == 'c') goto yy1056;
	goto yy600;
yy939:
	YYDEBUG(939, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'O') goto yy1057;
	if (yych == 'o') goto yy1057;
	goto yy600;
yy940:
	YYDEBUG(940, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy933;
	if (yych == 't') goto yy933;
	goto yy600;
yy941:
	YYDEBUG(941, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy1058;
	if (yych <= '/') goto yy942;
	if (yych <= '7') goto yy1059;
yy942:
	YYDEBUG(942, *YYCURSOR);
#line 1719 "ext/date/lib/parse_date.re"
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();

		s->time->y = timelib_get_nr(&ptr, 4);
		w = timelib_get_nr(&ptr, 2);
		d = 1;
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
#line 19846 "<stdout>"
yy943:
	YYDEBUG(943, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1061;
	if (yych == 'g') goto yy1061;
	goto yy59;
yy944:
	YYDEBUG(944, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy253;
	if (yych == 'y') goto yy253;
	goto yy59;
yy945:
	YYDEBUG(945, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1062;
	if (yych == 'e') goto yy1062;
	goto yy59;
yy946:
	YYDEBUG(946, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy253;
	if (yych == 'r') goto yy253;
	goto yy59;
yy947:
	YYDEBUG(947, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= '`') {
		if (yych <= 'A') {
			if (yych <= '@') goto yy59;
			goto yy106;
		} else {
			if (yych == 'P') goto yy106;
			goto yy59;
		}
	} else {
		if (yych <= 'p') {
			if (yych <= 'a') goto yy106;
			if (yych <= 'o') goto yy59;
			goto yy106;
		} else {
			if (yych == 0xE2) goto yy641;
			goto yy59;
		}
	}
yy948:
	YYDEBUG(948, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy177;
				goto yy638;
			} else {
				if (yych == ' ') goto yy638;
				goto yy177;
			}
		} else {
			if (yych <= '9') {
				if (yych <= '.') goto yy1063;
				goto yy177;
			} else {
				if (yych <= ':') goto yy1064;
				if (yych <= '@') goto yy177;
				goto yy106;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'P') {
				if (yych <= 'O') goto yy177;
				goto yy106;
			} else {
				if (yych == 'a') goto yy106;
				goto yy177;
			}
		} else {
			if (yych <= 0xC2) {
				if (yych <= 'p') goto yy106;
				if (yych <= 0xC1) goto yy177;
				goto yy640;
			} else {
				if (yych == 0xE2) goto yy641;
				goto yy177;
			}
		}
	}
yy949:
	YYDEBUG(949, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy567;
		if (yych <= '9') goto yy1065;
		if (yych <= 'm') goto yy567;
		goto yy741;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy567;
			goto yy741;
		} else {
			if (yych <= 's') goto yy742;
			if (yych <= 't') goto yy743;
			goto yy567;
		}
	}
yy950:
	YYDEBUG(950, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy567;
		if (yych <= '1') goto yy1065;
		if (yych <= 'm') goto yy567;
		goto yy741;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy567;
			goto yy741;
		} else {
			if (yych <= 's') goto yy742;
			if (yych <= 't') goto yy743;
			goto yy567;
		}
	}
yy951:
	YYDEBUG(951, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '2') goto yy1066;
	if (yych <= '3') goto yy1067;
	goto yy59;
yy952:
	YYDEBUG(952, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy290;
	if (yych <= '9') goto yy1068;
	goto yy290;
yy953:
	YYDEBUG(953, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy1069;
	goto yy59;
yy954:
	YYDEBUG(954, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy955:
	YYDEBUG(955, *YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy954;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy297;
		goto yy59;
	} else {
		if (yych <= '/') goto yy297;
		if (yych == '_') goto yy297;
		goto yy59;
	}
yy956:
	YYDEBUG(956, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ' ') goto yy1071;
	goto yy59;
yy957:
	YYDEBUG(957, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy973;
	if (yych == 'r') goto yy973;
	goto yy59;
yy958:
	YYDEBUG(958, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy973;
	if (yych == 'r') goto yy974;
	goto yy955;
yy959:
	YYDEBUG(959, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1072;
	if (yych == 'e') goto yy1072;
	goto yy59;
yy960:
	YYDEBUG(960, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
	if (yych <= 'c') {
		if (yych <= 'M') {
			if (yych <= 'F') {
				if (yych == 'D') goto yy856;
				if (yych <= 'E') goto yy59;
				goto yy857;
			} else {
				if (yych == 'H') goto yy858;
				if (yych <= 'L') goto yy59;
				goto yy859;
			}
		} else {
			if (yych <= 'U') {
				if (yych <= 'R') goto yy59;
				if (yych <= 'S') goto yy860;
				if (yych <= 'T') goto yy861;
				goto yy862;
			} else {
				if (yych <= 'W') {
					if (yych <= 'V') goto yy59;
					goto yy959;
				} else {
					if (yych == 'Y') goto yy864;
					goto yy59;
				}
			}
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'g') {
				if (yych <= 'd') goto yy856;
				if (yych == 'f') goto yy857;
				goto yy59;
			} else {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy858;
					goto yy59;
				} else {
					if (yych <= 'm') goto yy859;
					if (yych <= 'r') goto yy59;
					goto yy860;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') goto yy861;
				if (yych <= 'u') goto yy862;
				if (yych <= 'v') goto yy59;
				goto yy959;
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy59;
					goto yy864;
				} else {
					if (yych == 0xC2) goto yy1073;
					goto yy59;
				}
			}
		}
	}
yy961:
	YYDEBUG(961, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xAF) goto yy1074;
	goto yy59;
yy962:
	YYDEBUG(962, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1001;
	if (yych == 'h') goto yy1001;
	goto yy59;
yy963:
	YYDEBUG(963, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1001;
	if (yych == 'h') goto yy1004;
	goto yy955;
yy964:
	YYDEBUG(964, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy973;
	if (yych == 'y') goto yy973;
	goto yy59;
yy965:
	YYDEBUG(965, *YYCURSOR);
	++YYCURSOR;
	goto yy315;
yy966:
	YYDEBUG(966, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy973;
	if (yych == 'y') goto yy974;
	goto yy955;
yy967:
	YYDEBUG(967, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy954;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy297;
		goto yy315;
	} else {
		if (yych <= '/') goto yy297;
		if (yych == '_') goto yy297;
		goto yy315;
	}
yy968:
	YYDEBUG(968, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy20;
	if (yych <= '9') goto yy1075;
	goto yy20;
yy969:
	YYDEBUG(969, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '5') goto yy1076;
	if (yych <= '6') goto yy1077;
	if (yych <= '9') goto yy1078;
	goto yy59;
yy970:
	YYDEBUG(970, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '5') goto yy1079;
	if (yych <= '6') goto yy1080;
	if (yych <= '9') goto yy1078;
	goto yy59;
yy971:
	YYDEBUG(971, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy849;
				goto yy1081;
			} else {
				if (yych == ' ') goto yy1081;
				goto yy849;
			}
		} else {
			if (yych <= '9') {
				if (yych <= '.') goto yy970;
				goto yy849;
			} else {
				if (yych <= ':') goto yy970;
				if (yych <= '@') goto yy849;
				goto yy1083;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'P') {
				if (yych <= 'O') goto yy849;
				goto yy1083;
			} else {
				if (yych == 'a') goto yy1083;
				goto yy849;
			}
		} else {
			if (yych <= 0xC2) {
				if (yych <= 'p') goto yy1083;
				if (yych <= 0xC1) goto yy849;
				goto yy1084;
			} else {
				if (yych == 0xE2) goto yy1085;
				goto yy849;
			}
		}
	}
yy972:
	YYDEBUG(972, *YYCURSOR);
	++YYCURSOR;
	goto yy325;
yy973:
	YYDEBUG(973, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy142;
		if (yych <= 0x1F) goto yy295;
		goto yy142;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy295;
			goto yy142;
		} else {
			if (yych <= '/') goto yy295;
			if (yych <= '9') goto yy142;
			goto yy295;
		}
	}
yy974:
	YYDEBUG(974, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy954;
	}
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy142;
			goto yy295;
		} else {
			if (yych <= ' ') goto yy142;
			if (yych <= ',') goto yy295;
			goto yy700;
		}
	} else {
		if (yych <= '9') {
			if (yych == '/') goto yy297;
			goto yy142;
		} else {
			if (yych == '_') goto yy297;
			goto yy295;
		}
	}
yy975:
	YYDEBUG(975, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1086;
	if (yych == 'y') goto yy1086;
	goto yy59;
yy976:
	YYDEBUG(976, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1087;
	if (yych == 'r') goto yy1087;
	goto yy59;
yy977:
	YYDEBUG(977, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1088;
	if (yych == 'i') goto yy1088;
	goto yy59;
yy978:
	YYDEBUG(978, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy1089;
	if (yych == 'u') goto yy1089;
	goto yy59;
yy979:
	YYDEBUG(979, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= 'K') {
			if (yych == 'C') goto yy1090;
			goto yy59;
		} else {
			if (yych <= 'L') goto yy1091;
			if (yych <= 'M') goto yy59;
			goto yy1092;
		}
	} else {
		if (yych <= 'k') {
			if (yych == 'c') goto yy1090;
			goto yy59;
		} else {
			if (yych <= 'l') goto yy1091;
			if (yych == 'n') goto yy1092;
			goto yy59;
		}
	}
yy980:
	YYDEBUG(980, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1093;
	if (yych == 'n') goto yy1093;
	goto yy59;
yy981:
	YYDEBUG(981, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy1094;
	if (yych == 'e') goto yy1094;
yy982:
	YYDEBUG(982, *YYCURSOR);
#line 1862 "ext/date/lib/parse_date.re"
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("relativetext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text(&ptr, &behavior);
			timelib_eat_spaces(&ptr);
			timelib_set_relative(&ptr, i, behavior, s, TIMELIB_TIME_PART_DONT_KEEP);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 20338 "<stdout>"
yy983:
	YYDEBUG(983, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1095;
	if (yych == 't') goto yy1095;
	goto yy59;
yy984:
	YYDEBUG(984, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1096;
	if (yych == 'c') goto yy1096;
	goto yy59;
yy985:
	YYDEBUG(985, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1088;
	if (yych == 'n') goto yy1088;
	goto yy59;
yy986:
	YYDEBUG(986, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy1097;
	if (yych == 'u') goto yy1097;
	goto yy59;
yy987:
	YYDEBUG(987, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1098;
	if (yych == 'e') goto yy1098;
	goto yy59;
yy988:
	YYDEBUG(988, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1094;
	if (yych == 'e') goto yy1094;
	goto yy59;
yy989:
	YYDEBUG(989, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy59;
		if (yych <= 'D') goto yy1099;
		goto yy1100;
	} else {
		if (yych <= 'c') goto yy59;
		if (yych <= 'd') goto yy1099;
		if (yych <= 'e') goto yy1100;
		goto yy59;
	}
yy990:
	YYDEBUG(990, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1089;
	if (yych == 'a') goto yy1089;
	goto yy59;
yy991:
	YYDEBUG(991, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy981;
	if (yych == 's') goto yy981;
	goto yy59;
yy992:
	YYDEBUG(992, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1101;
	if (yych == 'y') goto yy1101;
	goto yy59;
yy993:
	YYDEBUG(993, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych == 0xA0) goto yy867;
	if (yych == 0xB5) goto yy991;
	goto yy59;
yy994:
	YYDEBUG(994, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
	if (yych <= 'd') {
		if (yych <= 'R') {
			if (yych <= 'F') {
				if (yych == 'D') goto yy856;
				if (yych <= 'E') goto yy59;
				goto yy857;
			} else {
				if (yych <= 'H') {
					if (yych <= 'G') goto yy59;
					goto yy858;
				} else {
					if (yych == 'M') goto yy859;
					goto yy59;
				}
			}
		} else {
			if (yych <= 'V') {
				if (yych <= 'S') goto yy860;
				if (yych <= 'T') goto yy861;
				if (yych <= 'U') goto yy862;
				goto yy59;
			} else {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy863;
					goto yy59;
				} else {
					if (yych <= 'Y') goto yy864;
					if (yych <= 'c') goto yy59;
					goto yy856;
				}
			}
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'h') {
				if (yych == 'f') goto yy857;
				if (yych <= 'g') goto yy59;
				goto yy858;
			} else {
				if (yych <= 'm') {
					if (yych <= 'l') goto yy59;
					goto yy859;
				} else {
					if (yych <= 'r') goto yy59;
					if (yych <= 's') goto yy860;
					goto yy861;
				}
			}
		} else {
			if (yych <= 'y') {
				if (yych <= 'v') {
					if (yych <= 'u') goto yy862;
					goto yy59;
				} else {
					if (yych <= 'w') goto yy863;
					if (yych <= 'x') goto yy59;
					goto yy864;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 0xC1) goto yy59;
					goto yy865;
				} else {
					if (yych == 0xE2) goto yy705;
					goto yy59;
				}
			}
		}
	}
yy995:
	YYDEBUG(995, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1102;
	if (yych == 't') goto yy1102;
	goto yy59;
yy996:
	YYDEBUG(996, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1102;
	if (yych == 't') goto yy1103;
	goto yy955;
yy997:
	YYDEBUG(997, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1104;
	if (yych == 's') goto yy1104;
	goto yy59;
yy998:
	YYDEBUG(998, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1104;
	if (yych == 's') goto yy1105;
	goto yy955;
yy999:
	YYDEBUG(999, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1007;
	if (yych == 'y') goto yy1007;
	goto yy59;
yy1000:
	YYDEBUG(1000, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy957;
	if (yych == 'e') goto yy957;
	goto yy59;
yy1001:
	YYDEBUG(1001, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ' ') {
		if (yych == '\t') goto yy834;
		if (yych <= 0x1F) goto yy59;
		goto yy834;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy59;
			goto yy837;
		} else {
			if (yych == 0xE2) goto yy838;
			goto yy59;
		}
	}
yy1002:
	YYDEBUG(1002, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1007;
	if (yych == 'y') goto yy1009;
	goto yy955;
yy1003:
	YYDEBUG(1003, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy957;
	if (yych == 'e') goto yy958;
	goto yy955;
yy1004:
	YYDEBUG(1004, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ' ') {
		if (yych == '\t') goto yy834;
		if (yych <= 0x1F) goto yy955;
		goto yy834;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy955;
			goto yy837;
		} else {
			if (yych == 0xE2) goto yy838;
			goto yy955;
		}
	}
yy1005:
	YYDEBUG(1005, *YYCURSOR);
	++YYCURSOR;
	goto yy777;
yy1006:
	YYDEBUG(1006, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy1106;
	if (yych == 'w') goto yy1106;
	goto yy59;
yy1007:
	YYDEBUG(1007, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy965;
	if (yych == 's') goto yy965;
	goto yy315;
yy1008:
	YYDEBUG(1008, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy1106;
	if (yych == 'w') goto yy1108;
	goto yy955;
yy1009:
	YYDEBUG(1009, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == '-') goto yy297;
			goto yy315;
		} else {
			if (yych <= '/') goto yy297;
			if (yych <= 'R') goto yy315;
			goto yy965;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy297;
			goto yy315;
		} else {
			if (yych == 's') goto yy967;
			if (yych <= 'z') goto yy954;
			goto yy315;
		}
	}
yy1010:
	YYDEBUG(1010, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy999;
	if (yych == 'a') goto yy999;
	goto yy59;
yy1011:
	YYDEBUG(1011, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy999;
	if (yych == 'a') goto yy1002;
	goto yy955;
yy1012:
	YYDEBUG(1012, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1109;
	if (yych == 'a') goto yy1109;
	goto yy59;
yy1013:
	YYDEBUG(1013, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1109;
	if (yych == 'a') goto yy1110;
	goto yy955;
yy1014:
	YYDEBUG(1014, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy1111;
	goto yy59;
yy1015:
	YYDEBUG(1015, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy1112;
	goto yy59;
yy1016:
	YYDEBUG(1016, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '2') goto yy1112;
	goto yy59;
yy1017:
	YYDEBUG(1017, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych == '-') goto yy893;
		if (yych <= '/') goto yy196;
		goto yy1113;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy196;
			goto yy97;
		} else {
			if (yych == 0xE2) goto yy98;
			goto yy196;
		}
	}
yy1018:
	YYDEBUG(1018, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy115;
	goto yy59;
yy1019:
	YYDEBUG(1019, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy115;
	goto yy59;
yy1020:
	YYDEBUG(1020, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1021, *YYCURSOR);
#line 1568 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("pointed date YYYY");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr(&ptr, 2);
		s->time->m = timelib_get_nr(&ptr, 2);
		s->time->y = timelib_get_nr(&ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
#line 20696 "<stdout>"
yy1022:
	YYDEBUG(1022, *YYCURSOR);
	++YYCURSOR;
	goto yy224;
yy1023:
	YYDEBUG(1023, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy1114;
	goto yy59;
yy1024:
	YYDEBUG(1024, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy1025;
		if (yych <= '9') goto yy897;
		if (yych >= 'n') goto yy741;
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy741;
		} else {
			if (yych <= 's') goto yy742;
			if (yych <= 't') goto yy743;
		}
	}
yy1025:
	YYDEBUG(1025, *YYCURSOR);
#line 1499 "ext/date/lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("iso8601date2");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
		s->time->m = timelib_get_nr(&ptr, 2);
		s->time->d = timelib_get_nr(&ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 20738 "<stdout>"
yy1026:
	YYDEBUG(1026, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy567;
			goto yy1028;
		} else {
			if (yych == 'T') goto yy1115;
			goto yy567;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1116;
			if (yych <= 'q') goto yy567;
			goto yy1116;
		} else {
			if (yych <= 's') goto yy1117;
			if (yych <= 't') goto yy1118;
			goto yy567;
		}
	}
yy1027:
	YYDEBUG(1027, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy567;
		} else {
			if (yych == 'T') goto yy1115;
			goto yy567;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1116;
			if (yych <= 'q') goto yy567;
			goto yy1116;
		} else {
			if (yych <= 's') goto yy1117;
			if (yych <= 't') goto yy1118;
			goto yy567;
		}
	}
yy1028:
	YYDEBUG(1028, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy1115;
		if (yych <= 'm') goto yy567;
		goto yy1116;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy567;
			goto yy1116;
		} else {
			if (yych <= 's') goto yy1117;
			if (yych <= 't') goto yy1118;
			goto yy567;
		}
	}
yy1029:
	YYDEBUG(1029, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '2') goto yy1119;
	if (yych <= '3') goto yy1120;
	if (yych <= '9') goto yy1028;
	goto yy59;
yy1030:
	YYDEBUG(1030, *YYCURSOR);
	++YYCURSOR;
	goto yy926;
yy1031:
	YYDEBUG(1031, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych == '-') goto yy951;
		goto yy600;
	} else {
		if (yych <= 'I') goto yy1051;
		if (yych == 'i') goto yy1051;
		goto yy600;
	}
yy1032:
	YYDEBUG(1032, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy951;
		goto yy600;
	} else {
		if (yych <= 'U') goto yy1052;
		if (yych == 'u') goto yy1052;
		goto yy600;
	}
yy1033:
	YYDEBUG(1033, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy951;
		goto yy600;
	} else {
		if (yych <= 'E') goto yy1053;
		if (yych == 'e') goto yy1053;
		goto yy600;
	}
yy1034:
	YYDEBUG(1034, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == '-') goto yy951;
		goto yy600;
	} else {
		if (yych <= 'R') goto yy1054;
		if (yych == 'r') goto yy1054;
		goto yy600;
	}
yy1035:
	YYDEBUG(1035, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy951;
		goto yy600;
	} else {
		if (yych <= 'U') goto yy1055;
		if (yych == 'u') goto yy1055;
		goto yy600;
	}
yy1036:
	YYDEBUG(1036, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych == '-') goto yy951;
		goto yy600;
	} else {
		if (yych <= 'Y') goto yy790;
		if (yych == 'y') goto yy790;
		goto yy600;
	}
yy1037:
	YYDEBUG(1037, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy951;
		goto yy600;
	} else {
		if (yych <= 'E') goto yy790;
		if (yych == 'e') goto yy790;
		goto yy600;
	}
yy1038:
	YYDEBUG(1038, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych == '-') goto yy951;
		goto yy600;
	} else {
		if (yych <= 'C') goto yy1056;
		if (yych == 'c') goto yy1056;
		goto yy600;
	}
yy1039:
	YYDEBUG(1039, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy951;
	goto yy600;
yy1040:
	YYDEBUG(1040, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == '-') goto yy951;
		goto yy600;
	} else {
		if (yych <= 'O') goto yy1057;
		if (yych == 'o') goto yy1057;
		goto yy600;
	}
yy1041:
	YYDEBUG(1041, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == '-') goto yy951;
		goto yy600;
	} else {
		if (yych <= 'T') goto yy1033;
		if (yych == 't') goto yy1033;
		goto yy600;
	}
yy1042:
	YYDEBUG(1042, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy1043;
		if (yych <= '9') goto yy1045;
		if (yych >= 'n') goto yy1121;
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy1121;
		} else {
			if (yych <= 's') goto yy1122;
			if (yych <= 't') goto yy1123;
		}
	}
yy1043:
	YYDEBUG(1043, *YYCURSOR);
#line 1487 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("iso8601date4 | iso8601date2 | iso8601dateslash | dateslash");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_signed_nr(s, &ptr, 4);
		s->time->m = timelib_get_nr(&ptr, 2);
		s->time->d = timelib_get_nr(&ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 20969 "<stdout>"
yy1044:
	YYDEBUG(1044, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy1043;
		if (yych <= '1') goto yy1045;
		if (yych <= 'm') goto yy1043;
		goto yy1121;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy1043;
			goto yy1121;
		} else {
			if (yych <= 's') goto yy1122;
			if (yych <= 't') goto yy1123;
			goto yy1043;
		}
	}
yy1045:
	YYDEBUG(1045, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy1121;
		goto yy1043;
	} else {
		if (yych <= 'r') goto yy1121;
		if (yych <= 's') goto yy1122;
		if (yych <= 't') goto yy1123;
		goto yy1043;
	}
yy1046:
	YYDEBUG(1046, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '2') goto yy1124;
	if (yych <= '3') goto yy1125;
	if (yych <= '9') goto yy1045;
	goto yy59;
yy1047:
	YYDEBUG(1047, *YYCURSOR);
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'F') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych >= '\t') goto yy195;
				} else {
					if (yych == ' ') goto yy195;
				}
			} else {
				if (yych <= 'C') {
					if (yych <= '9') goto yy1126;
				} else {
					if (yych <= 'D') goto yy198;
					if (yych >= 'F') goto yy199;
				}
			}
		} else {
			if (yych <= 'R') {
				if (yych <= 'H') {
					if (yych >= 'H') goto yy79;
				} else {
					if (yych == 'M') goto yy200;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'S') goto yy201;
					if (yych <= 'T') goto yy1127;
					goto yy88;
				} else {
					if (yych == 'W') goto yy90;
				}
			}
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy92;
				} else {
					if (yych <= 'd') goto yy198;
					if (yych >= 'f') goto yy199;
				}
			} else {
				if (yych <= 'l') {
					if (yych == 'h') goto yy79;
				} else {
					if (yych <= 'm') goto yy200;
					if (yych >= 's') goto yy201;
				}
			}
		} else {
			if (yych <= 'x') {
				if (yych <= 'u') {
					if (yych <= 't') goto yy1128;
					goto yy88;
				} else {
					if (yych == 'w') goto yy90;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 'y') goto yy92;
					if (yych >= 0xC2) goto yy97;
				} else {
					if (yych == 0xE2) goto yy98;
				}
			}
		}
	}
yy1048:
	YYDEBUG(1048, *YYCURSOR);
#line 1648 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("datenocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr(&ptr, 4);
		s->time->m = timelib_get_nr(&ptr, 2);
		s->time->d = timelib_get_nr(&ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NOCOLON;
	}
#line 21095 "<stdout>"
yy1049:
	YYDEBUG(1049, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy196;
		if (yych <= '9') goto yy1126;
		goto yy196;
	} else {
		if (yych <= 0xC2) goto yy97;
		if (yych == 0xE2) goto yy98;
		goto yy196;
	}
yy1050:
	YYDEBUG(1050, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '2') goto yy1129;
	if (yych <= '3') goto yy1130;
	goto yy59;
yy1051:
	YYDEBUG(1051, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy790;
	if (yych == 'l') goto yy790;
	goto yy59;
yy1052:
	YYDEBUG(1052, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1131;
	if (yych == 's') goto yy1131;
	goto yy59;
yy1053:
	YYDEBUG(1053, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1057;
	if (yych == 'm') goto yy1057;
	goto yy59;
yy1054:
	YYDEBUG(1054, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy1055;
	if (yych != 'u') goto yy59;
yy1055:
	YYDEBUG(1055, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1132;
	if (yych == 'a') goto yy1132;
	goto yy59;
yy1056:
	YYDEBUG(1056, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy790;
	if (yych == 'h') goto yy790;
	goto yy59;
yy1057:
	YYDEBUG(1057, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy1133;
	if (yych == 'b') goto yy1133;
	goto yy59;
yy1058:
	YYDEBUG(1058, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych >= '8') goto yy59;
yy1059:
	YYDEBUG(1059, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1060, *YYCURSOR);
#line 1700 "ext/date/lib/parse_date.re"
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweekday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();

		s->time->y = timelib_get_nr(&ptr, 4);
		w = timelib_get_nr(&ptr, 2);
		d = timelib_get_nr(&ptr, 1);
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
#line 21183 "<stdout>"
yy1061:
	YYDEBUG(1061, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1134;
	if (yych == 'h') goto yy1134;
	goto yy59;
yy1062:
	YYDEBUG(1062, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1135;
	if (yych == 'c') goto yy1135;
	goto yy59;
yy1063:
	YYDEBUG(1063, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy1136;
	goto yy59;
yy1064:
	YYDEBUG(1064, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy1138;
	goto yy59;
yy1065:
	YYDEBUG(1065, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy741;
		goto yy1025;
	} else {
		if (yych <= 'r') goto yy741;
		if (yych <= 's') goto yy742;
		if (yych <= 't') goto yy743;
		goto yy1025;
	}
yy1066:
	YYDEBUG(1066, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy1140;
	goto yy59;
yy1067:
	YYDEBUG(1067, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '1') goto yy1140;
	goto yy59;
yy1068:
	YYDEBUG(1068, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy290;
	if (yych <= '9') goto yy1142;
	goto yy290;
yy1069:
	YYDEBUG(1069, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1070;
	if (yych <= '9') goto yy1143;
yy1070:
	YYDEBUG(1070, *YYCURSOR);
#line 1738 "ext/date/lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("pgtextshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month(&ptr);
		s->time->d = timelib_get_nr(&ptr, 2);
		s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
#line 21259 "<stdout>"
yy1071:
	YYDEBUG(1071, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '1') goto yy1144;
	if (yych <= '2') goto yy1146;
	if (yych <= '9') goto yy1147;
	goto yy59;
yy1072:
	YYDEBUG(1072, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy59;
		if (yych <= 'D') goto yy1099;
		goto yy1148;
	} else {
		if (yych <= 'c') goto yy59;
		if (yych <= 'd') goto yy1099;
		if (yych <= 'e') goto yy1148;
		goto yy59;
	}
yy1073:
	YYDEBUG(1073, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych == 0xA0) goto yy960;
	if (yych == 0xB5) goto yy991;
	goto yy59;
yy1074:
	YYDEBUG(1074, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
	if (yych <= 'd') {
		if (yych <= 'R') {
			if (yych <= 'F') {
				if (yych == 'D') goto yy856;
				if (yych <= 'E') goto yy59;
				goto yy857;
			} else {
				if (yych <= 'H') {
					if (yych <= 'G') goto yy59;
					goto yy858;
				} else {
					if (yych == 'M') goto yy859;
					goto yy59;
				}
			}
		} else {
			if (yych <= 'V') {
				if (yych <= 'S') goto yy860;
				if (yych <= 'T') goto yy861;
				if (yych <= 'U') goto yy862;
				goto yy59;
			} else {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy959;
					goto yy59;
				} else {
					if (yych <= 'Y') goto yy864;
					if (yych <= 'c') goto yy59;
					goto yy856;
				}
			}
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'h') {
				if (yych == 'f') goto yy857;
				if (yych <= 'g') goto yy59;
				goto yy858;
			} else {
				if (yych <= 'm') {
					if (yych <= 'l') goto yy59;
					goto yy859;
				} else {
					if (yych <= 'r') goto yy59;
					if (yych <= 's') goto yy860;
					goto yy861;
				}
			}
		} else {
			if (yych <= 'y') {
				if (yych <= 'v') {
					if (yych <= 'u') goto yy862;
					goto yy59;
				} else {
					if (yych <= 'w') goto yy959;
					if (yych <= 'x') goto yy59;
					goto yy864;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 0xC1) goto yy59;
					goto yy865;
				} else {
					if (yych == 0xE2) goto yy838;
					goto yy59;
				}
			}
		}
	}
yy1075:
	YYDEBUG(1075, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy20;
	if (yych <= '5') goto yy1018;
	if (yych <= '6') goto yy1019;
	goto yy20;
yy1076:
	YYDEBUG(1076, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy849;
	if (yych <= '9') goto yy1149;
	goto yy849;
yy1077:
	YYDEBUG(1077, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1149;
	goto yy849;
yy1078:
	YYDEBUG(1078, *YYCURSOR);
	++YYCURSOR;
	goto yy849;
yy1079:
	YYDEBUG(1079, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy849;
	if (yych <= '9') goto yy1150;
	goto yy849;
yy1080:
	YYDEBUG(1080, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1150;
	goto yy849;
yy1081:
	YYDEBUG(1081, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(1082, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1081;
			goto yy59;
		} else {
			if (yych <= ' ') goto yy1081;
			if (yych <= '@') goto yy59;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy59;
		} else {
			if (yych <= 'a') goto yy1083;
			if (yych != 'p') goto yy59;
		}
	}
yy1083:
	YYDEBUG(1083, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == '.') goto yy1151;
		goto yy59;
	} else {
		if (yych <= 'M') goto yy1152;
		if (yych == 'm') goto yy1152;
		goto yy59;
	}
yy1084:
	YYDEBUG(1084, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xA0) goto yy1153;
	goto yy59;
yy1085:
	YYDEBUG(1085, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0x80) goto yy1154;
	goto yy59;
yy1086:
	YYDEBUG(1086, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1155;
	if (yych == 's') goto yy1155;
	goto yy982;
yy1087:
	YYDEBUG(1087, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1156;
	if (yych == 't') goto yy1156;
	goto yy59;
yy1088:
	YYDEBUG(1088, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1157;
			goto yy982;
		} else {
			if (yych <= ' ') goto yy1157;
			if (yych <= 'C') goto yy982;
			goto yy1159;
		}
	} else {
		if (yych <= 0xC1) {
			if (yych == 'd') goto yy1159;
			goto yy982;
		} else {
			if (yych <= 0xC2) goto yy1160;
			if (yych == 0xE2) goto yy1161;
			goto yy982;
		}
	}
yy1089:
	YYDEBUG(1089, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1086;
	if (yych == 'r') goto yy1086;
	goto yy59;
yy1090:
	YYDEBUG(1090, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1162;
	if (yych == 'r') goto yy1162;
	goto yy59;
yy1091:
	YYDEBUG(1091, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy1163;
	if (yych == 'l') goto yy1163;
	goto yy59;
yy1092:
	YYDEBUG(1092, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy1155;
		if (yych <= 'T') goto yy982;
		goto yy1164;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy982;
			goto yy1155;
		} else {
			if (yych == 'u') goto yy1164;
			goto yy982;
		}
	}
yy1093:
	YYDEBUG(1093, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1157;
			if (yych <= 0x1F) goto yy982;
			goto yy1157;
		} else {
			if (yych == 'D') goto yy1159;
			if (yych <= 'S') goto yy982;
			goto yy1165;
		}
	} else {
		if (yych <= 't') {
			if (yych == 'd') goto yy1159;
			if (yych <= 's') goto yy982;
			goto yy1165;
		} else {
			if (yych <= 0xC2) {
				if (yych <= 0xC1) goto yy982;
				goto yy1160;
			} else {
				if (yych == 0xE2) goto yy1161;
				goto yy982;
			}
		}
	}
yy1094:
	YYDEBUG(1094, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1086;
	if (yych == 'c') goto yy1086;
	goto yy59;
yy1095:
	YYDEBUG(1095, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1157;
			goto yy982;
		} else {
			if (yych <= ' ') goto yy1157;
			if (yych <= 'T') goto yy982;
			goto yy1166;
		}
	} else {
		if (yych <= 0xC1) {
			if (yych == 'u') goto yy1166;
			goto yy982;
		} else {
			if (yych <= 0xC2) goto yy1160;
			if (yych == 0xE2) goto yy1161;
			goto yy982;
		}
	}
yy1096:
	YYDEBUG(1096, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy1167;
		if (yych <= 'R') goto yy982;
		goto yy1155;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy982;
			goto yy1167;
		} else {
			if (yych == 's') goto yy1155;
			goto yy982;
		}
	}
yy1097:
	YYDEBUG(1097, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1157;
			goto yy982;
		} else {
			if (yych <= ' ') goto yy1157;
			if (yych <= 'Q') goto yy982;
			goto yy1168;
		}
	} else {
		if (yych <= 0xC1) {
			if (yych == 'r') goto yy1168;
			goto yy982;
		} else {
			if (yych <= 0xC2) goto yy1160;
			if (yych == 0xE2) goto yy1161;
			goto yy982;
		}
	}
yy1098:
	YYDEBUG(1098, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1157;
			goto yy982;
		} else {
			if (yych <= ' ') goto yy1157;
			if (yych <= 'R') goto yy982;
			goto yy1169;
		}
	} else {
		if (yych <= 0xC1) {
			if (yych == 's') goto yy1169;
			goto yy982;
		} else {
			if (yych <= 0xC2) goto yy1160;
			if (yych == 0xE2) goto yy1161;
			goto yy982;
		}
	}
yy1099:
	YYDEBUG(1099, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1157;
			goto yy982;
		} else {
			if (yych <= ' ') goto yy1157;
			if (yych <= 'M') goto yy982;
			goto yy1170;
		}
	} else {
		if (yych <= 0xC1) {
			if (yych == 'n') goto yy1170;
			goto yy982;
		} else {
			if (yych <= 0xC2) goto yy1160;
			if (yych == 0xE2) goto yy1161;
			goto yy982;
		}
	}
yy1100:
	YYDEBUG(1100, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy1171;
	if (yych == 'k') goto yy1171;
	goto yy59;
yy1101:
	YYDEBUG(1101, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych == ' ') goto yy1173;
		goto yy982;
	} else {
		if (yych <= 'S') goto yy1155;
		if (yych == 's') goto yy1155;
		goto yy982;
	}
yy1102:
	YYDEBUG(1102, *YYCURSOR);
	++YYCURSOR;
	goto yy722;
yy1103:
	YYDEBUG(1103, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy954;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy297;
		goto yy722;
	} else {
		if (yych <= '/') goto yy297;
		if (yych == '_') goto yy297;
		goto yy722;
	}
yy1104:
	YYDEBUG(1104, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ' ') {
		if (yych == '\t') goto yy701;
		if (yych <= 0x1F) goto yy59;
		goto yy701;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy59;
			goto yy704;
		} else {
			if (yych == 0xE2) goto yy705;
			goto yy59;
		}
	}
yy1105:
	YYDEBUG(1105, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ' ') {
		if (yych == '\t') goto yy701;
		if (yych <= 0x1F) goto yy955;
		goto yy701;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy955;
			goto yy704;
		} else {
			if (yych == 0xE2) goto yy705;
			goto yy955;
		}
	}
yy1106:
	YYDEBUG(1106, *YYCURSOR);
	++YYCURSOR;
yy1107:
	YYDEBUG(1107, *YYCURSOR);
#line 1199 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("tomorrow");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = 1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 21743 "<stdout>"
yy1108:
	YYDEBUG(1108, *YYCURSOR);
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy954;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy297;
		goto yy1107;
	} else {
		if (yych <= '/') goto yy297;
		if (yych == '_') goto yy297;
		goto yy1107;
	}
yy1109:
	YYDEBUG(1109, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1174;
	if (yych == 'y') goto yy1174;
	goto yy59;
yy1110:
	YYDEBUG(1110, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1174;
	if (yych == 'y') goto yy1176;
	goto yy955;
yy1111:
	YYDEBUG(1111, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '2') goto yy1177;
	if (yych <= '3') goto yy1178;
	goto yy59;
yy1112:
	YYDEBUG(1112, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy1179;
	goto yy59;
yy1113:
	YYDEBUG(1113, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych == '-') goto yy893;
		if (yych <= '/') goto yy196;
		goto yy1180;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy196;
			goto yy97;
		} else {
			if (yych == 0xE2) goto yy98;
			goto yy196;
		}
	}
yy1114:
	YYDEBUG(1114, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy1181;
	goto yy59;
yy1115:
	YYDEBUG(1115, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '1') goto yy1182;
	if (yych <= '2') goto yy1183;
	if (yych <= '9') goto yy1184;
	goto yy59;
yy1116:
	YYDEBUG(1116, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy1185;
	goto yy59;
yy1117:
	YYDEBUG(1117, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy1185;
	goto yy59;
yy1118:
	YYDEBUG(1118, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy1185;
	goto yy59;
yy1119:
	YYDEBUG(1119, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy567;
			goto yy1186;
		} else {
			if (yych == 'T') goto yy1115;
			goto yy567;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1116;
			if (yych <= 'q') goto yy567;
			goto yy1116;
		} else {
			if (yych <= 's') goto yy1117;
			if (yych <= 't') goto yy1118;
			goto yy567;
		}
	}
yy1120:
	YYDEBUG(1120, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy567;
			goto yy1186;
		} else {
			if (yych == 'T') goto yy1115;
			goto yy567;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1116;
			if (yych <= 'q') goto yy567;
			goto yy1116;
		} else {
			if (yych <= 's') goto yy1117;
			if (yych <= 't') goto yy1118;
			goto yy567;
		}
	}
yy1121:
	YYDEBUG(1121, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy1187;
	goto yy59;
yy1122:
	YYDEBUG(1122, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy1187;
	goto yy59;
yy1123:
	YYDEBUG(1123, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy1187;
	goto yy59;
yy1124:
	YYDEBUG(1124, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy1043;
		if (yych <= '9') goto yy1188;
		if (yych <= 'm') goto yy1043;
		goto yy1121;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy1043;
			goto yy1121;
		} else {
			if (yych <= 's') goto yy1122;
			if (yych <= 't') goto yy1123;
			goto yy1043;
		}
	}
yy1125:
	YYDEBUG(1125, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy1043;
		if (yych <= '1') goto yy1188;
		if (yych <= 'm') goto yy1043;
		goto yy1121;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy1043;
			goto yy1121;
		} else {
			if (yych <= 's') goto yy1122;
			if (yych <= 't') goto yy1123;
			goto yy1043;
		}
	}
yy1126:
	YYDEBUG(1126, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy196;
		if (yych <= '9') goto yy1189;
		goto yy196;
	} else {
		if (yych <= 0xC2) goto yy97;
		if (yych == 0xE2) goto yy98;
		goto yy196;
	}
yy1127:
	YYDEBUG(1127, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy59;
			if (yych <= '1') goto yy1190;
			goto yy1191;
		} else {
			if (yych <= '9') goto yy1192;
			if (yych <= 'G') goto yy59;
			goto yy266;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy267;
			goto yy59;
		} else {
			if (yych <= 'h') goto yy266;
			if (yych == 'u') goto yy267;
			goto yy59;
		}
	}
yy1128:
	YYDEBUG(1128, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy59;
			if (yych <= '1') goto yy1193;
			goto yy1194;
		} else {
			if (yych <= '9') goto yy1195;
			if (yych <= 'G') goto yy59;
			goto yy266;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy267;
			goto yy59;
		} else {
			if (yych <= 'h') goto yy266;
			if (yych == 'u') goto yy267;
			goto yy59;
		}
	}
yy1129:
	YYDEBUG(1129, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy1196;
	goto yy59;
yy1130:
	YYDEBUG(1130, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '1') goto yy1196;
	goto yy59;
yy1131:
	YYDEBUG(1131, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy790;
	if (yych == 't') goto yy790;
	goto yy59;
yy1132:
	YYDEBUG(1132, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1197;
	if (yych == 'r') goto yy1197;
	goto yy59;
yy1133:
	YYDEBUG(1133, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1198;
	if (yych == 'e') goto yy1198;
	goto yy59;
yy1134:
	YYDEBUG(1134, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy425;
	if (yych == 't') goto yy425;
	goto yy59;
yy1135:
	YYDEBUG(1135, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy628;
	if (yych == 'o') goto yy628;
	goto yy59;
yy1136:
	YYDEBUG(1136, *YYCURSOR);
	yyaccept = 4;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(1137, *YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '9') {
			if (yych <= '/') goto yy177;
			goto yy1136;
		} else {
			if (yych == 'A') goto yy1199;
			goto yy177;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'P') goto yy1199;
			if (yych <= '`') goto yy177;
			goto yy1199;
		} else {
			if (yych == 'p') goto yy1199;
			goto yy177;
		}
	}
yy1138:
	YYDEBUG(1138, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(1139, *YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '9') {
			if (yych <= '/') goto yy59;
			goto yy1138;
		} else {
			if (yych == 'A') goto yy1199;
			goto yy59;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'P') goto yy1199;
			if (yych <= '`') goto yy59;
			goto yy1199;
		} else {
			if (yych == 'p') goto yy1199;
			goto yy59;
		}
	}
yy1140:
	YYDEBUG(1140, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1141, *YYCURSOR);
#line 1752 "ext/date/lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("pgtextreverse");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
		s->time->m = timelib_get_month(&ptr);
		s->time->d = timelib_get_nr(&ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
#line 22093 "<stdout>"
yy1142:
	YYDEBUG(1142, *YYCURSOR);
	++YYCURSOR;
	goto yy290;
yy1143:
	YYDEBUG(1143, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1070;
	if (yych <= '9') goto yy1200;
	goto yy1070;
yy1144:
	YYDEBUG(1144, *YYCURSOR);
	yyaccept = 29;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1201;
			if (yych >= ' ') goto yy1201;
		} else {
			if (yych <= '9') {
				if (yych >= '0') goto yy1147;
			} else {
				if (yych == 'A') goto yy1203;
			}
		}
	} else {
		if (yych <= 'p') {
			if (yych <= '`') {
				if (yych <= 'P') goto yy1203;
			} else {
				if (yych <= 'a') goto yy1203;
				if (yych >= 'p') goto yy1203;
			}
		} else {
			if (yych <= 0xC2) {
				if (yych >= 0xC2) goto yy1204;
			} else {
				if (yych == 0xE2) goto yy1205;
			}
		}
	}
yy1145:
	YYDEBUG(1145, *YYCURSOR);
#line 1294 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("backof | frontof");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();

		if (*ptr == 'b') {
			s->time->h = timelib_get_nr(&ptr, 2);
			s->time->i = 15;
		} else {
			s->time->h = timelib_get_nr(&ptr, 2) - 1;
			s->time->i = 45;
		}
		if (*ptr != '\0' ) {
			timelib_eat_spaces(&ptr);
			s->time->h += timelib_meridian(&ptr, s->time->h);
		}

		TIMELIB_DEINIT;
		return TIMELIB_LF_DAY_OF_MONTH;
	}
#line 22159 "<stdout>"
yy1146:
	YYDEBUG(1146, *YYCURSOR);
	yyaccept = 29;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1201;
			if (yych <= 0x1F) goto yy1145;
			goto yy1201;
		} else {
			if (yych <= '4') {
				if (yych <= '/') goto yy1145;
			} else {
				if (yych == 'A') goto yy1203;
				goto yy1145;
			}
		}
	} else {
		if (yych <= 'p') {
			if (yych <= '`') {
				if (yych <= 'P') goto yy1203;
				goto yy1145;
			} else {
				if (yych <= 'a') goto yy1203;
				if (yych <= 'o') goto yy1145;
				goto yy1203;
			}
		} else {
			if (yych <= 0xC2) {
				if (yych <= 0xC1) goto yy1145;
				goto yy1204;
			} else {
				if (yych == 0xE2) goto yy1205;
				goto yy1145;
			}
		}
	}
yy1147:
	YYDEBUG(1147, *YYCURSOR);
	yyaccept = 29;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'P') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1201;
			if (yych <= 0x1F) goto yy1145;
			goto yy1201;
		} else {
			if (yych == 'A') goto yy1203;
			if (yych <= 'O') goto yy1145;
			goto yy1203;
		}
	} else {
		if (yych <= 'p') {
			if (yych == 'a') goto yy1203;
			if (yych <= 'o') goto yy1145;
			goto yy1203;
		} else {
			if (yych <= 0xC2) {
				if (yych <= 0xC1) goto yy1145;
				goto yy1204;
			} else {
				if (yych == 0xE2) goto yy1205;
				goto yy1145;
			}
		}
	}
yy1148:
	YYDEBUG(1148, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy1206;
	if (yych == 'k') goto yy1206;
	goto yy59;
yy1149:
	YYDEBUG(1149, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1208;
			if (yych <= 0x1F) goto yy849;
			goto yy1208;
		} else {
			if (yych <= '(') {
				if (yych <= '\'') goto yy849;
				goto yy1208;
			} else {
				if (yych == '+') goto yy1208;
				goto yy849;
			}
		}
	} else {
		if (yych <= 'z') {
			if (yych <= '@') {
				if (yych <= '-') goto yy1208;
				goto yy849;
			} else {
				if (yych <= 'Z') goto yy1208;
				if (yych <= '`') goto yy849;
				goto yy1208;
			}
		} else {
			if (yych <= 0xC2) {
				if (yych <= 0xC1) goto yy849;
				goto yy1214;
			} else {
				if (yych == 0xE2) goto yy1215;
				goto yy849;
			}
		}
	}
yy1150:
	YYDEBUG(1150, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1217;
			if (yych <= 0x1F) goto yy849;
			goto yy1217;
		} else {
			if (yych <= '(') {
				if (yych <= '\'') goto yy849;
				goto yy1217;
			} else {
				if (yych == '+') goto yy1217;
				goto yy849;
			}
		}
	} else {
		if (yych <= 'z') {
			if (yych <= '@') {
				if (yych <= '-') goto yy1217;
				goto yy849;
			} else {
				if (yych <= 'Z') goto yy1217;
				if (yych <= '`') goto yy849;
				goto yy1217;
			}
		} else {
			if (yych <= 0xC2) {
				if (yych <= 0xC1) goto yy849;
				goto yy1220;
			} else {
				if (yych == 0xE2) goto yy1221;
				goto yy849;
			}
		}
	}
yy1151:
	YYDEBUG(1151, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1152;
	if (yych != 'm') goto yy59;
yy1152:
	YYDEBUG(1152, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy1222;
		if (yych == '\t') goto yy1222;
		goto yy59;
	} else {
		if (yych <= ' ') goto yy1222;
		if (yych == '.') goto yy1224;
		goto yy59;
	}
yy1153:
	YYDEBUG(1153, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= '`') {
		if (yych <= 'A') {
			if (yych <= '@') goto yy59;
			goto yy1083;
		} else {
			if (yych == 'P') goto yy1083;
			goto yy59;
		}
	} else {
		if (yych <= 'p') {
			if (yych <= 'a') goto yy1083;
			if (yych <= 'o') goto yy59;
			goto yy1083;
		} else {
			if (yych == 0xC2) goto yy1084;
			goto yy59;
		}
	}
yy1154:
	YYDEBUG(1154, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xAF) goto yy1225;
	goto yy59;
yy1155:
	YYDEBUG(1155, *YYCURSOR);
	++YYCURSOR;
	goto yy982;
yy1156:
	YYDEBUG(1156, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy1226;
		if (yych <= 'M') goto yy59;
		goto yy1227;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy59;
			goto yy1226;
		} else {
			if (yych == 'n') goto yy1227;
			goto yy59;
		}
	}
yy1157:
	YYDEBUG(1157, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	YYDEBUG(1158, *YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1157;
		if (yych <= 0x1F) goto yy59;
		goto yy1157;
	} else {
		if (yych <= 'O') {
			if (yych <= 'N') goto yy59;
			goto yy1228;
		} else {
			if (yych == 'o') goto yy1228;
			goto yy59;
		}
	}
yy1159:
	YYDEBUG(1159, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1229;
	if (yych == 'a') goto yy1229;
	goto yy59;
yy1160:
	YYDEBUG(1160, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xA0) goto yy1230;
	goto yy59;
yy1161:
	YYDEBUG(1161, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0x80) goto yy1231;
	goto yy59;
yy1162:
	YYDEBUG(1162, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1232;
	if (yych == 'o') goto yy1232;
	goto yy59;
yy1163:
	YYDEBUG(1163, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1232;
	if (yych == 'i') goto yy1232;
	goto yy59;
yy1164:
	YYDEBUG(1164, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1233;
	if (yych == 't') goto yy1233;
	goto yy59;
yy1165:
	YYDEBUG(1165, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1086;
	if (yych == 'h') goto yy1086;
	goto yy59;
yy1166:
	YYDEBUG(1166, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1169;
	if (yych == 'r') goto yy1169;
	goto yy59;
yy1167:
	YYDEBUG(1167, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1234;
	if (yych == 'n') goto yy1234;
	goto yy59;
yy1168:
	YYDEBUG(1168, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1169;
	if (yych != 's') goto yy59;
yy1169:
	YYDEBUG(1169, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1159;
	if (yych == 'd') goto yy1159;
	goto yy59;
yy1170:
	YYDEBUG(1170, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1168;
	if (yych == 'e') goto yy1168;
	goto yy59;
yy1171:
	YYDEBUG(1171, *YYCURSOR);
	yyaccept = 30;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'D') goto yy856;
		if (yych >= 'S') goto yy1155;
	} else {
		if (yych <= 'd') {
			if (yych >= 'd') goto yy856;
		} else {
			if (yych == 's') goto yy1155;
		}
	}
yy1172:
	YYDEBUG(1172, *YYCURSOR);
#line 1838 "ext/date/lib/parse_date.re"
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("relativetextweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text(&ptr, &behavior);
			timelib_eat_spaces(&ptr);
			timelib_set_relative(&ptr, i, behavior, s, TIMELIB_TIME_PART_DONT_KEEP);
			s->time->relative.weekday_behavior = 2;

			/* to handle the format weekday + last/this/next week */
			if (s->time->relative.have_weekday_relative == 0) {
				TIMELIB_HAVE_WEEKDAY_RELATIVE();
				s->time->relative.weekday = 1;
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 22506 "<stdout>"
yy1173:
	YYDEBUG(1173, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1235;
	if (yych == 'o') goto yy1235;
	goto yy59;
yy1174:
	YYDEBUG(1174, *YYCURSOR);
	++YYCURSOR;
yy1175:
	YYDEBUG(1175, *YYCURSOR);
#line 1156 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("yesterday");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = -1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 22529 "<stdout>"
yy1176:
	YYDEBUG(1176, *YYCURSOR);
	yyaccept = 31;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy954;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy297;
		goto yy1175;
	} else {
		if (yych <= '/') goto yy297;
		if (yych == '_') goto yy297;
		goto yy1175;
	}
yy1177:
	YYDEBUG(1177, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy1187;
	goto yy59;
yy1178:
	YYDEBUG(1178, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '1') goto yy1187;
	goto yy59;
yy1179:
	YYDEBUG(1179, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '2') goto yy1236;
	if (yych <= '3') goto yy1237;
	goto yy59;
yy1180:
	YYDEBUG(1180, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych == '-') goto yy893;
		if (yych <= '/') goto yy196;
		goto yy1238;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy196;
			goto yy97;
		} else {
			if (yych == 0xE2) goto yy98;
			goto yy196;
		}
	}
yy1181:
	YYDEBUG(1181, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1239;
	goto yy59;
yy1182:
	YYDEBUG(1182, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy1184;
	if (yych <= ':') goto yy1240;
	goto yy59;
yy1183:
	YYDEBUG(1183, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '4') goto yy1184;
	if (yych == ':') goto yy1240;
	goto yy59;
yy1184:
	YYDEBUG(1184, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1240;
	goto yy59;
yy1185:
	YYDEBUG(1185, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'T') goto yy1115;
	goto yy567;
yy1186:
	YYDEBUG(1186, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy1241;
		if (yych <= 'm') goto yy1043;
		goto yy1116;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy1043;
			goto yy1116;
		} else {
			if (yych <= 's') goto yy1117;
			if (yych <= 't') goto yy1118;
			goto yy1043;
		}
	}
yy1187:
	YYDEBUG(1187, *YYCURSOR);
	++YYCURSOR;
	goto yy1043;
yy1188:
	YYDEBUG(1188, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy1187;
		if (yych <= 'm') goto yy1043;
		goto yy1121;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy1043;
			goto yy1121;
		} else {
			if (yych <= 's') goto yy1122;
			if (yych <= 't') goto yy1123;
			goto yy1043;
		}
	}
yy1189:
	YYDEBUG(1189, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy196;
		if (yych <= '9') goto yy1242;
		goto yy196;
	} else {
		if (yych <= 0xC2) goto yy97;
		if (yych == 0xE2) goto yy98;
		goto yy196;
	}
yy1190:
	YYDEBUG(1190, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '5') goto yy1243;
	if (yych <= '9') goto yy1192;
	if (yych <= ':') goto yy1244;
	goto yy59;
yy1191:
	YYDEBUG(1191, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy59;
		if (yych <= '4') goto yy1243;
		goto yy1245;
	} else {
		if (yych == ':') goto yy1244;
		goto yy59;
	}
yy1192:
	YYDEBUG(1192, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '5') goto yy1245;
	if (yych == ':') goto yy1244;
	goto yy59;
yy1193:
	YYDEBUG(1193, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '5') goto yy1246;
	if (yych <= '9') goto yy1195;
	goto yy59;
yy1194:
	YYDEBUG(1194, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '4') goto yy1246;
	if (yych <= '5') goto yy1245;
	goto yy59;
yy1195:
	YYDEBUG(1195, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '5') goto yy1245;
	goto yy59;
yy1196:
	YYDEBUG(1196, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ' ') goto yy1247;
	goto yy59;
yy1197:
	YYDEBUG(1197, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy790;
	if (yych == 'y') goto yy790;
	goto yy59;
yy1198:
	YYDEBUG(1198, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy790;
	if (yych == 'r') goto yy790;
	goto yy59;
yy1199:
	YYDEBUG(1199, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == '.') goto yy1248;
		goto yy59;
	} else {
		if (yych <= 'M') goto yy1249;
		if (yych == 'm') goto yy1249;
		goto yy59;
	}
yy1200:
	YYDEBUG(1200, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1070;
	if (yych <= '9') goto yy1250;
	goto yy1070;
yy1201:
	YYDEBUG(1201, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(1202, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1201;
			goto yy59;
		} else {
			if (yych <= ' ') goto yy1201;
			if (yych <= '@') goto yy59;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy59;
		} else {
			if (yych <= 'a') goto yy1203;
			if (yych != 'p') goto yy59;
		}
	}
yy1203:
	YYDEBUG(1203, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == '.') goto yy1251;
		goto yy59;
	} else {
		if (yych <= 'M') goto yy1252;
		if (yych == 'm') goto yy1252;
		goto yy59;
	}
yy1204:
	YYDEBUG(1204, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xA0) goto yy1253;
	goto yy59;
yy1205:
	YYDEBUG(1205, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0x80) goto yy1254;
	goto yy59;
yy1206:
	YYDEBUG(1206, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == 'D') goto yy856;
		if (yych <= 'R') goto yy59;
		goto yy1155;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy59;
			goto yy856;
		} else {
			if (yych == 's') goto yy1155;
			goto yy59;
		}
	}
yy1207:
	YYDEBUG(1207, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy1208:
	YYDEBUG(1208, *YYCURSOR);
	if (yych <= '+') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1207;
			if (yych <= 0x1F) goto yy59;
			goto yy1207;
		} else {
			if (yych == '(') goto yy1209;
			if (yych <= '*') goto yy59;
			goto yy1210;
		}
	} else {
		if (yych <= 'F') {
			if (yych == '-') goto yy1210;
			if (yych <= '@') goto yy59;
			goto yy1211;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'G') goto yy1212;
				goto yy1211;
			} else {
				if (yych <= '`') goto yy59;
				if (yych <= 'z') goto yy1213;
				goto yy59;
			}
		}
	}
yy1209:
	YYDEBUG(1209, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy59;
	if (yych <= 'Z') goto yy1213;
	if (yych <= '`') goto yy59;
	if (yych <= 'z') goto yy1213;
	goto yy59;
yy1210:
	YYDEBUG(1210, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '1') goto yy1255;
	if (yych <= '2') goto yy1256;
	if (yych <= '9') goto yy1257;
	goto yy59;
yy1211:
	YYDEBUG(1211, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy1078;
		goto yy849;
	} else {
		if (yych <= 'Z') goto yy1258;
		if (yych <= '`') goto yy849;
		if (yych <= 'z') goto yy1259;
		goto yy849;
	}
yy1212:
	YYDEBUG(1212, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == ')') goto yy1078;
		if (yych <= '@') goto yy849;
		goto yy1258;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'M') goto yy1260;
			goto yy1258;
		} else {
			if (yych <= '`') goto yy849;
			if (yych <= 'z') goto yy1259;
			goto yy849;
		}
	}
yy1213:
	YYDEBUG(1213, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy1078;
		goto yy849;
	} else {
		if (yych <= 'Z') goto yy1258;
		if (yych <= '`') goto yy849;
		if (yych <= 'z') goto yy1258;
		goto yy849;
	}
yy1214:
	YYDEBUG(1214, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xA0) goto yy1261;
	goto yy59;
yy1215:
	YYDEBUG(1215, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0x80) goto yy1262;
	goto yy59;
yy1216:
	YYDEBUG(1216, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy1217:
	YYDEBUG(1217, *YYCURSOR);
	if (yych <= '@') {
		if (yych <= '\'') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy59;
				goto yy1216;
			} else {
				if (yych == ' ') goto yy1216;
				goto yy59;
			}
		} else {
			if (yych <= '+') {
				if (yych <= '(') goto yy1209;
				if (yych <= '*') goto yy59;
				goto yy1210;
			} else {
				if (yych == '-') goto yy1210;
				goto yy59;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= 'G') {
				if (yych <= 'A') goto yy1218;
				if (yych <= 'F') goto yy1211;
				goto yy1212;
			} else {
				if (yych != 'P') goto yy1211;
			}
		} else {
			if (yych <= 'o') {
				if (yych <= '`') goto yy59;
				if (yych <= 'a') goto yy1219;
				goto yy1213;
			} else {
				if (yych <= 'p') goto yy1219;
				if (yych <= 'z') goto yy1213;
				goto yy59;
			}
		}
	}
yy1218:
	YYDEBUG(1218, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy1078;
			goto yy849;
		} else {
			if (yych <= '.') goto yy1151;
			if (yych <= '@') goto yy849;
			goto yy1258;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy1263;
			if (yych <= 'Z') goto yy1258;
			goto yy849;
		} else {
			if (yych == 'm') goto yy1264;
			if (yych <= 'z') goto yy1259;
			goto yy849;
		}
	}
yy1219:
	YYDEBUG(1219, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy1078;
			goto yy849;
		} else {
			if (yych <= '.') goto yy1151;
			if (yych <= '@') goto yy849;
			goto yy1258;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy1263;
			if (yych <= 'Z') goto yy1258;
			goto yy849;
		} else {
			if (yych == 'm') goto yy1263;
			if (yych <= 'z') goto yy1258;
			goto yy849;
		}
	}
yy1220:
	YYDEBUG(1220, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xA0) goto yy1265;
	goto yy59;
yy1221:
	YYDEBUG(1221, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0x80) goto yy1266;
	goto yy59;
yy1222:
	YYDEBUG(1222, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1223, *YYCURSOR);
#line 1904 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("dateshortwithtimeshort12 | dateshortwithtimelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month(&ptr);
		s->time->d = timelib_get_nr(&ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr(&ptr, 2);
		s->time->i = timelib_get_nr(&ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr(&ptr, 2);

			if (*ptr == '.') {
				s->time->us = timelib_get_frac_nr(&ptr);
			}
		}

		s->time->h += timelib_meridian(&ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
#line 23045 "<stdout>"
yy1224:
	YYDEBUG(1224, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy1222;
		if (yych <= 0x08) goto yy59;
		goto yy1222;
	} else {
		if (yych == ' ') goto yy1222;
		goto yy59;
	}
yy1225:
	YYDEBUG(1225, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= '`') {
		if (yych <= 'A') {
			if (yych <= '@') goto yy59;
			goto yy1083;
		} else {
			if (yych == 'P') goto yy1083;
			goto yy59;
		}
	} else {
		if (yych <= 'p') {
			if (yych <= 'a') goto yy1083;
			if (yych <= 'o') goto yy59;
			goto yy1083;
		} else {
			if (yych == 0xE2) goto yy1085;
			goto yy59;
		}
	}
yy1226:
	YYDEBUG(1226, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1227;
	if (yych != 'n') goto yy59;
yy1227:
	YYDEBUG(1227, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1267;
	if (yych == 'i') goto yy1267;
	goto yy59;
yy1228:
	YYDEBUG(1228, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1268;
	if (yych == 'f') goto yy1268;
	goto yy59;
yy1229:
	YYDEBUG(1229, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1270;
	if (yych == 'y') goto yy1270;
	goto yy59;
yy1230:
	YYDEBUG(1230, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	if (yych <= 'n') {
		if (yych == 'O') goto yy1228;
		goto yy59;
	} else {
		if (yych <= 'o') goto yy1228;
		if (yych == 0xC2) goto yy1160;
		goto yy59;
	}
yy1231:
	YYDEBUG(1231, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xAF) goto yy1271;
	goto yy59;
yy1232:
	YYDEBUG(1232, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1272;
	if (yych == 's') goto yy1272;
	goto yy59;
yy1233:
	YYDEBUG(1233, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1086;
	if (yych == 'e') goto yy1086;
	goto yy59;
yy1234:
	YYDEBUG(1234, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1086;
	if (yych == 'd') goto yy1086;
	goto yy59;
yy1235:
	YYDEBUG(1235, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1273;
	if (yych == 'f') goto yy1273;
	goto yy59;
yy1236:
	YYDEBUG(1236, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy1275;
	goto yy59;
yy1237:
	YYDEBUG(1237, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '1') goto yy1275;
	goto yy59;
yy1238:
	YYDEBUG(1238, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych == '-') goto yy893;
		if (yych <= '/') goto yy196;
		goto yy1277;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy196;
			goto yy97;
		} else {
			if (yych == 0xE2) goto yy98;
			goto yy196;
		}
	}
yy1239:
	YYDEBUG(1239, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '1') goto yy1278;
	if (yych <= '2') goto yy1279;
	goto yy59;
yy1240:
	YYDEBUG(1240, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '5') goto yy1280;
	if (yych <= '9') goto yy1281;
	goto yy59;
yy1241:
	YYDEBUG(1241, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '1') goto yy1282;
	if (yych <= '2') goto yy1283;
	if (yych <= '9') goto yy1184;
	goto yy59;
yy1242:
	YYDEBUG(1242, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy196;
		if (yych <= '9') goto yy1284;
		goto yy196;
	} else {
		if (yych <= 0xC2) goto yy97;
		if (yych == 0xE2) goto yy98;
		goto yy196;
	}
yy1243:
	YYDEBUG(1243, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '5') goto yy1285;
	if (yych <= '9') goto yy1286;
	if (yych >= ';') goto yy59;
yy1244:
	YYDEBUG(1244, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '5') goto yy1287;
	goto yy59;
yy1245:
	YYDEBUG(1245, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy1286;
	goto yy59;
yy1246:
	YYDEBUG(1246, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '5') goto yy1285;
	if (yych <= '9') goto yy1286;
	goto yy59;
yy1247:
	YYDEBUG(1247, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '1') goto yy1288;
	if (yych <= '2') goto yy1289;
	goto yy59;
yy1248:
	YYDEBUG(1248, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1249;
	if (yych != 'm') goto yy59;
yy1249:
	YYDEBUG(1249, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy1290;
		if (yych == '\t') goto yy1290;
		goto yy59;
	} else {
		if (yych <= ' ') goto yy1290;
		if (yych == '.') goto yy1292;
		goto yy59;
	}
yy1250:
	YYDEBUG(1250, *YYCURSOR);
	++YYCURSOR;
	goto yy1070;
yy1251:
	YYDEBUG(1251, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1252;
	if (yych != 'm') goto yy59;
yy1252:
	YYDEBUG(1252, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy1293;
		if (yych == '\t') goto yy1293;
		goto yy59;
	} else {
		if (yych <= ' ') goto yy1293;
		if (yych == '.') goto yy1294;
		goto yy59;
	}
yy1253:
	YYDEBUG(1253, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= '`') {
		if (yych <= 'A') {
			if (yych <= '@') goto yy59;
			goto yy1203;
		} else {
			if (yych == 'P') goto yy1203;
			goto yy59;
		}
	} else {
		if (yych <= 'p') {
			if (yych <= 'a') goto yy1203;
			if (yych <= 'o') goto yy59;
			goto yy1203;
		} else {
			if (yych == 0xC2) goto yy1204;
			goto yy59;
		}
	}
yy1254:
	YYDEBUG(1254, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xAF) goto yy1295;
	goto yy59;
yy1255:
	YYDEBUG(1255, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy849;
	if (yych <= '9') goto yy1296;
	if (yych <= ':') goto yy1297;
	goto yy849;
yy1256:
	YYDEBUG(1256, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '5') {
		if (yych <= '/') goto yy849;
		if (yych <= '4') goto yy1296;
		goto yy1298;
	} else {
		if (yych <= '9') goto yy1078;
		if (yych <= ':') goto yy1297;
		goto yy849;
	}
yy1257:
	YYDEBUG(1257, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy849;
	if (yych <= '5') goto yy1298;
	if (yych <= '9') goto yy1078;
	if (yych <= ':') goto yy1297;
	goto yy849;
yy1258:
	YYDEBUG(1258, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy1078;
		goto yy849;
	} else {
		if (yych <= 'Z') goto yy1299;
		if (yych <= '`') goto yy849;
		if (yych <= 'z') goto yy1299;
		goto yy849;
	}
yy1259:
	YYDEBUG(1259, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy1078;
			goto yy849;
		} else {
			if (yych == '.') goto yy849;
			goto yy1300;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy849;
			if (yych <= 'Z') goto yy1299;
			goto yy849;
		} else {
			if (yych <= '_') goto yy1300;
			if (yych <= '`') goto yy849;
			if (yych <= 'z') goto yy1301;
			goto yy849;
		}
	}
yy1260:
	YYDEBUG(1260, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == ')') goto yy1078;
		if (yych <= '@') goto yy849;
		goto yy1299;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'T') goto yy1302;
			goto yy1299;
		} else {
			if (yych <= '`') goto yy849;
			if (yych <= 'z') goto yy1299;
			goto yy849;
		}
	}
yy1261:
	YYDEBUG(1261, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
	if (yych <= '@') {
		if (yych <= '*') {
			if (yych == '(') goto yy1209;
			goto yy59;
		} else {
			if (yych == ',') goto yy59;
			if (yych <= '-') goto yy1210;
			goto yy59;
		}
	} else {
		if (yych <= '`') {
			if (yych == 'G') goto yy1212;
			if (yych <= 'Z') goto yy1211;
			goto yy59;
		} else {
			if (yych <= 'z') goto yy1213;
			if (yych == 0xC2) goto yy1214;
			goto yy59;
		}
	}
yy1262:
	YYDEBUG(1262, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xAF) goto yy1303;
	goto yy59;
yy1263:
	YYDEBUG(1263, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych <= '\t') {
			if (yych <= 0x00) goto yy1222;
			if (yych <= 0x08) goto yy849;
			goto yy1222;
		} else {
			if (yych == ' ') goto yy1222;
			if (yych <= '(') goto yy849;
			goto yy1078;
		}
	} else {
		if (yych <= '@') {
			if (yych == '.') goto yy1224;
			goto yy849;
		} else {
			if (yych <= 'Z') goto yy1299;
			if (yych <= '`') goto yy849;
			if (yych <= 'z') goto yy1299;
			goto yy849;
		}
	}
yy1264:
	YYDEBUG(1264, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych <= 0x00) goto yy1222;
			if (yych == '\t') goto yy1222;
			goto yy849;
		} else {
			if (yych <= '(') {
				if (yych <= ' ') goto yy1222;
				goto yy849;
			} else {
				if (yych <= ')') goto yy1078;
				if (yych <= ',') goto yy849;
				goto yy1300;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '.') goto yy1224;
			if (yych <= '/') goto yy1300;
			if (yych <= '@') goto yy849;
			goto yy1299;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy849;
				goto yy1300;
			} else {
				if (yych <= '`') goto yy849;
				if (yych <= 'z') goto yy1301;
				goto yy849;
			}
		}
	}
yy1265:
	YYDEBUG(1265, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych <= '(') {
				if (yych <= '\'') goto yy59;
				goto yy1209;
			} else {
				if (yych == '+') goto yy1210;
				goto yy59;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '-') goto yy1210;
				goto yy59;
			} else {
				if (yych <= 'A') goto yy1218;
				if (yych <= 'F') goto yy1211;
				goto yy1212;
			}
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'P') {
				if (yych <= 'O') goto yy1211;
				goto yy1218;
			} else {
				if (yych <= 'Z') goto yy1211;
				if (yych <= '`') goto yy59;
				goto yy1219;
			}
		} else {
			if (yych <= 'z') {
				if (yych == 'p') goto yy1219;
				goto yy1213;
			} else {
				if (yych == 0xC2) goto yy1220;
				goto yy59;
			}
		}
	}
yy1266:
	YYDEBUG(1266, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xAF) goto yy1304;
	goto yy59;
yy1267:
	YYDEBUG(1267, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1305;
	if (yych == 'g') goto yy1305;
	goto yy59;
yy1268:
	YYDEBUG(1268, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1269, *YYCURSOR);
#line 1317 "ext/date/lib/parse_date.re"
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("weekdayof");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_SPECIAL_RELATIVE();

		i = timelib_get_relative_text(&ptr, &behavior);
		timelib_eat_spaces(&ptr);
		if (i > 0) { /* first, second... etc */
			s->time->relative.special.type = TIMELIB_SPECIAL_DAY_OF_WEEK_IN_MONTH;
			timelib_set_relative(&ptr, i, 1, s, TIMELIB_TIME_PART_DONT_KEEP);
		} else { /* last */
			s->time->relative.special.type = TIMELIB_SPECIAL_LAST_DAY_OF_WEEK_IN_MONTH;
			timelib_set_relative(&ptr, i, behavior, s, TIMELIB_TIME_PART_DONT_KEEP);
		}
		TIMELIB_DEINIT;
		return TIMELIB_WEEK_DAY_OF_MONTH;
	}
#line 23568 "<stdout>"
yy1270:
	YYDEBUG(1270, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1157;
			goto yy982;
		} else {
			if (yych <= ' ') goto yy1157;
			if (yych <= 'R') goto yy982;
			goto yy1306;
		}
	} else {
		if (yych <= 0xC1) {
			if (yych == 's') goto yy1306;
			goto yy982;
		} else {
			if (yych <= 0xC2) goto yy1160;
			if (yych == 0xE2) goto yy1161;
			goto yy982;
		}
	}
yy1271:
	YYDEBUG(1271, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	if (yych <= 'n') {
		if (yych == 'O') goto yy1228;
		goto yy59;
	} else {
		if (yych <= 'o') goto yy1228;
		if (yych == 0xE2) goto yy1161;
		goto yy59;
	}
yy1272:
	YYDEBUG(1272, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1307;
	if (yych == 'e') goto yy1307;
	goto yy59;
yy1273:
	YYDEBUG(1273, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1274, *YYCURSOR);
#line 1277 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("firstdayof | lastdayof");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		/* skip "last day of" or "first day of" */
		if (*ptr == 'l' || *ptr == 'L') {
			s->time->relative.first_last_day_of = TIMELIB_SPECIAL_LAST_DAY_OF_MONTH;
		} else {
			s->time->relative.first_last_day_of = TIMELIB_SPECIAL_FIRST_DAY_OF_MONTH;
		}

		TIMELIB_DEINIT;
		return TIMELIB_LF_DAY_OF_MONTH;
	}
#line 23631 "<stdout>"
yy1275:
	YYDEBUG(1275, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1276, *YYCURSOR);
#line 1513 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("iso8601datex");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_signed_nr(s, &ptr, 19);
		s->time->m = timelib_get_nr(&ptr, 2);
		s->time->d = timelib_get_nr(&ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 23647 "<stdout>"
yy1277:
	YYDEBUG(1277, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych == '-') goto yy893;
		if (yych <= '/') goto yy196;
		goto yy1308;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy196;
			goto yy97;
		} else {
			if (yych == 0xE2) goto yy98;
			goto yy196;
		}
	}
yy1278:
	YYDEBUG(1278, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy1309;
	goto yy59;
yy1279:
	YYDEBUG(1279, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '4') goto yy1309;
	goto yy59;
yy1280:
	YYDEBUG(1280, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy1281;
	if (yych <= ':') goto yy1310;
	goto yy59;
yy1281:
	YYDEBUG(1281, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1310;
	goto yy59;
yy1282:
	YYDEBUG(1282, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy1311;
	if (yych <= ':') goto yy1240;
	goto yy59;
yy1283:
	YYDEBUG(1283, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '4') goto yy1311;
	if (yych == ':') goto yy1240;
	goto yy59;
yy1284:
	YYDEBUG(1284, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy196;
		if (yych <= '9') goto yy1312;
		goto yy196;
	} else {
		if (yych <= 0xC2) goto yy97;
		if (yych == 0xE2) goto yy98;
		goto yy196;
	}
yy1285:
	YYDEBUG(1285, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '5') goto yy1310;
	if (yych <= '6') goto yy1313;
	if (yych >= ':') goto yy59;
yy1286:
	YYDEBUG(1286, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '5') goto yy1314;
	if (yych <= '6') goto yy1315;
	goto yy59;
yy1287:
	YYDEBUG(1287, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy1316;
	goto yy59;
yy1288:
	YYDEBUG(1288, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy1317;
	goto yy59;
yy1289:
	YYDEBUG(1289, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '4') goto yy1317;
	goto yy59;
yy1290:
	YYDEBUG(1290, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1291, *YYCURSOR);
#line 1357 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("mssqltime");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr(&ptr, 2);
		s->time->i = timelib_get_nr(&ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr(&ptr, 2);

			if (*ptr == ':' || *ptr == '.') {
				s->time->us = timelib_get_frac_nr(&ptr);
			}
		}
		timelib_eat_spaces(&ptr);
		s->time->h += timelib_meridian(&ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
#line 23769 "<stdout>"
yy1292:
	YYDEBUG(1292, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy1290;
		if (yych <= 0x08) goto yy59;
		goto yy1290;
	} else {
		if (yych == ' ') goto yy1290;
		goto yy59;
	}
yy1293:
	YYDEBUG(1293, *YYCURSOR);
	++YYCURSOR;
	goto yy1145;
yy1294:
	YYDEBUG(1294, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy1293;
		if (yych <= 0x08) goto yy59;
		goto yy1293;
	} else {
		if (yych == ' ') goto yy1293;
		goto yy59;
	}
yy1295:
	YYDEBUG(1295, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= '`') {
		if (yych <= 'A') {
			if (yych <= '@') goto yy59;
			goto yy1203;
		} else {
			if (yych == 'P') goto yy1203;
			goto yy59;
		}
	} else {
		if (yych <= 'p') {
			if (yych <= 'a') goto yy1203;
			if (yych <= 'o') goto yy59;
			goto yy1203;
		} else {
			if (yych == 0xE2) goto yy1205;
			goto yy59;
		}
	}
yy1296:
	YYDEBUG(1296, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy849;
	if (yych <= '5') goto yy1318;
	if (yych <= '9') goto yy1078;
	if (yych <= ':') goto yy1319;
	goto yy849;
yy1297:
	YYDEBUG(1297, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '5') goto yy1298;
	if (yych <= '9') goto yy1078;
	goto yy59;
yy1298:
	YYDEBUG(1298, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy849;
	if (yych <= '9') goto yy1078;
	goto yy849;
yy1299:
	YYDEBUG(1299, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy1078;
		goto yy849;
	} else {
		if (yych <= 'Z') goto yy1320;
		if (yych <= '`') goto yy849;
		if (yych <= 'z') goto yy1320;
		goto yy849;
	}
yy1300:
	YYDEBUG(1300, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '@') goto yy59;
	if (yych <= 'Z') goto yy1321;
	if (yych <= '`') goto yy59;
	if (yych <= 'z') goto yy1321;
	goto yy59;
yy1301:
	YYDEBUG(1301, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy1078;
			goto yy849;
		} else {
			if (yych == '.') goto yy849;
			goto yy1300;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy849;
			if (yych <= 'Z') goto yy1320;
			goto yy849;
		} else {
			if (yych <= '_') goto yy1300;
			if (yych <= '`') goto yy849;
			if (yych <= 'z') goto yy1323;
			goto yy849;
		}
	}
yy1302:
	YYDEBUG(1302, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ')') {
			if (yych <= '(') goto yy849;
			goto yy1078;
		} else {
			if (yych == '+') goto yy1210;
			goto yy849;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '-') goto yy1210;
			if (yych <= '@') goto yy849;
			goto yy1320;
		} else {
			if (yych <= '`') goto yy849;
			if (yych <= 'z') goto yy1320;
			goto yy849;
		}
	}
yy1303:
	YYDEBUG(1303, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
	if (yych <= '@') {
		if (yych <= '*') {
			if (yych == '(') goto yy1209;
			goto yy59;
		} else {
			if (yych == ',') goto yy59;
			if (yych <= '-') goto yy1210;
			goto yy59;
		}
	} else {
		if (yych <= '`') {
			if (yych == 'G') goto yy1212;
			if (yych <= 'Z') goto yy1211;
			goto yy59;
		} else {
			if (yych <= 'z') goto yy1213;
			if (yych == 0xE2) goto yy1215;
			goto yy59;
		}
	}
yy1304:
	YYDEBUG(1304, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych <= '(') {
				if (yych <= '\'') goto yy59;
				goto yy1209;
			} else {
				if (yych == '+') goto yy1210;
				goto yy59;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '-') goto yy1210;
				goto yy59;
			} else {
				if (yych <= 'A') goto yy1218;
				if (yych <= 'F') goto yy1211;
				goto yy1212;
			}
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'P') {
				if (yych <= 'O') goto yy1211;
				goto yy1218;
			} else {
				if (yych <= 'Z') goto yy1211;
				if (yych <= '`') goto yy59;
				goto yy1219;
			}
		} else {
			if (yych <= 'z') {
				if (yych == 'p') goto yy1219;
				goto yy1213;
			} else {
				if (yych == 0xE2) goto yy1221;
				goto yy59;
			}
		}
	}
yy1305:
	YYDEBUG(1305, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1324;
	if (yych == 'h') goto yy1324;
	goto yy59;
yy1306:
	YYDEBUG(1306, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1157;
		if (yych <= 0x1F) goto yy982;
		goto yy1157;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy982;
			goto yy1160;
		} else {
			if (yych == 0xE2) goto yy1161;
			goto yy982;
		}
	}
yy1307:
	YYDEBUG(1307, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1325;
	if (yych == 'c') goto yy1325;
	goto yy59;
yy1308:
	YYDEBUG(1308, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych == '-') goto yy893;
		if (yych <= '/') goto yy196;
		goto yy1326;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy196;
			goto yy97;
		} else {
			if (yych == 0xE2) goto yy98;
			goto yy196;
		}
	}
yy1309:
	YYDEBUG(1309, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1327;
	goto yy59;
yy1310:
	YYDEBUG(1310, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '5') goto yy1328;
	if (yych <= '6') goto yy1330;
	if (yych <= '9') goto yy1331;
	goto yy59;
yy1311:
	YYDEBUG(1311, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1332;
	goto yy59;
yy1312:
	YYDEBUG(1312, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 0xC2) goto yy97;
	if (yych == 0xE2) goto yy98;
	goto yy196;
yy1313:
	YYDEBUG(1313, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '0') goto yy1328;
	if (yych <= '5') goto yy1314;
	if (yych <= '6') goto yy1315;
	goto yy59;
yy1314:
	YYDEBUG(1314, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy1331;
	goto yy59;
yy1315:
	YYDEBUG(1315, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1331;
	goto yy59;
yy1316:
	YYDEBUG(1316, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1286;
	goto yy59;
yy1317:
	YYDEBUG(1317, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1244;
	goto yy59;
yy1318:
	YYDEBUG(1318, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy849;
	if (yych <= '9') goto yy1333;
	goto yy849;
yy1319:
	YYDEBUG(1319, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '5') goto yy1334;
	if (yych <= '9') goto yy1078;
	goto yy59;
yy1320:
	YYDEBUG(1320, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy1078;
		goto yy849;
	} else {
		if (yych <= 'Z') goto yy1335;
		if (yych <= '`') goto yy849;
		if (yych <= 'z') goto yy1335;
		goto yy849;
	}
yy1321:
	YYDEBUG(1321, *YYCURSOR);
	yyaccept = 20;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(1322, *YYCURSOR);
	if (yych <= '@') {
		if (yych <= '-') {
			if (yych <= ',') goto yy849;
			goto yy1300;
		} else {
			if (yych == '/') goto yy1300;
			goto yy849;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy1321;
			if (yych <= '^') goto yy849;
			goto yy1300;
		} else {
			if (yych <= '`') goto yy849;
			if (yych <= 'z') goto yy1321;
			goto yy849;
		}
	}
yy1323:
	YYDEBUG(1323, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy1078;
			goto yy849;
		} else {
			if (yych == '.') goto yy849;
			goto yy1300;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy849;
			if (yych <= 'Z') goto yy1335;
			goto yy849;
		} else {
			if (yych <= '_') goto yy1300;
			if (yych <= '`') goto yy849;
			if (yych <= 'z') goto yy1336;
			goto yy849;
		}
	}
yy1324:
	YYDEBUG(1324, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1086;
	if (yych == 't') goto yy1086;
	goto yy59;
yy1325:
	YYDEBUG(1325, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1167;
	if (yych == 'o') goto yy1167;
	goto yy59;
yy1326:
	YYDEBUG(1326, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych == '-') goto yy893;
		if (yych <= '/') goto yy196;
		goto yy1337;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy196;
			goto yy97;
		} else {
			if (yych == 0xE2) goto yy98;
			goto yy196;
		}
	}
yy1327:
	YYDEBUG(1327, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '5') goto yy1338;
	goto yy59;
yy1328:
	YYDEBUG(1328, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1329;
	if (yych <= '9') goto yy1331;
yy1329:
	YYDEBUG(1329, *YYCURSOR);
#line 1660 "ext/date/lib/parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("xmlrpc | xmlrpcnocolon | soap | wddx | exif");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr(&ptr, 4);
		s->time->m = timelib_get_nr(&ptr, 2);
		s->time->d = timelib_get_nr(&ptr, 2);
		s->time->h = timelib_get_nr(&ptr, 2);
		s->time->i = timelib_get_nr(&ptr, 2);
		s->time->s = timelib_get_nr(&ptr, 2);
		if (*ptr == '.') {
			s->time->us = timelib_get_frac_nr(&ptr);
			if (*ptr) { /* timezone is optional */
				s->time->z = timelib_parse_zone(&ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
				if (tz_not_found) {
					add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
				}
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_XMLRPC_SOAP;
	}
#line 24218 "<stdout>"
yy1330:
	YYDEBUG(1330, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy1329;
yy1331:
	YYDEBUG(1331, *YYCURSOR);
	++YYCURSOR;
	goto yy1329;
yy1332:
	YYDEBUG(1332, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '5') goto yy1339;
	if (yych <= '9') goto yy1281;
	goto yy59;
yy1333:
	YYDEBUG(1333, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy849;
	if (yych <= '5') goto yy1340;
	if (yych <= '6') goto yy1341;
	goto yy849;
yy1334:
	YYDEBUG(1334, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy849;
	if (yych <= '9') goto yy1342;
	goto yy849;
yy1335:
	YYDEBUG(1335, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy1078;
		goto yy849;
	} else {
		if (yych <= 'Z') goto yy1343;
		if (yych <= '`') goto yy849;
		if (yych <= 'z') goto yy1343;
		goto yy849;
	}
yy1336:
	YYDEBUG(1336, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy1078;
			goto yy849;
		} else {
			if (yych == '.') goto yy849;
			goto yy1300;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy849;
			if (yych <= 'Z') goto yy1343;
			goto yy849;
		} else {
			if (yych <= '_') goto yy1300;
			if (yych <= '`') goto yy849;
			if (yych <= 'z') goto yy1344;
			goto yy849;
		}
	}
yy1337:
	YYDEBUG(1337, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy893;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy1345;
	goto yy59;
yy1338:
	YYDEBUG(1338, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy1346;
	goto yy59;
yy1339:
	YYDEBUG(1339, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy1347;
	if (yych <= ':') goto yy1310;
	goto yy59;
yy1340:
	YYDEBUG(1340, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy1078;
	goto yy59;
yy1341:
	YYDEBUG(1341, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1078;
	goto yy59;
yy1342:
	YYDEBUG(1342, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == ':') goto yy1348;
	goto yy849;
yy1343:
	YYDEBUG(1343, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy1078;
	goto yy849;
yy1344:
	YYDEBUG(1344, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ')') {
			if (yych <= '(') goto yy849;
			goto yy1078;
		} else {
			if (yych == '-') goto yy1300;
			goto yy849;
		}
	} else {
		if (yych <= '_') {
			if (yych <= '/') goto yy1300;
			if (yych <= '^') goto yy849;
			goto yy1300;
		} else {
			if (yych <= '`') goto yy849;
			if (yych <= 'z') goto yy1349;
			goto yy849;
		}
	}
yy1345:
	YYDEBUG(1345, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy893;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy1351;
	goto yy59;
yy1346:
	YYDEBUG(1346, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1352;
	goto yy59;
yy1347:
	YYDEBUG(1347, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1353;
	goto yy59;
yy1348:
	YYDEBUG(1348, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '5') goto yy1340;
	if (yych <= '6') goto yy1341;
	goto yy59;
yy1349:
	YYDEBUG(1349, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(1350, *YYCURSOR);
	if (yych <= '/') {
		if (yych == '-') goto yy1300;
		if (yych <= '.') goto yy59;
		goto yy1300;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy59;
			goto yy1300;
		} else {
			if (yych <= '`') goto yy59;
			if (yych <= 'z') goto yy1349;
			goto yy59;
		}
	}
yy1351:
	YYDEBUG(1351, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy893;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy1354;
	goto yy59;
yy1352:
	YYDEBUG(1352, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '5') goto yy1355;
	if (yych <= '6') goto yy1356;
	goto yy59;
yy1353:
	YYDEBUG(1353, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '5') goto yy1357;
	if (yych <= '6') goto yy1358;
	if (yych <= '9') goto yy1331;
	goto yy59;
yy1354:
	YYDEBUG(1354, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy893;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy1359;
	goto yy59;
yy1355:
	YYDEBUG(1355, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy1360;
	goto yy59;
yy1356:
	YYDEBUG(1356, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1360;
	goto yy59;
yy1357:
	YYDEBUG(1357, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1329;
	if (yych <= '9') goto yy1361;
	goto yy1329;
yy1358:
	YYDEBUG(1358, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1361;
	goto yy1329;
yy1359:
	YYDEBUG(1359, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy893;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy1362;
	goto yy59;
yy1360:
	YYDEBUG(1360, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ' ') {
		if (yych == '\t') goto yy1363;
		if (yych <= 0x1F) goto yy59;
		goto yy1363;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy59;
			goto yy1365;
		} else {
			if (yych == 0xE2) goto yy1366;
			goto yy59;
		}
	}
yy1361:
	YYDEBUG(1361, *YYCURSOR);
	yyaccept = 32;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy1367;
	goto yy1329;
yy1362:
	YYDEBUG(1362, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy893;
	goto yy59;
yy1363:
	YYDEBUG(1363, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
	YYDEBUG(1364, *YYCURSOR);
	if (yych <= '*') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy59;
			goto yy1363;
		} else {
			if (yych == ' ') goto yy1363;
			goto yy59;
		}
	} else {
		if (yych <= '-') {
			if (yych == ',') goto yy59;
			goto yy1368;
		} else {
			if (yych == 'G') goto yy1369;
			goto yy59;
		}
	}
yy1365:
	YYDEBUG(1365, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xA0) goto yy1370;
	goto yy59;
yy1366:
	YYDEBUG(1366, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0x80) goto yy1371;
	goto yy59;
yy1367:
	YYDEBUG(1367, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy1372;
	goto yy59;
yy1368:
	YYDEBUG(1368, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '1') goto yy1374;
	if (yych <= '2') goto yy1376;
	if (yych <= '9') goto yy1377;
	goto yy59;
yy1369:
	YYDEBUG(1369, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1378;
	goto yy59;
yy1370:
	YYDEBUG(1370, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
	if (yych <= '-') {
		if (yych == '+') goto yy1368;
		if (yych <= ',') goto yy59;
		goto yy1368;
	} else {
		if (yych <= 'G') {
			if (yych <= 'F') goto yy59;
			goto yy1369;
		} else {
			if (yych == 0xC2) goto yy1365;
			goto yy59;
		}
	}
yy1371:
	YYDEBUG(1371, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xAF) goto yy1379;
	goto yy59;
yy1372:
	YYDEBUG(1372, *YYCURSOR);
	yyaccept = 32;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
	YYDEBUG(1373, *YYCURSOR);
	if (yych <= '-') {
		if (yych == '+') goto yy1380;
		if (yych <= ',') goto yy1329;
		goto yy1380;
	} else {
		if (yych <= '9') {
			if (yych <= '/') goto yy1329;
			goto yy1372;
		} else {
			if (yych == 'G') goto yy1381;
			goto yy1329;
		}
	}
yy1374:
	YYDEBUG(1374, *YYCURSOR);
	yyaccept = 33;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1375;
	if (yych <= '9') goto yy1382;
	if (yych <= ':') goto yy1383;
yy1375:
	YYDEBUG(1375, *YYCURSOR);
#line 1766 "ext/date/lib/parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("clf");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr(&ptr, 2);
		s->time->m = timelib_get_month(&ptr);
		s->time->y = timelib_get_nr(&ptr, 4);
		s->time->h = timelib_get_nr(&ptr, 2);
		s->time->i = timelib_get_nr(&ptr, 2);
		s->time->s = timelib_get_nr(&ptr, 2);

		timelib_eat_spaces(&ptr);

		s->time->z = timelib_parse_zone(&ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
		if (tz_not_found) {
			add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
#line 24611 "<stdout>"
yy1376:
	YYDEBUG(1376, *YYCURSOR);
	yyaccept = 33;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '5') {
		if (yych <= '/') goto yy1375;
		if (yych <= '4') goto yy1382;
		goto yy1384;
	} else {
		if (yych <= '9') goto yy1385;
		if (yych <= ':') goto yy1383;
		goto yy1375;
	}
yy1377:
	YYDEBUG(1377, *YYCURSOR);
	yyaccept = 33;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1375;
	if (yych <= '5') goto yy1384;
	if (yych <= '9') goto yy1385;
	if (yych <= ':') goto yy1383;
	goto yy1375;
yy1378:
	YYDEBUG(1378, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1386;
	goto yy59;
yy1379:
	YYDEBUG(1379, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
	if (yych <= '-') {
		if (yych == '+') goto yy1368;
		if (yych <= ',') goto yy59;
		goto yy1368;
	} else {
		if (yych <= 'G') {
			if (yych <= 'F') goto yy59;
			goto yy1369;
		} else {
			if (yych == 0xE2) goto yy1366;
			goto yy59;
		}
	}
yy1380:
	YYDEBUG(1380, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '1') goto yy1387;
	if (yych <= '2') goto yy1388;
	if (yych <= '9') goto yy1389;
	goto yy59;
yy1381:
	YYDEBUG(1381, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1390;
	goto yy59;
yy1382:
	YYDEBUG(1382, *YYCURSOR);
	yyaccept = 33;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1375;
	if (yych <= '5') goto yy1391;
	if (yych <= '9') goto yy1385;
	if (yych <= ':') goto yy1392;
	goto yy1375;
yy1383:
	YYDEBUG(1383, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '5') goto yy1384;
	if (yych <= '9') goto yy1385;
	goto yy59;
yy1384:
	YYDEBUG(1384, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1375;
	if (yych >= ':') goto yy1375;
yy1385:
	YYDEBUG(1385, *YYCURSOR);
	++YYCURSOR;
	goto yy1375;
yy1386:
	YYDEBUG(1386, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '+') goto yy1368;
	if (yych == '-') goto yy1368;
	goto yy59;
yy1387:
	YYDEBUG(1387, *YYCURSOR);
	yyaccept = 32;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1329;
	if (yych <= '9') goto yy1393;
	if (yych <= ':') goto yy1394;
	goto yy1329;
yy1388:
	YYDEBUG(1388, *YYCURSOR);
	yyaccept = 32;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '5') {
		if (yych <= '/') goto yy1329;
		if (yych <= '4') goto yy1393;
		goto yy1328;
	} else {
		if (yych <= '9') goto yy1331;
		if (yych <= ':') goto yy1394;
		goto yy1329;
	}
yy1389:
	YYDEBUG(1389, *YYCURSOR);
	yyaccept = 32;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1329;
	if (yych <= '5') goto yy1328;
	if (yych <= '9') goto yy1331;
	if (yych <= ':') goto yy1394;
	goto yy1329;
yy1390:
	YYDEBUG(1390, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1395;
	goto yy59;
yy1391:
	YYDEBUG(1391, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1375;
	if (yych <= '9') goto yy1396;
	goto yy1375;
yy1392:
	YYDEBUG(1392, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '5') goto yy1397;
	if (yych <= '9') goto yy1385;
	goto yy59;
yy1393:
	YYDEBUG(1393, *YYCURSOR);
	yyaccept = 32;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1329;
	if (yych <= '5') goto yy1398;
	if (yych <= '9') goto yy1331;
	if (yych <= ':') goto yy1399;
	goto yy1329;
yy1394:
	YYDEBUG(1394, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '5') goto yy1328;
	if (yych <= '9') goto yy1331;
	goto yy59;
yy1395:
	YYDEBUG(1395, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '+') goto yy1380;
	if (yych == '-') goto yy1380;
	goto yy59;
yy1396:
	YYDEBUG(1396, *YYCURSOR);
	yyaccept = 33;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1375;
	if (yych <= '5') goto yy1400;
	if (yych <= '6') goto yy1401;
	goto yy1375;
yy1397:
	YYDEBUG(1397, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1375;
	if (yych <= '9') goto yy1402;
	goto yy1375;
yy1398:
	YYDEBUG(1398, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1329;
	if (yych <= '9') goto yy1403;
	goto yy1329;
yy1399:
	YYDEBUG(1399, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '5') goto yy1404;
	if (yych <= '9') goto yy1331;
	goto yy59;
yy1400:
	YYDEBUG(1400, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy1385;
	goto yy59;
yy1401:
	YYDEBUG(1401, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1385;
	goto yy59;
yy1402:
	YYDEBUG(1402, *YYCURSOR);
	yyaccept = 33;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == ':') goto yy1405;
	goto yy1375;
yy1403:
	YYDEBUG(1403, *YYCURSOR);
	yyaccept = 32;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1329;
	if (yych <= '5') goto yy1314;
	if (yych <= '6') goto yy1315;
	goto yy1329;
yy1404:
	YYDEBUG(1404, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1329;
	if (yych <= '9') goto yy1406;
	goto yy1329;
yy1405:
	YYDEBUG(1405, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '5') goto yy1400;
	if (yych <= '6') goto yy1401;
	goto yy59;
yy1406:
	YYDEBUG(1406, *YYCURSOR);
	yyaccept = 32;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == ':') goto yy1286;
	goto yy1329;
}
#line 1994 "ext/date/lib/parse_date.re"

}

#define YYMAXFILL 36


timelib_time *timelib_strtotime(const char *s, size_t len, timelib_error_container **errors, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_get_wrapper)
{
	Scanner in;
	int t;
	const char *e = s + len - 1;

	memset(&in, 0, sizeof(in));
	in.errors = timelib_malloc(sizeof(timelib_error_container));
	in.errors->warning_count = 0;
	in.errors->warning_messages = NULL;
	in.errors->error_count = 0;
	in.errors->error_messages = NULL;

	if (len > 0) {
		while (isspace(*s) && s < e) {
			s++;
		}
		while (isspace(*e) && e > s) {
			e--;
		}
	}
	if (e - s < 0) {
		in.time = timelib_time_ctor();
		add_error(&in, TIMELIB_ERR_EMPTY_STRING, "Empty string");
		if (errors) {
			*errors = in.errors;
		} else {
			timelib_error_container_dtor(in.errors);
		}
		in.time->y = in.time->d = in.time->m = in.time->h = in.time->i = in.time->s = in.time->us = in.time->dst = in.time->z = TIMELIB_UNSET;
		in.time->is_localtime = in.time->zone_type = 0;
		return in.time;
	}
	e++;

	in.str = timelib_malloc((e - s) + YYMAXFILL);
	memset(in.str, 0, (e - s) + YYMAXFILL);
	memcpy(in.str, s, (e - s));
	in.lim = in.str + (e - s) + YYMAXFILL;
	in.cur = in.str;
	in.time = timelib_time_ctor();
	in.time->y = TIMELIB_UNSET;
	in.time->d = TIMELIB_UNSET;
	in.time->m = TIMELIB_UNSET;
	in.time->h = TIMELIB_UNSET;
	in.time->i = TIMELIB_UNSET;
	in.time->s = TIMELIB_UNSET;
	in.time->us = TIMELIB_UNSET;
	in.time->z = TIMELIB_UNSET;
	in.time->dst = TIMELIB_UNSET;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;
	in.time->relative.days = TIMELIB_UNSET;

	do {
		t = scan(&in, tz_get_wrapper);
#ifdef DEBUG_PARSER
		printf("%d\n", t);
#endif
	} while(t != EOI);

	/* do funky checking whether the parsed time was valid time */
	if (in.time->have_time && !timelib_valid_time( in.time->h, in.time->i, in.time->s)) {
		add_warning(&in, TIMELIB_WARN_INVALID_TIME, "The parsed time was invalid");
	}
	/* do funky checking whether the parsed date was valid date */
	if (in.time->have_date && !timelib_valid_date( in.time->y, in.time->m, in.time->d)) {
		add_warning(&in, TIMELIB_WARN_INVALID_DATE, "The parsed date was invalid");
	}

	timelib_free(in.str);
	if (errors) {
		*errors = in.errors;
	} else {
		timelib_error_container_dtor(in.errors);
	}
	return in.time;
}

#define TIMELIB_CHECK_NUMBER                                           \
		if (strchr("0123456789", *ptr) == NULL)                        \
		{                                                              \
			add_pbf_error(s, TIMELIB_ERR_UNEXPECTED_DATA, "Unexpected data found.", string, begin); \
		}
#define TIMELIB_CHECK_SIGNED_NUMBER                                    \
		if (strchr("+-0123456789", *ptr) == NULL)                      \
		{                                                              \
			add_pbf_error(s, TIMELIB_ERR_UNEXPECTED_DATA, "Unexpected data found.", string, begin); \
		}

static void timelib_time_reset_fields(timelib_time *time)
{
	assert(time != NULL);

	time->y = 1970;
	time->m = 1;
	time->d = 1;
	time->h = time->i = time->s = 0;
	time->us = 0;
	time->tz_info = NULL;
}

static void timelib_time_reset_unset_fields(timelib_time *time)
{
	assert(time != NULL);

	if (time->y == TIMELIB_UNSET ) time->y = 1970;
	if (time->m == TIMELIB_UNSET ) time->m = 1;
	if (time->d == TIMELIB_UNSET ) time->d = 1;
	if (time->h == TIMELIB_UNSET ) time->h = 0;
	if (time->i == TIMELIB_UNSET ) time->i = 0;
	if (time->s == TIMELIB_UNSET ) time->s = 0;
	if (time->us == TIMELIB_UNSET ) time->us = 0;
}

static const timelib_format_specifier default_format_map[] = {
	{'+', TIMELIB_FORMAT_ALLOW_EXTRA_CHARACTERS},
	{'#', TIMELIB_FORMAT_ANY_SEPARATOR},
	{'j', TIMELIB_FORMAT_DAY_TWO_DIGIT},
	{'d', TIMELIB_FORMAT_DAY_TWO_DIGIT_PADDED},
	{'z', TIMELIB_FORMAT_DAY_OF_YEAR},
	{'S', TIMELIB_FORMAT_DAY_SUFFIX},
	{'U', TIMELIB_FORMAT_EPOCH_SECONDS},
	{'\\', TIMELIB_FORMAT_ESCAPE},
	{'h', TIMELIB_FORMAT_HOUR_TWO_DIGIT_12_MAX},
	{'g', TIMELIB_FORMAT_HOUR_TWO_DIGIT_12_MAX_PADDED},
	{'H', TIMELIB_FORMAT_HOUR_TWO_DIGIT_24_MAX},
	{'G', TIMELIB_FORMAT_HOUR_TWO_DIGIT_24_MAX_PADDED},
	{'a', TIMELIB_FORMAT_MERIDIAN},
	{'A', TIMELIB_FORMAT_MERIDIAN},
	{'u', TIMELIB_FORMAT_MICROSECOND_SIX_DIGIT},
	{'v', TIMELIB_FORMAT_MILLISECOND_THREE_DIGIT},
	{'i', TIMELIB_FORMAT_MINUTE_TWO_DIGIT},
	{'n', TIMELIB_FORMAT_MONTH_TWO_DIGIT},
	{'m', TIMELIB_FORMAT_MONTH_TWO_DIGIT_PADDED},
	{'?', TIMELIB_FORMAT_RANDOM_CHAR},
	{'!', TIMELIB_FORMAT_RESET_ALL},
	{'|', TIMELIB_FORMAT_RESET_ALL_WHEN_NOT_SET},
	{'s', TIMELIB_FORMAT_SECOND_TWO_DIGIT},
	{';', TIMELIB_FORMAT_SEPARATOR},
	{':', TIMELIB_FORMAT_SEPARATOR},
	{'/', TIMELIB_FORMAT_SEPARATOR},
	{'.', TIMELIB_FORMAT_SEPARATOR},
	{',', TIMELIB_FORMAT_SEPARATOR},
	{'-', TIMELIB_FORMAT_SEPARATOR},
	{'(', TIMELIB_FORMAT_SEPARATOR},
	{')', TIMELIB_FORMAT_SEPARATOR},
	{'*', TIMELIB_FORMAT_SKIP_TO_SEPARATOR},
	{'D', TIMELIB_FORMAT_TEXTUAL_DAY_3_LETTER},
	{'l', TIMELIB_FORMAT_TEXTUAL_DAY_FULL},
	{'M', TIMELIB_FORMAT_TEXTUAL_MONTH_3_LETTER},
	{'F', TIMELIB_FORMAT_TEXTUAL_MONTH_FULL},
	{'e', TIMELIB_FORMAT_TIMEZONE_OFFSET},
	{'P', TIMELIB_FORMAT_TIMEZONE_OFFSET},
	{'p', TIMELIB_FORMAT_TIMEZONE_OFFSET},
	{'T', TIMELIB_FORMAT_TIMEZONE_OFFSET},
	{'O', TIMELIB_FORMAT_TIMEZONE_OFFSET},
	{' ', TIMELIB_FORMAT_WHITESPACE},
	{'y', TIMELIB_FORMAT_YEAR_TWO_DIGIT},
	{'Y', TIMELIB_FORMAT_YEAR_FOUR_DIGIT},
	{'x', TIMELIB_FORMAT_YEAR_EXPANDED},
	{'X', TIMELIB_FORMAT_YEAR_EXPANDED},
	{'\0', TIMELIB_FORMAT_END}
};

static const timelib_format_config default_format_config = {
	default_format_map,
	// No prefix required by default.
	'\0'
};

static timelib_format_specifier_code timelib_lookup_format(char input, const timelib_format_specifier* format_map)
{
	while (format_map && format_map->specifier != '\0') {
		if (format_map->specifier == input) {
			return format_map->code;
		}
		format_map++;
	}
	return TIMELIB_FORMAT_LITERAL;
}

timelib_time *timelib_parse_from_format(const char *format, const char *string, size_t len, timelib_error_container **errors, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_get_wrapper)
{
	return timelib_parse_from_format_with_map(format, string, len, errors, tzdb, tz_get_wrapper, &default_format_config);
}

timelib_time *timelib_parse_from_format_with_map(const char *format, const char *string, size_t len, timelib_error_container **errors, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_get_wrapper, const timelib_format_config* format_config)
{
	const char  *fptr = format;
	const char  *ptr = string;
	const char  *begin;
	timelib_sll  tmp;
	Scanner      in;
	Scanner     *s = &in;
	bool         allow_extra = false;
	bool         prefix_found = false;
	int          iso_year = TIMELIB_UNSET;
	int          iso_week_of_year = TIMELIB_UNSET;
	int          iso_day_of_week = TIMELIB_UNSET;
	char         prefix_char = format_config->prefix_char;
	const timelib_format_specifier *format_map = format_config->format_map;

	memset(&in, 0, sizeof(in));
	in.errors = timelib_malloc(sizeof(timelib_error_container));
	in.errors->warning_count = 0;
	in.errors->warning_messages = NULL;
	in.errors->error_count = 0;
	in.errors->error_messages = NULL;

	in.time = timelib_time_ctor();
	in.time->y = TIMELIB_UNSET;
	in.time->d = TIMELIB_UNSET;
	in.time->m = TIMELIB_UNSET;
	in.time->h = TIMELIB_UNSET;
	in.time->i = TIMELIB_UNSET;
	in.time->s = TIMELIB_UNSET;
	in.time->us = TIMELIB_UNSET;
	in.time->z = TIMELIB_UNSET;
	in.time->dst = TIMELIB_UNSET;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;

	/* Loop over the format string */
	while (*fptr && *ptr) {
		begin = ptr;

		if (prefix_char) {
			/* There are 2 cases where the input string and format string
			 * should match the next literal:
			 *
			 * 1. No prefix has been specified yet in the format, so expect 1:1
			 *    match.
			 * 2. Sequential prefix characters indicating that the second
			 *    prefix is escaped. (e.g. "%%" is expecting literal "%")
			 */
			if ((!prefix_found && *fptr != prefix_char) ||
				(prefix_found && *fptr == prefix_char)) {
				if (*fptr != *ptr) {
					add_pbf_error(s, TIMELIB_ERR_FORMAT_LITERAL_MISMATCH, "Format literal not found", string, begin);
				}
				ptr++;
				fptr++;
				prefix_found = false;
				continue;
			}

			if (*fptr == prefix_char) {
				fptr++;
				prefix_found = true;
				continue;
			}

			/* Fall through case is that the prefix has been found and the next
			 * character is the format specifier. */
			prefix_found = false;
		}

		switch (timelib_lookup_format(*fptr, format_map)) {
			case TIMELIB_FORMAT_TEXTUAL_DAY_3_LETTER: /* three letter day */
			case TIMELIB_FORMAT_TEXTUAL_DAY_FULL: /* full day */
				{
					const timelib_relunit* tmprel = 0;

					tmprel = timelib_lookup_relunit(&ptr);
					if (!tmprel) {
						add_pbf_error(s, TIMELIB_ERR_NO_TEXTUAL_DAY, "A textual day could not be found", string, begin);
						break;
					} else {
						in.time->have_relative = 1;
						in.time->relative.have_weekday_relative = 1;
						in.time->relative.weekday = tmprel->multiplier;
						in.time->relative.weekday_behavior = 1;
					}
				}
				break;
			case TIMELIB_FORMAT_DAY_TWO_DIGIT: /* two digit day, without leading zero */
			case TIMELIB_FORMAT_DAY_TWO_DIGIT_PADDED: /* two digit day, with leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->d = timelib_get_nr(&ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_DAY, "A two digit day could not be found", string, begin);
					break;
				}

				s->time->have_date = 1;
				break;
			case TIMELIB_FORMAT_DAY_SUFFIX: /* day suffix, ignored, nor checked */
				timelib_skip_day_suffix(&ptr);
				break;
			case TIMELIB_FORMAT_DAY_OF_YEAR: /* day of year - resets month (0 based) - also initializes everything else to !TIMELIB_UNSET */
				TIMELIB_CHECK_NUMBER;
				if (s->time->y == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_MERIDIAN_BEFORE_HOUR, "A 'day of year' can only come after a year has been found", string, begin);
				}
				if ((tmp = timelib_get_nr(&ptr, 3)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_THREE_DIGIT_DAY_OF_YEAR, "A three digit day-of-year could not be found", string, begin);
					break;
				}

				if (s->time->y != TIMELIB_UNSET) {
					s->time->have_date = 1;
					s->time->m = 1;
					s->time->d = tmp + 1;
					timelib_do_normalize(s->time);
				}
				break;

			case TIMELIB_FORMAT_MONTH_TWO_DIGIT: /* two digit month, without leading zero */
			case TIMELIB_FORMAT_MONTH_TWO_DIGIT_PADDED: /* two digit month, with leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->m = timelib_get_nr(&ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_MONTH, "A two digit month could not be found", string, begin);
					break;
				}
				s->time->have_date = 1;
				break;
			case TIMELIB_FORMAT_TEXTUAL_MONTH_3_LETTER: /* three letter month */
			case TIMELIB_FORMAT_TEXTUAL_MONTH_FULL: /* full month */
				tmp = timelib_lookup_month(&ptr);
				if (!tmp) {
					add_pbf_error(s, TIMELIB_ERR_NO_TEXTUAL_MONTH, "A textual month could not be found", string, begin);
					break;
				}

				s->time->have_date = 1;
				s->time->m = tmp;
				break;
			case TIMELIB_FORMAT_YEAR_TWO_DIGIT: /* two digit year */
				{
					int length = 0;
					TIMELIB_CHECK_NUMBER;
					if ((s->time->y = timelib_get_nr_ex(&ptr, 2, &length)) == TIMELIB_UNSET) {
						add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_YEAR, "A two digit year could not be found", string, begin);
						break;
					}
					
					s->time->have_date = 1;
					TIMELIB_PROCESS_YEAR(s->time->y, length);
				}
				break;
			case TIMELIB_FORMAT_YEAR_FOUR_DIGIT: /* four digit year */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->y = timelib_get_nr(&ptr, 4)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_FOUR_DIGIT_YEAR, "A four digit year could not be found", string, begin);
					break;
				}

				s->time->have_date = 1;
				break;
			case TIMELIB_FORMAT_YEAR_EXPANDED: /* optional symbol, followed by up to 19 digits */
				TIMELIB_CHECK_SIGNED_NUMBER;
				if ((s->time->y = timelib_get_signed_nr(s, &ptr, 19)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_FOUR_DIGIT_YEAR, "An expanded digit year could not be found", string, begin);
					break;
				}

				s->time->have_date = 1;
				break;
			case TIMELIB_FORMAT_HOUR_TWO_DIGIT_12_MAX: /* two digit hour, without leading zero */
			case TIMELIB_FORMAT_HOUR_TWO_DIGIT_12_MAX_PADDED: /* two digit hour, with leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->h = timelib_get_nr(&ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_HOUR, "A two digit hour could not be found", string, begin);
					break;
				}
				if (s->time->h > 12) {
					add_pbf_error(s, TIMELIB_ERR_HOUR_LARGER_THAN_12, "Hour cannot be higher than 12", string, begin);
					break;
				}

				s->time->have_time = 1;
				break;
			case TIMELIB_FORMAT_HOUR_TWO_DIGIT_24_MAX_PADDED: /* two digit hour, with leading zero */
			case TIMELIB_FORMAT_HOUR_TWO_DIGIT_24_MAX: /* two digit hour, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->h = timelib_get_nr(&ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_HOUR, "A two digit hour could not be found", string, begin);
					break;
				}

				s->time->have_time = 1;
				break;
			case TIMELIB_FORMAT_MERIDIAN: /* am/pm/a.m./p.m. AM/PM/A.M./P.M. */
				if (s->time->h == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_MERIDIAN_BEFORE_HOUR, "Meridian can only come after an hour has been found", string, begin);
				}
				if ((tmp = timelib_meridian_with_check(&ptr, s->time->h)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_MERIDIAN, "A meridian could not be found", string, begin);
					break;
				}

				s->time->have_time = 1;
				if (s->time->h != TIMELIB_UNSET) {
					s->time->h += tmp;
				}
				break;
			case TIMELIB_FORMAT_MINUTE_TWO_DIGIT: /* two digit minute, with leading zero */
				{
					int length;
					timelib_sll min;

					TIMELIB_CHECK_NUMBER;
					min = timelib_get_nr_ex(&ptr, 2, &length);
					if (min == TIMELIB_UNSET || length != 2) {
						add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_MINUTE, "A two digit minute could not be found", string, begin);
						break;
					}

					s->time->have_time = 1;
					s->time->i = min;
				}
				break;
			case TIMELIB_FORMAT_SECOND_TWO_DIGIT: /* two digit second, with leading zero */
				{
					int length;
					timelib_sll sec;

					TIMELIB_CHECK_NUMBER;
					sec = timelib_get_nr_ex(&ptr, 2, &length);
					if (sec == TIMELIB_UNSET || length != 2) {
						add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_SECOND, "A two digit second could not be found", string, begin);
						break;
					}

					s->time->have_time = 1;
					s->time->s = sec;
				}
				break;
			case TIMELIB_FORMAT_MICROSECOND_SIX_DIGIT: /* up to six digit microsecond */
				{
					double f;
					const char *tptr;

					TIMELIB_CHECK_NUMBER;
					tptr = ptr;
					if ((f = timelib_get_nr(&ptr, 6)) == TIMELIB_UNSET || (ptr - tptr < 1)) {
						add_pbf_error(s, TIMELIB_ERR_NO_SIX_DIGIT_MICROSECOND, "A six digit microsecond could not be found", string, begin);
						break;
					}

					s->time->us = (f * pow(10, 6 - (ptr - tptr)));
				}
				break;
			case TIMELIB_FORMAT_MILLISECOND_THREE_DIGIT: /* up to three digit millisecond */
				{
					double f;
					const char *tptr;

					TIMELIB_CHECK_NUMBER;
					tptr = ptr;
					if ((f = timelib_get_nr(&ptr, 3)) == TIMELIB_UNSET || (ptr - tptr < 1)) {
						add_pbf_error(s, TIMELIB_ERR_NO_THREE_DIGIT_MILLISECOND, "A three digit millisecond could not be found", string, begin);
						break;
					}
					
					s->time->us = (f * pow(10, 3 - (ptr - tptr)) * 1000);
				}
				break;
			case TIMELIB_FORMAT_WHITESPACE: /* any sort of whitespace (' ' and \t) */
				timelib_eat_spaces(&ptr);
				break;
			case TIMELIB_FORMAT_EPOCH_SECONDS: /* epoch seconds */
				TIMELIB_CHECK_SIGNED_NUMBER;
				tmp = timelib_get_signed_nr(s, &ptr, 24);
				s->time->have_zone = 1;
				s->time->sse = tmp;
				s->time->is_localtime = 1;
				s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
				s->time->z = 0;
				s->time->dst = 0;
				timelib_update_from_sse(s->time);
				break;

			case TIMELIB_FORMAT_ANY_SEPARATOR: /* separation symbol */
				if (timelib_lookup_format(*ptr, format_map) != TIMELIB_FORMAT_SEPARATOR) {
					add_pbf_error(s, TIMELIB_ERR_NO_SEP_SYMBOL, "The separation symbol ([;:/.,-]) could not be found", string, begin);
					break;
				}
				
				++ptr;
				break;

			case TIMELIB_FORMAT_SEPARATOR:
				if (*ptr != *fptr) {
					add_pbf_error(s, TIMELIB_ERR_NO_SEP_SYMBOL, "The separation symbol could not be found", string, begin);
					break;
				}

				++ptr;
				break;

			case TIMELIB_FORMAT_RESET_ALL: /* reset all fields to default */
				timelib_time_reset_fields(s->time);
				break; /* break intentionally not missing */

			case TIMELIB_FORMAT_RESET_ALL_WHEN_NOT_SET: /* reset all fields to default when not set */
				timelib_time_reset_unset_fields(s->time);
				break; /* break intentionally not missing */

			case TIMELIB_FORMAT_RANDOM_CHAR: /* random char */
				++ptr;
				break;

			case TIMELIB_FORMAT_ESCAPE: /* escaped char */
				if (!fptr[1]) {
					add_pbf_error(s, TIMELIB_ERR_EXPECTED_ESCAPE_CHAR, "Escaped character expected", string, begin);
					break;
				}
				fptr++;
				if (*ptr != *fptr) {
					add_pbf_error(s, TIMELIB_ERR_NO_ESCAPED_CHAR, "The escaped character could not be found", string, begin);
					break;
				}

				++ptr;
				break;

			case TIMELIB_FORMAT_SKIP_TO_SEPARATOR: /* random chars until a separator or number ([ \t.,:;/-0123456789]) */
				timelib_eat_until_separator(&ptr);
				break;

			case TIMELIB_FORMAT_ALLOW_EXTRA_CHARACTERS: /* allow extra chars in the format */
				allow_extra = true;
				break;
			case TIMELIB_FORMAT_YEAR_ISO:
				if ((iso_year = timelib_get_nr(&ptr, 4)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_FOUR_DIGIT_YEAR_ISO, "A four digit ISO year could not be found", string, begin);
					break;
				}

				s->time->have_date = 1;
				break;
			case TIMELIB_FORMAT_WEEK_OF_YEAR_ISO:
				if ((iso_week_of_year = timelib_get_nr(&ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_WEEK, "A two digit ISO week could not be found", string, begin);
					break;
				}
				/* Range is 1 - 53  for ISO week of year */
				if (iso_week_of_year < 1 || iso_week_of_year > 53) {
					add_pbf_error(s, TIMELIB_ERR_INVALID_WEEK, "ISO Week must be between 1 and 53", string, begin);
					break;
				}

				s->time->have_date = 1;
				break;
			case TIMELIB_FORMAT_DAY_OF_WEEK_ISO:
				if ((iso_day_of_week = timelib_get_nr(&ptr, 1)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_DAY_OF_WEEK, "A single digit day of week could not be found", string, begin);
					break;
				}
				if (iso_day_of_week < 1 || iso_day_of_week > 7) {
					add_pbf_error(s, TIMELIB_ERR_INVALID_DAY_OF_WEEK, "Day of week must be between 1 and 7", string, begin);
					break;
				}

				s->time->have_date = 1;
				break;
			case TIMELIB_FORMAT_TIMEZONE_OFFSET: /* timezone */
				{
					int tz_not_found;

					s->time->z = timelib_parse_zone(&ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
					if (tz_not_found) {
						add_pbf_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database", string, begin);
						break;
					}

					s->time->have_zone = 1;
				}
				break;
			case TIMELIB_FORMAT_TIMEZONE_OFFSET_MINUTES: /* timezone format +/-mmm */
				s->time->z = timelib_parse_tz_minutes(&ptr, s->time);
				if (s->time->z == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_INVALID_TZ_OFFSET, "Invalid timezone offset in minutes", string, begin);
					break;
				}

				s->time->have_zone = 1;
				break;
			case TIMELIB_FORMAT_LITERAL:
			default:
				if (*fptr != *ptr) {
					add_pbf_error(s, TIMELIB_ERR_WRONG_FORMAT_SEP, "The format separator does not match", string, begin);
				}
				ptr++;
		}
		fptr++;
	}
	if (*ptr) {
		if (allow_extra) {
			add_pbf_warning(s, TIMELIB_WARN_TRAILING_DATA, "Trailing data", string, ptr);
		} else {
			add_pbf_error(s, TIMELIB_ERR_TRAILING_DATA, "Trailing data", string, ptr);
		}
	}

	if (*fptr) {
		/* Trailing reset specifiers are valid. */
		int done = 0;
		while (*fptr && !done) {
			switch (timelib_lookup_format(*fptr, format_map)) {
				case TIMELIB_FORMAT_RESET_ALL: /* reset all fields to default */
					timelib_time_reset_fields(s->time);
					break;

				case TIMELIB_FORMAT_RESET_ALL_WHEN_NOT_SET: /* reset all fields to default when not set */
					timelib_time_reset_unset_fields(s->time);
					break;
				case TIMELIB_FORMAT_ALLOW_EXTRA_CHARACTERS:
					break;

				default:
					add_pbf_error(s, TIMELIB_ERR_DATA_MISSING, "Not enough data available to satisfy format", string, ptr);
					done = 1;
			}
			fptr++;
		}
	}

	/* clean up a bit */
	if (s->time->h != TIMELIB_UNSET || s->time->i != TIMELIB_UNSET || s->time->s != TIMELIB_UNSET || s->time->us != TIMELIB_UNSET) {
		if (s->time->h == TIMELIB_UNSET ) {
			s->time->h = 0;
		}
		if (s->time->i == TIMELIB_UNSET ) {
			s->time->i = 0;
		}
		if (s->time->s == TIMELIB_UNSET ) {
			s->time->s = 0;
		}
		if (s->time->us == TIMELIB_UNSET ) {
			s->time->us = 0;
		}
	}

	/* Check for mixing of ISO dates with natural dates. */
	if (s->time->y != TIMELIB_UNSET && (iso_week_of_year != TIMELIB_UNSET || iso_year != TIMELIB_UNSET || iso_day_of_week != TIMELIB_UNSET)) {
		add_pbf_error(s, TIMELIB_ERR_MIX_ISO_WITH_NATURAL, "Mixing of ISO dates with natural dates is not allowed", string, ptr);
	}
	if (iso_year != TIMELIB_UNSET && (s->time->y != TIMELIB_UNSET || s->time->m != TIMELIB_UNSET || s->time->d != TIMELIB_UNSET)) {
		add_pbf_error(s, TIMELIB_ERR_MIX_ISO_WITH_NATURAL, "Mixing of ISO dates with natural dates is not allowed", string, ptr);
	}

	/* Convert ISO values */
	if (iso_year != TIMELIB_UNSET) {
		/* Default week of year and day of week to 1. */
		if (iso_week_of_year == TIMELIB_UNSET) {
			iso_week_of_year = 1;
		}
		if (iso_day_of_week == TIMELIB_UNSET) {
			iso_day_of_week = 1;
		}
		timelib_date_from_isodate(iso_year, iso_week_of_year, iso_day_of_week, &s->time->y, &s->time->m, &s->time->d);
	} else if (iso_week_of_year != TIMELIB_UNSET || iso_day_of_week != TIMELIB_UNSET) {
		add_pbf_warning(s, TIMELIB_WARN_INVALID_DATE, "The parsed date was invalid", string, ptr);
	}

	/* do funky checking whether the parsed time was valid time */
	if (s->time->h != TIMELIB_UNSET && s->time->i != TIMELIB_UNSET &&
		s->time->s != TIMELIB_UNSET &&
		!timelib_valid_time( s->time->h, s->time->i, s->time->s)) {
		add_pbf_warning(s, TIMELIB_WARN_INVALID_TIME, "The parsed time was invalid", string, ptr);
	}
	/* do funky checking whether the parsed date was valid date */
	if (s->time->y != TIMELIB_UNSET && s->time->m != TIMELIB_UNSET &&
		s->time->d != TIMELIB_UNSET &&
		!timelib_valid_date( s->time->y, s->time->m, s->time->d)) {
		add_pbf_warning(s, TIMELIB_WARN_INVALID_DATE, "The parsed date was invalid", string, ptr);
	}

	if (errors) {
		*errors = in.errors;
	} else {
		timelib_error_container_dtor(in.errors);
	}
	return in.time;
}

void timelib_fill_holes(timelib_time *parsed, timelib_time *now, int options)
{
	if (!(options & TIMELIB_OVERRIDE_TIME) && parsed->have_date && !parsed->have_time) {
		parsed->h = 0;
		parsed->i = 0;
		parsed->s = 0;
		parsed->us = 0;
	}
	if (
		parsed->y != TIMELIB_UNSET || parsed->m != TIMELIB_UNSET || parsed->d != TIMELIB_UNSET ||
		parsed->h != TIMELIB_UNSET || parsed->i != TIMELIB_UNSET || parsed->s != TIMELIB_UNSET
	) {
		if (parsed->us == TIMELIB_UNSET) parsed->us = 0;
	} else {
		if (parsed->us == TIMELIB_UNSET) parsed->us = now->us != TIMELIB_UNSET ? now->us : 0;
	}
	if (parsed->y == TIMELIB_UNSET) parsed->y = now->y != TIMELIB_UNSET ? now->y : 0;
	if (parsed->m == TIMELIB_UNSET) parsed->m = now->m != TIMELIB_UNSET ? now->m : 0;
	if (parsed->d == TIMELIB_UNSET) parsed->d = now->d != TIMELIB_UNSET ? now->d : 0;
	if (parsed->h == TIMELIB_UNSET) parsed->h = now->h != TIMELIB_UNSET ? now->h : 0;
	if (parsed->i == TIMELIB_UNSET) parsed->i = now->i != TIMELIB_UNSET ? now->i : 0;
	if (parsed->s == TIMELIB_UNSET) parsed->s = now->s != TIMELIB_UNSET ? now->s : 0;

	if (!parsed->tz_info) {
		parsed->tz_info = now->tz_info ? (!(options & TIMELIB_NO_CLONE) ? timelib_tzinfo_clone(now->tz_info) : now->tz_info) : NULL;

		if (parsed->z == TIMELIB_UNSET) parsed->z = now->z != TIMELIB_UNSET ? now->z : 0;
		if (parsed->dst == TIMELIB_UNSET) parsed->dst = now->dst != TIMELIB_UNSET ? now->dst : 0;

		if (!parsed->tz_abbr) {
			parsed->tz_abbr = now->tz_abbr ? timelib_strdup(now->tz_abbr) : NULL;
		}
	}

	if (parsed->zone_type == 0 && now->zone_type != 0) {
		parsed->zone_type = now->zone_type;
/*		parsed->tz_abbr = now->tz_abbr ? timelib_strdup(now->tz_abbr) : NULL;
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
*/		parsed->is_localtime = 1;
	}
/*	timelib_dump_date(parsed, 2);
	timelib_dump_date(now, 2);
*/
}

const char *timelib_timezone_id_from_abbr(const char *abbr, timelib_long gmtoffset, int isdst)
{
	const timelib_tz_lookup_table *tp;

	tp = abbr_search(abbr, gmtoffset, isdst);
	if (tp) {
		return (tp->full_tz_name);
	} else {
		return NULL;
	}
}

const timelib_tz_lookup_table *timelib_timezone_abbreviations_list(void)
{
	return timelib_timezone_lookup;
}

#ifdef DEBUG_PARSER_STUB
int main(void)
{
	timelib_time time = timelib_strtotime("May 12");

	printf ("%04d-%02d-%02d %02d:%02d:%02d.%-5d %+04d %1d",
		time.y, time.m, time.d, time.h, time.i, time.s, time.f, time.z, time.dst);
	if (time.have_relative) {
		printf ("%3dY %3dM %3dD / %3dH %3dM %3dS",
			time.relative.y, time.relative.m, time.relative.d, time.relative.h, time.relative.i, time.relative.s);
	}
	if (time.have_weekday_relative) {
		printf (" / %d", time.relative.weekday);
	}
	if (time.have_weeknr_day) {
		printf(" / %dW%d", time.relative.weeknr_day.weeknr, time.relative.weeknr_day.dayofweek);
	}
	return 0;
}
#endif

/*
 * vim: syntax=c
 */
