{$IFDEF WINDOWS}
{$N-,V-,W-,G+}
{$ELSE}
{$E-,N-,V-}
{$ENDIF}

Unit bibputbk;

Interface

uses
{$IFDEF WINDOWS}
  WinDos, Wobjects, wbibdisp, WinTypes, WinProcs, Strings, wbibslct, commdlg,
  rc_id, wHugeMem,
{$ELSE}
  Dos, objects, BibCRT, bibdisp, bibselct,
{$ENDIF}
  bibstrg, rc_strng, bibfile, bibvars, bibutil, lfnunit;

function AuxToBib(paux: PStream; var bib: text; bibname: string): boolean;

implementation


function AuxToBib(paux: PStream; var bib: text; bibname: string): boolean;
const
  DiskPool = 1;   { In units of the cluster size }
var
  nbib: file;
  icode: byte;
  n,bsize: Word;
  ercode,i: integer;
  BibSize,BakSize,ClusSize,lTime: longint;
  Dir,Name,Ext,bakname,tmp: PString;
  BackedNow,Backed,ok: boolean;
  BakTime: TDateTime;
  ch: char;

function SaveToFile(var f: string): integer;
var
  i: integer;
  written: word;
begin
  LFNAssign(nbib,f);
  i:=LFNrewrite(nbib,1);
  if i=0 then
  begin
    bsize:=FileBufSize;
    paux^.seek(0); 
    n:=bsize; 
    if paux^.GetPos+n>paux^.GetSize then n:=paux^.GetSize-paux^.GetPos;
    while (i=0) and (n>0) do
    begin
      paux^.read(bibbuf^,n);
      {$I-}
      BlockWrite(nbib,bibbuf^,n,written); i:=IoResult;
      {$I+}
      if written<n then i:=101;
      n:=bsize; 
      if paux^.GetPos+n>paux^.GetSize then n:=paux^.GetSize-paux^.GetPos;
    end;
  end;
  LFNClose(nbib);
  SaveToFile:=i; 
end;                       { SaveToFile }

function GetNewFilename(var f: string): integer;
var
  o_k,finish,accept: boolean;
  i: integer;
{$IFDEF WINDOWS}
  TOF: TOpenFileName;
  Buf,ExtBuf: Pchar;
  FOpenHook: TFarProc;
  Title: array[0..32] of char;
{$ENDIF}
begin
  GetNewFilename:=1;
{$IFDEF WINDOWS}
  i:=AskIf3(StringRC(Str_NotEnoughSpace,''),'Abort','Retry','Save as...');
{$ELSE}
  if MultiTasking then
    i:=AskIf3(StringRC(Str_NotEnoughSpace,''),'Abort','Retry','Save as...')
  else begin
    if AskIfRC(Str_NotEnoughSpace,'','','Abort','Save as...') then i:=1
    else i:=3;
  end;
{$ENDIF}
  if i=1 then Exit
  else if i=2 then GetNewFilename:=i
  else if i=3 then
  begin
    accept:=false;
{$IFDEF WINDOWS}
    GetMem(Buf,256); GetMem(ExtBuf,256);
    FOpenHook:=MakeProcInstance(TFarProc(@FOpenDlgHook),HInstance);
    FillChar(TOF,sizeof(TOpenFileName),0);
    Buf[0]:=#0;
    StrPCopy(ExtBuf,DefExtension[BibTeXFormat]^);
    with TOF do
    begin
      lStructSize:=sizeof(TOpenFileName);
      HWndOwner:=CurrentWindow^.HWindow;
      lpstrFile:=Buf;
      nMaxFile:=255;
      Flags:=ofn_HideReadOnly    or ofn_NoReadOnlyReturn or
             ofn_OverwritePrompt or ofn_PathMustExist or
             ofn_EnableHook      {or ofn_EnableTemplate};
      if LFNAble then flags:=flags or ofn_LongNames;
      if ExtBuf[0]='.' then lpstrDefExt:=ExtBuf+1
      else lpstrDefExt:=ExtBuf; 
      lpTemplateName:=PChar(rc_FileOpenBrowse);
      lpfnHook:=FOpenHookProc(FOpenHook);
      lpstrTitle:='Save As...';
    end;
    TOF.hInstance:=HInstance;
    accept:=GetSaveFileName(TOF);
    FreeProcInstance(FOpenHook);
    if accept then f:=StrPas(Buf);
    FreeMem(ExtBuf,256); FreeMem(Buf,256);
{$ELSE}
    FileChoose(f,DefExtension[BibTeXFormat]^,TexInputList,
               AnyFile and (not (Directory or SysFile)),
               true,false,false,Nil,'Save as:','',accept);
{$ENDIF}
    if (not accept) or (f='') then Exit
    else begin
      CanonicalFName(f); ChrDelL(f,' '); ChrDelR(f,' ');
      GetNewFilename:=3;
    end;
  end;
end;                         { GetNewFilename }

function CheckSpace(var f: string): boolean;
var
  o_k,finish: boolean;
  i: integer;
  BibFree,Needed: Longint;
  D: string;
begin
  finish:=false;
  repeat
    o_k:=true;
    BibFree:=FreeSpace(f);
    if backed then Needed:=Paux^.GetSize-BibSize
    else begin
      LFNFSplit(LFNFExpand(F),@D,Nil,Nil); 
      if StrCmpI(D,Dir^,1,1,255)=0 then      { In the same directory as the original }
        Needed:=Paux^.GetSize-BakSize
      else Needed:=Paux^.GetSize;
    end;
    if BibFree-DiskPool*ClusSize<Needed then
    begin
      o_k:=false;
      i:=GetNewFilename(f); if i=1 then finish:=true;
    end;
  until finish or o_k;
  CheckSpace:=o_k;
end;                      { CheckSpace }

procedure TidyUp;
begin
  LFNDispose(nbib);
  AllocStrings(false,@tmp,Nil,Nil,Nil);
  AllocStrings(false,@Dir,@Name,@Ext,@bakname);
  AuxToBib:=ok;
end;

function LaterThan(T1,T2: TDateTime): boolean;
begin
  {
  with T1 do
    logstring(num2str(day)+'/'+num2str(month)+'/'+num2str(year)
     +', '+num2str(hour)+':'+num2str(min)+':'+num2str(sec));
  with T2 do
    logstring(num2str(day)+'/'+num2str(month)+'/'+num2str(year)
     +', '+num2str(hour)+':'+num2str(min)+':'+num2str(sec));
  }
  LaterThan:=false;
  if (T1.Year>T2.Year) then
    LaterThan:=true
  else if T1.Year=T2.Year then
  begin
    if T1.Month>T2.Month then LaterThan:=true
    else if T1.Month=T2.Month then
    begin
      if T1.Day>T2.Day then LaterThan:=true
      else if T1.Day=T2.Day then
      begin
        if T1.Hour>T2.Hour then LaterThan:=true
        else if T1.Hour=T2.Hour then
        begin
          if T1.Min>T2.Min then LaterThan:=true
              else if (T1.Min=T2.Min) and
                (T1.Sec>T2.Sec) then LaterThan:=true
        end;
      end;
    end;
  end;
end;               { LaterThan }

{$IFDEF WINDOWS}
var
  RAM: PHugeMemStream;
  T: THandle;
{$ENDIF}

begin
  BackedNow:=false; ok:=false; AuxToBib:=false;
  if Paux^.status<>stOK then
  begin
    ErrorMessageRC(Str_CantCreateTemp,''); Exit;
  end;
{$IFDEF WINDOWS}
  if bibname=File_Clipboard then
  begin
    OpenClipboard(HMainW);
    EmptyClipboard;
    New(RAM,init(Paux^.GetSize+2));
    Paux^.seek(0);
    RAM^.CopyFrom(PAux^,PAux^.GetSize);
    ch:=#0; RAM^.write(ch,1);
    RAM^.Owner:=false;
    T:=RAM^.Handle;
    Dispose(RAM,Done);
    SetClipboardData(cf_text,T);
    CloseClipboard;
    AuxToBib:=true;
    Exit;
  end;
{$ENDIF}
  AllocStrings(true,@Dir,@Name,@Ext,@bakname);
  AllocStrings(true,@tmp,Nil,Nil,Nil);
  LFNClose(bib);
  LFNNew(nbib,false);
  BibSize:=0; ercode:=0;
  BakName^:=''; BakSize:=0;
  if LFNFileExist(bibname) then BibSize:=FileSize(bibname);
  ClusSize:=ClusterSize(bibname);
  LFNFSplit(LFNfexpand(bibname),Dir,Name,Ext);

  if (bibsize<2) or (BackupExtension^='none') then backed:=true
  else begin
    backed:=false;
    bakname^:=Dir^+Name^+BackupExtension^;
    CanonicalFname(bakname^); CanonicalFname(Dir^);
    logstring(bakname^);
    if LFNFileExist(BakName^) then
    begin
      BakSize:=FileSize(BakName^);
      UnpackTime(GetFileTime(BakName^),BakTime);
      Backed:=LaterThan(BakTime,StartupTime);
    end;
  end;

  {
  message('Cluster size = '+num2str(ClusSize)+', file size = '+num2str(bibsize));
  }

  tmp^:=bibname;
  if not CheckSpace(tmp^) then
  begin
    TidyUp; Exit;
  end else if StrCmpI(tmp^,bibname,1,1,255)<>0 then
  begin
    ercode:=SaveToFile(tmp^); i:=0;
    while (i<>1) and (ercode<>0) do    { Error - not enough space? }
    begin
      i:=GetNewFilename(tmp^);
      if i=3 then ercode:=SaveToFile(tmp^);
    end;
    TidyUp; Exit;
  end;
                  { Backup }
  if not backed then
  begin
    if LFNFileExist(bakname^) then
    begin
      LFNAssign(nbib,bakname^);
      ercode:=LFNErase(nbib);
      if (ercode<>0) and AskIfRC(Str_CantRemoveOldBak,'','',
             'Abort','Continue') then
      begin
        TidyUp; Exit;
      end;
    end;
    LFNAssign(nbib,bibname);
    ercode:=LFNRename(nbib,bakname^);
    if (ercode<>0) and AskIfRC(Str_BakError,bakname^,'',
           'Abort','Continue') then
    begin
      TidyUp; Exit;
    end;
    backed:=true; backednow:=true;
    { Touch }
    with baktime do
    begin
      GetDate(Year,Month,Day,n); GetTime(Hour,Min,Sec,n);
    end;
    PackTime(BakTime,lTime);
    LFNAssign(nbib,bakname^); LFNReset(nbib,1);
    SetFTime(nbib,lTime); LFNClose(nbib);
  end;

  { Save the file }
  tmp^:=bibname; 
  ercode:=SaveToFile(tmp^); i:=0;
  while (i<>1) and (ercode<>0) do  { Error - not enough space? }
  begin
    i:=GetNewFilename(tmp^);
    if i=3 then ercode:=SaveToFile(tmp^);
  end;
  LFNAssign(bib,bibname);
  SetTextBuf(bib,bibbuf^,FileBufSize);
  if (tmp^<>bibname) or (ercode<>0) then
  begin
    if BackedNow then
    begin
      LFNassign(nbib,bakname^); LFNrename(nbib,bibname);
    end;
    ErrorMessageRC(Str_AuxToBibErr,''); TidyUp; Exit;
  end;
  ok:=true;
  TidyUp;
end;                            { AuxToBib }

end.
